/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.internal.jep;

import com.silabs.external.api.jep.JepScriptEngine;
import com.silabs.java.utils.api.IDisposable;
import com.silabs.ss.platform.api.scripting.core.ISLSScriptAPI;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import jep.ClassEnquirer;
import jep.ClassList;
import jep.JepException;

public class StudioClassEnquirer
implements ClassEnquirer {
    private final JepScriptEngine engine;
    private ClassEnquirer fallBackEnquirer = null;

    StudioClassEnquirer(JepScriptEngine e) {
        this.engine = e;
    }

    public boolean isJavaPackage(String name) {
        if ("Studio".equals(name)) {
            return true;
        }
        if (name.equals("com") || name.startsWith("com.") || name.equals("org") || name.startsWith("org.")) {
            return true;
        }
        ClassEnquirer ce = this.getFallback();
        if (ce == null) {
            return false;
        }
        return ce.isJavaPackage(name);
    }

    public String[] getClassNames(String name) {
        ClassEnquirer ce;
        Object apiObj;
        ISLSScriptAPI api;
        if (name.startsWith("Studio") && this.engine != null && (api = (ISLSScriptAPI)(apiObj = this.engine.get("api"))) != null) {
            if ("Studio".equals(name)) {
                Collection c = api.getModuleNames();
                if (c == null) {
                    return null;
                }
                return c.toArray(new String[c.size()]);
            }
            String moduleName = name.substring("Studio".length() + 1);
            Object module = api.getModule(moduleName);
            if (module != null) {
                Class<?> cls = module.getClass();
                Method[] methods = cls.getMethods();
                Field[] fields = cls.getFields();
                ArrayList names = new ArrayList();
                Arrays.stream(methods).forEach(m -> {
                    boolean bl = names.add(m.getName());
                });
                Arrays.stream(fields).forEach(f -> {
                    boolean bl = names.add(f.getName());
                });
                return names.toArray(new String[names.size()]);
            }
        }
        if ((ce = this.getFallback()) == null) {
            return new String[0];
        }
        return ce.getClassNames(name);
    }

    public String[] getSubPackages(String name) {
        ClassEnquirer ce = this.getFallback();
        if (ce == null) {
            return new String[0];
        }
        return ce.getSubPackages(name);
    }

    public boolean isJavaModule(String name) {
        Object apiObj;
        ISLSScriptAPI api;
        if (name.startsWith("Studio") && name.contains(".") && this.engine != null && (api = (ISLSScriptAPI)(apiObj = this.engine.get("api"))) != null) {
            String moduleName = name.substring("Studio".length() + 1);
            return api.getModule(moduleName) != null;
        }
        return false;
    }

    public Object getAttribute(Object javaObject, String name) {
        if (javaObject == null || name == null) {
            return null;
        }
        try {
            Field f = javaObject.getClass().getField(name);
            if (f != null) {
                return f;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {}
        return null;
    }

    public void loadJavaModule(final String name) {
        String moduleName;
        Object module;
        Object apiObj;
        ISLSScriptAPI api;
        if (name.startsWith("Studio") && name.contains(".") && this.engine != null && (api = (ISLSScriptAPI)(apiObj = this.engine.get("api"))) != null && (module = api.getModule(moduleName = name.substring("Studio".length() + 1))) != null) {
            if (module instanceof IDisposable) {
                ((IDisposable)module).addDisposeListener(new Runnable(){

                    @Override
                    public void run() {
                        if (StudioClassEnquirer.this.engine != null) {
                            StudioClassEnquirer.this.engine.unregisterModule(name);
                        }
                    }
                });
            }
            this.engine.registerModule(name, module);
        }
    }

    private ClassEnquirer getFallback() {
        if (this.fallBackEnquirer == null) {
            try {
                this.fallBackEnquirer = ClassList.getInstance();
            }
            catch (JepException jepException) {}
        }
        return this.fallBackEnquirer;
    }
}

