/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.internal.jep;

import com.silabs.external.api.jep.JepScriptEngine;
import com.silabs.external.api.jep.StudioJep;
import com.silabs.java.utils.SwappableClassLoader;
import com.silabs.java.utils.runtime.RuntimeUtils;
import com.silabs.ss.platform.api.descriptor.core.model.MDescriptor;
import com.silabs.ss.platform.api.rcp.core.IRunnableService;
import com.silabs.ss.platform.api.scripting.core.ISLSScriptAPI;
import com.silabs.ss.platform.api.scripting.core.IScript;
import com.silabs.ss.platform.api.scripting.core.IScriptEngineConfiguration;
import com.silabs.ss.platform.api.scripting.core.IScriptModuleProvider;
import com.silabs.ss.platform.api.scripting.core.IScriptMonitor;
import com.silabs.ss.platform.api.scripting.core.ScriptEngineContext;
import com.silabs.ss.platform.internal.api.scripting.core.BaseScript;
import com.silabs.ss.platform.internal.api.scripting.core.BaseScriptEngineConfiguration;
import com.silabs.ss.platform.internal.api.scripting.core.IScriptModuleRegistryListener;
import com.silabs.ss.platform.internal.api.scripting.core.ScriptModule;
import com.silabs.ss.platform.internal.api.scripting.core.WrappedScriptEngine;
import com.silabs.ss.platform.performance.recording.LoggingFeature;
import com.silabs.ss.platform.performance.recording.PerformanceMetadata;
import com.silabs.ss.platform.performance.recording.StopWatch;
import com.silabs.ss.platform.performance.recording.rcp.PerformanceManager;
import com.silabs.ss.support.internal.jep.Activator;
import com.silabs.ss.support.internal.jep.HeadlessThreadRunner;
import com.silabs.ss.support.internal.jep.StudioClassEnquirer;
import com.silabs.ss.support.internal.jep.StudioClassLoader;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jep.ClassEnquirer;
import jep.IThreadRunner;
import jep.StudioInterpreter;
import jep.python.PyCallable;
import jep.python.PyObject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class PythonScript
extends BaseScript {
    public static String ENGINE_JEP = "jep";
    private static final Object LOCKING_OBJECT = PythonScript.class;
    private static final boolean DEBUG = false;
    private static ScriptEngineManager scriptEngineManager;
    private static SwappableClassLoader swappableClassLoader;

    static {
        swappableClassLoader = new SwappableClassLoader();
    }

    public PythonScript() {
    }

    public PythonScript(MDescriptor desc) {
        super(desc);
    }

    private static void registerModuleClassPath(String moduleName, StudioClassLoader classLoader) {
        IScriptModuleProvider provider;
        try {
            provider = ScriptModule.registry().getScriptModuleProvider(moduleName);
        }
        catch (CoreException coreException) {
            return;
        }
        if (provider == null) {
            return;
        }
        String bundleId = provider.getProvidingBundleId();
        if (bundleId != null) {
            classLoader.registerClassLoader(Platform.getBundle((String)bundleId));
        }
    }

    private static String getIncludePath(IScriptEngineConfiguration config) {
        ArrayList<String> paths = new ArrayList<String>();
        if (config != null) {
            IPath[] libPaths;
            IPath scriptPath = config.getScriptFilePath();
            if (scriptPath != null) {
                paths.add(scriptPath.removeLastSegments(1).toOSString());
            }
            if ((libPaths = config.getUserLibraryPaths()) != null && libPaths.length > 0) {
                IPath[] iPathArray = libPaths;
                int n = libPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath path = iPathArray[n2];
                    paths.add(path.toOSString());
                    ++n2;
                }
            }
        }
        return String.join((CharSequence)File.pathSeparator, paths);
    }

    public IScriptEngineConfiguration createConfiguration() {
        return new BaseScriptEngineConfiguration();
    }

    public ScriptEngine createEngine(IScriptEngineConfiguration config_) throws CoreException {
        IScriptEngineConfiguration config;
        Bundle contextBundle;
        ScriptEngine engine = PythonScript.createJepEngine();
        if (engine == null) {
            throw Activator.reporter.newCoreException("support for script engine '" + ENGINE_JEP + "' is not installed");
        }
        if (config_ == null) {
            config_ = this.createConfiguration();
        }
        if ((contextBundle = (config = config_).getContextBundle()) == null) {
            contextBundle = Activator.getContext().getBundle();
        }
        StudioClassLoader classLoader = StudioClassLoader.getInstance();
        classLoader.registerClassLoader(contextBundle);
        return new PythonScriptEngine(engine, config, classLoader);
    }

    public void disposeEngine(ScriptEngine engine) {
        ISLSScriptAPI api = (ISLSScriptAPI)engine.get("api");
        if (api != null) {
            api.dispose();
        }
        engine.getBindings(100).clear();
        engine.getBindings(200).clear();
        if (engine instanceof PythonScriptEngine) {
            ((PythonScriptEngine)((Object)engine)).dispose();
        }
    }

    public boolean isWrappedObject(Object obj) {
        return obj instanceof PyObject;
    }

    public Object wrapObject(Object obj) {
        return obj;
    }

    public Object unwrapObject(Object scriptObj) {
        return scriptObj;
    }

    public Object wrapFunction(Object obj, Class<?> klass, String name, Class<?> ... argTypes) throws ScriptException {
        return null;
    }

    public Object invokeFunction(Object func, Object ... args) throws ScriptException {
        if (func instanceof StudioInterpreter.PyObjectWrapper var3_4 && ( instanceOfPatternExpressionValue = wrapper.wrapped()) instanceof PyCallable && (var4_6 = (PyCallable) instanceOfPatternExpressionValue) == (PyCallable) instanceOfPatternExpressionValue) {
            return wrapper.syncExec(() -> PythonScript.lambda$0((PyCallable)callable, args));
        }
        throw new IllegalStateException("Unhandled Python object: " + func.getClass());
    }

    public String formatException(Throwable t) {
        return null;
    }

    public Class<?> wrapClass(Class<?> javaClass) {
        return javaClass;
    }

    public void addContextBundle(ScriptEngineContext context, Bundle bundle) throws UnsupportedOperationException {
    }

    public ISLSScriptAPI.Exception wrapCheckedException(Throwable t) {
        return null;
    }

    public ISLSScriptAPI.Exception wrapObjectAsCheckedException(Object t) {
        return null;
    }

    public Object[] getLockingObjects() {
        return new Object[]{LOCKING_OBJECT};
    }

    private static ScriptEngine createJepEngine() {
        ScriptEngineManager engMgr = PythonScript.getScriptEngineManager();
        if (engMgr == null) {
            return null;
        }
        return engMgr.getEngineByName(ENGINE_JEP);
    }

    private static ScriptEngineManager getScriptEngineManager() {
        if (scriptEngineManager == null) {
            scriptEngineManager = StudioJep.getScriptEngineManager();
        }
        return scriptEngineManager;
    }

    private static /* synthetic */ Object lambda$0(PyCallable pyCallable, Object[] objectArray) {
        return pyCallable.call(objectArray);
    }

    private final class PythonScriptEngine
    extends WrappedScriptEngine {
        private IScriptEngineConfiguration config;
        private final StudioClassLoader classLoader;
        private IScriptModuleRegistryListener moduleLoaderListener;
        private static final String SCHEMA_VERSION = "version";
        private static final String SCHEMA_VERSION_NUMBER = "1.0";
        private static final String FILE_NAME = "fileName";

        private IThreadRunner getThreadRunner() {
            if (RuntimeUtils.isHeadless()) {
                return new HeadlessThreadRunner();
            }
            ServiceReference serviceReference = Activator.getContext().getServiceReference(IRunnableService.class.getName());
            final IRunnableService runnableSvc = (IRunnableService)Activator.getContext().getService(serviceReference);
            return new IThreadRunner(){

                public void syncExec(Runnable r) {
                    if (runnableSvc != null) {
                        runnableSvc.syncExec(r);
                    }
                }

                public void asyncExec(Runnable r) {
                    if (runnableSvc != null) {
                        runnableSvc.asyncExec(r);
                    }
                }
            };
        }

        public PythonScriptEngine(ScriptEngine wrapped, IScriptEngineConfiguration config, StudioClassLoader classLoader) throws CoreException {
            super(wrapped);
            this.config = config;
            this.classLoader = classLoader;
            if (wrapped instanceof JepScriptEngine) {
                try {
                    ((JepScriptEngine)wrapped).init(false, PythonScript.getIncludePath(config), (ClassLoader)swappableClassLoader, (ClassEnquirer)new StudioClassEnquirer((JepScriptEngine)wrapped), this.getThreadRunner(), RuntimeUtils.isHeadless());
                }
                catch (ScriptException e) {
                    throw Activator.reporter.newCoreException("Failed to init PythonScriptEngine", (Throwable)e);
                }
            }
            this.moduleLoaderListener = new ScriptModuleRegistryListener(this.classLoader);
            ScriptModule.registry().addListener(this.moduleLoaderListener);
            String[] stringArray = ScriptModule.registry().getScriptModuleNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String moduleName = stringArray[n2];
                PythonScript.registerModuleClassPath(moduleName, classLoader);
                ++n2;
            }
        }

        void dispose() {
            if (this.wrapped == null || !(this.wrapped instanceof JepScriptEngine)) {
                return;
            }
            ((JepScriptEngine)this.wrapped).close();
        }

        protected void finalize() throws Throwable {
            ScriptModule.registry().removeListener(this.moduleLoaderListener);
            super.finalize();
        }

        private PerformanceMetadata getEvalObject(String fileName) {
            return PerformanceMetadata.builder().put(SCHEMA_VERSION, (Object)SCHEMA_VERSION_NUMBER).put(FILE_NAME, (Object)fileName).build();
        }

        public Object eval(Reader reader, Bindings n) throws ScriptException {
            Object result = null;
            String scriptFile = (String)this.getContext().getAttribute("javax.script.filename");
            IPath scriptFilePath = this.config.getScriptFilePath();
            if (scriptFilePath != null) {
                scriptFile = scriptFilePath.toOSString();
                this.getContext().setAttribute("javax.script.filename", scriptFile, 100);
            }
            String fileForJSON = scriptFile;
            StopWatch perf = PerformanceManager.INSTANCE.logStartChildMap(LoggingFeature.ALL, "Execute Python Script - JEP", () -> this.getEvalObject(fileForJSON));
            ClassLoader origSwapCL = swappableClassLoader.getClassLoader();
            IScriptMonitor scriptMonitor = PythonScript.this.createScriptMonitor(this.getContext(), this.config.getScriptMonitors());
            try {
                try {
                    String[] args;
                    swappableClassLoader.setClassLoader((ClassLoader)((Object)this.classLoader));
                    scriptMonitor.scriptStarted((IScript)PythonScript.this, (ScriptEngine)((Object)this));
                    ISLSScriptAPI api = (ISLSScriptAPI)this.get("api");
                    if (api == null) {
                        ScriptEngineContext ctx = new ScriptEngineContext((IScript)PythonScript.this, this.config, (ScriptEngine)((Object)this));
                        this.classLoader.setContext(ctx);
                        api = ScriptModule.createScriptAPI((ScriptEngineContext)ctx);
                        this.put("api", PythonScript.this.wrapObject(api));
                    }
                    if ((args = this.config.getScriptArguments()) != null) {
                        this.getContext().setAttribute("javax.script.argv", args, 100);
                    }
                    result = super.eval(reader, n);
                    scriptMonitor.scriptFinished(result, null);
                }
                catch (ScriptException e) {
                    scriptMonitor.scriptFinished(null, e);
                    throw e;
                }
            }
            finally {
                swappableClassLoader.setClassLoader(origSwapCL);
                perf.done();
            }
            return result;
        }
    }

    private static class ScriptModuleRegistryListener
    implements IScriptModuleRegistryListener {
        private StudioClassLoader classLoader;

        public ScriptModuleRegistryListener(StudioClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public void loadedProvider(String moduleName, IScriptModuleProvider provider) {
            PythonScript.registerModuleClassPath(moduleName, this.classLoader);
        }
    }
}

