/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.ses;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.engine.IProjectModel;
import com.silabs.ss.framework.project.api.core.engine.IProjectModelEngineFactory;
import com.silabs.ss.framework.project.api.core.engine.ProjectModelUtils;
import com.silabs.ss.framework.project.api.core.external.BaseExternalProjectImporter;
import com.silabs.ss.framework.project.api.core.external.IExternalImporter;
import com.silabs.ss.framework.project.api.core.external.IImportProjectDescriptor;
import com.silabs.ss.framework.project.api.core.external.ImportProjectRecord;
import com.silabs.ss.framework.project.api.core.external.ProjectImportUtils;
import com.silabs.ss.framework.project.api.core.model.ELanguage;
import com.silabs.ss.framework.project.api.core.model.MBuildSetting;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MFileContent;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MSettingsSite;
import com.silabs.ss.framework.project.api.core.model.MToolOption;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import com.silabs.ss.framework.project.api.core.utils.ProjectModelObjFactory;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.ses.SESArmExternalOptions;
import com.silabs.ss.framework.project.internal.core.type.ses.SESMetadataHandler;
import com.silabs.ss.framework.project.internal.core.type.ses.SESModelUtils;
import com.silabs.ss.framework.project.internal.core.type.ses.SESProjectOperationHandler;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.SESConfiguration;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.SESConfigurationContainer;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.SESFile;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.SESFolder;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.SESProject;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.SESSolution;
import com.silabs.ss.framework.project.internal.core.type.ses.sesmodel.util.SESModelSwitchRecurser;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.property.model.IPropertyGroup;
import com.silabs.ss.platform.api.descriptor.core.type.CoreTypes;
import com.silabs.ss.platform.api.rcp.core.IPathUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SESExternalProjectImporter
extends BaseExternalProjectImporter
implements IExternalImporter {
    private static final Set<String> CONTROL_OPTION_NAMES = Set.of("c_preprocessor_definitions", "c_user_include_directories", "linker_additional_files", "linker_additional_system_libraries");

    public SESExternalProjectImporter(String superTypeId) {
        super(superTypeId);
    }

    @Override
    public ImportProjectRecord[] findProjects(File projectLocation) {
        File[] sesFiles;
        TreeSet<ImportProjectRecord> projectRecordsList = new TreeSet<ImportProjectRecord>((pr1, pr2) -> pr1.getName().compareTo(pr2.getName()));
        File[] fileArray = sesFiles = projectLocation.listFiles((dir, name) -> "emProject".equals(FileUtils.getExtension((String)name)));
        int n = sesFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isFile()) {
                Activator.reporter.logError("File not found " + String.valueOf(file));
            } else {
                SESSolution currentSolution = SESModelUtils.loadSESSolution(file);
                IPath projectRoot = IPathUtils.createPath((String)file.toString());
                projectRoot = projectRoot.append(currentSolution.getName());
                for (SESProject proj : currentSolution.getProjects()) {
                    ImportProjectRecord projRecord = new ImportProjectRecord(proj.getName(), projectRoot.toFile());
                    projectRecordsList.add(projRecord);
                }
            }
            ++n2;
        }
        return projectRecordsList.toArray(new ImportProjectRecord[projectRecordsList.size()]);
    }

    @Override
    public MProject createImportModel(IImportProjectDescriptor importDescr, IProgressMonitor monitor) throws CoreException {
        File sesProjectFile = importDescr.getInputLocation();
        if (!sesProjectFile.isFile()) {
            return this.createNewEmptyMProj(importDescr);
        }
        SESSolution sesModel = SESModelUtils.loadSESSolution(sesProjectFile);
        if (sesModel == null) {
            Activator.reporter.logInfo("No solution in " + String.valueOf(sesProjectFile));
            return this.createNewEmptyMProj(importDescr);
        }
        if (sesModel.getProjects().isEmpty()) {
            Activator.reporter.logInfo("No project in " + String.valueOf(sesProjectFile));
            return this.createNewEmptyMProj(importDescr);
        }
        SESProject sesProj = null;
        String importProjName = importDescr.getName();
        if (importProjName != null) {
            sesProj = SESModelUtils.findProject(sesModel, importProjName);
            if (sesProj == null) {
                return this.createNewEmptyMProj(importDescr);
            }
        } else {
            sesProj = (SESProject)sesModel.getProjects().get(0);
        }
        SESProjectImporter sesImporter = new SESProjectImporter(importDescr);
        MProject mProject = sesImporter.importProject(sesModel, sesProj);
        SESMetadataHandler metadataHandler = new SESMetadataHandler(sesProj);
        metadataHandler.apply(mProject);
        return mProject;
    }

    private MProject createNewEmptyMProj(IImportProjectDescriptor importDescr) {
        MProject mProject = ProjectModelFactory.eINSTANCE.createMProject();
        mProject.setContentRoot(importDescr.getInputLocation().getParentFile().toURI().toString());
        mProject.setName(importDescr.getName());
        return mProject;
    }

    private static class SESProjectImporter {
        private MProject mProject = ProjectModelFactory.eINSTANCE.createMProject();
        private IProjectModel iModel;
        private File contentDir;
        private Map<String, Collection<String>> configMap;

        public SESProjectImporter(IImportProjectDescriptor importDescr) {
            this.mProject.setName(importDescr.getName());
            this.contentDir = importDescr.getInputLocation().getParentFile();
            this.configMap = new HashMap<String, Collection<String>>();
            this.mProject.setContentRoot(this.contentDir.toURI().toString());
            this.iModel = IProjectModelEngineFactory.INSTANCE.createProjectModel(this.mProject, null);
        }

        private MProject importProject(SESSolution solution, SESProject proj) {
            this.mProject.setName(proj.getName());
            new SESModelSwitchRecurser<Object>(){

                @Override
                public Object caseSESConfiguration(SESConfiguration config) {
                    SESModelUtils.parseSESList(config.getInherited_configurations()).forEach(c -> {
                        boolean bl = configMap.computeIfAbsent((String)c, s -> new HashSet()).add(config.getName());
                    });
                    return null;
                }
            }.doSwitch(solution);
            this.importConfigurations(solution, null);
            this.importConfigurations(proj, null);
            for (SESFile file : proj.getFiles()) {
                this.importFile((MFolderEntry)this.mProject, file);
            }
            for (SESFolder folder : proj.getFolders()) {
                this.importFolder(folder, (MFolderEntry)this.mProject);
            }
            return this.mProject;
        }

        private void importFolder(SESFolder sesFolder, MFolderEntry parentFolder) {
            MFolderEntry mFolder = ProjectModelUtils.findOrCreateFolder(this.iModel, parentFolder, sesFolder.getName());
            this.importConfigurations(sesFolder, ProjectModelUtils.getProjectPathFor((MEntry)mFolder));
            for (SESFile childSESFile : sesFolder.getFiles()) {
                this.importFile(mFolder, childSESFile);
            }
            for (SESFolder childSESFolder : sesFolder.getFolders()) {
                this.importFolder(childSESFolder, mFolder);
            }
        }

        private void importFile(MFolderEntry mFolder, SESFile sesFile) {
            IPath basePath = IPathUtils.createPath((String)sesFile.getFile_name());
            String resolvedPath = this.contentDir.toPath().resolve(basePath.toFile().toPath()).toFile().getAbsolutePath();
            String fileName = basePath.lastSegment();
            IPath folderPath = ProjectModelUtils.getProjectPathFor((MEntry)mFolder);
            IPath projPath = folderPath.append(fileName);
            String contentURI = IPathUtils.createPath((String)resolvedPath).toFile().toURI().toString();
            MFileContent mFile = ProjectModelUtils.findOrCreateFileContent(this.iModel, this.mProject, projPath, contentURI);
            mFile.setName(fileName);
            String sesFileName = sesFile.getName();
            if (TextUtils.hasContent((String)sesFileName)) {
                mFile.setName(sesFileName);
            }
            this.importConfigurations(sesFile, projPath);
        }

        private void importConfigurations(SESConfigurationContainer sesContainer, IPath projPath) {
            for (SESConfiguration sesConfig : this.getSortedList(sesContainer)) {
                Collection mConfigNames = this.configMap.getOrDefault(sesConfig.getName(), Arrays.asList(sesConfig.getName()));
                for (String mConfigName : mConfigNames) {
                    MConfiguration mConfig = this.mProject.findConfigurationByName(mConfigName);
                    if (mConfig == null) {
                        mConfig = ProjectModelFactory.eINSTANCE.createMConfiguration();
                        mConfig.setName(sesConfig.getName());
                        this.mProject.getConfigurations().add((Object)mConfig);
                    }
                    boolean isBuiltin = "Simplicity_Configuration_Content".equals(sesConfig.getName());
                    this.importConfigurationOptions(sesConfig, mConfig, isBuiltin, projPath);
                }
            }
        }

        private Iterable<SESConfiguration> getSortedList(SESConfigurationContainer sesContainer) {
            ArrayList<SESConfiguration> configs = new ArrayList<SESConfiguration>((Collection<SESConfiguration>)sesContainer.getConfigurations());
            configs.sort((c1, c2) -> {
                if ("Simplicity_Configuration_Content".equals(c1.getName())) {
                    return 1;
                }
                if ("Simplicity_Configuration_Content".equals(c2.getName())) {
                    return -1;
                }
                return c1.getName().compareTo(c2.getName());
            });
            return configs;
        }

        private MConfiguration importConfigurationOptions(SESConfiguration sesConfig, MConfiguration mConfig, boolean isBuiltin, IPath projPath) {
            String otherLibNames;
            String otherFiles;
            if (sesConfig == null) {
                return mConfig;
            }
            Map<String, String> c_defs_map = SESModelUtils.parseSESMacrosForConfigOption(sesConfig.getC_preprocessor_definitions());
            c_defs_map.entrySet().stream().distinct().forEach(d -> this.addMacro(mConfig, isBuiltin, (Map.Entry<String, String>)d));
            String sesIncs = sesConfig.getC_user_include_directories();
            if (TextUtils.hasContent((String)sesIncs)) {
                SESModelUtils.parseSESList(sesIncs).forEach(c -> this.handleNewOption(ProjectModelObjFactory.forMIncludePath(ProjectImportUtils.formatPath(c, this.contentDir.toURI(), true)), isBuiltin, new ArrayList<String>(List.of(ELanguage.C.getLiteral())), mConfig));
            }
            if (TextUtils.hasContent((String)(otherFiles = sesConfig.getLinker_additional_files()))) {
                SESModelUtils.parseSESList(otherFiles).forEach(c -> this.handleNewOption(ProjectModelObjFactory.forMLibraryFile().setUri(ProjectImportUtils.formatPath(c, this.contentDir.toURI(), false)), isBuiltin, new ArrayList<String>(List.of(ELanguage.OBJ.getLiteral())), mConfig));
            }
            if (TextUtils.hasContent((String)(otherLibNames = sesConfig.getLinker_additional_system_libraries()))) {
                SESModelUtils.parseSESList(otherLibNames).forEach(c -> this.handleNewOption(ProjectModelObjFactory.forMLibraryFile().setName((String)c), isBuiltin, new ArrayList<String>(List.of(ELanguage.OBJ.getLiteral())), mConfig));
            }
            this.importToolOptions(sesConfig, (MSettingsSite)mConfig, SESArmExternalOptions.sesArmAssemblerOptionGroup, isBuiltin);
            this.importToolOptions(sesConfig, (MSettingsSite)mConfig, SESArmExternalOptions.sesArmCompilerOptionGroup, isBuiltin);
            this.importToolOptions(sesConfig, (MSettingsSite)mConfig, SESArmExternalOptions.sesArmLinkerOptionGroup, isBuiltin);
            this.importToolOptions(sesConfig, (MSettingsSite)mConfig, SESArmExternalOptions.sesArmTargetOptionGroup, isBuiltin);
            if (TextUtils.hasContent((String)sesConfig.getPre_build_command())) {
                mConfig.setPrebuildStep(sesConfig.getPre_build_command());
            }
            if (TextUtils.hasContent((String)sesConfig.getPost_build_command())) {
                mConfig.setPostbuildStep(sesConfig.getPost_build_command());
            }
            if (projPath != null && "Yes".equals(sesConfig.getBuild_exclude_from_build())) {
                mConfig.getExcludedPaths().add((Object)projPath.toString());
            }
            return mConfig;
        }

        private void addMacro(MConfiguration mConfig, boolean isBuiltin, Map.Entry<String, String> d) {
            ArrayList<String> langs = new ArrayList<String>(List.of(ELanguage.C.getLiteral()));
            ProjectModelObjFactory.CreateMMacroDefinition macro = ProjectModelObjFactory.forMMacroDefinition(d.getKey(), d.getValue());
            this.handleNewOption(macro, isBuiltin, langs, mConfig);
        }

        private void importToolOptions(SESConfiguration sesConfig, MSettingsSite site, IPropertyGroup optionGroup, boolean isBuiltin) {
            if (sesConfig == null) {
                return;
            }
            IProperty[] iPropertyArray = optionGroup.getProperties();
            int n = iPropertyArray.length;
            int n2 = 0;
            while (n2 < n) {
                String optionValue;
                EStructuralFeature optionFeature;
                IProperty property = iPropertyArray[n2];
                String sesOptionName = property.getName();
                if (!(CONTROL_OPTION_NAMES.contains(sesOptionName) || SESProjectOperationHandler.DEFAULT_ARM_CORE_SETTINGS.containsKey(property) || SESProjectOperationHandler.PART_SELECTION_CONFIG_OPTIONS.contains(property) || (optionFeature = sesConfig.eClass().getEStructuralFeature(sesOptionName)) == null || (optionValue = (String)sesConfig.eGet(optionFeature)) == null || TextUtils.isEmpty((String)optionValue))) {
                    ProjectModelObjFactory.CreateMToolOption opt = (ProjectModelObjFactory.CreateMToolOption)((ProjectModelObjFactory.CreateMToolOption)ProjectModelObjFactory.forMToolOption(optionGroup.getId(), property.getId()).setBuiltin(isBuiltin)).findOrApply(site);
                    if (CoreTypes.STRING_LIST.getType() == property.getType()) {
                        SESModelUtils.parseSESList(optionValue).forEach(v -> {
                            ProjectModelObjFactory.CreateMToolListOption createMToolListOption = opt.newListOption((String)v).setBuiltin(isBuiltin).find().set(o -> o.setBuiltin(isBuiltin && o.isBuiltin()));
                        });
                    } else if (!isBuiltin || ((MToolOption)opt.get()).isBuiltin()) {
                        opt.setValue(optionValue);
                    }
                }
                ++n2;
            }
        }

        private <T extends ProjectModelObjFactory.BaseCreateObject<T, MOption>, MOption extends MBuildSetting> void handleNewOption(T option, boolean isBuiltin, Collection<String> langs, MConfiguration mConfig) {
            ((ProjectModelObjFactory.BaseCreateEObject)((ProjectModelObjFactory.BaseCreateObject)option.set(m -> m.setLanguageCompatibility(TextUtils.catenateStrings((Collection)langs, (String)" ")))).setBuiltin(isBuiltin)).findOrApply((MSettingsSite)mConfig);
            boolean existingBuiltin = ((MBuildSetting)option.get()).isBuiltin();
            List oldLangs = TextUtils.splitByCharacterToList((String)((MBuildSetting)option.get()).getLanguageCompatibility(), (char)' ');
            if (isBuiltin && !existingBuiltin) {
                this.modifyLangs(langs, oldLangs);
                if (langs.isEmpty()) {
                    return;
                }
                option = (ProjectModelObjFactory.BaseCreateObject)((ProjectModelObjFactory.BaseCreateObject)option.copy()).apply((MSettingsSite)mConfig);
            } else {
                this.modifyLangs(oldLangs, langs);
                if (!oldLangs.isEmpty()) {
                    option.set(m -> m.setLanguageCompatibility(TextUtils.catenateStrings((Collection)oldLangs, (String)" ")));
                    option = (ProjectModelObjFactory.BaseCreateObject)((ProjectModelObjFactory.BaseCreateObject)option.copy()).apply((MSettingsSite)mConfig);
                }
            }
            ((ProjectModelObjFactory.BaseCreateObject)option.set(m -> m.setLanguageCompatibility(TextUtils.catenateStrings((Collection)langs, (String)" ")))).setBuiltin(isBuiltin);
        }

        private void modifyLangs(Collection<String> builtinLangs, Collection<String> userLangs) {
            if (userLangs.contains("ALL")) {
                builtinLangs.clear();
            }
            if (userLangs.contains(ELanguage.C.getLiteral())) {
                builtinLangs.remove(ELanguage.C.getLiteral());
            }
            if (userLangs.contains(ELanguage.OBJ.getLiteral())) {
                builtinLangs.remove(ELanguage.OBJ.getLiteral());
            }
        }
    }
}

