/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.makefile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.silabs.java.utils.Result;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.function.Caster;
import com.silabs.ss.framework.project.api.core.ProjectProperties;
import com.silabs.ss.framework.project.api.core.entity.IExternalProjectEntity;
import com.silabs.ss.framework.project.api.core.model.options.IGenericOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.solution.ISolutionEntity;
import com.silabs.ss.framework.project.api.toolchain.core.ToolchainProperties;
import com.silabs.ss.framework.project.internal.core.type.generic.BaseGenericTemplates;
import com.silabs.ss.framework.project.internal.core.type.generic.IGenericTemplate;
import com.silabs.ss.framework.project.internal.core.type.makefile.MakefileTemplate;
import com.silabs.ss.framework.project.internal.core.type.makefile.options.MakefileArmGccGenericOptionMapper;
import com.silabs.ss.framework.project.internal.core.type.makefile.options.MakefileHostGccGenericOptionMapper;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MakefileTemplates
extends BaseGenericTemplates<MakefileTemplate> {
    private static MakefileTemplates INSTANCE = new MakefileTemplates();
    public static final int MAKEFILE_VERSION = 16;
    private static final String TEMPLATE_LOC = "data/makefile_templates/";
    private static final String CUSTOM_MAK_NAME = "custom";
    private static final String CUSTOM_MAIN_TEMPLATE_END = "Makefile";
    private static final String CUSTOM_PROJECT_TEMPLATE_PATTERN = ".*\\..*\\.mak";

    public static MakefileTemplates instance() {
        return INSTANCE;
    }

    @Override
    protected boolean preferInternal() {
        return false;
    }

    public final File getConstantTemplate(IExternalProjectEntity project) throws IOException {
        ImmutableList<File> templates = this.getTemplates((IDescriptor)project, true, t -> t.mainTemplate((IDescriptor)project));
        if (templates.isEmpty()) {
            throw new IllegalArgumentException("No base template for " + project.getName());
        }
        return (File)templates.get(0);
    }

    public final ImmutableList<File> getGeneratedTemplates(IExternalProjectEntity project) throws IOException {
        return this.getTemplates((IDescriptor)project, true, t -> t.contentTemplates((IDescriptor)project));
    }

    public final Result<File, IOException> solutionTemplate(ISolutionEntity entity) {
        return ToolchainType.solution.mainTemplate((IDescriptor)entity).findFirst().orElse((Result<File, IOException>)Result.err((Object)new IOException("Failed to load content!")));
    }

    @Override
    protected Stream<MakefileTemplate> getDefaultTemplates(IDescriptor desc) {
        Stream<ToolchainType> exportTemps = this.findToolchainType(desc);
        return exportTemps.map(arg_0 -> ((Caster)Caster.with(MakefileTemplate.class)).cast(arg_0));
    }

    @Override
    protected Stream<MakefileTemplate> loadCustom(IDescriptor desc, File templateDir) {
        ArrayList projectTempls = new ArrayList();
        List mainTempls = Stream.of(templateDir.listFiles()).peek(f -> {
            if (f.getName().matches(CUSTOM_PROJECT_TEMPLATE_PATTERN)) {
                projectTempls.add(f);
            }
        }).filter(f -> f.getName().endsWith(CUSTOM_MAIN_TEMPLATE_END)).collect(Collectors.toList());
        if (mainTempls.isEmpty() || projectTempls.isEmpty()) {
            return null;
        }
        Stream<ToolchainType> tcType = this.findToolchainType(desc);
        return tcType.map(t -> new MakefileCustomExportTemplates((ToolchainType)t, (File)mainTempls.get(0), projectTempls));
    }

    private Stream<ToolchainType> findToolchainType(IDescriptor desc) {
        Stream<ToolchainType> exportTemps = Stream.of(ToolchainType.values());
        Collection tcCompat = (Collection)desc.getProperty(ToolchainProperties.TOOLCHAIN_COMPATIBILITY);
        if (!tcCompat.isEmpty()) {
            exportTemps = exportTemps.filter(e -> tcCompat.stream().anyMatch(arg_0 -> e.tcCompat.contains(arg_0)));
        }
        String coreCompat = desc.getPropertyAccess().getValueString(ProjectProperties.ALLOWED_CORE_ARCHITECTURE);
        exportTemps = exportTemps.filter(e -> TextUtils.hasContent((String)coreCompat) ? e.coreCompat.contains((Object)coreCompat) : e.coreCompat.contains((Object)"ARM"));
        return exportTemps;
    }

    @Override
    protected int templateVersion() {
        return 16;
    }

    @Override
    protected String name() {
        return "makefile";
    }

    @Override
    protected String internalTemplateLocation() {
        return TEMPLATE_LOC;
    }

    @Override
    protected Stream<? extends IGenericTemplate> existingCopiedTemplates() {
        return Stream.of(ToolchainType.values());
    }

    @Override
    protected Result<File, IOException> customFiles(File copiedPath, String template) {
        String copiedName = copiedPath.getName();
        int idx = copiedName.indexOf(46);
        if (idx > 0) {
            String customFileName = CUSTOM_MAK_NAME + copiedName.substring(idx, copiedName.length());
            File customPath = new File(copiedPath.getParentFile(), customFileName);
            if (customPath.isFile()) {
                return Result.ok((Object)customPath);
            }
        }
        return null;
    }

    private static class MakefileCustomExportTemplates
    extends BaseGenericTemplates.CustomExportTemplates
    implements MakefileTemplate {
        final ToolchainType type;
        private final Result<File, IOException> mainTemplate;

        public MakefileCustomExportTemplates(ToolchainType type, File mainTempl, Collection<File> projectTempls) {
            super(projectTempls);
            this.type = type;
            this.mainTemplate = Result.ok((Object)mainTempl);
        }

        @Override
        public Stream<Result<File, IOException>> mainTemplate(IDescriptor desc) {
            return Stream.of(this.mainTemplate);
        }

        @Override
        public Stream<Result<File, IOException>> contentTemplates(IDescriptor desc) {
            return super.resolvedTemplates(desc);
        }

        @Override
        public Stream<Result<File, IOException>> resolvedTemplates(IDescriptor desc) {
            return Stream.concat(this.mainTemplate(desc), this.contentTemplates(desc));
        }

        @Override
        public IGenericOptionMappingRegistry genericRegistry() {
            return this.type.regSupp.get();
        }

        @Override
        public String basePropertyId() {
            return this.type.basePropId;
        }
    }

    private static enum ToolchainType implements MakefileTemplate
    {
        armGCC((ImmutableSet<String>)ImmutableSet.of((Object)"gcc"), (ImmutableSet<String>)ImmutableSet.of((Object)"ARM"), "makefile.arm.gcc", MakefileArmGccGenericOptionMapper::gccRegistry, "arm_gcc/arm_gcc.Makefile", (ImmutableSet<String>)ImmutableSet.of((Object)"arm_gcc/arm_gcc.project.mak")),
        hostGCC((ImmutableSet<String>)ImmutableSet.of((Object)"gcc"), (ImmutableSet<String>)ImmutableSet.of((Object)"HOST"), "makefile.host.gcc", MakefileHostGccGenericOptionMapper::gccRegistry, "host_gcc/host_gcc.Makefile", (ImmutableSet<String>)ImmutableSet.of((Object)"host_gcc/host_gcc.project.mak")),
        riscvGCC((ImmutableSet<String>)ImmutableSet.of((Object)"gcc"), (ImmutableSet<String>)ImmutableSet.of((Object)"RISC-V"), "makefile.arm.gcc", MakefileArmGccGenericOptionMapper::gccRegistry, "riscv_gcc/riscv_gcc.Makefile", (ImmutableSet<String>)ImmutableSet.of((Object)"riscv_gcc/riscv_gcc.project.mak")),
        solution((ImmutableSet<String>)ImmutableSet.of((Object)"gcc"), (ImmutableSet<String>)ImmutableSet.of(), "", () -> null, "solution.Makefile", (ImmutableSet<String>)ImmutableSet.of());

        final ImmutableSet<String> tcCompat;
        final ImmutableSet<String> coreCompat;
        final String mainTempl;
        final ImmutableSet<String> templPaths;
        final String basePropId;
        final Supplier<IGenericOptionMappingRegistry> regSupp;

        private ToolchainType(ImmutableSet<String> tcCompat, ImmutableSet<String> coreCompat, String basePropId, Supplier<IGenericOptionMappingRegistry> sup, String mainTemp, ImmutableSet<String> templatePaths) {
            this.tcCompat = tcCompat;
            this.coreCompat = coreCompat;
            this.mainTempl = mainTemp;
            this.templPaths = templatePaths;
            this.basePropId = basePropId;
            this.regSupp = sup;
        }

        @Override
        public Stream<Result<File, IOException>> mainTemplate(IDescriptor desc) {
            return Stream.of(MakefileTemplates.instance().loadTemplate(this.mainTempl, desc));
        }

        @Override
        public Stream<Result<File, IOException>> contentTemplates(IDescriptor desc) {
            return this.templPaths.stream().map(p -> MakefileTemplates.instance().loadTemplate((String)p, desc));
        }

        @Override
        public IGenericOptionMappingRegistry genericRegistry() {
            return this.regSupp.get();
        }

        @Override
        public String basePropertyId() {
            return this.basePropId;
        }

        @Override
        public Stream<String> internalTemplates() {
            return Stream.concat(Stream.of(this.mainTempl), this.templPaths.stream());
        }
    }
}

