/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.makefile;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.entity.IExternalProjectEntity;
import com.silabs.ss.framework.project.api.generator.template.ITemplateGenerator;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.generic.GenericOperationHandler;
import com.silabs.ss.framework.project.internal.core.type.makefile.MakefileJinjaOptions;
import com.silabs.ss.framework.project.internal.core.type.makefile.MakefileMetadataHandler;
import com.silabs.ss.framework.project.internal.core.type.makefile.MakefileTemplates;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class MakefileOperationHandler
extends GenericOperationHandler {
    public static final String POST_BUILD_VAR = "@\"$(POST_BUILD_EXE)\"";
    protected File mainTemplate;

    public MakefileOperationHandler(IExternalProjectEntity projEnt) {
        super(projEnt, null, null);
    }

    @Override
    protected void setUpTemplateFilesAndProperties() throws CoreException {
        try {
            this.templateFiles = MakefileTemplates.instance().getGeneratedTemplates(this.getProjectEntity());
            this.mainTemplate = MakefileTemplates.instance().getConstantTemplate(this.getProjectEntity());
            this.basePropertyIds = MakefileTemplates.instance().getBasePropertyIds((IDescriptor)this.getProjectEntity());
        }
        catch (IOException e) {
            throw Activator.reporter.newCoreException("Failed to load templates for Makefile exporter. Cannot export to Makefile!", (Throwable)e);
        }
    }

    @Override
    public String lookupCommanderVariable() {
        return POST_BUILD_VAR;
    }

    @Override
    protected MakefileMetadataHandler createMetadataHandler(File projMak) {
        return MakefileMetadataHandler.forWriting(this.projectContentMap, projMak);
    }

    @Override
    protected IPath getBasePath() throws IOException {
        IPath installationPath = this.getProjectEntity().getInstallationPath();
        String baseName = this.getFileNameWithoutFullExtension(installationPath.lastSegment());
        return installationPath.removeLastSegments(1).append(baseName);
    }

    @Override
    protected void generateOutputFromTemplateFiles(ITemplateGenerator generator, IPath basePath) throws IOException {
        this.generateIncludeMakefile(generator, basePath);
        this.generate(generator, basePath);
    }

    protected void generate(ITemplateGenerator generator, IPath basePath) throws IOException {
        this.generateOutput(generator, basePath, this.mainTemplate, false);
    }

    @Override
    protected File getNewFile(IPath basePath, File templateFile, ITemplateGenerator generator) {
        String fileName = templateFile.getName();
        int extIdx = fileName.indexOf(46);
        if (extIdx >= 0) {
            String newExt = fileName.substring(extIdx + 1);
            return basePath.addFileExtension(newExt).toFile();
        }
        return basePath.toFile();
    }

    protected void generateIncludeMakefile(ITemplateGenerator generator, IPath basePath) throws IOException {
        for (File makTemplate : this.templateFiles) {
            File outputFile = this.generateOutput(generator, basePath, makTemplate, true);
            this.getSortedList(MakefileJinjaOptions.ProjectOptions.INLCUDED_MAKEFILES).add(outputFile.getName());
        }
    }

    protected String getFileNameWithoutFullExtension(String fileName) {
        String baseFileName = Stream.concat(this.templateFiles.stream(), Stream.of(this.mainTemplate)).map(this::getTemplateFileExtension).filter(TextUtils::hasContent).filter(e -> fileName.endsWith("." + e)).map(e -> fileName.substring(0, fileName.length() - e.length() - 1)).findFirst().orElse(fileName);
        return baseFileName;
    }

    @Override
    protected File getNewFile(IPath basePath, File templateFile) {
        return basePath.addFileExtension(this.getTemplateFileExtension(templateFile)).toFile();
    }

    private String getTemplateFileExtension(File templateFile) {
        String fileName = templateFile.getName();
        int extIdx = fileName.indexOf(46);
        if (extIdx >= 0) {
            return fileName.substring(extIdx + 1);
        }
        return "";
    }
}

