/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew.model;

import com.google.common.base.Objects;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarEwProjectUtils;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARElement;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARProject;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IarEwwBatchBuild;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IarEwwProject;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.Node;

public class IarEwwWorkspace
extends IARElement {
    private static final String ELEMENT_PROJECT = "project";
    private static final String ELEMENT_BATCHBUILD = "batchBuild";
    private List<IarEwwProject> projects;
    private IarEwwBatchBuild batchBuild;
    private File ewwFile;

    public IarEwwWorkspace(Node node, File ewwFile) {
        super(node);
        this.ewwFile = ewwFile;
        this.projects = new ArrayList<IarEwwProject>();
        this.loadProjects();
        this.loadBatchBuild();
    }

    public File ewwFile() {
        return this.ewwFile;
    }

    protected void loadProjects() {
        for (Node groupNode : this.childNodes().get((Object)ELEMENT_PROJECT)) {
            this.projects.add(new IarEwwProject(groupNode));
        }
    }

    protected void loadBatchBuild() {
        this.batchBuild = new IarEwwBatchBuild((Node)this.childNodes().get((Object)ELEMENT_BATCHBUILD).get(0));
    }

    public IarEwwBatchBuild getBatchBuild() {
        return this.batchBuild;
    }

    public IarEwwProject addProject(String path) {
        Node projectNode = this.createSubNode(path, ELEMENT_PROJECT, "path");
        IarEwwProject project = new IarEwwProject(projectNode);
        this.projects.add(project);
        return project;
    }

    public IarEwwProject removeProject(String path) {
        Optional<IarEwwProject> projToRemoveOptional = this.projects.stream().filter(iarProj -> path.equals(iarProj.path())).findFirst();
        if (projToRemoveOptional.isPresent()) {
            IarEwwProject projToRemove = projToRemoveOptional.get();
            if (this.getNode().removeChild(projToRemove.getNode()) == null) {
                return null;
            }
            if (this.projects.remove(projToRemove)) {
                return projToRemove;
            }
        }
        return null;
    }

    public boolean clearProjects() {
        ArrayList<IarEwwProject> projectsCpy = new ArrayList<IarEwwProject>(this.projects);
        for (IarEwwProject project : projectsCpy) {
            if (this.getNode().removeChild(project.getNode()) == null) {
                return false;
            }
            this.projects.remove(project);
        }
        return true;
    }

    public boolean updateProjectPath(int projectIndex, String updatedPath) {
        if (projectIndex < this.projects.size() && projectIndex >= 0) {
            this.projects.get(projectIndex).setPath(updatedPath);
            return true;
        }
        return false;
    }

    public Optional<IarEwwProject> findProjectFromAbsProjPath(IPath absProjectPath) {
        if (absProjectPath == null) {
            return Optional.empty();
        }
        Optional<IarEwwProject> optFoundProject = this.projects.stream().filter(project -> Objects.equal((Object)absProjectPath.toFile().toPath().normalize().toAbsolutePath(), (Object)IarEwProjectUtils.getAbsoluteProjectPath(project.path(), this.ewwFile.getParentFile().toPath()))).findFirst();
        return optFoundProject;
    }

    public List<IarEwwProject> getIarEwwProjects() {
        return this.projects;
    }

    public List<Path> getProjectPaths() {
        ArrayList<Path> projectPaths = new ArrayList<Path>();
        Path workspaceDir = this.ewwFile.toPath().getParent();
        for (IarEwwProject project : this.projects) {
            Path projectPath = IarEwProjectUtils.getAbsoluteProjectPath(project.path(), workspaceDir);
            projectPaths.add(projectPath);
        }
        return projectPaths;
    }

    public List<IARProject> getIARProjects() throws CoreException {
        ArrayList<IARProject> iarProjects = new ArrayList<IARProject>();
        Path workspaceDir = this.ewwFile.toPath().getParent();
        for (IarEwwProject project : this.projects) {
            Path projectPath = IarEwProjectUtils.getAbsoluteProjectPath(project.path(), workspaceDir);
            IARProject iarProject = IarEwProjectUtils.loadIarProject(projectPath.toFile());
            iarProjects.add(iarProject);
        }
        return iarProjects;
    }
}

