/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew.model;

import com.silabs.ss.framework.project.api.core.external.utils.IExternalProjectContentContainer;
import com.silabs.ss.framework.project.api.core.external.utils.ImporterTool;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARConfiguration;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARContentContainer;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Node;

public class IARProject
extends IARContentContainer
implements IExternalProjectContentContainer {
    public IARProject(Node iarProjectRoot, File ewpFile) {
        super(iarProjectRoot, (IPath)new Path(ewpFile.getParent()), null);
        this.setFile(ewpFile);
        super.setName(ewpFile.getName());
        this.setVariableReplacements(this.getProjectVariables());
        this.addConfigurations(this.getVariableReplacements());
        ImporterTool.ToolchainID projectToolchainID = null;
        if (!this.getConfigurations().isEmpty()) {
            projectToolchainID = ((IARConfiguration)this.getConfigurations().get(0)).getToolchain();
        }
        this.addGroupsAndFiles(this.getVariableReplacements(), projectToolchainID);
    }

    private Map<String, String> getProjectVariables() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("$CUR_DIR$", "studio:/project/");
        map.put("$PROJ_FNAME$", this.getName());
        map.put("$PROJ_DIR$", this.projectFolder().toString().replace("\\", "/"));
        map.put("$PROJ_PATH$", this.file().toString().replace("\\", "/"));
        map.put("###Uninitialized###", "");
        map.put("$FILE_DIR$", "");
        return map;
    }

    public void formatForImport() {
        this.getConfigurations().forEach(IARConfiguration::formatForImport);
    }
}

