/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew.model;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.builtin.ProjectBuiltInHandler;
import com.silabs.ss.framework.project.api.core.external.ProjectImportUtils;
import com.silabs.ss.framework.project.api.core.model.ELanguage;
import com.silabs.ss.framework.project.api.core.model.MBuildSetting;
import com.silabs.ss.framework.project.api.core.model.MMacroDefinition;
import com.silabs.ss.framework.project.internal.core.type.iarew.IARExternalProjectImporter;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARConfiguration;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.StringListOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class IARMacroDefinitions {
    private static final String CXX_NODE_NAME = "CCDefines";
    private static final String ASM_NODE_NAME = "ADefines";
    private final String OBJ_NODE_NAME;
    private final StringListOption cxxOption;
    private final StringListOption asmOption;
    private final StringListOption objOption;
    private IARConfiguration parent;

    public IARMacroDefinitions(IARConfiguration parent) {
        this.parent = parent;
        this.OBJ_NODE_NAME = parent.configInfo.getLinkerDefinesOptionName();
        this.cxxOption = (StringListOption)parent.getAndClear(CXX_NODE_NAME);
        this.asmOption = (StringListOption)parent.getAndClear(ASM_NODE_NAME);
        this.objOption = (StringListOption)parent.findOption(this.OBJ_NODE_NAME);
    }

    public String addMacro(String name, String value, List<ELanguage> langs, boolean replace) {
        if (TextUtils.isEmpty((String)value)) {
            value = "1";
        }
        String macro = name + "=" + value;
        if (langs.contains(ELanguage.C) || langs.contains(ELanguage.CPP)) {
            this.cxxOption.appendState(macro, replace);
        }
        if (langs.contains(ELanguage.ASM)) {
            this.asmOption.appendState(macro, replace);
        }
        return value;
    }

    public void removeIf(Predicate<String> remove) {
        this.cxxOption.removeNodes(remove);
        this.asmOption.removeNodes(remove);
    }

    public void removeBuiltins(ProjectBuiltInHandler builtins) {
        this.cxxOption.removeNodes(s -> this.isBuiltin(builtins, (String)s));
        this.asmOption.removeNodes(s -> this.isBuiltin(builtins, (String)s));
    }

    private boolean isBuiltin(ProjectBuiltInHandler builtins, String macro) {
        String[] macroSpl = TextUtils.splitByCharacter((String)macro, (char)'=');
        return builtins.isMacroBuiltin(macroSpl[0], macroSpl[1]);
    }

    public List<MBuildSetting> convert() {
        LinkedHashMap<String, MMacroDefinition> convertedContents = new LinkedHashMap<String, MMacroDefinition>();
        this.convertMacros(convertedContents, this.cxxOption, ProjectImportUtils.getELanguageString(ELanguage.C, ELanguage.CPP));
        this.convertMacros(convertedContents, this.asmOption, ProjectImportUtils.getELanguageString(ELanguage.ASM));
        this.convertMacros(convertedContents, this.objOption, ProjectImportUtils.getELanguageString(ELanguage.OBJ));
        return new ArrayList<MBuildSetting>(convertedContents.values());
    }

    private void convertMacros(Map<String, MMacroDefinition> macros, StringListOption macroOption, String lang) {
        if (macroOption == null) {
            return;
        }
        Iterator iterator = macroOption.getValue().iterator();
        while (iterator.hasNext()) {
            String macro = (String)iterator.next();
            MMacroDefinition macroDef = macros.get(macro);
            if (macroDef != null) {
                macroDef.setLanguageCompatibility(macroDef.getLanguageCompatibility() + " " + lang);
                continue;
            }
            macroDef = ProjectImportUtils.createMMacroDefinitionFromString(macro, lang, this.parent.variableReplacements, IARExternalProjectImporter.VARIABLE_PATTERN, this.parent.getUnconvertedVariables());
            macros.put(macro, macroDef);
        }
    }
}

