/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew.model;

import com.silabs.ss.framework.project.api.core.external.utils.IExternalProjectEntry;
import com.silabs.ss.framework.project.api.core.external.utils.ImporterTool;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IAREntry;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Node;

public class IARFile
extends IAREntry
implements IExternalProjectEntry {
    public IARFile(Node fileNode, IPath projectFolder, Map<String, String> replacements, ImporterTool.ToolchainID projectToolchainID) {
        super(fileNode, projectFolder, projectToolchainID);
        String filePath = this.getName().replaceAll("\\$PROJ_DIR\\$", projectFolder.toPortableString()).replace("\\", "/");
        this.setFile(new File(filePath));
        this.setName(this.file().getName());
        this.setVariableReplacements(this.getFileVariables(replacements));
        this.addConfigurations(this.getVariableReplacements());
        this.checkForLibraries();
    }

    private Map<String, String> getFileVariables(Map<String, String> replacements) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(replacements);
        map.put("$FILE_BNAME$", new Path(this.getName()).removeFileExtension().toPortableString());
        map.put("$FILE_BPATH$", new Path(this.file().toString()).removeFileExtension().toPortableString());
        map.put("$FILE_FNAME$", this.getName());
        map.put("$FILE_PATH$", new Path(this.file().toString()).toPortableString());
        map.put("$FILE_DIR$", new Path(this.file().getParent()).toPortableString());
        return map;
    }
}

