/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew.model;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IarEwpModelUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IARElement {
    protected static final String ELEMENT_NAME = "name";
    private ListMultimap<String, Node> childNodes;
    private String name;
    private Node node;
    private final String nodeName;
    protected Node spaceNode;
    protected Node insertionNode;

    public IARElement(Node node) {
        this.node = node;
        if (node == null) {
            this.name = "";
            this.nodeName = "";
            this.childNodes = ArrayListMultimap.create();
            return;
        }
        this.spaceNode = this.findTextNode();
        this.insertionNode = this.findInsertionNode();
        this.childNodes = IarEwpModelUtils.getChildNodes(node);
        this.name = !this.childNodes.containsKey((Object)ELEMENT_NAME) ? "" : ((Node)this.childNodes.get((Object)ELEMENT_NAME).get(0)).getTextContent();
        this.nodeName = this.name;
    }

    protected Node findTextNode() {
        if (this.getNode() == null || !this.getNode().hasChildNodes()) {
            return null;
        }
        int i = 0;
        while (i < this.getNode().getChildNodes().getLength()) {
            Node node = this.getNode().getChildNodes().item(i);
            String contents = node.getTextContent();
            if (contents.trim().isEmpty() && !contents.replace("\r", "").replace("\n", "").isEmpty()) {
                return node;
            }
            ++i;
        }
        return null;
    }

    private Node findInsertionNode() {
        if (this.getNode() == null || !this.getNode().hasChildNodes()) {
            return null;
        }
        int childLen = this.getNode().getChildNodes().getLength();
        Node lastNode = this.getNode().getChildNodes().item(childLen - 1);
        if (lastNode.getTextContent().trim().isEmpty()) {
            return lastNode;
        }
        return null;
    }

    protected Node createSubNode(String elementContent, String elementName, String elementNameKey) {
        LinkedHashMap<String, String> elemNameKeyToContent = new LinkedHashMap<String, String>();
        elemNameKeyToContent.put(elementNameKey, elementContent);
        return this.createSubNode(elemNameKeyToContent, elementName);
    }

    protected Node createSubNode(LinkedHashMap<String, String> elemNameKeyToContent, String elementName) {
        String spaceContent = this.spaceNode == null ? "\n\t" : this.spaceNode.getTextContent();
        String tabOnlyContent = spaceContent.replace("\n", "").replace("\r", "");
        int depth = this.depth();
        String singleTab = tabOnlyContent.substring(0, depth == 0 ? tabOnlyContent.length() : tabOnlyContent.length() / depth);
        String endContent = "\n".equals(spaceContent) ? spaceContent : spaceContent.substring(0, spaceContent.length() - singleTab.length());
        Document parent = this.getNode().getOwnerDocument();
        Element groupNode = parent.createElement(elementName);
        for (Map.Entry<String, String> nameKeyToContent : elemNameKeyToContent.entrySet()) {
            Element nameNode = parent.createElement(nameKeyToContent.getKey());
            nameNode.setTextContent(nameKeyToContent.getValue());
            groupNode.appendChild(parent.createTextNode(spaceContent + singleTab));
            groupNode.appendChild(nameNode);
            groupNode.appendChild(parent.createTextNode(spaceContent));
            this.getNode().appendChild(parent.createTextNode(singleTab));
            this.getNode().appendChild(groupNode);
            this.getNode().appendChild(parent.createTextNode(endContent));
        }
        return groupNode;
    }

    private int depth() {
        int i = 0;
        Node node = this.getNode().getParentNode();
        while (node != null && i < 100) {
            ++i;
            node = node.getParentNode();
        }
        return i;
    }

    public Node getNode() {
        return this.node;
    }

    public String getName() {
        return this.name;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ListMultimap<String, Node> childNodes() {
        return this.childNodes;
    }
}

