/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.solution.ISolutionEntity;
import com.silabs.ss.framework.project.api.core.solution.engine.BaseExternalSolutionEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.solution.engine.ISolutionEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionBuildStep;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionConfig;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionConfigSettings;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionModule;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionModuleReference;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionProject;
import com.silabs.ss.framework.project.api.core.solution.model.SolutionModelFactory;
import com.silabs.ss.framework.project.api.core.solution.operations.AddSolutionConfigProjectOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.AddSolutionDefinedModuleOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.AddSolutionModuleReferenceOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.AddSolutionProjectOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.BaseSetSolutionConfigBuildStepOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.BaseSolutionConfigEngineOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.CreateSolutionConfigOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.ResetSolutionModuleReferencesOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.SetGeneralPropertyOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.SetNameOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.SetSolutionConfigPostbuildStepOperation;
import com.silabs.ss.framework.project.api.core.solution.operations.SetSolutionConfigPrebuildStepOperation;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarEwProjectUtils;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarEwwMetadataHandler;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarIpcfModelUtils;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.IarProjectConnectionType;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARConfiguration;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARProject;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IarEwwBatchBuild;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IarEwwProject;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IarEwwWorkspace;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;

public class IarEwwSolutionOperationHandler
extends BaseExternalSolutionEngineOperationHandler
implements ISolutionEngineOperationHandler {
    private static final String BUILD_STEP_PREBUILD_SENTINEL = "%PREBUILD%";
    private static final String BUILD_STEP_POSTBUILD_SENTINEL = "%POSTBUILD%";
    private File ewwFile;
    private File slnIwcfFile;
    private IarProjectConnectionType slnIpcf;
    private IarEwwWorkspace iarSln;
    private IarEwwMetadataHandler iarSlnMetadata;
    private String preBuildStep = "";
    private String postBuildStep = "";

    public Path getEwwFilePath() {
        return this.ewwFile.toPath();
    }

    public Path getEwwDirPath() {
        return this.getParentFile(this.getEwwFilePath()).toPath();
    }

    public IarEwwSolutionOperationHandler(ISolutionEntity solution) {
        super(solution);
    }

    @Override
    public void load() throws CoreException {
        boolean isTemplate;
        try {
            this.ewwFile = this.getSolutionEntity().getInstallationPath().toFile();
            this.slnIwcfFile = FileUtils.replaceFileExtension((File)this.ewwFile, (String)"iwcf");
        }
        catch (IOException e) {
            throw Activator.reporter.newCoreException("Failed to load *.eww path", (Throwable)e);
        }
        File ewwTemplate = this.ewwFile;
        boolean bl = isTemplate = !ewwTemplate.isFile();
        if (isTemplate) {
            try {
                ewwTemplate.getParentFile().mkdirs();
                FileUtils.copyFile((File)IarEwProjectUtils.loadEwwTemplate(), (File)ewwTemplate);
            }
            catch (IOException e) {
                Activator.reporter.logError("Failed to copy .eww template file during initial solution generation.", (Throwable)e);
            }
        }
        this.iarSln = IarEwProjectUtils.loadIarSolution(ewwTemplate);
        if (!this.slnIwcfFile.isFile()) {
            this.slnIpcf = IarIpcfModelUtils.createStudioIpcf();
            this.iarSlnMetadata = new IarEwwMetadataHandler(this.slnIpcf);
            this.iarSlnMetadata.solution().clean();
            this.iarSlnMetadata.solution().model().setName(this.getSolutionEntity().getName());
        } else {
            this.slnIpcf = IarEwProjectUtils.loadProjectConnection(this.slnIwcfFile);
            this.iarSlnMetadata = IarEwwMetadataHandler.load(this.ewwFile);
            for (IarEwwProject ewwProject : this.iarSln.getIarEwwProjects()) {
                this.iarSlnMetadata.projectsCache().addCacheProjPath(ewwProject.path());
            }
            this.iarSln.clearProjects();
            EList moduleProjects = this.iarSlnMetadata.solution().model().getProjects();
            for (MSolutionProject project : moduleProjects) {
                File projFile = Path.of(project.getLocation(), new String[0]).toFile();
                String relProjPath = IarEwProjectUtils.getRelativeWsProjectPath(projFile, this.getEwwDirPath());
                this.iarSln.addProject(relProjPath);
            }
        }
        Collection<String> builtinProjPaths = this.iarSlnMetadata.builtins().builtinProjPaths();
        for (String builtinProjPath : builtinProjPaths) {
            this.iarSln.removeProject(builtinProjPath);
        }
    }

    @Override
    public void commit() throws CoreException {
        this.iarSlnMetadata.write();
        IarEwProjectUtils.writeIpcfFile(this.slnIpcf, this.slnIwcfFile);
        this.deleteGeneratedProjectEwwFiles(this.iarSln.getProjectPaths());
        List<Path> projPaths = this.iarSln.getProjectPaths();
        projPaths.stream().forEach(projPath -> IarEwProjectUtils.writeSolutionConnectionFile(projPath, this.getEwwFilePath().toAbsolutePath()));
        IarEwwBatchBuild batchBuild = this.iarSln.getBatchBuild();
        String batchDefName = IarEwProjectUtils.getStudioBatchDefName(this.getSolutionEntity().getName());
        batchBuild.removeBatchDefinitionsWithName(batchDefName);
        this.createBatchBuildDef(batchBuild, batchDefName);
        IarEwProjectUtils.writeIarXml(this.iarSln, this.ewwFile);
    }

    private void createBatchBuildDef(IarEwwBatchBuild batchBuild, String batchDefName) throws CoreException {
        ArrayList<IarEwwBatchBuild.IarEwwBatchEntry> batchDefMembers = new ArrayList<IarEwwBatchBuild.IarEwwBatchEntry>();
        BuildStepProject buildStepProj = this.createBuildStepProject();
        batchDefMembers.add(new IarEwwBatchBuild.IarEwwBatchEntry(buildStepProj.projName, "Solution_PreBuild"));
        for (Path iarProjPath : this.iarSln.getProjectPaths()) {
            if (iarProjPath.getFileName().equals(buildStepProj.projPath.getFileName())) continue;
            batchDefMembers.add(this.addBatchDefMember(iarProjPath));
        }
        batchDefMembers.add(new IarEwwBatchBuild.IarEwwBatchEntry(buildStepProj.projName, "Solution_PostBuild"));
        batchBuild.addBatchDefinition(batchDefName, batchDefMembers);
    }

    private BuildStepProject createBuildStepProject() throws CoreException {
        String projName = IarEwProjectUtils.buildStepProjName(this.getSolutionEntity().getName());
        Path buildStepProj = this.ewwFile.toPath().getParent().resolve(projName + ".ewp");
        try {
            Path ewpTemplate = IarEwProjectUtils.loadEwpBuildStepTemplate().toPath();
            String fileContents = FileUtils.readFileContents((Path)ewpTemplate, (Charset)FileUtils.defaultCharset());
            fileContents = fileContents.replace(BUILD_STEP_PREBUILD_SENTINEL, this.preBuildStep).replace(BUILD_STEP_POSTBUILD_SENTINEL, this.postBuildStep);
            FileUtils.writeFileContents((Path)buildStepProj, (String)fileContents, (Charset)FileUtils.defaultCharset());
            this.iarSln.getProjectPaths().add(buildStepProj);
            return new BuildStepProject(projName, buildStepProj);
        }
        catch (IOException e) {
            throw Activator.reporter.newCoreException("Failed to create build step project", (Throwable)e);
        }
    }

    private IarEwwBatchBuild.IarEwwBatchEntry addBatchDefMember(Path projPath) {
        String projName = projPath.getFileName().toString().replace(".ewp", "");
        String configName = this.getProjectConfig(projPath);
        return new IarEwwBatchBuild.IarEwwBatchEntry(projName, configName);
    }

    private String getProjectConfig(Path projPath) {
        String defaultConfigName = "Default";
        if (projPath.toFile().isFile()) {
            try {
                IARProject iarProject = IarEwProjectUtils.loadIarProject(projPath.toFile());
                return ((IARConfiguration)iarProject.getConfigurations().get(0)).getName();
            }
            catch (CoreException e) {
                Activator.reporter.logError("Failed to load IAR project " + projPath.toString(), (Throwable)e);
            }
        }
        return defaultConfigName;
    }

    private void deleteGeneratedProjectEwwFiles(List<Path> iarProjectPaths) {
        for (Path iarProjectPath : iarProjectPaths) {
            File projEwwFile;
            File projectDir = this.getParentFile(iarProjectPath);
            File[] siblingFiles = projectDir.listFiles();
            if (siblingFiles == null || siblingFiles.length == 0) {
                return;
            }
            List<File> iarProjectFiles = Arrays.asList(siblingFiles);
            String iarProjectPathStr = iarProjectPath.getFileName().toString();
            String genProjEwwName = iarProjectPathStr.replace(FileUtils.getExtension((String)iarProjectPathStr), "eww");
            Optional<File> optProjEwwFile = iarProjectFiles.stream().filter(iarFile -> Objects.equals(iarFile.getName(), genProjEwwName)).findFirst();
            if (!optProjEwwFile.isPresent() || !IarEwProjectUtils.isEwwStudioGenerated(projEwwFile = optProjEwwFile.get()) || projEwwFile.delete()) continue;
            Activator.reporter.logError("Failed to delete project .eww file " + projEwwFile.getAbsolutePath());
        }
    }

    private File getParentFile(Path filePath) {
        Path normPath = filePath.normalize();
        return normPath.getParent().toFile();
    }

    @Override
    public void handleSetSolutionConfigPrebuildStepOperation(SetSolutionConfigPrebuildStepOperation operation, IProgressMonitor monitor) throws CoreException {
        String buildStep = operation.buildStep();
        if (TextUtils.isEmpty((String)buildStep)) {
            return;
        }
        this.preBuildStep = this.substitutePostBuildVariables(buildStep);
        this.setMetadataSlnModelBuildStepOperation(operation, true);
    }

    @Override
    public void handleSetSolutionConfigPostbuildStepOperation(SetSolutionConfigPostbuildStepOperation operation, IProgressMonitor monitor) throws CoreException {
        String buildStep = operation.buildStep();
        if (TextUtils.isEmpty((String)buildStep)) {
            return;
        }
        this.postBuildStep = this.substitutePostBuildVariables(buildStep);
        this.setMetadataSlnModelBuildStepOperation(operation, false);
    }

    private void setMetadataSlnModelBuildStepOperation(BaseSetSolutionConfigBuildStepOperation operation, boolean prebuild) {
        MSolutionBuildStep slnModelBuildStep = SolutionModelFactory.eINSTANCE.createMSolutionBuildStep();
        slnModelBuildStep.setBuildStep(operation.buildStep());
        slnModelBuildStep.setBuiltin(operation.isBuiltIn());
        if (prebuild) {
            this.getSolutionConfig(operation).setPrebuildStep(slnModelBuildStep);
        } else {
            this.getSolutionConfig(operation).setPostbuildStep(slnModelBuildStep);
        }
    }

    @Override
    public void handleAddProjectOperation(AddSolutionProjectOperation operation, IProgressMonitor monitor) throws CoreException {
        Path locationPath;
        boolean isBuiltIn = operation.isBuiltin();
        String location = operation.location();
        String defaultFileName = operation.projectName() + ".ewp";
        if (location == null) {
            String projLocationFromModule = this.findProjLocationInSolutionModules(operation.projectName());
            if (!TextUtils.isEmpty((String)projLocationFromModule)) {
                String formattedModuleProjPath = "$WS_DIR$\\" + projLocationFromModule.replace("/", "\\") + "\\" + defaultFileName;
                this.addProjectToIarSln(formattedModuleProjPath, isBuiltIn);
                return;
            }
            String projLocFromCachedProjects = this.findProjLocationInClearedProjects(defaultFileName);
            if (!TextUtils.isEmpty((String)projLocFromCachedProjects)) {
                this.addProjectToIarSln(projLocFromCachedProjects, isBuiltIn);
                return;
            }
            locationPath = Path.of(defaultFileName, new String[0]);
        } else {
            locationPath = location.endsWith("ewp") ? Path.of(location, new String[0]) : Path.of(location, new String[0]).resolve(defaultFileName);
        }
        String relProjPath = IarEwProjectUtils.getRelativeWsProjectPath(locationPath.toFile(), this.getEwwDirPath());
        this.addProjectToIarSln(relProjPath, isBuiltIn);
    }

    private void addProjectToIarSln(String relProjPath, boolean isBuiltIn) {
        this.iarSln.addProject(relProjPath);
        if (isBuiltIn) {
            this.iarSlnMetadata.builtins().addBuiltInProjPath(relProjPath);
        }
    }

    private String findProjLocationInClearedProjects(String projectName) {
        for (String ewwProjectPath : this.iarSlnMetadata.projectsCache().cachedProjPaths()) {
            Path absProjPath = IarEwProjectUtils.getAbsoluteProjectPath(ewwProjectPath, this.getEwwDirPath());
            if (!Objects.equals(absProjPath.getFileName().toString(), projectName)) continue;
            return ewwProjectPath;
        }
        return null;
    }

    private String findProjLocationInSolutionModules(String projectName) {
        EList slnModules = this.iarSlnMetadata.solution().model().getSolutionDefinedModules();
        for (MSolutionModule mSlnModule : slnModules) {
            EList mSlnProjects = mSlnModule.getProjects();
            for (MSolutionProject mSlnProject : mSlnProjects) {
                if (!Objects.equals(mSlnProject.getName(), projectName) || mSlnProject.getLocation() == null) continue;
                return mSlnProject.getLocation();
            }
        }
        return null;
    }

    @Override
    public void handleSetNameOperation(SetNameOperation operation, IProgressMonitor monitor) throws CoreException {
        Object newEwwFileName = operation.name();
        if (!TextUtils.isEmpty((String)newEwwFileName)) {
            if (!((String)newEwwFileName).endsWith(".eww")) {
                newEwwFileName = (String)newEwwFileName + ".eww";
            }
            Path newEwwFilePath = Path.of(this.getEwwDirPath().toString(), operation.name() + ".eww");
            if (Objects.equals(this.ewwFile.toPath(), newEwwFilePath)) {
                return;
            }
            try {
                if (this.ewwFile.exists()) {
                    newEwwFilePath.toFile().getParentFile().mkdirs();
                    FileUtils.copyFile((File)this.ewwFile, (File)newEwwFilePath.toFile());
                    if (FileUtils.fileExists((String)newEwwFilePath.toString()) && this.ewwFile.delete()) {
                        this.ewwFile = newEwwFilePath.toFile();
                    }
                }
            }
            catch (IOException e) {
                Activator.reporter.logError("Failed to rename " + this.ewwFile.toString() + " to new name " + newEwwFilePath.toString(), (Throwable)e);
            }
            this.iarSlnMetadata.solution().model().setName(operation.name());
        }
    }

    @Override
    public void handleAddSolutionModuleReferenceOperation(AddSolutionModuleReferenceOperation operation, IProgressMonitor monitor) throws CoreException {
        MSolutionModuleReference ref = SolutionModelFactory.eINSTANCE.createMSolutionModuleReference();
        ref.setId(operation.moduleId());
        this.iarSlnMetadata.solution().model().getSolutionModuleReferences().add((Object)ref);
    }

    @Override
    public void handleAddSolutionDefinedModuleOperation(AddSolutionDefinedModuleOperation operation, IProgressMonitor monitor) throws CoreException {
        this.iarSlnMetadata.solution().model().getSolutionDefinedModules().add((Object)operation.module());
    }

    @Override
    public void handleAddSolutionConfigProjectOperation(AddSolutionConfigProjectOperation operation, IProgressMonitor monitor) throws CoreException {
        MSolutionConfig slnConfig = (MSolutionConfig)this.getSolutionConfig(operation);
        if (slnConfig == null) {
            return;
        }
        MSolutionProject project = SolutionModelFactory.eINSTANCE.createMSolutionProject();
        project.setName(operation.projectName());
        project.setConfiguration(operation.projectConfig());
        project.setBinary(operation.binary());
        project.setBuiltin(operation.isBuiltin());
        slnConfig.getProjects().add((Object)project);
    }

    @Override
    public void handleCreateSolutionConfigOperation(CreateSolutionConfigOperation operation, IProgressMonitor monitor) throws CoreException {
        MSolutionConfig newSlnConfig = (MSolutionConfig)this.getSolutionConfig(operation);
        if (newSlnConfig == null) {
            return;
        }
        newSlnConfig.setBuiltin(operation.isBuiltin());
        this.iarSlnMetadata.solution().model().getConfigs().add((Object)newSlnConfig);
    }

    @Override
    public void handleSetGeneralPropertyOperation(SetGeneralPropertyOperation operation, IProgressMonitor monitor) throws CoreException {
        this.iarSlnMetadata.solution().model().getPropertySet();
        MSolutionConfigSettings slnConfig = this.getSolutionConfig(operation);
        slnConfig.putPropertyEntry(operation.key(), operation.value(), operation.isBuiltin());
    }

    private MSolutionConfigSettings getSolutionConfig(BaseSolutionConfigEngineOperation operation) {
        String slnConfigName = operation.solutionConfig();
        if (TextUtils.isEmpty((String)slnConfigName)) {
            return this.iarSlnMetadata.solution().model();
        }
        Optional<MSolutionConfig> optSlnConfig = this.iarSlnMetadata.solution().model().getConfigs().stream().filter(slnConfig -> Objects.equals(slnConfigName, slnConfig.getName())).findFirst();
        if (optSlnConfig.isEmpty()) {
            MSolutionConfig newSlnConfig = SolutionModelFactory.eINSTANCE.createMSolutionConfig();
            newSlnConfig.setName(slnConfigName);
            this.iarSlnMetadata.solution().model().getConfigs().add((Object)newSlnConfig);
            return newSlnConfig;
        }
        return (MSolutionConfigSettings)optSlnConfig.get();
    }

    @Override
    public void handleResetSolutionModuleReferencesOperation(ResetSolutionModuleReferencesOperation operation, IProgressMonitor monitor) throws CoreException {
    }

    private record BuildStepProject(String projName, Path projPath) {
    }
}

