/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.silabs.java.utils.ExceptionUtils;
import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.log.Log;
import com.silabs.java.utils.variables.IVariableStore;
import com.silabs.java.utils.variables.KeyedVariableLookup;
import com.silabs.java.utils.variables.engine.CoreOperatorHandler;
import com.silabs.java.utils.variables.engine.IOperatorHandler;
import com.silabs.java.utils.variables.engine.IVariableSubstitutionEngine;
import com.silabs.java.utils.variables.engine.StockVariables;
import com.silabs.java.utils.variables.engine.VariableSubstitutionEngine;
import com.silabs.ss.framework.project.api.core.ProjectGenerationProperties;
import com.silabs.ss.framework.project.api.core.ProjectProperties;
import com.silabs.ss.framework.project.api.core.builtin.ProjectBuiltInHandler;
import com.silabs.ss.framework.project.api.core.engine.BaseExternalProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.engine.ICopiedFileReference;
import com.silabs.ss.framework.project.api.core.engine.IModuleReference;
import com.silabs.ss.framework.project.api.core.engine.ModuleReference;
import com.silabs.ss.framework.project.api.core.engine.ProjectModelModuleUtils;
import com.silabs.ss.framework.project.api.core.engine.ProjectModelUtils;
import com.silabs.ss.framework.project.api.core.engine.operations.AddIncludePathSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddLibraryFileSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddLibraryPathSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddMacroDefinitionSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddModuleReferenceOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddProjectDefinedModuleOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddProjectResourceFilterOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddSourceFolderToConfigurationOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.AddToolOptionOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.BaseProjectEngineConfigOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.ExcludeResourceFromConfigurationOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IAddToProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IConfigurationScopeEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IHandleFileProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IHandleFolderProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IncludeResourceIntoConfigurationOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.ResetModuleReferencesOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.SetConfigurationOutputBaseNameOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.SetConfigurationPostbuildStepOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.SetConfigurationPrebuildStepOperation;
import com.silabs.ss.framework.project.api.core.entity.IBuildConfiguration;
import com.silabs.ss.framework.project.api.core.entity.IExternalProjectEntity;
import com.silabs.ss.framework.project.api.core.external.BaseExternalProjectImporter;
import com.silabs.ss.framework.project.api.core.model.MConvertedOption;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MToolListOption;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import com.silabs.ss.framework.project.api.core.utils.ProjectFileUtils;
import com.silabs.ss.framework.project.api.toolchain.core.IResolvedToolOption;
import com.silabs.ss.framework.project.api.toolchain.core.ToolOption;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModelOptionEngine;
import com.silabs.ss.framework.project.internal.core.type.StudioExporterUtils;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarEwProjectUtils;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarEwpMetadataHandler;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarIpcfModelUtils;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.BuildActionType;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.FilePathType;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.FilesType;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.Groupable;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.IarProjectConnectionFactory;
import com.silabs.ss.framework.project.internal.core.type.iarew.iarprojconnection.IarProjectConnectionType;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.BaseIAROption;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARConfiguration;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARContentContainer;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARFile;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARGroup;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IARProject;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IarEwwWorkspace;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.URIListOption;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.URIOption;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.type.CoreTypes;
import com.silabs.ss.platform.api.rcp.core.BundleUtils;
import com.silabs.ss.platform.api.rcp.core.IPathUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.osgi.framework.Bundle;

public class IarEwpOperationHandler
extends BaseExternalProjectEngineOperationHandler {
    private static final String LIBRARY_MODULE_ID = "internal.iar.ewp.libraries";
    static final String DEFAULT_CONFIG_NAME = "Default";
    private File ewpFile;
    private File ipcfFile;
    private IARProject iarProject;
    private IarProjectConnectionType ipcf;
    private Set<File> addedFiles;
    private IarEwpMetadataHandler metadata;
    private String partName;
    private String configName;
    private final IVariableSubstitutionEngine standardEngine = VariableSubstitutionEngine.create((char)'(', (IOperatorHandler)CoreOperatorHandler.INSTANCE, (boolean)false);
    private IVariableStore projectVariables;
    private Path generationDir;
    private Path sdkDir;
    private Path relativeSdkDir;
    private Collection<Runnable> libraryFiles;
    private Map<File, IPath> projectLibFiles;
    private MProject libModule;
    private ModuleReference libModuleRef;
    private boolean copyFilesToEwp;
    private Map<IPath, String> addedFilesMap;
    private Multimap<IPath, String> filesToExclude;

    public IarEwpOperationHandler(IExternalProjectEntity projEnt) {
        super(projEnt);
    }

    @Override
    public void load() throws CoreException {
        IARContentContainer ipcfFolder;
        boolean isTemplate;
        IBuildConfiguration bConf = this.getTargetConfig();
        this.addedFiles = new HashSet<File>();
        this.libraryFiles = new ArrayList<Runnable>();
        this.projectLibFiles = new HashMap<File, IPath>();
        this.filesToExclude = LinkedHashMultimap.create();
        this.addedFilesMap = new HashMap<IPath, String>();
        this.libModule = ProjectModelFactory.eINSTANCE.createMProject();
        this.libModule.setPdmId(LIBRARY_MODULE_ID);
        this.libModule.setBuiltin(true);
        this.libModuleRef = new ModuleReference(ProjectModelModuleUtils.createModule(LIBRARY_MODULE_ID, ".*"));
        this.libModuleRef.getModule().setPdm(true);
        this.projectVariables = new KeyedVariableLookup();
        StockVariables.INSTANCE.setVariables(this.projectVariables, (Object)bConf);
        this.copyFilesToEwp = (Boolean)this.getProjectEntity().getProperty(ProjectGenerationProperties.IAR_EWP_LIST_FILES);
        this.generationDir = this.getProjectEntity().getInstallationFile().getParentFile().toPath();
        this.projectVariables.setValue("projectLocation", (Object)this.generationDir);
        this.relativeSdkDir = StudioExporterUtils.loadFromVariables(this.projectVariables, "sdkInstallationPath");
        this.sdkDir = null;
        this.ewpFile = FileUtils.replaceFileExtension((File)this.getProjectEntity().getInstallationFile(), (String)"ewp");
        this.ipcfFile = FileUtils.replaceFileExtension((File)this.ewpFile, (String)"ipcf");
        File ewpTemplate = this.ewpFile;
        boolean bl = isTemplate = !ewpTemplate.isFile();
        if (isTemplate) {
            ewpTemplate = IarEwProjectUtils.loadEwpTemplate();
        }
        this.iarProject = IarEwProjectUtils.loadIarProject(ewpTemplate);
        IARConfiguration config = this.iarProject.getConfigurations().stream().filter(c -> c.getName().equals(bConf.getName())).findFirst().orElse((IARConfiguration)this.iarProject.getConfigurations().get(0));
        String partOpn = (String)this.projectVariables.getValue("partOpn");
        config.getPart().changePart((String)bConf.getProperty(ProjectProperties.PART_ID), partOpn);
        this.partName = config.getPart().getPartName();
        Optional<IarProjectConnectionType> foundIpcf = IarIpcfModelUtils.findIpcfFiles(this.iarProject);
        String ipcfFilePath = "$PROJ_DIR$\\" + this.ipcfFile.getName();
        if (!foundIpcf.isPresent()) {
            this.iarProject.addFile(ipcfFilePath);
        }
        if (this.copyFilesToEwp && (ipcfFolder = IarIpcfModelUtils.findFolder((IARContentContainer)this.iarProject, IPathUtils.createPath((String)"Simplicity Configurator"))) != null) {
            this.iarProject.remove(ipcfFolder);
        }
        this.ipcf = IarIpcfModelUtils.createStudioIpcf();
        this.metadata = IarEwpMetadataHandler.load(foundIpcf.orElse(null), this.ipcf);
        config.includes().removeBuiltins((ProjectBuiltInHandler)this.metadata.builtins().getFor(null));
        config.macros().removeBuiltins((ProjectBuiltInHandler)this.metadata.builtins().getFor(null));
        this.metadata.builtins().resetLanguageSettings();
        this.metadata.modules().resetPdms();
        this.metadata.modules().resetRefs();
        this.metadata.properties().add(bConf);
        Optional.ofNullable(this.relativeSdkDir).map(Path::toUri).map(URI::toString).ifPresent(this.metadata.variables()::addSdkPath);
        if (isTemplate) {
            config.getOutputName().setOutputName(FileUtils.replaceFileExtension((File)this.ewpFile, (String)"s37").getName());
            config.getOutputFile().setOutputFile(FileUtils.replaceFileExtension((File)this.ewpFile, (String)"out").getName());
            config.setName(bConf.getName());
            this.addTemplateBuiltins();
        }
        this.configName = config.getName();
    }

    private void addTemplateBuiltins() {
        Object defaults = this.metadata.defaults().getFor(null);
        BaseExternalProjectImporter.ExternalProjectEntry externalEnt = new BaseExternalProjectImporter.ExternalProjectEntry(this.iarProject);
        BaseExternalProjectImporter.ExternalProjectConfiguration extConfig = externalEnt.getConfigurations().iterator().next();
        EList convertedOpts = extConfig.toMConfiguration().getConvertedOptions();
        ProjectModelOptionEngine.convertToToolOpts((Collection<MConvertedOption>)convertedOpts).optionStream().map(o -> new ToolOption(o.getToolId(), o.getOptionId(), o.getValue(), o.getToolListOptions().stream().map(MToolListOption::getValue))).peek(t -> t.setBuiltin(true)).forEach(arg_0 -> defaults.addToolOption(arg_0));
    }

    @Override
    public void commit() throws CoreException {
        this.clearExclusions(this.iarProject);
        Iterator iterator = this.filesToExclude.keys().iterator();
        while (iterator.hasNext()) {
            String filePath;
            IPath exclude;
            IARFile ewpFile = this.createEwpFile(exclude, filePath, !"".equals(filePath = this.addedFilesMap.getOrDefault(exclude = (IPath)iterator.next(), "")));
            if (ewpFile == null) continue;
            Collection configs = this.filesToExclude.get((Object)exclude);
            ewpFile.setExcludedConfigurationNames(configs);
        }
        this.libraryFiles.forEach(Runnable::run);
        this.metadata.modules().add(this.libModuleRef);
        this.metadata.modules().add(this.libModule);
        this.metadata.write();
        IarEwProjectUtils.writeIarXml(this.iarProject, this.ewpFile);
        IarEwProjectUtils.writeIpcfFile(this.ipcf, this.ipcfFile);
        ImmutableMap replMap = ImmutableMap.of((Object)"$--partNumber--$", (Object)this.partName, (Object)"$--ewpFile--$", (Object)this.ewpFile.getName(), (Object)"$--configName--$", (Object)this.configName);
        this.checkExtraFiles("ewd", (Map<String, String>)replMap);
        if (!this.slnEwwFileExists()) {
            this.buildDefaultEwwFile();
        }
    }

    private void clearExclusions(IARContentContainer folder) {
        folder.setExcludedConfigurationNames(List.of());
        for (IARFile file : folder.getChildFiles()) {
            file.setExcludedConfigurationNames(List.of());
        }
        for (IARGroup subFolder : folder.getChildFolders()) {
            this.clearExclusions(subFolder);
        }
    }

    private boolean slnEwwFileExists() throws CoreException {
        Optional<File> optSlnConnectionFile = IarEwProjectUtils.findSolutionConnectionFile(this.ewpFile.toPath());
        return optSlnConnectionFile.isPresent();
    }

    private void buildDefaultEwwFile() throws CoreException {
        String relProjPath = IarEwProjectUtils.getRelativeWsProjectPath(this.ewpFile, this.ewpFile.toPath().getParent());
        File existingEwwFile = FileUtils.replaceFileExtension((File)this.ewpFile, (String)"eww");
        if (existingEwwFile.isFile()) {
            IarEwwWorkspace iarWkspc = IarEwProjectUtils.loadIarSolution(existingEwwFile);
            iarWkspc.updateProjectPath(0, relProjPath);
            return;
        }
        File ewwFile = this.checkExtraFiles("eww", Map.of());
        if (ewwFile == null || !ewwFile.isFile()) {
            return;
        }
        IarEwwWorkspace iarWkspc = IarEwProjectUtils.loadIarSolution(ewwFile);
        iarWkspc.addProject(relProjPath);
        IarEwProjectUtils.writeIarXml(iarWkspc, ewwFile);
    }

    private File checkExtraFiles(String extension, Map<String, String> replacements) {
        File extraFile = FileUtils.replaceFileExtension((File)this.ewpFile, (String)extension);
        if (extraFile.isFile()) {
            return extraFile;
        }
        try {
            File extraTemplate = BundleUtils.getBundleContentPath((Bundle)Activator.getContext().getBundle(), (IPath)IPathUtils.createPath((String)("data/iar_ew_templates/arm/arm." + extension)), Collections.emptyMap()).toFile();
            String extraContents = new String(FileUtils.readFileContents((File)extraTemplate, null));
            for (Map.Entry<String, String> entry : replacements.entrySet()) {
                extraContents = extraContents.replace(entry.getKey(), entry.getValue());
            }
            FileUtils.writeFileContents((File)extraFile, (String)extraContents);
            return extraFile;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected void handleAddCopiedFileReference(ICopiedFileReference reference) {
        this.metadata.copiedFiles().add(reference);
    }

    @Override
    protected Collection<ICopiedFileReference> copiedFiles() {
        return this.metadata.copiedFiles().copiedFileRefs();
    }

    @Override
    public void handleSetConfigurationPrebuildStepOperation(SetConfigurationPrebuildStepOperation operation, IProgressMonitor monitor) throws CoreException {
        String preBuildCmd = this.substitutePostBuildVariables(operation.getPrebuildStep());
        this.ipcf.setPreBuild(this.createBuildStep(preBuildCmd));
        if (this.copyFilesToEwp) {
            IARConfiguration config = this.findConfig(operation);
            config.buildActions().setPreBuild(preBuildCmd);
        }
    }

    @Override
    public void handleSetConfigurationPostbuildStepOperation(SetConfigurationPostbuildStepOperation operation, IProgressMonitor monitor) throws CoreException {
        String postBuildCmd = this.substitutePostBuildVariables(operation.getPostbuildStep());
        this.ipcf.setPostBuild(this.createBuildStep(postBuildCmd));
        if (this.copyFilesToEwp) {
            IARConfiguration config = this.findConfig(operation);
            config.buildActions().setPostBuild(postBuildCmd);
        }
    }

    private BuildActionType createBuildStep(String cmd) {
        BuildActionType bat = IarProjectConnectionFactory.eINSTANCE.createBuildActionType();
        bat.setCommand(cmd);
        return bat;
    }

    @Override
    protected String lookupBuildDirVariable() {
        return "$TARGET_DIR$";
    }

    @Override
    public void handleAddToolOptionOperation(AddToolOptionOperation op, IProgressMonitor monitor) throws CoreException {
        IProperty prop = StudioExporterUtils.findProperty(op);
        if (prop == null || !prop.getId().startsWith("iar.ewp.arm")) {
            return;
        }
        boolean isListValue = CoreTypes.STRING_LIST.getType() == prop.getType();
        ArrayList<String> baseValues = new ArrayList<String>();
        if (!TextUtils.isEmpty((String)op.getValue())) {
            if (isListValue) {
                baseValues.addAll((Collection)CoreTypes.STRING_LIST.convert(op.getValue()));
            } else {
                baseValues.add(op.getValue());
            }
        }
        op.getListOperatons().stream().map(AddToolOptionOperation.AddToolListOptionOperation::getValue).forEachOrdered(baseValues::add);
        IARConfiguration config = this.findConfig(op);
        Map<String, BaseIAROption<?>> options = config.getOptionMap();
        BaseIAROption<?> baseOpt = options.get(prop.getName());
        if (baseOpt == null) {
            Log.warning((String)("Unknown option for property " + prop.getId()), (Throwable)ExceptionUtils.newMinimalStackException());
            return;
        }
        if (baseOpt instanceof URIOption || baseOpt instanceof URIListOption) {
            baseValues = baseValues.stream().map(this::resolveAndRelativizePath).collect(Collectors.toList());
        }
        if (baseValues.isEmpty()) {
            baseValues.add("");
        }
        baseOpt.setValue(baseValues);
        IResolvedToolOption option = StudioExporterUtils.getToolOption(op, prop, isListValue, baseValues);
        ((ProjectBuiltInHandler)this.metadata.builtins().getFor(op.getProjectPath())).addToolOption(option);
        ((ProjectBuiltInHandler)this.metadata.defaults().getFor(op.getProjectPath())).removeToolOption(option);
    }

    @Override
    public void handleAddIncludePathSettingOperation(AddIncludePathSettingOperation operation, IProgressMonitor monitor) throws CoreException {
        String resolvedPath = this.resolveAndRelativizePath(operation.getUri());
        IARConfiguration config = this.findConfig(operation);
        config.includes().addPath(resolvedPath, ProjectModelUtils.getLanguagesFor(operation), true);
        if (operation.isBuiltin()) {
            this.builtins(operation).addInclude(operation.getUri());
        }
    }

    @Override
    public void handleAddMacroDefinitionSettingOperation(AddMacroDefinitionSettingOperation operation, IProgressMonitor monitor) throws CoreException {
        IARConfiguration config = this.findConfig(operation);
        String normalizedValue = config.macros().addMacro(operation.getName(), operation.getValue(), ProjectModelUtils.getLanguagesFor(operation), true);
        if (operation.isBuiltin()) {
            this.builtins(operation).addMacro(operation.getName(), normalizedValue);
        }
    }

    @Override
    protected void registerProjectFile(IAddToProjectEngineOperation operation, IPath prjPath, File fileLoc) {
        if (operation instanceof IHandleFolderProjectEngineOperation) {
            this.createGroup(prjPath, true);
        } else if (operation instanceof IHandleFileProjectEngineOperation) {
            if (ProjectFileUtils.isLibraryFile(fileLoc)) {
                this.projectLibFiles.put(fileLoc, prjPath);
            } else {
                this.handleFile(fileLoc, prjPath);
            }
        }
    }

    @Override
    public void handleExcludeResourceFromConfigurationOperation(ExcludeResourceFromConfigurationOperation operation, IProgressMonitor monitor) throws CoreException {
        IPath projPath = operation.getProjectPath();
        this.filesToExclude.put((Object)projPath, (Object)operation.getBuildConfiguration());
    }

    @Override
    public void handleAddLibraryFileSettingOperation(AddLibraryFileSettingOperation operation, IProgressMonitor monitor) throws CoreException {
        IPath libPath;
        URI libUri = operation.getLibraryURI();
        if (libUri == null) {
            String libName = operation.getLibraryName();
            if (operation.isBuiltin()) {
                this.builtins(operation).addLibraryFile(libName);
            }
            IARConfiguration config = this.findConfig(operation);
            config.libraries().addLibrary(libName, true);
            return;
        }
        File libFile = StudioExporterUtils.resolvePath(this.standardEngine, this.projectVariables, libUri);
        if (this.relativeSdkDir != null) {
            String path = StudioExporterUtils.getRelativePath(libFile, false, this.relativeSdkDir, this.generationDir).replace(StudioExporterUtils.getVariableCounter(0), "").replace(StudioExporterUtils.getVariableCounter(1), "");
            IPath relLibPath = IPathUtils.createPath((String)path);
            int count = relLibPath.matchingFirstSegments(IPathUtils.create((String)".."));
            libPath = relLibPath.removeFirstSegments(count);
        } else {
            libPath = IPathUtils.createPath((String)"libraries").append(libFile.getName());
        }
        if (operation.isBuiltin()) {
            this.builtins(operation).addLibraryFile(operation.getLibraryURI());
        }
        this.libraryFiles.add(() -> this.handleLibFile(libFile, libPath));
    }

    private void handleLibFile(File libFile, IPath defaultLibPath) {
        IPath libPath = this.projectLibFiles.getOrDefault(libFile, defaultLibPath);
        if (this.handleFile(libFile, libPath)) {
            this.libModuleRef.getBuiltinSources().add(libPath.toPortableString());
        }
    }

    private boolean handleFile(File fileLoc, IPath prjPath) {
        if (!this.addedFiles.add(fileLoc) || fileLoc.getName().endsWith(".ipcf")) {
            return false;
        }
        IARFile iarFile = IarIpcfModelUtils.findFile(this.iarProject, prjPath, fileLoc.getAbsolutePath());
        if (iarFile != null) {
            return false;
        }
        String relativeFile = this.getRelativePath(fileLoc, false);
        Groupable group = this.createGroup(prjPath.removeLastSegments(1), false);
        FilePathType file = IarProjectConnectionFactory.eINSTANCE.createFilePathType();
        file.setPath(relativeFile);
        group.getFiles().add((Object)file);
        this.addedFilesMap.put(prjPath, relativeFile);
        if (this.copyFilesToEwp) {
            this.createEwpFile(prjPath, relativeFile);
        }
        return true;
    }

    private IARFile createEwpFile(IPath prjPath, String fileLoc) {
        return this.createEwpFile(prjPath, fileLoc, true);
    }

    private IARFile createEwpFile(IPath prjPath, String fileLoc, boolean create) {
        IPath ewpPrjPath = IPathUtils.createPath((String)"Simplicity Configurator").append(prjPath);
        boolean isAbsolute = IPathUtils.create((String)fileLoc).toFile().isAbsolute();
        Object ewpPath = isAbsolute ? fileLoc : "$PROJ_DIR$\\" + fileLoc;
        return IarIpcfModelUtils.doFindOrCreateFile(this.iarProject, ewpPrjPath, (String)ewpPath, create);
    }

    private Groupable createGroup(IPath prjPath, boolean validate) {
        IARContentContainer folder;
        if (validate && (folder = IarIpcfModelUtils.findFolder((IARContentContainer)this.iarProject, prjPath)) != null) {
            return null;
        }
        FilesType files = this.ipcf.getFiles();
        if (files == null) {
            files = IarProjectConnectionFactory.eINSTANCE.createFilesType();
            this.ipcf.setFiles(files);
        }
        if (this.copyFilesToEwp) {
            this.createEwpGroup(prjPath);
        }
        return IarIpcfModelUtils.findOrCreateFolder(files, prjPath);
    }

    private IARContentContainer createEwpGroup(IPath prjPath) {
        IPath ewpPrjPath = IPathUtils.createPath((String)"Simplicity Configurator").append(prjPath);
        return IarIpcfModelUtils.findOrCreateFolder(this.iarProject, ewpPrjPath);
    }

    @Override
    public void handleAddLibraryPathSettingOperation(AddLibraryPathSettingOperation operation, IProgressMonitor monitor) throws CoreException {
        if (operation.isBuiltin()) {
            this.builtins(operation).addLibraryPath(operation.getLibraryURI());
        }
    }

    @Override
    public void handleAddModuleReferenceOperation(AddModuleReferenceOperation operation, IProgressMonitor monitor) throws CoreException {
        IModuleReference modRef = operation.getModuleReference();
        if (LIBRARY_MODULE_ID.equals(modRef.getId())) {
            return;
        }
        this.metadata.modules().add(modRef);
    }

    @Override
    public void handleResetModuleReferencesOperation(ResetModuleReferencesOperation operation, IProgressMonitor monitor) throws CoreException {
        this.metadata.modules().resetRefs();
    }

    @Override
    public void handleAddProjectDefinedModuleOperation(AddProjectDefinedModuleOperation operation, IProgressMonitor monitor) throws CoreException {
        MProject modDef = operation.getModuleDefinition();
        if (LIBRARY_MODULE_ID.equals(modDef.getPdmId())) {
            return;
        }
        this.metadata.modules().add(modDef);
    }

    private IARConfiguration findConfig(IConfigurationScopeEngineOperation op) {
        return (IARConfiguration)this.iarProject.getConfigurations().get(0);
    }

    private ProjectBuiltInHandler builtins(BaseProjectEngineConfigOperation operation) {
        return this.metadata.builtins().getFor(operation.getProjectPath());
    }

    private String resolveAndRelativizePath(String uriStr) {
        URI uri;
        if (uriStr.startsWith("$")) {
            return uriStr.replace("/", "\\");
        }
        try {
            uri = new URI(uriStr);
        }
        catch (URISyntaxException uRISyntaxException) {
            return uriStr;
        }
        return this.resolveAndRelativizePath(uri);
    }

    private String resolveAndRelativizePath(URI uri) {
        String path = StudioExporterUtils.resolveAndRelativizePath(this.standardEngine, this.projectVariables, uri, false, this.sdkDir, this.generationDir);
        return this.formatPath(path, true);
    }

    private String getRelativePath(File fileLoc, boolean absolute) {
        String path = StudioExporterUtils.getRelativePath(fileLoc, false, this.sdkDir, this.generationDir);
        return this.formatPath(path, absolute);
    }

    private String formatPath(String path, boolean absolute) {
        String projRepl = absolute ? "$PROJ_DIR$\\" : "";
        String sdkRepl = "";
        return path.replace("/", "\\").replace(StudioExporterUtils.getVariableCounter(0), sdkRepl).replace(StudioExporterUtils.getVariableCounter(1), projRepl);
    }

    @Override
    public void handleAddProjectResourceFilterOperation(AddProjectResourceFilterOperation operation, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void handleAddSourceFolderToConfigurationOperation(AddSourceFolderToConfigurationOperation operation, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void handleIncludeResourceIntoConfigurationOperation(IncludeResourceIntoConfigurationOperation operation, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void handleSetConfigurationOutputBaseNameOperation(SetConfigurationOutputBaseNameOperation operation, IProgressMonitor monitor) throws CoreException {
    }
}

