/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.iarew;

import com.silabs.ss.framework.project.api.core.external.IFlagParser;
import com.silabs.ss.framework.project.api.core.external.IImportProjectDescriptor;
import com.silabs.ss.framework.project.api.core.external.IStringSplitter;
import com.silabs.ss.framework.project.api.core.external.ProjectImportUtils;
import com.silabs.ss.framework.project.api.core.external.utils.ImporterTool;
import com.silabs.ss.framework.project.api.core.model.MBuildSetting;
import com.silabs.ss.framework.project.api.core.model.options.IDirectOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.IGenericOptionMappingRegistry;
import com.silabs.ss.framework.project.internal.api.core.external.impl.PropertyInfo;
import com.silabs.ss.framework.project.internal.core.type.iarew.IARDirectOptionsMapping;
import com.silabs.ss.framework.project.internal.core.type.iarew.IARExternalProjectImporter;
import com.silabs.ss.framework.project.internal.core.type.iarew.IARGenericOptionsMappings;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarEwp8051ExternalOptions;
import com.silabs.ss.framework.project.internal.core.type.iarew.IarEwpArmExternalOptions;
import com.silabs.ss.framework.project.internal.core.type.iarew.model.IIARConfigurationInfo;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class IARFlagParser
implements IFlagParser {
    private static Pattern INCLUDE = Pattern.compile("(?<=^-I).*");
    private static Pattern MACRO = Pattern.compile("(?<=^-D).*");
    private static Pattern LIBPATH = Pattern.compile("(?<=^-L).*");
    private static Pattern VARIABLE_PATTERN = IARExternalProjectImporter.VARIABLE_PATTERN;
    private Set<String> unconvertedVariables;
    private IIARConfigurationInfo info;

    public IARFlagParser(ImporterTool.ToolchainID toolchain) {
        this(toolchain == ImporterTool.ToolchainID.ARM ? new IarEwpArmExternalOptions() : new IarEwp8051ExternalOptions());
    }

    public IARFlagParser(IIARConfigurationInfo info) {
        this.info = info;
    }

    @Override
    public String getToolchainCompatibility() {
        return ".*iar.*";
    }

    @Override
    public Collection<String> getUnconvertedVariables() {
        if (this.unconvertedVariables == null) {
            this.unconvertedVariables = new HashSet<String>();
        }
        return this.unconvertedVariables;
    }

    @Override
    public List<MBuildSetting> getBuildSettingsFromFlagList(List<String> flags, ImporterTool.ToolchainID toolchainID, ImporterTool.ToolType toolType, URI basePath, IImportProjectDescriptor desc, Map<String, String> variables) {
        Pattern includePattern = null;
        Pattern macroPattern = MACRO;
        Pattern libPattern = null;
        IStringSplitter includeSplitter = ProjectImportUtils.getSemicolonOrCommaStringSplitter();
        IStringSplitter macroSplitter = ProjectImportUtils.getMacroSemicolonOrCommaStringSplitter();
        if (toolType == ImporterTool.ToolType.COMPILER || toolType == ImporterTool.ToolType.ASSEMBLER) {
            includePattern = INCLUDE;
        } else if (toolType == ImporterTool.ToolType.LINKER) {
            libPattern = LIBPATH;
        }
        return ProjectImportUtils.createBuildSettingsFromFlags(flags, basePath, ProjectImportUtils.getELanguage(toolType), includePattern, includeSplitter, macroPattern, macroSplitter, libPattern, includeSplitter, null, null, desc, variables, VARIABLE_PATTERN, this.getUnconvertedVariables());
    }

    @Override
    public List<String> splitCommandLineFlags(String flags) {
        return ProjectImportUtils.splitHyphenDeliminatedFlags(flags);
    }

    @Override
    public Map<IProperty, Object> getFlagProperties(List<String> flags, ImporterTool.ToolchainID toolchainID, ImporterTool.ToolType toolType) {
        return this.getFlagProperties(flags, toolType);
    }

    public Map<IProperty, Object> getFlagProperties(List<String> flags, ImporterTool.ToolType toolType) {
        HashMap<IProperty, Object> flagProperties = new HashMap<IProperty, Object>();
        IProperty miscFlagsProperty = this.info.getMiscOpt(toolType);
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String flag : flags) {
            ArrayList<String> values = new ArrayList<String>();
            String flagId = this.parseFlag(flag, this.info.toolchain(), toolType, values);
            PropertyInfo propertyInfo = this.info.property(PropertyInfo.generateId(flagId, ""), toolType);
            if (propertyInfo == null) continue;
            Object importValue = this.getImportValue(propertyInfo, values, this.info.toolchain(), toolType);
            flagProperties.put(propertyInfo.getProperty(), importValue);
            toRemove.add(flag);
        }
        ProjectImportUtils.removeStringsFromStringList(flags, toRemove);
        String squashedFlags = ProjectImportUtils.squashStringListToString(flags);
        if (miscFlagsProperty != null) {
            flagProperties.put(miscFlagsProperty, squashedFlags);
        }
        return flagProperties;
    }

    private Object getImportValue(PropertyInfo propertyInfo, List<String> values, ImporterTool.ToolchainID toolchainID, ImporterTool.ToolType toolType) {
        String name = propertyInfo.getId();
        IProperty property = propertyInfo.getProperty();
        String propertyType = property.getType().getName();
        Object value = null;
        if (propertyType.equals("string")) {
            value = values.isEmpty() ? null : values.get(0);
        } else if (propertyType.equals("uriList")) {
            if (name.equals(PropertyInfo.generateId("--system_include_dir", ""))) {
                String args;
                String string = args = values.isEmpty() ? "" : values.get(0);
                if (!args.isEmpty()) {
                    value = Arrays.asList(args.split(","));
                } else {
                    return null;
                }
            }
            value = ProjectImportUtils.convertStringListToURIList(values);
        } else if (propertyType.equals("stringList")) {
            value = values;
        } else if (propertyType.equals("int")) {
            value = values.isEmpty() ? null : Integer.valueOf(Integer.parseInt(values.get(0)));
        } else if (propertyType.equals("boolean")) {
            String val;
            String string = val = values.isEmpty() ? "" : values.get(0);
            if (val.equals("1")) {
                value = true;
            } else if (val.equals("0")) {
                value = false;
            } else assert (false);
        }
        return value;
    }

    public String parseFlag(String flag, ImporterTool.ToolchainID toolchainId, ImporterTool.ToolType toolType, List<String> values) {
        String[] regexFlagList = null;
        String flagId = "";
        regexFlagList = toolType == ImporterTool.ToolType.COMPILER ? new String[]{"-l"} : (toolType == ImporterTool.ToolType.LINKER ? new String[]{"-a", "-c", "-e", "-F", "-g", "-H", "-h", "-J", "-K", "-L", "-M", "-n", "-O", "-o", "-p", "-Q", "-R", "-U", "-V", "-w", "-x", "-Y", "-y", "-Z", "-z"} : new String[]{});
        String[] flagParts = null;
        String[] stringArray = regexFlagList;
        int n = regexFlagList.length;
        int n2 = 0;
        while (n2 < n) {
            String regexFlag = stringArray[n2];
            flagParts = this.splitByRegex(flag, regexFlag);
            if (flagParts != null) break;
            ++n2;
        }
        if (flagParts != null) {
            flagId = flagParts[0];
            if (flagParts.length > 1) {
                values.add(flagParts[1]);
            }
            return flagId;
        }
        String newName = "";
        String newValue = "1";
        String[] splitState = flag.split("=", 2);
        if (splitState.length > 1) {
            newName = splitState[0];
            newValue = splitState[1];
        } else {
            splitState = flag.split(" ", 2);
            newName = splitState[0];
            if (splitState.length > 1) {
                newValue = splitState[1];
            }
        }
        flagId = newName;
        if (!newValue.isEmpty()) {
            values.add(newValue.trim());
        }
        return newName;
    }

    private boolean matchPattern(String string, String regex) {
        return string.matches(regex + ".*");
    }

    private String[] splitByRegex(String state, String flag) {
        if (!this.matchPattern(state, flag)) {
            return null;
        }
        String[] splitString = state.split(flag, 2);
        return splitString;
    }

    @Override
    public IGenericOptionMappingRegistry getGenericRegistry() {
        return IARGenericOptionsMappings.iarOptionMappingRegistry;
    }

    @Override
    public IDirectOptionMappingRegistry getDirectRegistry() {
        return IARDirectOptionsMapping.registry();
    }
}

