/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type.generic;

import com.silabs.java.utils.FileUtils;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectCopiedFiles;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectMetadataHandler;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectModuleHandler;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectPropertiesHandler;
import com.silabs.ss.framework.project.internal.core.type.IExternalProjectMetadata;
import com.silabs.ss.framework.project.internal.core.type.generic.GenericProjectContentMetadata;
import com.silabs.ss.framework.project.internal.core.type.generic.GenericProjectRootMetadata;
import com.silabs.ss.framework.project.internal.core.type.generic.GenericTypeUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public class GenericMetadataHandler
extends ExternalProjectMetadataHandler<MProject, GenericMetadataHandler> {
    protected GenericProjectRootMetadata projectRoot;
    protected ExternalProjectModuleHandler modules;
    protected ExternalProjectCopiedFiles copiedFiles;
    protected ExternalProjectPropertiesHandler properties;
    protected GenericProjectContentMetadata projectSources;
    protected Map<String, Object> contentMap;
    protected File projFile;

    public GenericMetadataHandler() {
    }

    public GenericMetadataHandler(Map<String, Object> aContentMap, File aTemplateFile) {
        this.contentMap = aContentMap;
        this.projFile = aTemplateFile;
    }

    @Override
    protected void loadMetadataHandlers(List<IExternalProjectMetadata<MProject>> handlers) {
        this.projectRoot = new GenericProjectRootMetadata();
        handlers.add(this.projectRoot);
        this.projectSources = new GenericProjectContentMetadata();
        handlers.add(this.projectSources);
        this.modules = new ExternalProjectModuleHandler();
        handlers.add(this.modules);
        this.copiedFiles = new ExternalProjectCopiedFiles();
        handlers.add(this.copiedFiles);
        this.properties = new ExternalProjectPropertiesHandler();
        handlers.add(this.properties);
    }

    public ExternalProjectModuleHandler modules() {
        return this.modules;
    }

    public ExternalProjectCopiedFiles copiedFiles() {
        return this.copiedFiles;
    }

    public ExternalProjectPropertiesHandler properties() {
        return this.properties;
    }

    public GenericProjectContentMetadata projectContent() {
        return this.projectSources;
    }

    @Override
    protected void writeStringContent(String metadata) {
        this.contentMap.put(this.getKeyMetadata(), metadata);
    }

    @Override
    protected String getStringContent() {
        return this.extractMetadataFromFile(this.projFile);
    }

    protected String extractMetadataFromFile(File outputFile) {
        if (!outputFile.exists()) {
            return "";
        }
        String content = GenericTypeUtils.synchronizeFile(outputFile, () -> this.doLoadFile(outputFile));
        int begMetadata = content.lastIndexOf(this.getMetadataBeginLine());
        if (begMetadata < 0) {
            return "";
        }
        int endMetadata = content.lastIndexOf(this.getMetadataEndLine());
        if (endMetadata < 0 || endMetadata < begMetadata) {
            return "";
        }
        String mapContent = content.substring(begMetadata + this.getMetadataBeginLine().length(), endMetadata);
        return mapContent;
    }

    private String doLoadFile(File outputFile) {
        try {
            return FileUtils.readFileContents((Path)outputFile.toPath(), null);
        }
        catch (IOException e) {
            Activator.reporter.logException((Throwable)e);
            return "";
        }
    }

    public static GenericMetadataHandler forLoading(File outputFile) {
        return GenericMetadataHandler.forWriting(null, outputFile);
    }

    public static GenericMetadataHandler forWriting(Map<String, Object> aContentMap, File outputFile) {
        return (GenericMetadataHandler)new GenericMetadataHandler(aContentMap, outputFile).load();
    }

    protected String getMetadataBeginLine() {
        return "BEGIN_" + this.getKeyMetadata() + "=";
    }

    protected String getMetadataEndLine() {
        return "=END_" + this.getKeyMetadata();
    }

    protected String getKeyMetadata() {
        return "SIMPLICITY_STUDIO_METADATA";
    }
}

