/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type;

import com.silabs.ss.framework.project.api.core.solution.model.MSolution;
import com.silabs.ss.framework.project.api.core.solution.model.SolutionModelFactory;
import com.silabs.ss.framework.project.api.core.solution.model.util.manual.SolutionModelLoading;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectMetadataHandler;
import com.silabs.ss.framework.project.internal.core.type.IExternalProjectMetadata;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;

public class ExternalSolutionModelHandler
implements IExternalProjectMetadata<MSolution> {
    private static final String KEY = "SIMPLICITY_STUDIO_SOLUTION_MODEL";
    private MSolution model = SolutionModelFactory.eINSTANCE.createMSolution();

    public void add(MSolution model) {
        this.model = model;
    }

    public MSolution model() {
        return this.model;
    }

    public void clean() {
        this.model = SolutionModelFactory.eINSTANCE.createMSolution();
    }

    @Override
    public void apply(MSolution solution) {
        solution.getSolutionDefinedModules().addAll((Collection)this.model.getSolutionDefinedModules());
        Stream.concat(Stream.of(this.model), this.model.getConfigs().stream()).forEach(m -> {
            boolean bl = solution.getSolutionModuleReferences().addAll((Collection)m.getSolutionModuleReferences());
        });
        solution.setName(this.model.getName());
    }

    @Override
    public void write(ExternalProjectMetadataHandler<MSolution, ?> handler) {
        try {
            handler.put(KEY, SolutionModelLoading.storeMSolutionsToString((MSolution[])new MSolution[]{this.model}));
        }
        catch (IOException e) {
            Activator.reporter.logException((Throwable)e);
        }
    }

    @Override
    public void load(ExternalProjectMetadataHandler<MSolution, ?> handler) {
        try {
            List solutions = SolutionModelLoading.loadMSolutionsFromString((String)handler.get(KEY));
            if (!solutions.isEmpty()) {
                this.model = (MSolution)solutions.get(0);
            }
        }
        catch (IOException e) {
            Activator.reporter.logException((Throwable)e);
        }
        if (this.model == null) {
            this.model = SolutionModelFactory.eINSTANCE.createMSolution();
        }
    }
}

