/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.type;

import com.silabs.ss.framework.project.api.core.BuildConfigProperties;
import com.silabs.ss.framework.project.api.core.ProjectCommonProperties;
import com.silabs.ss.framework.project.api.core.engine.IModuleReference;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.util.manual.ProjectModelLoading;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.type.ExternalProjectMetadataHandler;
import com.silabs.ss.framework.project.internal.core.type.IExternalProjectMetadata;
import com.silabs.ss.platform.api.descriptor.core.type.CoreTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.CoreException;

public class ExternalProjectModuleHandler
implements IExternalProjectMetadata<MProject> {
    private static final String KEY_MODULES = "SIMPLICITY_STUDIO_MODULES";
    private static final String KEY_PDMS = "SIMPLICITY_STUDIO_PDMS";
    private Collection<IModuleReference> modRefs = new LinkedHashSet<IModuleReference>();
    private Collection<MProject> pdms = new LinkedHashSet<MProject>();
    private String modRefStr;

    public void add(IModuleReference reference) {
        this.modRefs.add(reference);
    }

    public void add(MProject project) {
        this.pdms.add(project);
    }

    public void resetRefs() {
        this.modRefs.clear();
    }

    public void resetPdms() {
        this.pdms.clear();
    }

    public Collection<IModuleReference> modRefs() {
        return this.modRefs;
    }

    @Override
    public void apply(MProject project) {
        this.modRefs.stream().filter(r -> !r.isRemoved()).map(IModuleReference::getModule).forEach(arg_0 -> project.getModules().add(arg_0));
        project.getProperties().put((Object)ProjectCommonProperties.REFERENCED_MODULES.id(), (Object)this.modRefStr);
        project.getProjectDefinedModules().addAll(this.pdms);
    }

    @Override
    public void write(ExternalProjectMetadataHandler<MProject, ?> handler) {
        String moduleRefs = BuildConfigProperties.REFERENCED_MODULES.type().stringize(this.modRefs);
        String pdmStr = ExternalProjectModuleHandler.writeMProject(this.pdms);
        handler.put(KEY_MODULES, moduleRefs);
        handler.put(KEY_PDMS, pdmStr);
    }

    @Override
    public void load(ExternalProjectMetadataHandler<MProject, ?> handler) {
        this.modRefStr = handler.get(KEY_MODULES);
        this.modRefs = (Collection)BuildConfigProperties.REFERENCED_MODULES.type().convert(this.modRefStr);
        this.pdms = ExternalProjectModuleHandler.loadMProject(handler.get(KEY_PDMS));
    }

    private static String writeMProject(Collection<MProject> pdms) {
        ArrayList<String> pdmContents = new ArrayList<String>();
        for (MProject pdm : pdms) {
            try {
                String mprojStr = ProjectModelLoading.storeMProjectModel((MProject)pdm);
                pdmContents.add(mprojStr);
            }
            catch (CoreException e) {
                Activator.reporter.logException((Throwable)e);
            }
        }
        String pdmStr = CoreTypes.STRING_LIST.stringize(pdmContents);
        return pdmStr;
    }

    private static Collection<MProject> loadMProject(String pdmStr) {
        Collection pdms = (Collection)CoreTypes.STRING_LIST.convert(pdmStr);
        ArrayList<MProject> pdmContent = new ArrayList<MProject>();
        for (String pdm : pdms) {
            try {
                pdmContent.add(ProjectModelLoading.loadProjectModel((String)pdm));
            }
            catch (CoreException e) {
                Activator.reporter.logException((Throwable)e);
            }
        }
        return pdmContent;
    }
}

