/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.templates;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.variables.IVariableLookup;
import com.silabs.java.utils.variables.MapVariableLookup;
import com.silabs.java.utils.variables.engine.CoreOperatorHandler;
import com.silabs.java.utils.variables.engine.IOperatorHandler;
import com.silabs.java.utils.variables.engine.VariableSubstitutionEngine;
import com.silabs.ss.framework.project.api.core.engine.BaseWrappedProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.engine.operations.CopyProjectFileOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.LinkProjectFileOperation;
import com.silabs.ss.framework.project.api.templates.ITemplateContext;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.platform.api.rcp.core.URIUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class TemplateProjectEngineOperationHandler
extends BaseWrappedProjectEngineOperationHandler {
    private VariableSubstitutionEngine engine;
    private IVariableLookup templateVariableLookup;
    private boolean shouldExpand;

    public TemplateProjectEngineOperationHandler(IProjectEngineOperationHandler wrapped, ITemplateContext context, boolean shouldExpand) {
        super(wrapped);
        this.shouldExpand = shouldExpand;
        this.templateVariableLookup = new MapVariableLookup(context.getVariableMap());
        this.engine = new VariableSubstitutionEngine('(');
        this.engine.setOperatorHandler((IOperatorHandler)CoreOperatorHandler.INSTANCE);
    }

    @Override
    public void handleCopyProjectFileOperation(CopyProjectFileOperation operation, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (this.shouldExpand) {
            File filePath;
            try {
                filePath = URIUtils.resolveURIToPath((URI)operation.getContentURI()).toFile();
            }
            catch (IOException e) {
                throw Activator.reporter.newCoreException("cannot access " + String.valueOf(operation.getContentURI()), (Throwable)e);
            }
            if (filePath.isFile()) {
                File newFile = this.createTempExpandedFile(filePath, operation.getProjectPath(), (IProgressMonitor)subMonitor.newChild(1));
                operation = new CopyProjectFileOperation(operation.getSession(), operation.getProjectPath(), newFile, null, operation.getSelector());
            } else {
                LinkProjectFileOperation linkOp = new LinkProjectFileOperation(operation.getSession(), null, operation.getProjectPath(), filePath, null, operation.getSelector());
                super.handleLinkProjectFileOperation(linkOp, (IProgressMonitor)subMonitor);
            }
        }
        subMonitor.setWorkRemaining(1);
        super.handleCopyProjectFileOperation(operation, (IProgressMonitor)subMonitor.newChild(1));
    }

    protected File createTempExpandedFile(File content, IPath prjPath, IProgressMonitor monitor) throws CoreException {
        File tempFile;
        String contentStr;
        try {
            contentStr = new String(FileUtils.readFileContents((File)content, null));
        }
        catch (IOException e1) {
            throw Activator.reporter.newCoreException("Failed to read " + String.valueOf(content), (Throwable)e1);
        }
        contentStr = this.expandString(prjPath, contentStr);
        try {
            tempFile = File.createTempFile("expandedFile", "");
            FileUtils.writeFileContents((File)tempFile, (String)contentStr);
        }
        catch (IOException e) {
            Activator.reporter.logError("Failed to expand file", (Throwable)e);
            tempFile = content;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return tempFile;
    }

    private String expandString(final IPath filePath, String contentStr) {
        IVariableLookup fileVariableLookup = new IVariableLookup(){

            public Object getValue(String var) {
                if ("filename".equals(var)) {
                    return filePath.lastSegment();
                }
                return TemplateProjectEngineOperationHandler.this.templateVariableLookup.getValue(var);
            }

            public Collection<String> getVariableNames() {
                ArrayList<String> all = new ArrayList<String>(TemplateProjectEngineOperationHandler.this.templateVariableLookup.getVariableNames());
                all.add("filename");
                return all;
            }
        };
        return this.engine.substitute(contentStr, fileVariableLookup);
    }
}

