/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.templates;

import com.silabs.ss.framework.project.api.core.templates.ProjectTemplateUtils;
import com.silabs.ss.framework.project.api.templates.ITemplateDescriptor;
import com.silabs.ss.framework.project.api.templates.IWriteableTemplateDescriptor;
import com.silabs.ss.framework.project.api.templates.TemplateDescriptor;
import com.silabs.ss.framework.project.api.templates.TemplateProperties;
import com.silabs.ss.framework.project.api.templates.manager.ITemplateDetector;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.platform.api.content.core.item.Appnote;
import com.silabs.ss.platform.api.content.core.item.ContentItemProperties;
import com.silabs.ss.platform.api.content.core.item.IContentItemDescriptor;
import com.silabs.ss.platform.api.descriptor.core.IWriteableDescriptor;
import com.silabs.ss.platform.api.descriptor.core.property.CoreProperties;
import com.silabs.ss.platform.api.descriptor.core.registry.BaseDetector;
import com.silabs.ss.platform.api.descriptor.core.registry.RegistryDescriptorUtils;
import com.silabs.ss.platform.api.sdk.core.SDKProperties;
import com.silabs.ss.platform.performance.recording.LoggingFeature;
import com.silabs.ss.platform.performance.recording.StopWatch;
import com.silabs.ss.platform.performance.recording.rcp.PerformanceManager;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class AppNoteProjectTemplateDetector
extends BaseDetector<ITemplateDescriptor>
implements ITemplateDetector {
    public AppNoteProjectTemplateDetector() {
        super("Scanning templates...", ITemplateDescriptor.class);
    }

    protected void detectInDirectory(List<ITemplateDescriptor> descs, File dir) {
    }

    protected void quickScan(List<ITemplateDescriptor> descs, IProgressMonitor monitor) {
        StopWatch stopWatch = PerformanceManager.INSTANCE.logStart(LoggingFeature.ALL, "AppNoteProjectTemplateDetector.detectDescriptors", null);
        IContentItemDescriptor[] appnotes = (IContentItemDescriptor[])Appnote.registry().getAllDescriptors();
        monitor.beginTask("Scanning app notes for templates", appnotes.length);
        IContentItemDescriptor[] iContentItemDescriptorArray = appnotes;
        int n = appnotes.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                Path templatesFile;
                IContentItemDescriptor appnote = iContentItemDescriptorArray[n2];
                ArrayList<String> templateIds = new ArrayList<String>();
                String templatesFileProp = (String)appnote.getProperty(ContentItemProperties.TEMPLATES_FILE);
                if (templatesFileProp != null && !templatesFileProp.isEmpty() && (templatesFile = new Path(templatesFileProp)).toFile().isFile()) {
                    Collection detected;
                    try {
                        detected = RegistryDescriptorUtils.loadDescriptorsFromFile(TemplateDescriptor.class, (File)templatesFile.toFile(), (String)"template");
                    }
                    catch (IOException e) {
                        Activator.reporter.logException((Throwable)e);
                        break block8;
                    }
                    for (ITemplateDescriptor template : detected) {
                        String[] projectFiles;
                        String projectFilesProp = template.getPropertyAccess().getValueString(TemplateProperties.PROJECT_FILES);
                        if (projectFilesProp == null || projectFilesProp.isEmpty()) {
                            Activator.reporter.logError("Template project file(s) not specified: " + template.getLabel());
                            continue;
                        }
                        IWriteableTemplateDescriptor writeable = (IWriteableTemplateDescriptor)template;
                        writeable.setProperty(TemplateProperties.CONTRIBUTING_APPNOTE, (Object)appnote.getId());
                        writeable.setProperty(SDKProperties.CONTRIBUTING_SDK, (Object)((String)appnote.getProperty(SDKProperties.CONTRIBUTING_SDK)));
                        ProjectTemplateUtils.setDefaults(writeable);
                        int projectFileIndex = 0;
                        String[] stringArray = projectFiles = projectFilesProp.split(",");
                        int n3 = projectFiles.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String projectFile = stringArray[n4];
                            ITemplateDescriptor tmpl = this.createAppNoteTemplate(writeable, appnote, (IPath)templatesFile, projectFile, projectFileIndex);
                            if (tmpl != null) {
                                descs.add(tmpl);
                                templateIds.add(tmpl.getId());
                            }
                            ++projectFileIndex;
                            ++n4;
                        }
                    }
                    ((IWriteableDescriptor)appnote).setProperty(ContentItemProperties.TEMPLATE_IDS, templateIds);
                }
            }
            ++n2;
        }
        PerformanceManager.INSTANCE.logEnd(stopWatch);
        monitor.done();
    }

    private ITemplateDescriptor createAppNoteTemplate(IWriteableTemplateDescriptor writeable, IContentItemDescriptor appnote, IPath templatesFile, String projectFile, int projectFileIndex) {
        String type;
        String fileExtension;
        Object id;
        if (projectFileIndex > 0) {
            writeable = (IWriteableTemplateDescriptor)writeable.copy();
        }
        if (projectFile.startsWith("asset")) {
            try {
                URI installationURI = new URI(projectFile);
                String path = installationURI.getPath();
                writeable.setProperty(CoreProperties.INSTALLATION_PATH, (Object)installationURI);
                id = appnote.getId() + "." + path;
                fileExtension = new Path(path).getFileExtension();
            }
            catch (URISyntaxException uRISyntaxException) {
                Activator.reporter.logError("Invalid URI for project file path: " + projectFile);
                return null;
            }
        } else {
            IPath absolutePath = templatesFile.removeLastSegments(1).append(projectFile.replace("%20", " "));
            if (!absolutePath.toFile().exists()) {
                Activator.reporter.logError("Template project file not found: " + absolutePath.toPortableString());
                return null;
            }
            writeable.setProperty(CoreProperties.INSTALLATION_PATH, (Object)absolutePath.toFile().toURI());
            id = this.createUniqueId(appnote.getId(), absolutePath);
            fileExtension = absolutePath.getFileExtension();
        }
        writeable.setId((String)id);
        writeable.setProperty(CoreProperties.HIDDEN, (Object)true);
        if (projectFileIndex > 0) {
            writeable.setName((String)id);
        }
        if ("template".equals(type = writeable.getPropertyAccess().getValueString(TemplateProperties.TYPE))) {
            writeable.setProperty(TemplateProperties.COPY_ORIGINAL_CONTENT, (Object)false);
            writeable.setProperty(CoreProperties.HIDDEN, (Object)true);
        } else {
            writeable.setProperty(TemplateProperties.COPY_ORIGINAL_CONTENT, (Object)true);
        }
        if (fileExtension.equalsIgnoreCase("slsproj")) {
            writeable.setProperty(TemplateProperties.NAMESPACE, (Object)"projectTemplate");
        }
        writeable.setProperty(CoreProperties.BUILTIN, (Object)true);
        return writeable;
    }

    private String createUniqueId(String sdkId, IPath path) {
        StringBuilder id = new StringBuilder(sdkId);
        String[] stringArray = path.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            id.append(".");
            id.append(segment);
            ++n2;
        }
        return id.toString();
    }
}

