/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.repos;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.templates.ITemplateDescriptor;
import com.silabs.ss.framework.project.api.templates.IWriteableTemplateDescriptor;
import com.silabs.ss.framework.project.api.templates.manager.ITemplateDetector;
import com.silabs.ss.framework.project.internal.api.core.templates.TemplateUtils;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.platform.api.descriptor.core.property.CoreProperties;
import com.silabs.ss.platform.api.descriptor.core.registry.BaseDetector;
import com.silabs.ss.platform.api.repos.IRepo;
import com.silabs.ss.platform.api.repos.Repo;
import com.silabs.ss.platform.api.repos.RepoProperties;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class RepoTemplatesDetector
extends BaseDetector<ITemplateDescriptor>
implements ITemplateDetector {
    public RepoTemplatesDetector() {
        super("Scanning Repo templates...", ITemplateDescriptor.class);
    }

    protected void detectInDirectory(List<ITemplateDescriptor> descs, File dir) {
    }

    protected void quickScan(List<ITemplateDescriptor> descs, IProgressMonitor monitor) {
        IRepo[] repos = (IRepo[])Repo.manager().getAll();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Scanning Repos for templates", (int)repos.length);
        IRepo[] iRepoArray = repos;
        int n = repos.length;
        int n2 = 0;
        while (n2 < n) {
            IRepo repo = iRepoArray[n2];
            if (((String)repo.getProperty(RepoProperties.REPO_TYPE)).equals("template")) {
                this.scanForRepo(descs, (IProgressMonitor)subMonitor.newChild(1), repo);
            }
            ++n2;
        }
    }

    public ITemplateDescriptor[] detectDescriptors(Map<String, Object> parameters, IProgressMonitor monitor) throws CoreException {
        if (this.shouldScan(parameters, "parentId")) {
            ArrayList<ITemplateDescriptor> descs = new ArrayList<ITemplateDescriptor>();
            String repoId = (String)parameters.get("parentId");
            IRepo repo = (IRepo)Repo.manager().find(repoId);
            if (repo != null) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("Scanning Repo for templates: " + repo.getLabel()), (int)1);
                this.scanForRepo(descs, (IProgressMonitor)subMonitor.newChild(1), repo);
                return descs.toArray(new ITemplateDescriptor[descs.size()]);
            }
        }
        return (ITemplateDescriptor[])super.detectDescriptors(parameters, (IProgressMonitor)(monitor == null ? new NullProgressMonitor() : monitor));
    }

    protected boolean shouldScan(Map<String, Object> parameters, String key) {
        if ("parentId".equals(key)) {
            return parameters.get(key) != null;
        }
        return super.shouldScan(parameters, key);
    }

    private void scanForRepo(List<ITemplateDescriptor> descs, IProgressMonitor monitor, IRepo repo) {
        try {
            String path = repo.getTemplatesPath(monitor);
            if (TextUtils.hasContent((String)path)) {
                ArrayList<ITemplateDescriptor> descsRepo = new ArrayList<ITemplateDescriptor>();
                TemplateUtils.loadTemplateFile(descsRepo, null, (IPath)new Path(path));
                for (ITemplateDescriptor desc : descsRepo) {
                    IWriteableTemplateDescriptor descW = (IWriteableTemplateDescriptor)desc;
                    descW.setProperty(CoreProperties.PROVIDER_LABEL, (Object)repo.getLabel());
                    descW.setProperty(CoreProperties.PROVIDER_URI, (Object)((URI)repo.getProperty(RepoProperties.REPO_URI)).toString());
                    descW.setProperty(RepoProperties.PROVIDING_REPO, (Object)repo.getId());
                    descs.add((ITemplateDescriptor)descW);
                }
            }
        }
        catch (Exception e) {
            Activator.reporter.logException((Throwable)e);
        }
    }
}

