/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.engine;

import com.silabs.java.utils.MapUtils;
import com.silabs.java.utils.Pair;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.engine.IProjectModel;
import com.silabs.ss.framework.project.api.core.engine.ProjectModelUtils;
import com.silabs.ss.framework.project.api.core.model.MConfigSettings;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MModule;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MProjectResourceTree;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import com.silabs.ss.framework.project.api.core.model.MSettingsSite;
import com.silabs.ss.framework.project.api.core.model.util.manual.ProjectModelLoading;
import com.silabs.ss.framework.project.api.toolchain.core.configs.StockConfiguration;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModelMergeUtils;
import com.silabs.ss.platform.api.descriptor.core.compatibility.Compatibility;
import com.silabs.ss.platform.api.descriptor.core.registry.IRegistry;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;

public class ProjectModuleHandlerUtils {
    public static Map<IBuildConfigurationDescriptor, MConfiguration> createBConfToMConfMap(IProjectDescriptor projDesc, MProject expanded) {
        LinkedHashMap<IBuildConfigurationDescriptor, MConfiguration> configMap = new LinkedHashMap<IBuildConfigurationDescriptor, MConfiguration>();
        IBuildConfigurationDescriptor[] iBuildConfigurationDescriptorArray = projDesc.getBuildConfigurationDescriptors();
        int n = iBuildConfigurationDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildConfigurationDescriptor buildConf = iBuildConfigurationDescriptorArray[n2];
            MConfiguration config = ProjectModelUtils.findOrAddNewConfigurationFor(expanded, buildConf);
            configMap.put(buildConf, config);
            ++n2;
        }
        return configMap;
    }

    public static void mergeDuplicateFolders(MFolderEntry folder) {
        HashMap<String, MFolderEntry> cachedMap = new HashMap<String, MFolderEntry>();
        Iterator iter = folder.getFolders().iterator();
        while (iter.hasNext()) {
            MFolderEntry subFold = (MFolderEntry)iter.next();
            MFolderEntry oldFolder = cachedMap.put(subFold.getName(), subFold);
            if (oldFolder != null) {
                oldFolder.getFolders().addAll((Collection)subFold.getFolders());
                oldFolder.getFiles().addAll((Collection)subFold.getFiles());
                ProjectModelMergeUtils.mergeSettingsSites((MSettingsSite)subFold, (MSettingsSite)oldFolder);
                ProjectModelMergeUtils.mergeSelectableSettings((MSelectable)subFold, (MSelectable)oldFolder);
                ProjectModuleHandlerUtils.mergeDuplicateFolders(oldFolder);
                iter.remove();
                continue;
            }
            ProjectModuleHandlerUtils.mergeDuplicateFolders(subFold);
        }
    }

    public static <T extends MSettingsSite & MConfigSettings> MConfiguration mergeConfig(MProject project, IBuildConfigurationDescriptor conf, T clientConf) throws CoreException {
        MConfiguration expandedConf = project.findConfigurationByName(conf.getName());
        if (expandedConf == null) {
            throw Activator.reporter.newCoreException("did not find model config for " + String.valueOf(conf), null);
        }
        ProjectModelMergeUtils.mergeSettingsSites(clientConf, (MSettingsSite)expandedConf);
        ProjectModelMergeUtils.mergeConfigSettings(clientConf, (MConfigSettings)expandedConf);
        return expandedConf;
    }

    public static MConfiguration findMatchingStockConfig(MProject model, IBuildConfigurationDescriptor conf) {
        for (MConfiguration config : model.getConfigurations()) {
            String stockCompat = config.getStockConfigCompatibility();
            if (TextUtils.isEmpty((String)stockCompat) || !Compatibility.fromGrammarString((IRegistry)StockConfiguration.manager(), (String)stockCompat).isCompatibleWith(conf.getStockConfigurationId())) continue;
            return config;
        }
        return null;
    }

    public static Map<String, Pair<Set<MModule>, Set<IBuildConfigurationDescriptor>>> collapseModuleMap(Map<Pair<String, MModule>, Set<IBuildConfigurationDescriptor>> moduleConfigMap) {
        HashMap<String, Pair<Set<MModule>, Set<IBuildConfigurationDescriptor>>> modIdConfigMap = new HashMap<String, Pair<Set<MModule>, Set<IBuildConfigurationDescriptor>>>();
        for (Map.Entry<Pair<String, MModule>, Set<IBuildConfigurationDescriptor>> mcmEnt : moduleConfigMap.entrySet()) {
            String moduleId = (String)mcmEnt.getKey().first;
            MModule module = (MModule)mcmEnt.getKey().second;
            Set<IBuildConfigurationDescriptor> buildConfigs = mcmEnt.getValue();
            Pair modConfigs = (Pair)MapUtils.findOrCreate(modIdConfigMap, (Object)moduleId, () -> new Pair(new HashSet(), new HashSet()));
            ((Set)modConfigs.first).add(module);
            ((Set)modConfigs.second).addAll(buildConfigs);
        }
        return modIdConfigMap;
    }

    public static Map<Pair<String, MModule>, Set<IBuildConfigurationDescriptor>> buildModuleToConfigMap(IProjectModel userModel, MProject expanded, Map<IBuildConfigurationDescriptor, MConfiguration> configMap) {
        LinkedHashMap<Pair<String, MModule>, Set<IBuildConfigurationDescriptor>> moduleConfigMap = new LinkedHashMap<Pair<String, MModule>, Set<IBuildConfigurationDescriptor>>();
        ProjectModuleHandlerUtils.doBuildModuleToConfigMap(userModel, moduleConfigMap, (List<MModule>)expanded.getModules(), configMap.keySet());
        configMap.forEach((buildConfig, mconfig) -> ProjectModuleHandlerUtils.doBuildModuleToConfigMap(userModel, moduleConfigMap, (List<MModule>)mconfig.getModules(), Arrays.asList(buildConfig)));
        return moduleConfigMap;
    }

    private static void doBuildModuleToConfigMap(IProjectModel userModel, Map<Pair<String, MModule>, Set<IBuildConfigurationDescriptor>> moduleConfigMap, List<MModule> modules, Collection<IBuildConfigurationDescriptor> buildConfigs) {
        modules.stream().map(mod -> new Pair((Object)userModel.resolveString(mod.getId()), mod)).map(key -> (Set)MapUtils.findOrCreate((Map)moduleConfigMap, (Object)key, HashSet::new)).forEach(confs -> {
            boolean bl = confs.addAll(buildConfigs);
        });
        modules.clear();
    }

    public static void dumpExpandedProject(MProject expanded, MProjectResourceTree rsrcTree, MultiStatus multiStatus) throws CoreException {
        StringBuilder sb = new StringBuilder();
        sb.append(ProjectModelLoading.storeMProjectModel((MProject)expanded));
        sb.append("\nResource trees:\n");
        for (Map.Entry ent : rsrcTree.getConfigurations().entrySet()) {
            sb.append("\n\tConfig ").append((String)ent.getKey()).append(":\n");
            sb.append(ent.getValue());
        }
        sb.append("\n---------------\n");
        IStatus[] iStatusArray = multiStatus.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            sb.append(status.getMessage()).append('\n');
            ++n2;
        }
        sb.append("\n---------------\n");
        System.out.println(sb);
    }
}

