/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.engine;

import com.silabs.java.utils.MapUtils;
import com.silabs.java.utils.Pair;
import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.engine.IProjectModel;
import com.silabs.ss.framework.project.api.core.engine.ProjectModelUtils;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MFolderReference;
import com.silabs.ss.framework.project.api.core.model.MModule;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MProjectReference;
import com.silabs.ss.framework.project.api.core.model.MProjectResourceTree;
import com.silabs.ss.framework.project.api.core.model.MReference;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import com.silabs.ss.framework.project.api.core.model.util.ProjectModelSwitch;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModelCompatibility;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModuleAccessor;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModuleHandlerUtils;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModuleUpdateUtils;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ProjectModuleExclusionHandler {
    private IProjectModel userModel;
    private MProject expanded;
    private Map<IBuildConfigurationDescriptor, MConfiguration> configMap;
    private MProjectResourceTree rsrcTree;
    private Map<String, Set<String>> builtinSourcesMap = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> builtinExcludesMap = new HashMap<String, Set<String>>();
    private final RemoveContent removals = new RemoveContent();

    public ProjectModuleExclusionHandler(IProjectModel userModel, MProject expanded, Map<IBuildConfigurationDescriptor, MConfiguration> configMap, MProjectResourceTree rsrcTree) {
        this.userModel = userModel;
        this.expanded = expanded;
        this.configMap = configMap;
        this.rsrcTree = rsrcTree;
    }

    public Map<String, Set<String>> getBuiltinSources() {
        return this.builtinSourcesMap;
    }

    public Map<String, Set<String>> getBuiltinExcludes() {
        return this.builtinExcludesMap;
    }

    public Set<String> getSourcesFor(String moduleKey) {
        return (Set)MapUtils.findOrCreate(this.builtinSourcesMap, (Object)moduleKey, LinkedHashSet::new);
    }

    public Set<String> getExcludesFor(String moduleKey) {
        return (Set)MapUtils.findOrCreate(this.builtinExcludesMap, (Object)moduleKey, LinkedHashSet::new);
    }

    public Collection<IPath> getRemovedFiles() {
        return this.removals.removedFiles;
    }

    public Collection<IPath> getRemovedFolders() {
        return this.removals.removedFolders;
    }

    public static void standardizeExclusions(MProject expanded) {
        EList projExcls = expanded.getExcludedPaths();
        expanded.getConfigurations().forEach(arg_0 -> ProjectModuleExclusionHandler.lambda$2((List)projExcls, arg_0));
        projExcls.clear();
    }

    public static List<IBuildConfigurationDescriptor> determineIfExcluded(IProjectDescriptor projectDesc, IProjectModel rawModel, MProject expandedModel, MSelectable selector, ProjectModelCompatibility configCompat, IPath projectPath, IProjectModel configModel) {
        MProject existingModel = rawModel == null ? null : rawModel.getModel();
        List<IBuildConfigurationDescriptor> exclCfgs = configCompat.calculateContentExclusion(projectDesc, selector);
        if (exclCfgs == null && existingModel != null && ProjectModelUtils.findEntry(configModel, (MFolderEntry)existingModel, projectPath) != null && ProjectModelUtils.findEntry(configModel, (MFolderEntry)expandedModel, projectPath) == null) {
            exclCfgs = Stream.of(projectDesc.getBuildConfigurationDescriptors()).collect(Collectors.toList());
        }
        return exclCfgs;
    }

    public void excludeFromConfigs(MEntry entry, List<IBuildConfigurationDescriptor> exclCfgs, MModule mmodule) {
        if (exclCfgs == null) {
            return;
        }
        String projPath = ProjectModelUtils.getProjectPathFor(entry).toString();
        for (IBuildConfigurationDescriptor exclCfg : exclCfgs) {
            MProjectReference projRef = (MProjectReference)this.rsrcTree.getConfigurations().get((Object)exclCfg.getId());
            MReference ref = (MReference)projRef.getEntryToReferenceMap().get(entry);
            if (ref == null || !ref.isBuiltin()) continue;
            String moduleKey = ProjectModuleAccessor.getModuleKey((IDescriptor)exclCfg, mmodule);
            this.getExcludesFor(moduleKey).add(projPath);
            ref.setExcluded(true);
        }
    }

    public boolean cleanModuleSources(IProjectDescriptor projDesc, Map<Pair<String, MModule>, Set<IBuildConfigurationDescriptor>> moduleConfigMap) {
        Map<String, Pair<Set<MModule>, Set<IBuildConfigurationDescriptor>>> modIdConfigMap = ProjectModuleHandlerUtils.collapseModuleMap(moduleConfigMap);
        boolean changed = false;
        IBuildConfigurationDescriptor[] iBuildConfigurationDescriptorArray = projDesc.getBuildConfigurationDescriptors();
        int n = iBuildConfigurationDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildConfigurationDescriptor buildConf = iBuildConfigurationDescriptorArray[n2];
            HashSet<String> allSourcesToRemove = new HashSet<String>();
            HashSet allSourcesToAdd = new HashSet();
            modIdConfigMap.entrySet().forEach(mcmEnt -> {
                String moduleId = (String)mcmEnt.getKey();
                Set buildConfigs = (Set)((Pair)mcmEnt.getValue()).second;
                Set setToUse = buildConfigs.contains(buildConf) ? allSourcesToAdd : allSourcesToRemove;
                buildConfigs.parallelStream().map(bconf -> ProjectModuleAccessor.getModuleKey((IDescriptor)bconf, moduleId)).map(this.builtinSourcesMap::get).filter(Objects::nonNull).forEachOrdered(setToUse::addAll);
            });
            allSourcesToRemove.removeAll(allSourcesToAdd);
            changed |= ProjectModuleExclusionHandler.excludeModuleFromConfig((MProjectReference)this.rsrcTree.getConfigurations().get((Object)buildConf.getName()), allSourcesToRemove);
            ++n2;
        }
        return changed;
    }

    private static boolean excludeModuleFromConfig(MProjectReference projRef, Set<String> allModuleSources) {
        boolean[] changed = new boolean[1];
        allModuleSources.parallelStream().map(Path::new).map(p -> ProjectModelUtils.findReference((MFolderReference)projRef, (IPath)p)).filter(Objects::nonNull).filter(ref -> !ref.isExcluded()).filter(MReference::isBuiltin).forEach(ref -> {
            ref.setExcluded(true);
            blArray[0] = true;
        });
        return changed[0];
    }

    public void finalizeExclusions(ProjectModuleAccessor accessor, MProjectResourceTree originalRsrcTree) {
        this.excludeOldModuleSources(accessor, originalRsrcTree);
        this.recursivelyEliminateFullyExcludedFiles((MEntry)this.expanded);
        for (Map.Entry<IBuildConfigurationDescriptor, MConfiguration> ent : this.configMap.entrySet()) {
            MProjectReference projRef = (MProjectReference)this.rsrcTree.getConfigurations().get((Object)ent.getValue().getName());
            this.updateResourceExclusions(ent.getValue(), projRef);
            this.addModuleReferencesForAllExclusions(accessor, ent.getKey(), projRef);
        }
    }

    private void excludeOldModuleSources(final ProjectModuleAccessor accessor, MProjectResourceTree originalRsrcTree) {
        if (originalRsrcTree == null) {
            return;
        }
        final Set allModulePaths = ((Stream)Stream.of(this.builtinSourcesMap, this.builtinExcludesMap).parallel()).map(Map::entrySet).flatMap(Collection::stream).map(Map.Entry::getValue).flatMap(Collection::stream).filter(Objects::nonNull).map(s -> s.toLowerCase(Locale.ROOT)).distinct().collect(Collectors.toSet());
        new ProjectModelSwitch<Object>(){

            public Object caseMReference(MReference ref) {
                if (ref.getProvidingModule() == null) {
                    return null;
                }
                IPath realPrjPath = ProjectModelUtils.getProjectPathFor(ref.getRef());
                String prjPath = realPrjPath.toPortableString();
                if (allModulePaths.contains(prjPath.toLowerCase(Locale.ROOT))) {
                    return null;
                }
                if (!ProjectModuleUpdateUtils.isEntryBuiltin(ProjectModuleExclusionHandler.this.rsrcTree, realPrjPath)) {
                    return null;
                }
                for (Map.Entry<IBuildConfigurationDescriptor, MConfiguration> ent : ProjectModuleExclusionHandler.this.configMap.entrySet()) {
                    String moduleKey = ProjectModuleAccessor.getModuleKey((IDescriptor)ent.getKey(), ref.getProvidingModule());
                    accessor.registerRemovedModule(ent.getKey(), ref.getProvidingModule());
                    ProjectModuleExclusionHandler.this.getExcludesFor(moduleKey).add(prjPath);
                    ProjectModuleExclusionHandler.this.getSourcesFor(moduleKey).add(prjPath);
                    ent.getValue().getExcludedPaths().add((Object)prjPath);
                }
                MEntry matchingEntry = ProjectModelUtils.findEntry(ProjectModuleExclusionHandler.this.userModel, (MFolderEntry)ProjectModuleExclusionHandler.this.expanded, realPrjPath);
                if (ProjectModuleUpdateUtils.canDeleteBuiltinEntry(ProjectModuleExclusionHandler.this.expanded, matchingEntry)) {
                    ProjectModuleExclusionHandler.this.removals.add(realPrjPath, ref.getRef());
                }
                return null;
            }

            public Object defaultCase(EObject object) {
                Object[] objectArray = object.eContents().toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    this.doSwitch((EObject)obj);
                    ++n2;
                }
                return this;
            }
        }.doSwitch((EObject)originalRsrcTree);
    }

    protected void recursivelyEliminateFullyExcludedFiles(MEntry ent) {
        boolean isEmptyFolder = false;
        if (ent instanceof MFolderEntry) {
            MFolderEntry folderEntry = (MFolderEntry)ent;
            ((Stream)Stream.of(folderEntry.getFolders(), folderEntry.getFiles()).parallel()).flatMap(Collection::stream).collect(Collectors.toList()).forEach(this::recursivelyEliminateFullyExcludedFiles);
            boolean bl = isEmptyFolder = folderEntry.getFolders().isEmpty() && folderEntry.getFiles().isEmpty();
        }
        if (ent.isBuiltin() && (isEmptyFolder || this.isExcludedInAll(ent))) {
            this.removals.add(ProjectModelUtils.getProjectPathFor(ent), ent);
            MFolderEntry eContainer = (MFolderEntry)ent.eContainer();
            eContainer.getFiles().remove((Object)ent);
            eContainer.getFolders().remove((Object)ent);
        }
    }

    public boolean isExcludedInAll(MEntry entry) {
        for (Map.Entry ent : this.rsrcTree.getConfigurations().entrySet()) {
            MReference ref = (MReference)((MProjectReference)ent.getValue()).getEntryToReferenceMap().get(entry);
            if (ref != null && ref.isExcluded()) continue;
            return false;
        }
        return true;
    }

    protected void updateResourceExclusions(MConfiguration conf, MProjectReference ref) {
        ArrayList<String> newExcls = new ArrayList<String>(1);
        this.recursivelyUpdateResourceExclusions(newExcls, (MFolderReference)ref, (IPath)Path.EMPTY);
        ((Stream)conf.getExcludedPaths().parallelStream().filter(prevExcl -> !newExcls.contains(prevExcl)).filter(prevExcl -> ProjectModelUtils.findReference((MFolderReference)ref, (IPath)new Path(prevExcl)) == null).sequential()).forEach(newExcls::add);
        conf.getExcludedPaths().clear();
        conf.getExcludedPaths().addAll(newExcls);
    }

    private void recursivelyUpdateResourceExclusions(List<String> newExcls, MFolderReference topRef, IPath path) {
        for (MFolderReference ref2 : topRef.getFolders()) {
            this.recursivelyUpdateResourceExclusions(newExcls, ref2, path.append(ref2.getRef().getName()));
        }
        topRef.getFiles().stream().filter(MReference::isExcluded).map(ref -> ref.getRef().getName()).map(name -> path.append(name).toPortableString()).forEach(newExcls::add);
        if (!(topRef instanceof MProjectReference) && topRef.isExcludedTree()) {
            this.fixUpBuiltinExcludes(path);
            this.fixUpExcludes(newExcls, path);
            newExcls.add(path.toPortableString());
        }
    }

    private void fixUpBuiltinExcludes(IPath path) {
        this.builtinExcludesMap.values().parallelStream().filter(excludes -> this.fixUpExcludes((Collection<String>)excludes, path)).forEach(excludes -> {
            boolean bl = excludes.add(path.toString());
        });
    }

    private boolean fixUpExcludes(Collection<String> excludes, IPath path) {
        return excludes.removeIf(exclude -> path.isPrefixOf((IPath)new Path(exclude)));
    }

    private void addModuleReferencesForAllExclusions(final ProjectModuleAccessor accessor, final IBuildConfigurationDescriptor config, MProjectReference projRef) {
        new ProjectModelSwitch<Object>(){

            public Object caseMReference(MReference ref) {
                if (ref.getProvidingModule() == null || !ref.isExcluded() || !ref.isBuiltin()) {
                    return null;
                }
                IPath realPrjPath = ProjectModelUtils.getProjectPathFor(ref.getRef());
                String prjPath = realPrjPath.toPortableString();
                String moduleKey = ProjectModuleAccessor.getModuleKey((IDescriptor)config, ref.getProvidingModule());
                ProjectModuleExclusionHandler.this.getSourcesFor(moduleKey).add(prjPath);
                ProjectModuleExclusionHandler.this.getExcludesFor(moduleKey).add(prjPath);
                accessor.registerRemovedModule(config, ref.getProvidingModule());
                return null;
            }

            public Object defaultCase(EObject object) {
                Object[] objectArray = object.eContents().toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    this.doSwitch((EObject)obj);
                    ++n2;
                }
                return this;
            }
        }.doSwitch((EObject)projRef);
    }

    private static /* synthetic */ void lambda$2(List list, MConfiguration c) {
        boolean bl = c.getExcludedPaths().addAll((Collection)list);
    }

    private final class RemoveContent {
        private final Collection<IPath> removedFolders = new LinkedHashSet<IPath>();
        private final Collection<IPath> removedFiles = new LinkedHashSet<IPath>();

        private RemoveContent() {
        }

        public void addFile(IPath path) {
            this.removedFiles.add(path);
        }

        public void addFolder(IPath path) {
            this.removedFolders.add(path);
        }

        public void add(IPath realPrjPath, MEntry ref) {
            if (ref instanceof MFolderEntry) {
                this.addFolder(realPrjPath);
            } else {
                this.addFile(realPrjPath);
            }
        }

        public String toString() {
            return "Removed Files: " + this.removedFiles + " Removed Folders: " + this.removedFolders;
        }
    }
}

