/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.engine;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.model.MConfigSettings;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import com.silabs.ss.framework.project.api.core.model.MSettingsSite;
import com.silabs.ss.framework.project.api.core.model.ProjectModelPackage;
import com.silabs.ss.framework.project.internal.core.engine.BaseMergeUtils;
import com.silabs.ss.platform.api.descriptor.core.type.EcoreTypeUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ProjectModelMergeUtils
extends BaseMergeUtils {
    private ProjectModelMergeUtils() {
    }

    public static void moveSettingsIntoConfigs(MProject project) {
        ProjectModelMergeUtils.propagateSettingsIntoConfigurations(project);
        Stream.concat(ProjectModelMergeUtils.settingsSiteRefs().stream(), ProjectModelMergeUtils.configSettingsRefs().stream()).map(r -> ProjectModelMergeUtils.getReflectiveEList((EObject)project, r)).forEach(List::clear);
        for (MConfiguration config : project.getConfigurations()) {
            if (TextUtils.isEmpty((String)config.getPostbuildStep())) {
                config.setPostbuildStep(project.getPostbuildStep());
            }
            if (!TextUtils.isEmpty((String)config.getPrebuildStep())) continue;
            config.setPrebuildStep(project.getPrebuildStep());
        }
        project.setPostbuildStep("");
        project.setPrebuildStep("");
    }

    public static void copyConfigSettings(MConfigSettings to, MConfigSettings from) {
        ProjectModelMergeUtils.configSettingsRefs().forEach(r -> ProjectModelMergeUtils.copyLists((EObject)from, (EObject)to, r));
        for (Map.Entry ent : from.getEntrySettings().entrySet()) {
            MSettingsSite projSite = (MSettingsSite)to.getEntrySettings().get(ent.getKey());
            if (projSite == null) {
                to.getEntrySettings().put((Object)((MEntry)ent.getKey()), (Object)((MSettingsSite)EcoreTypeUtils.copy((EObject)((MSettingsSite)ent.getValue()))));
                continue;
            }
            ProjectModelMergeUtils.copySettingsSite(projSite, (MSettingsSite)ent.getValue());
        }
    }

    public static void copySettingsSite(MSettingsSite to, MSettingsSite from) {
        ProjectModelMergeUtils.settingsSiteRefs().forEach(r -> ProjectModelMergeUtils.copyLists((EObject)from, (EObject)to, r));
    }

    public static void propagateSettingsIntoConfigurations(MProject project) {
        for (MConfiguration conf : project.getConfigurations()) {
            ProjectModelMergeUtils.propagateSettingsSite((MSettingsSite)conf, (MSettingsSite)project);
            ProjectModelMergeUtils.propagateConfigSettings((MConfigSettings)conf, (MConfigSettings)project);
        }
    }

    private static void propagateConfigSettings(MConfigSettings to, MConfigSettings from) {
        ProjectModelMergeUtils.configSettingsRefs().forEach(r -> ProjectModelMergeUtils.propagateLists((EObject)from, (EObject)to, r));
        for (Map.Entry ent : from.getEntrySettings().entrySet()) {
            MSettingsSite projSite = (MSettingsSite)to.getEntrySettings().get(ent.getKey());
            if (projSite == null) {
                to.getEntrySettings().put((Object)((MEntry)ent.getKey()), (Object)((MSettingsSite)EcoreTypeUtils.copy((EObject)((MSettingsSite)ent.getValue()))));
                continue;
            }
            ProjectModelMergeUtils.propagateSettingsSite(projSite, (MSettingsSite)ent.getValue());
        }
    }

    private static void propagateSettingsSite(MSettingsSite to, MSettingsSite from) {
        ProjectModelMergeUtils.settingsSiteRefs().forEach(r -> ProjectModelMergeUtils.propagateLists((EObject)from, (EObject)to, r));
    }

    public static void mergeCommonSettings(MProject project) {
        ProjectModelMergeUtils.mergeSettingsSites(project);
        ProjectModelMergeUtils.mergeConfigSettings(project);
        ProjectModelMergeUtils.mergeSelectableSettings(project);
        List.of(ProjectModelPackage.Literals.MCONFIG_SETTINGS__POSTBUILD_STEP, ProjectModelPackage.Literals.MCONFIG_SETTINGS__PREBUILD_STEP).forEach(r -> ProjectModelMergeUtils.mergeCommonListItems((EObject)project, (Collection<? extends EObject>)project.getConfigurations(), (EStructuralFeature)r, o -> TextUtils.hasContent((String)((String)o))));
    }

    private static void mergeConfigSettings(MProject proj) {
        ProjectModelMergeUtils.configSettingsRefs().stream().filter(r -> !ProjectModelPackage.Literals.MCONFIG_SETTINGS__EXCLUDED_PATHS.equals(r)).forEach(r -> ProjectModelMergeUtils.mergeCommonListItems((EObject)proj, (Collection<? extends EObject>)proj.getConfigurations(), r));
    }

    private static void mergeSettingsSites(MProject proj) {
        ProjectModelMergeUtils.settingsSiteRefs().forEach(r -> ProjectModelMergeUtils.mergeCommonListItems((EObject)proj, (Collection<? extends EObject>)proj.getConfigurations(), r));
    }

    private static void mergeSelectableSettings(MProject proj) {
        ProjectModelMergeUtils.selectableSettingsRefs().forEach(r -> ProjectModelMergeUtils.mergeItems((EObject)proj, (Collection<? extends EObject>)proj.getConfigurations(), r));
    }

    public static void mergeSelectableSettings(MSelectable from, MSelectable to) {
        ProjectModelMergeUtils.selectableSettingsRefs().forEach(r -> ProjectModelMergeUtils.mergeStringLists((EObject)from, (EObject)to, r));
    }

    public static void mergeConfigSettings(MConfigSettings from, MConfigSettings to) {
        ProjectModelMergeUtils.configSettingsRefs().forEach(r -> ProjectModelMergeUtils.mergeLists((EObject)from, (EObject)to, r));
        for (EStructuralFeature setting : ProjectModelMergeUtils.stringConfigSettingsRefs()) {
            if (!TextUtils.isEmpty((String)((String)to.eGet(setting)))) continue;
            to.eSet(setting, from.eGet(setting));
        }
        for (Map.Entry ent : from.getEntrySettings().entrySet()) {
            MSettingsSite projSite = (MSettingsSite)to.getEntrySettings().get(ent.getKey());
            if (projSite == null) {
                to.getEntrySettings().put((Object)((MEntry)ent.getKey()), (Object)((MSettingsSite)EcoreTypeUtils.copy((EObject)((MSettingsSite)ent.getValue()))));
                continue;
            }
            ProjectModelMergeUtils.mergeSettingsSites((MSettingsSite)ent.getValue(), projSite);
        }
    }

    public static void mergeSettingsSites(MSettingsSite from, MSettingsSite to) {
        ProjectModelMergeUtils.settingsSiteRefs().forEach(r -> ProjectModelMergeUtils.mergeLists((EObject)from, (EObject)to, r));
    }

    private static Collection<EStructuralFeature> selectableSettingsRefs() {
        return Arrays.asList(ProjectModelPackage.Literals.MSELECTABLE__BOARD_COMPATIBILITY, ProjectModelPackage.Literals.MSELECTABLE__PART_COMPATIBILITY, ProjectModelPackage.Literals.MSELECTABLE__SDK_COMPATIBILITY, ProjectModelPackage.Literals.MSELECTABLE__TOOLCHAIN_COMPATIBILITY, ProjectModelPackage.Literals.MSELECTABLE__COMPATIBILITY);
    }

    private static Collection<EStructuralFeature> configSettingsRefs() {
        return Arrays.asList(ProjectModelPackage.Literals.MCONFIG_SETTINGS__EXCLUDED_PATHS, ProjectModelPackage.Literals.MCONFIG_SETTINGS__SOURCE_FOLDERS, ProjectModelPackage.Literals.MCONFIG_SETTINGS__MODULES);
    }

    private static Collection<EStructuralFeature> stringConfigSettingsRefs() {
        return List.of(ProjectModelPackage.Literals.MCONFIG_SETTINGS__OUTPUT_FILE_BASE, ProjectModelPackage.Literals.MCONFIG_SETTINGS__PREBUILD_STEP, ProjectModelPackage.Literals.MCONFIG_SETTINGS__POSTBUILD_STEP);
    }

    private static Collection<EStructuralFeature> settingsSiteRefs() {
        return Arrays.asList(ProjectModelPackage.Literals.MSETTINGS_SITE__INCLUDE_PATHS, ProjectModelPackage.Literals.MSETTINGS_SITE__MACRO_DEFINITIONS, ProjectModelPackage.Literals.MSETTINGS_SITE__LIBRARY_FILES, ProjectModelPackage.Literals.MSETTINGS_SITE__LIBRARY_PATHS, ProjectModelPackage.Literals.MSETTINGS_SITE__TOOL_OPTIONS, ProjectModelPackage.Literals.MSETTINGS_SITE__CONVERTED_OPTIONS);
    }
}

