/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.engine;

import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationFactory;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineSession;
import com.silabs.ss.framework.project.api.core.engine.IProjectFileContentVisitor;
import com.silabs.ss.framework.project.api.core.engine.operations.IAddToProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IConfigurationScopeEngineOperation;
import com.silabs.ss.framework.project.api.core.external.IImportProjectDescriptor;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MFileEntry;
import com.silabs.ss.framework.project.api.core.model.MFolderContent;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import com.silabs.ss.framework.project.internal.core.engine.ProjectEngineOperationHolder;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModelCompatibility;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModelEngine;
import java.io.File;
import java.io.IOException;
import java.util.Deque;
import org.eclipse.core.runtime.IPath;

public class ProjectModelEngineConfigVisitor
implements IProjectFileContentVisitor {
    private final IBuildConfigurationDescriptor buildConf;
    private final IProjectEngineOperationFactory factory;
    private final IProjectEngineSession session;
    private final ProjectEngineOperationHolder operations;
    private final Deque<Boolean> excluding;
    private final ProjectModelCompatibility compat;

    public ProjectModelEngineConfigVisitor(IBuildConfigurationDescriptor buildConf, IProjectEngineOperationFactory factory, IProjectEngineSession session, ProjectEngineOperationHolder operations, Deque<Boolean> excluding, ProjectModelCompatibility compat) {
        this.buildConf = buildConf;
        this.factory = factory;
        this.session = session;
        this.operations = operations;
        this.excluding = excluding;
        this.compat = compat;
    }

    @Override
    public void visitFailed(MFolderEntry container, File containerFile, IPath projectPath, MEntry entry, MSelectable selectable, File entryFile, IOException e) {
        if (entry instanceof MFileEntry && this.session.getProjectDescriptor() instanceof IImportProjectDescriptor) {
            this.visit(container, containerFile, projectPath, (MFileEntry)entry, selectable, entryFile);
        } else {
            this.operations.add(this.factory.createReportErrorOperation(this.session, entry, entryFile, e));
        }
    }

    @Override
    public boolean preVisit(MFolderEntry entry, File containerFile, IPath projectPath, MSelectable selector, File contentFolder) {
        boolean isIncluded;
        IAddToProjectEngineOperation op;
        boolean isConfigIncluded;
        block9: {
            try {
                isConfigIncluded = this.compat.isCompatibleForConfig(selector, this.buildConf);
                op = this.factory.createAddProjectFolderOperation(this.session, containerFile, projectPath, contentFolder, entry, selector);
                if (op != null || !isConfigIncluded) break block9;
                IConfigurationScopeEngineOperation confOp = this.factory.createIncludeResourceIntoConfigurationOperation(this.session, this.buildConf.getId(), projectPath, contentFolder.toURI());
                this.operations.add(confOp);
                this.excluding.push(false);
                return true;
            }
            catch (IOException e) {
                this.operations.add(this.factory.createReportErrorOperation(this.session, (MEntry)entry, contentFolder, e));
                return false;
            }
        }
        boolean bl = isIncluded = ProjectModelEngine.shouldIncludeEntry(this.excluding, (MEntry)entry, containerFile, contentFolder) && isConfigIncluded;
        if (isIncluded) {
            this.operations.add(op);
        }
        if (!isConfigIncluded) {
            IConfigurationScopeEngineOperation confOp = this.factory.createExcludeResourceFromConfigurationOperation(this.session, this.buildConf.getId(), projectPath, contentFolder.toURI());
            this.operations.add(confOp);
        }
        if (isIncluded) {
            if (!(entry instanceof MFolderContent && ((MFolderContent)entry).isVirtual() || this.factory.shouldEnter(this.session, entry, op))) {
                this.excluding.push(true);
            } else {
                this.excluding.push(false);
            }
        } else {
            this.excluding.push(true);
        }
        return true;
    }

    @Override
    public void visit(MFolderEntry container, File containerFile, IPath projectPath, MFileEntry entry, MSelectable selector, File contentFile) {
        try {
            boolean isIncluded;
            boolean acceptSelector = this.compat.isCompatibleForConfig(selector, this.buildConf);
            boolean acceptContainer = this.compat.isCompatibleForConfig((MSelectable)container, this.buildConf);
            IAddToProjectEngineOperation op = this.factory.createAddProjectFileOperation(this.session, containerFile, projectPath, contentFile, entry, selector);
            if (op == null && acceptSelector && acceptContainer) {
                IConfigurationScopeEngineOperation confOp = this.factory.createIncludeResourceIntoConfigurationOperation(this.session, this.buildConf.getId(), projectPath, contentFile.toURI());
                this.operations.add(confOp);
                return;
            }
            boolean bl = isIncluded = ProjectModelEngine.shouldIncludeEntry(this.excluding, (MEntry)entry, containerFile, contentFile) && acceptContainer && acceptSelector;
            if (isIncluded) {
                this.operations.add(op);
            }
            if (!acceptSelector || !acceptContainer) {
                IConfigurationScopeEngineOperation confOp = this.factory.createExcludeResourceFromConfigurationOperation(this.session, this.buildConf.getId(), projectPath, contentFile.toURI());
                this.operations.add(confOp);
            }
        }
        catch (IOException e) {
            this.operations.add(this.factory.createReportErrorOperation(this.session, (MEntry)entry, contentFile, e));
        }
    }

    @Override
    public boolean postVisit(MFolderEntry entry, IPath projectPath, File contentFolder) {
        this.excluding.pop();
        return true;
    }
}

