/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.engine;

import com.silabs.java.utils.ObjectUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.model.MMacroDefinition;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import com.silabs.ss.framework.project.api.core.model.MToolListOption;
import com.silabs.ss.framework.project.api.core.model.MToolOption;
import com.silabs.ss.framework.project.api.core.solution.model.MSolution;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionBuildStep;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionModuleReference;
import com.silabs.ss.framework.project.api.core.solution.model.MSolutionProject;
import com.silabs.ss.framework.project.internal.api.core.solution.model.util.manual.SolutionLiterals;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModelMergeUtils;
import com.silabs.ss.platform.api.descriptor.core.model.impl.StringToStringMapImpl;
import com.silabs.ss.platform.api.descriptor.core.type.CoreTypes;
import com.silabs.ss.platform.api.descriptor.core.type.EcoreTypeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class BaseMergeUtils {
    public static final String READ_FROM_EXISTING = "READ_FROM_EXISTING";

    protected BaseMergeUtils() {
    }

    protected static void copyLists(EObject from, EObject to, EStructuralFeature listRef) {
        List<Object> fitems = BaseMergeUtils.getReflectiveEList(from, listRef);
        List<Object> titems = BaseMergeUtils.getReflectiveEList(to, listRef);
        HashSet<Object> stitems = new HashSet<Object>(titems);
        for (Object o : fitems) {
            if (stitems.contains(o)) continue;
            if (o instanceof EObject) {
                titems.add(EcoreTypeUtils.copy((EObject)((EObject)o)));
                continue;
            }
            titems.add(o);
        }
    }

    protected static void propagateLists(EObject from, EObject to, EStructuralFeature listRef) {
        List<Object> fitems = BaseMergeUtils.getReflectiveEList(from, listRef);
        List<Object> titems = BaseMergeUtils.getReflectiveEList(to, listRef);
        HashSet<Object> stitems = new HashSet<Object>(titems);
        int offs = 0;
        for (Object fobj : fitems) {
            if (stitems.contains(fobj)) continue;
            if (fobj instanceof EObject) {
                titems.add(offs++, EcoreTypeUtils.copy((EObject)((EObject)fobj)));
                continue;
            }
            titems.add(offs++, fobj);
        }
    }

    protected static void mergeCommonListItems(EObject parent, Collection<? extends EObject> subObjs, EStructuralFeature listRef) {
        BaseMergeUtils.mergeCommonListItems(parent, subObjs, listRef, o -> true);
    }

    protected static void mergeCommonListItems(EObject parent, Collection<? extends EObject> subObjs, EStructuralFeature listRef, Predicate<Object> isValid) {
        LinkedHashSet<Object> confCommon = null;
        for (EObject eObject : subObjs) {
            List<Object> citems = BaseMergeUtils.getReflectiveEList(eObject, listRef);
            if (confCommon == null) {
                confCommon = new LinkedHashSet<Object>(citems);
                continue;
            }
            confCommon.retainAll(new ArrayList<Object>(citems));
        }
        if (confCommon == null || confCommon.isEmpty()) {
            return;
        }
        List<Object> list = BaseMergeUtils.getReflectiveEList(parent, listRef);
        for (Object e : confCommon) {
            for (EObject eObject : subObjs) {
                List<Object> citems = BaseMergeUtils.getReflectiveEList(eObject, listRef);
                Iterator<Object> iter = citems.iterator();
                while (iter.hasNext()) {
                    Object item = iter.next();
                    if (!item.equals(e)) continue;
                    iter.remove();
                }
            }
            BaseMergeUtils.handleEquivalent(e, list, true);
            if (!isValid.test(e)) continue;
            list.add(e);
        }
    }

    protected static void removeCommonItems(EObject toKeepObj, EObject toRemoveObj, EStructuralFeature listRef) {
        List<Object> toKeepItems = BaseMergeUtils.getReflectiveEList(toKeepObj, listRef);
        List<Object> toRemoveItems = BaseMergeUtils.getReflectiveEList(toRemoveObj, listRef);
        for (Object toKeep : toKeepItems) {
            BaseMergeUtils.handleEquivalent(toKeep, toRemoveItems, true);
        }
    }

    protected static void mergeLists(EObject from, EObject to, EStructuralFeature listRef) {
        List<Object> fitems = BaseMergeUtils.getReflectiveEList(from, listRef);
        List<Object> titems = BaseMergeUtils.getReflectiveEList(to, listRef);
        for (Object o : fitems) {
            boolean needsAdd = BaseMergeUtils.handleEquivalent(o, titems, false);
            if (!needsAdd) continue;
            if (o instanceof EObject) {
                titems.add(EcoreTypeUtils.copy((EObject)((EObject)o)));
                continue;
            }
            titems.add(o);
        }
    }

    protected static void mergeStringLists(EObject from, EObject to, EStructuralFeature listRef) {
        String fromStr = (String)from.eGet(listRef);
        String toStr = (String)to.eGet(listRef);
        if (fromStr == null && toStr == null) {
            return;
        }
        Collection fromList = (Collection)CoreTypes.STRING_LIST.convert(fromStr);
        Collection toList = (Collection)CoreTypes.STRING_LIST.convert(toStr);
        LinkedHashSet toSet = new LinkedHashSet(toList);
        for (String o : fromList) {
            if (toSet.contains(o)) continue;
            toList.add(o);
        }
        to.eSet(listRef, (Object)CoreTypes.STRING_LIST.stringize((Object)toList));
    }

    protected static void mergeItems(EObject proj, Collection<? extends EObject> subObjs, EStructuralFeature listRef) {
        Object confCommon = null;
        for (EObject eObject : subObjs) {
            Object citem = eObject.eGet(listRef);
            if (confCommon == null) {
                confCommon = citem;
                continue;
            }
            if (ObjectUtils.equals((Object)citem, (Object)confCommon)) continue;
            return;
        }
        proj.eSet(listRef, confCommon);
        for (EObject eObject : subObjs) {
            eObject.eUnset(listRef);
        }
    }

    protected static List<Object> getReflectiveEList(EObject owner, EStructuralFeature listRef) {
        Object eObj = owner.eGet(listRef);
        if (eObj instanceof List) {
            return (List)eObj;
        }
        if (eObj instanceof Collection) {
            return new ArrayList<Object>((Collection)eObj);
        }
        return new SingleEntryList(owner, listRef, eObj);
    }

    protected static boolean handleEquivalent(Object o, List<?> list, boolean removeEquivalent) {
        Object toKeepObj = removeEquivalent ? o : null;
        Comparator<Object> comp = BaseMergeUtils.getEquivalencyComparator(o);
        Iterator<?> iter = list.iterator();
        while (iter.hasNext()) {
            Object existing = iter.next();
            if (comp.compare(existing, o) != 0) continue;
            if (toKeepObj != null) {
                iter.remove();
                BaseMergeUtils.mergeEquivalent(toKeepObj, existing);
                continue;
            }
            toKeepObj = existing;
            BaseMergeUtils.mergeEquivalent(existing, o);
        }
        return removeEquivalent || toKeepObj == null;
    }

    protected static void mergeEquivalent(Object toKeep, Object toRemove) {
        MToolOption toRemoveOpt;
        MToolOption toKeepOpt;
        if (toKeep instanceof MToolOption && toRemove instanceof MToolOption) {
            toKeepOpt = (MToolOption)toKeep;
            toRemoveOpt = (MToolOption)toRemove;
            EList removalList = toRemoveOpt.getToolListOptions();
            for (MToolListOption listOption : toKeepOpt.getToolListOptions()) {
                BaseMergeUtils.handleEquivalent(listOption, removalList, true);
            }
            toKeepOpt.getToolListOptions().addAll((Collection)removalList);
            if (toKeepOpt.isBuiltin() && !toRemoveOpt.isBuiltin()) {
                toKeepOpt.setBuiltin(false);
            }
            toKeepOpt.setBuiltin(toKeepOpt.calculateBuiltinState());
        } else if (toKeep instanceof MToolListOption && toRemove instanceof MToolListOption) {
            if (((MToolListOption)toKeep).isBuiltin() && !((MToolListOption)toRemove).isBuiltin()) {
                ((MToolListOption)toKeep).setBuiltin(false);
            }
        } else if (toKeep instanceof MSolutionProject && toRemove instanceof MSolutionProject) {
            toKeepOpt = (MSolutionProject)toKeep;
            toRemoveOpt = (MSolutionProject)toRemove;
            BaseMergeUtils.setIfHasContent((EObject)toKeepOpt, (EObject)toRemoveOpt, new EStructuralFeature[]{SolutionLiterals.MSOLUTION_PROJECT__BINARY, SolutionLiterals.MSOLUTION_PROJECT__CONFIGURATION, SolutionLiterals.MSOLUTION_PROJECT__LOCATION});
        }
        if (toKeep instanceof MSelectable) {
            toKeepOpt = (MSelectable)toKeep;
            if (toRemove instanceof MSelectable) {
                toRemoveOpt = (MSelectable)toRemove;
                ProjectModelMergeUtils.mergeSelectableSettings((MSelectable)toRemoveOpt, (MSelectable)toKeepOpt);
            }
        }
    }

    private static void setIfHasContent(EObject setTo, EObject setFrom, EStructuralFeature ... refs) {
        EStructuralFeature[] eStructuralFeatureArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature ref = eStructuralFeatureArray[n2];
            String str = (String)setFrom.eGet(ref);
            if (TextUtils.hasContent((String)str)) {
                setTo.eSet(ref, (Object)str);
            }
            ++n2;
        }
    }

    private static Comparator<Object> getEquivalencyComparator(Object o) {
        Comparator comp = o instanceof MToolOption ? (o1, o2) -> {
            if (!(o1 instanceof MToolOption)) {
                return -1;
            }
            if (!(o2 instanceof MToolOption)) {
                return -1;
            }
            MToolOption opt1 = (MToolOption)o1;
            MToolOption opt2 = (MToolOption)o2;
            if (ObjectUtils.equals((Object)opt1.getOptionId(), (Object)opt2.getOptionId()) && ObjectUtils.equals((Object)opt1.getToolId(), (Object)opt2.getToolId()) && ObjectUtils.equals((Object)opt1.getValue(), (Object)opt2.getValue())) {
                return 0;
            }
            return -1;
        } : (o instanceof MToolListOption ? (o1, o2) -> {
            if (!(o1 instanceof MToolListOption)) {
                return -1;
            }
            if (!(o2 instanceof MToolListOption)) {
                return -1;
            }
            MToolListOption opt1 = (MToolListOption)o1;
            MToolListOption opt2 = (MToolListOption)o2;
            if (ObjectUtils.equals((Object)opt1.getValue(), (Object)opt2.getValue())) {
                return 0;
            }
            return -1;
        } : (o instanceof MMacroDefinition ? (o1, o2) -> {
            if (!(o1 instanceof MMacroDefinition)) {
                return -1;
            }
            if (!(o2 instanceof MMacroDefinition)) {
                return -1;
            }
            MMacroDefinition opt1 = (MMacroDefinition)o1;
            MMacroDefinition opt2 = (MMacroDefinition)o2;
            if (opt1.isBuiltin() == opt2.isBuiltin() && ObjectUtils.equals((Object)opt1.getName(), (Object)opt2.getName()) && ObjectUtils.equals((Object)opt1.getValue(), (Object)opt2.getValue())) {
                return 0;
            }
            return -1;
        } : (o instanceof MSolutionProject ? (o1, o2) -> {
            if (!(o1 instanceof MSolutionProject)) {
                return -1;
            }
            if (!(o2 instanceof MSolutionProject)) {
                return -1;
            }
            MSolutionProject opt1 = (MSolutionProject)o1;
            MSolutionProject opt2 = (MSolutionProject)o2;
            if (opt1.isBuiltin() != opt2.isBuiltin() || !ObjectUtils.equals((Object)opt1.getName(), (Object)opt2.getName())) {
                return -1;
            }
            boolean opt1IsProj = opt1.eContainer() instanceof MSolution;
            boolean opt2IsProj = opt2.eContainer() instanceof MSolution;
            boolean isEqual = true;
            isEqual = opt1IsProj && opt2IsProj ? BaseMergeUtils.isEqualOrEmpty(opt1.getLocation(), opt2.getLocation()) : (!opt1IsProj && !opt2IsProj ? BaseMergeUtils.isEqualOrEmpty(opt1.getBinary(), opt2.getBinary()) && BaseMergeUtils.isEqualOrEmpty(opt1.getConfiguration(), opt2.getConfiguration()) : BaseMergeUtils.isEqualOrEmpty(opt1.getLocation(), opt2.getLocation()) && BaseMergeUtils.isEqualOrEmpty(opt1.getBinary(), opt2.getBinary()) && BaseMergeUtils.isEqualOrEmpty(opt1.getConfiguration(), opt2.getConfiguration()));
            return isEqual ? 0 : -1;
        } : (o instanceof MSolutionModuleReference ? (o1, o2) -> {
            if (!(o1 instanceof MSolutionModuleReference)) {
                return -1;
            }
            if (!(o2 instanceof MSolutionModuleReference)) {
                return -1;
            }
            return ((MSolutionModuleReference)o1).getId().compareTo(((MSolutionModuleReference)o1).getId());
        } : (o instanceof MSolutionBuildStep ? (o1, o2) -> {
            if (!(o1 instanceof MSolutionBuildStep)) {
                return -1;
            }
            if (!(o2 instanceof MSolutionBuildStep)) {
                return -1;
            }
            MSolutionBuildStep opt1 = (MSolutionBuildStep)o1;
            MSolutionBuildStep opt2 = (MSolutionBuildStep)o2;
            if (opt1.isBuiltin() == opt2.isBuiltin() && ObjectUtils.equals((Object)opt1.getBuildStep(), (Object)opt2.getBuildStep())) {
                return 0;
            }
            return -1;
        } : (o instanceof StringToStringMapImpl ? (o1, o2) -> {
            if (!(o1 instanceof StringToStringMapImpl)) {
                return -1;
            }
            if (!(o2 instanceof StringToStringMapImpl)) {
                return -1;
            }
            StringToStringMapImpl opt1 = (StringToStringMapImpl)o1;
            StringToStringMapImpl opt2 = (StringToStringMapImpl)o2;
            if (opt1.isBuiltin() == opt2.isBuiltin() && ObjectUtils.equals((Object)opt1, (Object)opt2)) {
                return 0;
            }
            return -1;
        } : (o1, o2) -> {
            if (ObjectUtils.equals((Object)o1, (Object)o2)) {
                return 0;
            }
            return -1;
        }))))));
        return comp;
    }

    private static boolean isEqualOrEmpty(String s1, String s2) {
        if (TextUtils.isEmpty((String)s1) || TextUtils.isEmpty((String)s2)) {
            return true;
        }
        return s1.equals(s2);
    }

    private static class SingleEntryList
    extends ArrayList<Object> {
        private final EObject owner;
        private final EStructuralFeature listRef;
        private final Object eObj;

        public SingleEntryList(EObject owner, EStructuralFeature listRef, Object eObj) {
            this.owner = owner;
            this.listRef = listRef;
            this.eObj = eObj;
            if (eObj != null) {
                this.add(eObj);
            }
        }

        @Override
        public Object remove(int index) {
            Object removed = super.remove(index);
            if (this.eObj == removed) {
                this.doRemove();
            }
            return removed;
        }

        @Override
        public boolean add(Object e) {
            boolean retVal = super.add(e);
            this.doAdd(e);
            return retVal;
        }

        @Override
        public void add(int index, Object element) {
            super.add(index, element);
            this.doAdd(element);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            if (this.eObj != null && c.contains(this.eObj)) {
                this.doRemove();
            }
            return super.removeAll(c);
        }

        @Override
        public boolean removeIf(Predicate<? super Object> filter) {
            if (this.eObj != null && filter.test(this.eObj)) {
                this.doRemove();
            }
            return super.removeIf(filter);
        }

        private void doRemove() {
            this.owner.eSet(this.listRef, null);
        }

        private void doAdd(Object element) {
            this.owner.eSet(this.listRef, element);
        }
    }
}

