/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.api.core.external.impl;

import com.silabs.ss.framework.project.api.core.model.options.DirectOptionMappingFactory;
import com.silabs.ss.framework.project.api.core.model.options.GenericOptionMappingFactory;
import com.silabs.ss.platform.api.descriptor.core.IWriteableDescriptor;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.property.model.IPropertyGroup;
import com.silabs.ss.platform.api.descriptor.core.property.model.Property;

public class PropertyInfo {
    private final IPropertyGroup group;
    private final String name;
    private final String type;
    private final String description;
    private final String version;
    private final IProperty property;
    private static final String SEPARATOR = "-";

    public PropertyInfo(IPropertyGroup group, String name, String type, String version, String description) {
        this.group = group;
        this.name = name;
        this.type = type;
        this.description = description;
        this.version = version;
        this.property = this.constructProperty();
    }

    public String getId() {
        return PropertyInfo.generateId(this.name, this.version);
    }

    public String getPropId() {
        return this.property == null ? "" : this.property.getId();
    }

    public GenericOptionMappingFactory createNewGenericMappingFactory() {
        return GenericOptionMappingFactory.with((IProperty)this.property);
    }

    public DirectOptionMappingFactory createNewDirectMappingFactory() {
        return DirectOptionMappingFactory.with((IProperty)this.property);
    }

    public IProperty getProperty() {
        return this.property;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    private IProperty constructProperty() {
        IProperty property = Property.registry().registerProperty(this.group, this.getId(), this.type, this.description);
        ((IWriteableDescriptor)property).setLabel(this.description);
        return property;
    }

    public static String generateId(String name, String version) {
        return name + (String)(version.isEmpty() ? "" : SEPARATOR + version);
    }
}

