/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.api.core.external.impl;

import com.silabs.ss.framework.project.api.core.external.IFlagParser;
import com.silabs.ss.framework.project.api.core.external.IImportProjectDescriptor;
import com.silabs.ss.framework.project.api.core.external.IStringSplitter;
import com.silabs.ss.framework.project.api.core.external.ProjectImportUtils;
import com.silabs.ss.framework.project.api.core.external.utils.ImporterTool;
import com.silabs.ss.framework.project.api.core.model.MBuildSetting;
import com.silabs.ss.framework.project.api.core.model.options.IDirectOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.IGenericOptionMappingRegistry;
import com.silabs.ss.framework.project.internal.api.core.external.impl.KeilDirectOptionsMappings;
import com.silabs.ss.framework.project.internal.api.core.external.impl.KeilGenericOptionsMappings;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KeilFlagParser
implements IFlagParser {
    private static final Map<Object, Integer> SIZE_SPEED_MAP = ProjectImportUtils.mapEnumStringToInt("SIZE", "SPEED");
    private static final Map<Object, Integer> MODEL_SIZE_MAP = ProjectImportUtils.mapEnumStringToInt("SMALL", "COMPACT", "LARGE");
    private static final Map<Object, Integer> FALSE_TRUE_MAP = ProjectImportUtils.mapEnumStringToInt(false, true);
    private static Map<String, String> MODEL_SIZE_ABBREVIATIONS = new HashMap<String, String>();

    public KeilFlagParser() {
        MODEL_SIZE_ABBREVIATIONS.put("SM", "SMALL");
        MODEL_SIZE_ABBREVIATIONS.put("CP", "COMPACT");
        MODEL_SIZE_ABBREVIATIONS.put("LS", "LARGE");
    }

    @Override
    public String getToolchainCompatibility() {
        return ".*keil.*";
    }

    @Override
    public List<MBuildSetting> getBuildSettingsFromFlagList(List<String> flags, ImporterTool.ToolchainID toolchainID, ImporterTool.ToolType toolType, URI basePath, IImportProjectDescriptor desc, Map<String, String> variables) {
        Pattern includePattern = null;
        Pattern macroPattern = null;
        Pattern libPattern = null;
        IStringSplitter includeSplitter = null;
        IStringSplitter macroSplitter = null;
        IStringSplitter libSplitter = null;
        if (toolType == ImporterTool.ToolType.COMPILER) {
            includePattern = Pattern.compile("(?i)(?<=(^INCDIR|^ID)\\s?\\().*(?=\\)$)");
            macroPattern = Pattern.compile("(?i)(?<=(^DEFINE|^DF)\\s?\\().*(?=\\)$)");
            includeSplitter = ProjectImportUtils.getSemicolonOrCommaStringSplitter();
        } else if (toolType == ImporterTool.ToolType.ASSEMBLER) {
            includePattern = Pattern.compile("(?i)(?<=(^INCDIR|^ID)\\s?\\().*(?=\\)$)");
            macroPattern = Pattern.compile("(?i)(?<=(^DEFINE|^DF)\\s?\\().*(?=\\)$)");
            includeSplitter = ProjectImportUtils.getSemicolonOrCommaStringSplitter();
        } else if (toolType == ImporterTool.ToolType.LINKER && toolchainID != ImporterTool.ToolchainID.EIGHTYFIFTYONE) {
            macroPattern = Pattern.compile("(?i)(?<=(^ASSIGN|^AS)\\s?\\().*(?=\\)$)");
        }
        macroSplitter = ProjectImportUtils.getMacroSemicolonOrCommaStringSplitter();
        return ProjectImportUtils.createBuildSettingsFromFlags(flags, basePath, ProjectImportUtils.getELanguage(toolType), includePattern, includeSplitter, macroPattern, macroSplitter, libPattern, libSplitter, null, null, desc, variables, null, this.getUnconvertedVariables());
    }

    @Override
    public List<String> splitCommandLineFlags(String flags) {
        return ProjectImportUtils.splitDirectiveFlags(flags);
    }

    @Override
    public IGenericOptionMappingRegistry getGenericRegistry() {
        return KeilGenericOptionsMappings.genericRegistry;
    }

    @Override
    public IDirectOptionMappingRegistry getDirectRegistry() {
        return KeilDirectOptionsMappings.registry();
    }

    @Override
    public Collection<String> getUnconvertedVariables() {
        return Collections.emptyList();
    }

    @Override
    public Map<IProperty, Object> getFlagProperties(List<String> flags, ImporterTool.ToolchainID toolchainID, ImporterTool.ToolType toolType) {
        Pattern directivePattern = Pattern.compile("\\w+(?=(\\s?\\()?)");
        Pattern argPattern = Pattern.compile("(?<=\\().*(?=\\))");
        HashMap<IProperty, Object> flagProperties = new HashMap<IProperty, Object>();
        ArrayList<String> toRemove = new ArrayList<String>();
        String toolID = "";
        toolID = KeilFlagParser.getToolIDString(toolType);
        for (String flag : flags) {
            Matcher directiveMatcher = directivePattern.matcher(flag);
            if (!directiveMatcher.find()) continue;
            String directive = directiveMatcher.group().trim().replaceAll("^\"|\"$", "");
            if (toolType == ImporterTool.ToolType.LINKER && (directive.matches("^(PL|PAGELENGTH)") || directive.matches("^(PW|PAGEWIDTH)") || directive.matches("^(RS|RAMSIZE)") || directive.matches("^(RU|REMOVEUNUSED)"))) {
                toRemove.add(flag);
            }
            IProperty flagProperty = KeilDirectOptionsMappings.getFlagProperty(directive, toolID);
            String args = ProjectImportUtils.patternMatchGetter(flag, argPattern);
            boolean removed = KeilFlagParser.addFlagToMap(flagProperties, toolID, directive, args, flagProperty);
            if (!removed) continue;
            toRemove.add(flag);
        }
        ProjectImportUtils.removeStringsFromStringList(flags, toRemove);
        if (!flags.isEmpty()) {
            IProperty miscFlagsProperty = KeilDirectOptionsMappings.getMiscFlagsProperty(toolID);
            assert (miscFlagsProperty != null);
            String miscFlagsValue = ProjectImportUtils.squashStringListToString(flags);
            flagProperties.put(miscFlagsProperty, miscFlagsValue.trim());
        }
        return flagProperties;
    }

    private static String getToolIDString(ImporterTool.ToolType toolType) {
        String toolID = null;
        switch (toolType) {
            case ASSEMBLER: {
                toolID = "com.silabs.ide.si8051.keil.toolchain.assembler";
                break;
            }
            case COMPILER: {
                toolID = "com.silabs.ide.si8051.keil.toolchain.compiler";
                break;
            }
            case LINKER: {
                toolID = "com.silabs.ide.si8051.keil.toolchain.linker";
                break;
            }
        }
        return toolID;
    }

    private static boolean addFlagToMap(Map<IProperty, Object> map, String tool, String directive, String args, IProperty property) {
        if (property == null) {
            return false;
        }
        assert (map != null);
        String propertyType = property.getType().getName();
        List<String> value = null;
        if (propertyType.equals("int")) {
            try {
                value = KeilFlagParser.findIntValue(map, tool, directive, args);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        } else if (propertyType.equals("string")) {
            value = args;
        } else if (propertyType.equals("long")) {
            try {
                value = Long.parseLong(args);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        } else if (propertyType.equals("stringList")) {
            value = Arrays.asList(args.split(","));
        } else {
            return false;
        }
        map.put(property, value);
        return true;
    }

    private static int findIntValue(Map<IProperty, Object> map, String tool, String directive, String args) throws NumberFormatException {
        int value = -1;
        value = args == null || args.isEmpty() ? FALSE_TRUE_MAP.get(!directive.startsWith("NO")) : (KeilFlagParser.getFullSizeName(args) != null ? MODEL_SIZE_MAP.get(KeilFlagParser.getFullSizeName(args)) : (KeilFlagParser.getFullSizeName(directive) != null ? MODEL_SIZE_MAP.get(KeilFlagParser.getFullSizeName(directive)) : ("OPTIMIZE".equals(directive) ? KeilFlagParser.addOptimizeFlagToFlagMap(map, tool, args, value) : Integer.parseInt(args))));
        return value;
    }

    private static int addOptimizeFlagToFlagMap(Map<IProperty, Object> map, String tool, String args, int value) throws NumberFormatException {
        String size_speed = "";
        if (SIZE_SPEED_MAP.containsKey(args)) {
            size_speed = args;
        } else {
            String[] splitArgs = args.split(",");
            value = Integer.parseInt(splitArgs[0]);
            if (splitArgs.length > 1) {
                size_speed = splitArgs[1];
            }
        }
        if (!size_speed.isEmpty() && SIZE_SPEED_MAP.containsKey(args)) {
            KeilFlagParser.addFlagToMap(map, tool, args, SIZE_SPEED_MAP.get(args).toString(), KeilDirectOptionsMappings.getFlagProperty(args, tool));
        }
        if (value > 9) {
            throw new NumberFormatException();
        }
        return value;
    }

    private static String getFullSizeName(String name) {
        if (MODEL_SIZE_ABBREVIATIONS.containsKey(name)) {
            return MODEL_SIZE_ABBREVIATIONS.get(name);
        }
        if (!MODEL_SIZE_MAP.containsKey(name)) {
            return null;
        }
        return name;
    }
}

