/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.utils;

import com.silabs.java.utils.CollectionUtils;
import com.silabs.java.utils.ExceptionUtils;
import com.silabs.java.utils.function.Caster;
import com.silabs.java.utils.variables.IVariableLookup;
import com.silabs.java.utils.variables.MapVariableLookup;
import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.IWriteableProjectDescriptor;
import com.silabs.ss.framework.project.api.core.ImportMode;
import com.silabs.ss.framework.project.api.core.ProjectWithBuildConfigurationId;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationFactory;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.engine.IProjectModel;
import com.silabs.ss.framework.project.api.core.engine.IProjectModelEngine;
import com.silabs.ss.framework.project.api.core.engine.IProjectModelEngineFactory;
import com.silabs.ss.framework.project.api.core.engine.ProjectEngineOperationUtils;
import com.silabs.ss.framework.project.api.core.engine.ProjectModelModuleUtils;
import com.silabs.ss.framework.project.api.core.engine.ProjectVariables;
import com.silabs.ss.framework.project.api.core.engine.operations.IProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.entity.IBuildConfiguration;
import com.silabs.ss.framework.project.api.core.entity.IProjectEntity;
import com.silabs.ss.framework.project.api.core.external.IExternalImporter;
import com.silabs.ss.framework.project.api.core.external.IExternalType;
import com.silabs.ss.framework.project.api.core.external.ImportProjectDescriptor;
import com.silabs.ss.framework.project.api.core.model.MConfigSettings;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MProjectResourceTree;
import com.silabs.ss.framework.project.api.core.type.IProjectType;
import com.silabs.ss.framework.project.api.core.type.ProjectType;
import com.silabs.ss.framework.project.api.core.utils.ProjectUtils;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModel;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModelEngineFactory;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModelMergeUtils;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModuleUpdateUtils;
import com.silabs.ss.platform.api.content.board.core.BoardUtils;
import com.silabs.ss.platform.api.content.board.core.IBoard;
import com.silabs.ss.platform.api.content.board.core.IBoardDescriptor;
import com.silabs.ss.platform.api.content.part.core.IPart;
import com.silabs.ss.platform.api.content.part.core.IPartDescriptor;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.IWriteableDescriptor;
import com.silabs.ss.platform.api.descriptor.core.model.MDescriptor;
import com.silabs.ss.platform.api.descriptor.core.property.CoreProperties;
import com.silabs.ss.platform.api.sdk.core.ISDK;
import com.silabs.ss.platform.api.sdk.core.ISDKDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;

public class ProjectUpdateUtils {
    private ProjectUpdateUtils() {
    }

    public static IProjectEntity getProjectEntity(File filePath, IProjectDescriptor projDesc) {
        IProjectType projType = ProjectType.manager().getProjectType((IPath)new Path(filePath.getAbsolutePath()));
        IProjectEntity projEnt = projType.createProjectEntity(projDesc, filePath);
        if (projEnt instanceof IWriteableDescriptor && !projEnt.getPropertyAccess().isValueNonDefault(CoreProperties.INSTALLATION_PATH)) {
            ((IWriteableDescriptor)projEnt).setProperty(CoreProperties.INSTALLATION_PATH, (Object)filePath.toURI());
        }
        return projEnt;
    }

    public static IProjectModel createExistingUserProjectModel(IProjectEntity project, IVariableLookup variableLookup) throws CoreException {
        return ProjectUpdateUtils.createExistingUserProjectModel(project, variableLookup, true);
    }

    public static IProjectModel createExistingUserProjectModel(IProjectEntity project, IVariableLookup variableLookup, boolean simplify) throws CoreException {
        IProjectModel model = ProjectUpdateUtils.createExistingRawProjectModel(project, variableLookup, simplify);
        return ProjectModuleUpdateUtils.convertRawToUserProject(model, project);
    }

    public static IProjectModel createExistingRawProjectModel(IProjectEntity project, IVariableLookup variableLookup, boolean simplify) throws CoreException {
        ImportProjectDescriptor importDescr = new ImportProjectDescriptor(project.getName());
        try {
            importDescr.setInputLocation(project.getInstallationPath().toFile());
        }
        catch (IOException e) {
            throw Activator.reporter.newCoreException("Failed to load install path", (Throwable)e);
        }
        importDescr.setProjectEntity(project);
        importDescr.setImportMode(ImportMode.IN_PLACE);
        importDescr.setSimplify(simplify);
        IExternalType projType = Optional.of(project).map(IProjectEntity::getProjectType).map(IProjectType::getExternalType).orElseGet(ProjectUtils::getSlsExistingProjectType);
        IExternalImporter extType = projType.getImportType();
        MProject mproject = extType.createImportModel(importDescr, (IProgressMonitor)new NullProgressMonitor());
        ProjectUpdateUtils.resolveConfigurations(mproject, project);
        Stream.concat(Stream.of(project), Stream.of(project.getBuildConfigurations())).map(arg_0 -> ((Caster)Caster.with(IWriteableDescriptor.class)).cast(arg_0)).forEach(d -> ProjectUpdateUtils.updateProperties(d, mproject));
        mproject.getProperties().put((Object)"READ_FROM_EXISTING", (Object)Boolean.TRUE.toString());
        if (mproject.getContentRoot() == null) {
            throw Activator.reporter.newCoreException("Content root cannot be null when importing! projectType: " + projType.getId());
        }
        if (importDescr.isSimplify()) {
            ProjectModelMergeUtils.mergeCommonSettings(mproject);
        }
        return ProjectUpdateUtils.formatExistingRawProjectModel(project, variableLookup, mproject);
    }

    private static Object resolveConfigurations(MProject mproject, IProjectEntity projEnt) {
        IWriteableProjectDescriptor projDesc = (IWriteableProjectDescriptor)projEnt.getDescriptor();
        for (MConfiguration mconfig : mproject.getConfigurations()) {
            if (projEnt.findBuildConfiguration(mconfig.getName()) != null) continue;
            IBuildConfigurationDescriptor bconf = projDesc.findBuildConfigurationDescriptor(mconfig.getName());
            if (bconf == null) {
                bconf = projDesc.createBuildConfiguration();
                bconf.applySettings(mconfig);
                projDesc.buildConfigurationDescriptors().add(bconf);
            }
            try {
                projEnt.edit();
                projEnt.addBuildConfiguration(bconf);
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    private static void updateProperties(IWriteableDescriptor desc, MProject mproj) {
        MProject mdesc;
        Object object = mdesc = desc instanceof IProjectEntity ? mproj : mproj.findConfiguration((IDescriptor)desc);
        if (mdesc == null) {
            return;
        }
        Set updateKeys = mdesc.getProperties().keySet().stream().filter(k -> desc.getPropertyMapper().findProperty(k) != null).collect(Collectors.toSet());
        updateKeys.stream().forEachOrdered(arg_0 -> ProjectUpdateUtils.lambda$6(desc, (MDescriptor)mdesc, arg_0));
        mdesc.getProperties().removeIf(e -> updateKeys.contains(e.getKey()));
    }

    public static IProjectModel formatExistingRawProjectModel(IProjectEntity project, IVariableLookup variableLookup, MProject mproject) {
        MProjectResourceTree resourceTree = ProjectModuleUpdateUtils.createProjectResourceTree(mproject, variableLookup);
        ProjectModuleUpdateUtils.associateExistingEntriesWithModules(project, mproject, resourceTree);
        IProjectModel model = IProjectModelEngineFactory.INSTANCE.createExistingProjectModel(mproject, variableLookup, null, resourceTree);
        return model;
    }

    public static void updateToolContribution(IProjectModel projModel, MConfigSettings settings, String contributionId, MProject toolSettings) {
        ProjectUpdateUtils.updateToolContribution(projModel.getModel(), settings, contributionId, toolSettings);
    }

    public static void updateToolContribution(MProject project, MConfigSettings settings, String contributionId, MProject toolSettings) {
        toolSettings.setPdmId(contributionId);
        ProjectUpdateUtils.replaceProjectDefinedModuleReference((EList<MProject>)project.getProjectDefinedModules(), toolSettings);
        ProjectModelModuleUtils.replaceModuleReference(settings, toolSettings.getPdmId(), ".*").setPdm(true);
    }

    public static void replaceProjectDefinedModuleReference(EList<MProject> list, MProject newToolValue) {
        ListIterator iter = list.listIterator();
        while (iter.hasNext()) {
            MProject element = (MProject)iter.next();
            if (!Objects.equals(element.getPdmId(), newToolValue.getPdmId())) continue;
            iter.set(newToolValue);
            return;
        }
        list.add((Object)newToolValue);
    }

    public static void updateProjectFromModel(IProjectModel model, IProjectEntity project) throws CoreException {
        ProjectUpdateUtils.updateProjectFromModel(model, project, ProjectEngineOperationUtils.getOperationFactory(project));
    }

    public static void updateProjectFromModel(IProjectModel model, IProjectEntity project, IProjectEngineOperationFactory factory) throws CoreException {
        project.getProjectType().runProjectOperation(() -> ProjectUpdateUtils.updateProjectFromModelLocked(model, project, factory));
    }

    private static void updateProjectFromModelLocked(IProjectModel model, IProjectEntity project, IProjectEngineOperationFactory factory) throws CoreException {
        project.edit();
        ProjectUpdateUtils.doUpdateProjectFromModel(model, project, factory);
        project.save(null);
    }

    protected static void doUpdateProjectFromModel(IProjectModel model, IProjectEntity project, IProjectEngineOperationFactory factory) throws CoreException {
        IProjectEngineOperationHandler operationHandler = project.getProjectType().createProjectEngineOperationHandler(project);
        if (operationHandler.getProjectEntity() != null && operationHandler.getProjectEntity() != project) {
            throw new IllegalArgumentException("Handles are not the same!");
        }
        IProjectModel model_copy = ProjectModelEngineFactory.INSTANCE.createExistingProjectModel(model.getModel().copy(), model.getVariableLookup(), model.getContentRootURI(), model.getProjectResourceTree());
        ((ProjectModel)model_copy).setRawModel(model.getRawModel());
        IProjectType projType = null;
        if (!Objects.equals(project.getProjectType(), ((IProjectDescriptor)project.getDescriptor()).getProjectType())) {
            projType = ((IProjectDescriptor)project.getDescriptor()).getProjectType();
            ((IWriteableProjectDescriptor)project.getDescriptor()).setProjectType(project.getProjectType());
        }
        project.setup(model_copy, (IProgressMonitor)new NullProgressMonitor());
        operationHandler.load();
        if (project.getBuildConfigurations().length == 0) {
            throw Activator.reporter.newCoreException("At least one build configuration is required!", (Throwable)ExceptionUtils.newMinimalStackException());
        }
        MultiStatus status = null;
        IBuildConfiguration[] iBuildConfigurationArray = project.getBuildConfigurations();
        int n = iBuildConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildConfiguration conf = iBuildConfigurationArray[n2];
            MultiStatus configStatus = ProjectUpdateUtils.doUpdateBuildConfigFromModel(model_copy, project, operationHandler, conf, factory);
            if (status == null) {
                status = configStatus;
            } else {
                status.merge((IStatus)configStatus);
            }
            ++n2;
        }
        operationHandler.commit();
        if (projType != null) {
            ((IWriteableProjectDescriptor)project.getDescriptor()).setProjectType(projType);
        }
        if (status != null && !status.isOK()) {
            throw new CoreException(status);
        }
    }

    public static void updateBuildConfigFromModel(IProjectModel model, IProjectEntity project, IBuildConfiguration conf) throws CoreException {
        IProjectType projType = project.getProjectType();
        IProjectEngineOperationHandler operationHandler = projType.createProjectEngineOperationHandler(project);
        projType = null;
        if (!Objects.equals(project.getProjectType(), ((IProjectDescriptor)project.getDescriptor()).getProjectType())) {
            projType = ((IProjectDescriptor)project.getDescriptor()).getProjectType();
            ((IWriteableProjectDescriptor)project.getDescriptor()).setProjectType(project.getProjectType());
        }
        operationHandler.load();
        MultiStatus status = ProjectUpdateUtils.doUpdateBuildConfigFromModel(model, project, operationHandler, conf, ProjectEngineOperationUtils.getDefaultOperationFactory());
        operationHandler.commit();
        if (projType != null) {
            ((IWriteableProjectDescriptor)project.getDescriptor()).setProjectType(projType);
        }
        if (!status.isOK()) {
            throw new CoreException((IStatus)status);
        }
    }

    private static MultiStatus doUpdateBuildConfigFromModel(IProjectModel model_, IProjectEntity project, IProjectEngineOperationHandler operationHandler, IBuildConfiguration conf, IProjectEngineOperationFactory factory) throws CoreException {
        IVariableLookup variableLookup = ProjectVariables.createVariableLookup(conf);
        IProjectModel model = IProjectModelEngineFactory.INSTANCE.createProjectModelWithLookup(model_, variableLookup);
        conf.setup(model, (IProgressMonitor)new NullProgressMonitor());
        IProjectModelEngine engine = IProjectModelEngineFactory.INSTANCE.createProjectModelEngine(model);
        List<IProjectEngineOperation> operations = engine.createProjectEngineOperationsForConfig((IBuildConfigurationDescriptor)conf.getDescriptor(), factory);
        engine.queueProjectOperations(operations, operationHandler, (IProgressMonitor)new NullProgressMonitor());
        project.setConfigurationDirty(conf, true);
        return engine.status();
    }

    public static void updateDependencies(IProjectEntity[] entities, IProgressMonitor monitor, Function<IBuildConfiguration, Collection<ProjectWithBuildConfigurationId>> dependencySupplier) throws CoreException {
        ProjectUpdateUtils.updateDependencies(Arrays.asList(entities), monitor, dependencySupplier);
    }

    public static void updateDependencies(Collection<IProjectEntity> entities, IProgressMonitor monitor, Function<IBuildConfiguration, Collection<ProjectWithBuildConfigurationId>> dependencySupplier) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        Map<IProjectEntity, Map<String, Collection<ProjectWithBuildConfigurationId>>> projectsToUpdate = ProjectUpdateUtils.loadDependencies(entities, dependencySupplier, (IProgressMonitor)subMon.split(1));
        if (!projectsToUpdate.isEmpty()) {
            subMon.setWorkRemaining(projectsToUpdate.size());
            MultiStatus status = new MultiStatus(Activator.id(), 0, "Problems updating projects!", null);
            for (Map.Entry<IProjectEntity, Map<String, Collection<ProjectWithBuildConfigurationId>>> updateContent : projectsToUpdate.entrySet()) {
                try {
                    ProjectUpdateUtils.updateProjectDependencies(updateContent.getKey(), updateContent.getValue(), (IProgressMonitor)subMon.split(1));
                }
                catch (CoreException e) {
                    status.merge(Activator.reporter.newErrorStatus(e.getMessage(), (Throwable)e));
                }
            }
            if (!status.isOK()) {
                throw new CoreException((IStatus)status);
            }
        }
        subMon.setWorkRemaining(0);
    }

    private static Map<IProjectEntity, Map<String, Collection<ProjectWithBuildConfigurationId>>> loadDependencies(Collection<IProjectEntity> entities, Function<IBuildConfiguration, Collection<ProjectWithBuildConfigurationId>> dependencySupplier, IProgressMonitor monitor) {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)entities.size());
        HashMap<IProjectEntity, Map<String, Collection<ProjectWithBuildConfigurationId>>> projectsToUpdate = new HashMap<IProjectEntity, Map<String, Collection<ProjectWithBuildConfigurationId>>>();
        for (IProjectEntity handle : entities) {
            IBuildConfiguration[] iBuildConfigurationArray = handle.getBuildConfigurations();
            int n = iBuildConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildConfiguration bconf = iBuildConfigurationArray[n2];
                Collection<ProjectWithBuildConfigurationId> dependencies = bconf.getProjectDependencies();
                Collection<ProjectWithBuildConfigurationId> newDependencies = dependencySupplier.apply(bconf);
                if (newDependencies != null && !CollectionUtils.sameContent(dependencies, newDependencies)) {
                    projectsToUpdate.computeIfAbsent(handle, h -> new HashMap()).put(bconf.getId(), newDependencies);
                }
                ++n2;
            }
            subMon.split(1);
        }
        return projectsToUpdate;
    }

    public static void updateProjectDependencies(IProjectEntity project, Map<String, Collection<ProjectWithBuildConfigurationId>> configIdDependencies, IProgressMonitor monitor) throws CoreException {
        if (configIdDependencies.isEmpty()) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        MapVariableLookup variableLookup = new MapVariableLookup();
        IProjectModel model = ProjectUpdateUtils.createExistingUserProjectModel(project, (IVariableLookup)variableLookup);
        subMonitor.split(1);
        project.edit();
        for (Map.Entry<String, Collection<ProjectWithBuildConfigurationId>> configIdDepend : configIdDependencies.entrySet()) {
            String confId = configIdDepend.getKey();
            Collection<ProjectWithBuildConfigurationId> dependencies = configIdDepend.getValue();
            IBuildConfiguration bconf = project.findBuildConfiguration(confId);
            bconf.setProjectDependencies(dependencies);
            project.setConfigurationDirty(bconf, true);
        }
        subMonitor.split(1);
        if (model != null) {
            ProjectUpdateUtils.doUpdateProjectFromModel(model, project, ProjectEngineOperationUtils.getOperationFactory(project));
            subMonitor.split(1);
        }
        subMonitor.setWorkRemaining(1);
        project.save((IProgressMonitor)subMonitor.split(1));
    }

    public static void updateBoardPartAndSDK(IProjectEntity project, IBuildConfiguration[] confs, IBoard[] newBoards, IPart newPart, ISDK newSDK) throws CoreException {
        ProjectUpdateUtils.doUpdateBoardPartAndSDK(project, (IDescriptor[])newBoards, (IDescriptor)newPart, (IDescriptor)newSDK, confs);
    }

    public static void updateBoardPartAndSDK(IProjectEntity project, IBoardDescriptor[] newBoards, IPartDescriptor newPart, ISDKDescriptor newSDK, IBuildConfiguration ... confs) throws CoreException {
        ProjectUpdateUtils.doUpdateBoardPartAndSDK(project, (IDescriptor[])newBoards, (IDescriptor)newPart, (IDescriptor)newSDK, confs);
    }

    private static void doUpdateBoardPartAndSDK(IProjectEntity project, IDescriptor[] newBoards, IDescriptor newPart, IDescriptor newSDK, IBuildConfiguration[] confs) throws CoreException {
        MapVariableLookup variableLookup = new MapVariableLookup();
        IProjectModel model = ProjectUpdateUtils.createExistingUserProjectModel(project, (IVariableLookup)variableLookup);
        project.editMetadata();
        IBuildConfiguration[] iBuildConfigurationArray = confs;
        int n = confs.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildConfiguration oldConf = iBuildConfigurationArray[n2];
            IBuildConfiguration conf = project.findBuildConfiguration(oldConf.getId());
            if (newBoards != null) {
                ((IBuildConfigurationDescriptor)conf.getDescriptor()).setBoardIds(BoardUtils.toStringArray((IDescriptor[])newBoards));
            }
            if (newPart != null) {
                ((IBuildConfigurationDescriptor)conf.getDescriptor()).setPartId(newPart.getId());
            }
            if (newSDK != null) {
                ((IBuildConfigurationDescriptor)conf.getDescriptor()).setSdkId(newSDK.getId());
            }
            project.setConfigurationDirty(conf, true);
            ++n2;
        }
        if (model != null) {
            ProjectUpdateUtils.doUpdateProjectFromModel(model, project, ProjectEngineOperationUtils.getDefaultOperationFactory());
        }
    }

    private static /* synthetic */ void lambda$6(IWriteableDescriptor iWriteableDescriptor, MDescriptor mDescriptor, String k) {
        Object object = iWriteableDescriptor.setProperty(k, mDescriptor.getProperties().get((Object)k));
    }
}

