/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.external.report;

import com.silabs.java.utils.ObjectUtils;
import com.silabs.java.utils.Pair;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.runtime.RuntimeUtils;
import com.silabs.ss.framework.project.api.core.external.IImportProjectDescriptor;
import com.silabs.ss.framework.project.api.core.external.IProjectReport;
import com.silabs.ss.framework.project.api.core.external.report.ProjectImportReportSection;
import com.silabs.ss.framework.project.api.core.external.report.SettingsSiteCollator;
import com.silabs.ss.framework.project.api.core.model.ELanguage;
import com.silabs.ss.framework.project.api.core.model.EMappingStatus;
import com.silabs.ss.framework.project.api.core.model.EValueStatus;
import com.silabs.ss.framework.project.api.core.model.MBuildSetting;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MConvertedOption;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MGenericOption;
import com.silabs.ss.framework.project.api.core.model.MIncludePath;
import com.silabs.ss.framework.project.api.core.model.MLibraryFile;
import com.silabs.ss.framework.project.api.core.model.MLibraryPath;
import com.silabs.ss.framework.project.api.core.model.MMacroDefinition;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MSettingsSite;
import com.silabs.ss.framework.project.api.core.model.MSpecificOption;
import com.silabs.ss.framework.project.api.core.model.MToolOption;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.property.model.Property;
import com.silabs.ss.platform.api.rcp.core.URIUtils;
import com.silabs.ss.platform.api.rcp.core.html.HtmlContainerNode;
import com.silabs.ss.platform.api.rcp.core.html.HtmlDocument;
import com.silabs.ss.platform.api.rcp.core.html.HtmlHeading;
import com.silabs.ss.platform.api.rcp.core.html.HtmlTable;
import com.silabs.ss.platform.api.rcp.core.html.HtmlTableColumn;
import com.silabs.ss.platform.api.rcp.core.html.HtmlTableRow;
import com.silabs.ss.platform.api.rcp.core.html.HtmlText;
import com.silabs.ss.platform.api.rcp.core.html.IHtmlContainerNode;
import com.silabs.ss.platform.api.rcp.core.html.IHtmlNode;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.emf.ecore.EObject;

public class ProjectImportReport
extends HtmlContainerNode
implements IProjectReport {
    private static final String tableStyle = "border:1px solid";
    private HtmlContainerNode includeSection;
    private HtmlContainerNode macroSection;
    private HtmlContainerNode librarySection;
    private HtmlContainerNode excludedSection = new ProjectImportReportSection("excluded", 2, "Excluded Files and Folders", "These are the files and folders that will not be built with the project. ", "This setting is found by right clicking on a file/folder > Properties > C/C++ Build > Settings > Exclude Resource From Build.");
    private HtmlContainerNode migratedSection;
    private HtmlContainerNode unhandledSection;
    private HtmlContainerNode unmappedSection;
    private HtmlContainerNode partiallyMappedSection;
    private HtmlContainerNode mappedSection;
    private HtmlContainerNode importedSection;
    private MProject project;
    private HtmlContainerNode messages;
    private Map<Pair<HtmlContainerNode, MSettingsSite>, SettingsSiteCollator> settingSiteToCollatorMap;

    public ProjectImportReport(IImportProjectDescriptor descr) {
        super(descr.getName(), null);
        this.excludedSection.setHideIfEmpty(true);
        this.includeSection = new ProjectImportReportSection("includes", 2, "Include Path Settings", "These include paths were converted from the external project.", "They are found under Project > Properties > C/C++ Build > Settings > Includes.");
        this.includeSection.setHideIfEmpty(true);
        this.macroSection = new ProjectImportReportSection("macros", 2, "Defined Symbols Settings", "These symbols/macros/variables were converted from the external project.", "They are found under Project > Properties > C/C++ Build > Settings > Symbols.");
        this.macroSection.setHideIfEmpty(true);
        this.librarySection = new ProjectImportReportSection("library", 2, "Libraries", "These library paths and/or library files were converted from the external project.", "They are found under Project > Properties > C/C++ Build > Settings.");
        this.librarySection.setHideIfEmpty(true);
        this.migratedSection = new ProjectImportReportSection("migrated", 2, "Directly Migrated Settings", "These build settings were directly converted from the external project.", "They are found under Project > Properties > C/C++ Build > Settings.");
        this.migratedSection.setHideIfEmpty(true);
        this.unhandledSection = new ProjectImportReportSection("unhandled", 2, "Unhandled Settings", "Studio could not apply these build settings.", "These settings were converted from the external project into generic settings, but cannot (yet) be converted to the new project's toolchain.");
        this.unhandledSection.setHideIfEmpty(true);
        this.unmappedSection = new ProjectImportReportSection("unmapped", 2, "Unconverted Settings", "Studio could not convert these settings.", "These settings were converted from the external project but have no generic representation.", "Please review them in the project or folder/file properties to see if there are similar build settings.");
        this.unmappedSection.setHideIfEmpty(true);
        this.partiallyMappedSection = new ProjectImportReportSection("partiallyMapped", 2, "Partially Converted Settings", "Studio could not fully convert these settings.", "These settings were converted from the external project into generic settings, but these settings are not all available in the new project's toolchain.", "Please review them in the project or folder/file properties to see if there are similar build settings.");
        this.partiallyMappedSection.setHideIfEmpty(true);
        this.mappedSection = new ProjectImportReportSection("mapped", 2, "Converted Settings", "Studio converted these settings from the original project.", "They are found under Project > Properties > C/C++ Build > Settings.");
        this.mappedSection.setHideIfEmpty(true);
        this.importedSection = new ProjectImportReportSection("generics", 2, "Imported Settings", "These are the settings Studio imported from the external project.  (This section is only generated in developer mode.)");
        this.importedSection.setHideIfEmpty(true);
        this.settingSiteToCollatorMap = new LinkedHashMap<Pair<HtmlContainerNode, MSettingsSite>, SettingsSiteCollator>();
        HtmlDocument html = new HtmlDocument("Project Import Report for " + descr.getName());
        this.add((IHtmlNode)html);
        html.body().add((IHtmlNode)new HtmlHeading(1, "Project Import Summary"));
        HtmlTable table = new HtmlTable();
        html.body().add((IHtmlNode)table);
        table.addRow(new Object[]{"Import time", DateFormat.getDateTimeInstance().format(new Date())});
        if (descr.getImportProjectRecord() != null) {
            table.addRow(new Object[]{"Original location", descr.getImportProjectRecord().getProjectFile().getAbsolutePath()});
            table.addRow(new Object[]{"Original project name", descr.getImportProjectRecord().getName()});
        }
        if (descr.getExternalProjectType() != null) {
            table.addRow(new Object[]{"Original project type", descr.getExternalProjectType().getLabel()});
        }
        table.addRow(new Object[]{"Import mode", descr.getImportMode().getLabel()});
        HtmlContainerNode messageSection = new HtmlContainerNode("messages", "div");
        messageSection.setHideIfEmpty(true);
        html.body().add((IHtmlNode)messageSection);
        messageSection.add((IHtmlNode)new HtmlHeading(1, "Project Conversion Messages"));
        this.messages = new HtmlTable(new String[]{"Severity", "Message"});
        this.messages.addStyle("width:100%");
        messageSection.add((IHtmlNode)this.messages);
        HtmlContainerNode settings = new HtmlContainerNode("settings", "div");
        settings.setHideIfEmpty(true);
        html.body().add((IHtmlNode)settings);
        settings.add((IHtmlNode)new HtmlHeading(1, "Settings Conversion Summary"));
        settings.add((IHtmlNode)this.excludedSection);
        settings.add((IHtmlNode)this.includeSection);
        settings.add((IHtmlNode)this.macroSection);
        settings.add((IHtmlNode)this.migratedSection);
        settings.add((IHtmlNode)this.librarySection);
        settings.add((IHtmlNode)this.unhandledSection);
        settings.add((IHtmlNode)this.unmappedSection);
        settings.add((IHtmlNode)this.partiallyMappedSection);
        settings.add((IHtmlNode)this.mappedSection);
        if (RuntimeUtils.isPlatformPDELaunch()) {
            settings.add((IHtmlNode)this.importedSection);
        }
    }

    @Override
    public void setProject(MProject project) {
        this.project = project;
    }

    protected SettingsSiteCollator getSettingsSiteCollator(HtmlContainerNode rootSection, MSettingsSite site) {
        Pair key = new Pair((Object)rootSection, (Object)site);
        SettingsSiteCollator collator = this.settingSiteToCollatorMap.get(key);
        if (collator != null) {
            return collator;
        }
        Pair<MConfiguration, MEntry> configList = this.getConfigurationOwner(site);
        MConfiguration config = (MConfiguration)configList.first;
        IPath path = this.getPath((MEntry)configList.second);
        IHtmlContainerNode section = this.setupReportSection(rootSection, site, config, path);
        HtmlTable table = this.setupCollatorTable(rootSection, section);
        section.add((IHtmlNode)table);
        collator = new SettingsSiteCollator(table, rootSection == this.importedSection);
        this.settingSiteToCollatorMap.put((Pair<HtmlContainerNode, MSettingsSite>)key, collator);
        return collator;
    }

    private IHtmlContainerNode setupReportSection(HtmlContainerNode rootSection, MSettingsSite site, MConfiguration config, IPath path) {
        Object section;
        if (config != null) {
            String secName = "config." + config.getName();
            section = rootSection.findChild(secName);
            if (section == null) {
                section = new ProjectImportReportSection(secName, 3, "Settings for " + config.getLabel(), new String[0]);
                rootSection.add((IHtmlNode)section);
            }
        } else {
            section = rootSection.findChild("project");
            if (section == null) {
                section = new ProjectImportReportSection("project", 3, "Project Settings", new String[0]);
                rootSection.add((IHtmlNode)section);
            }
        }
        if (path.segmentCount() > 0) {
            String subName = path.toPortableString();
            Object subSection = section.findChild(subName);
            if (subSection == null) {
                subSection = new ProjectImportReportSection(subName, 3, "Settings on " + path.toPortableString(), new String[0]);
                int numIndent = path.toPortableString().split("/").length - 1;
                Object attributes = "width:100%";
                if (rootSection != this.importedSection) {
                    attributes = (String)attributes + "; margin-left:" + (numIndent < 10 ? numIndent : 10) + "%";
                }
                subSection.setAttribute("style", (String)attributes);
                section.add((IHtmlNode)subSection);
            }
            section = subSection;
        }
        return section;
    }

    private HtmlTable setupCollatorTable(HtmlContainerNode rootSection, IHtmlContainerNode section) {
        HtmlTable table;
        if (rootSection == this.unhandledSection || rootSection == this.importedSection) {
            table = new HtmlTable(new String[]{"External Tool", "External Option", "External Value", "Generic Group", "Generic Option(s)", "Generic Value(s)"});
            table.addStyle("width:100%");
        } else {
            table = new HtmlTable(new String[]{"External Tool", "External Option", "External Value", "Converted Tool", "Converted Option(s)", "Converted Value(s)"});
            table.addStyle("width:100%");
        }
        if (rootSection == this.unmappedSection || rootSection == this.unhandledSection) {
            table.addStyle("width:100%; background-color: #fff0f0");
        } else if (rootSection == this.partiallyMappedSection) {
            table.addStyle("width:100%; background-color: #fffff0");
        } else if (rootSection == this.mappedSection || rootSection == this.migratedSection) {
            table.addStyle("width:100%; background-color: #f0fff0");
        } else if (rootSection == this.importedSection) {
            rootSection.setAttribute("style", "background-color: #e0e0e0");
            table.addStyle("width:90%; margin-left: 5%; background-color: #f0f0ff; font-size: 75%");
        }
        if (section.getName().contains("config.")) {
            table.addStyle("margin-bottom: 1em");
        }
        return table;
    }

    @Override
    public void reportImportedOption(MSettingsSite site, MSpecificOption spec) {
        SettingsSiteCollator collator = this.getSettingsSiteCollator(this.importedSection, site);
        if (spec.getGenericMappings().isEmpty()) {
            collator.addMapping((MConvertedOption)spec, null);
        } else {
            for (MGenericOption gen : spec.getGenericMappings()) {
                collator.addMapping((MConvertedOption)spec, (MConvertedOption)gen);
            }
        }
    }

    @Override
    public void reportMigratedOption(MSettingsSite site, MSpecificOption spec, MToolOption toolOption) {
        SettingsSiteCollator collator = this.getSettingsSiteCollator(this.migratedSection, site);
        MSpecificOption toolSpec = ProjectModelFactory.eINSTANCE.createMSpecificOption();
        toolSpec.setToolId(toolOption.getToolId());
        toolSpec.setOptionId(toolOption.getOptionId());
        toolSpec.setValue((Object)toolOption.getValue());
        collator.addMapping((MConvertedOption)spec, (MConvertedOption)toolSpec);
    }

    private void buildTable(MSettingsSite site, HtmlTable table, HtmlContainerNode rootSection, Object[] definitions) {
        if (definitions.length == 0) {
            return;
        }
        Pair<MConfiguration, MEntry> configList = this.getConfigurationOwner(site);
        MConfiguration config = (MConfiguration)configList.first;
        IPath path = this.getPath((MEntry)configList.second);
        IHtmlContainerNode buildConfig = this.setupReportSection(rootSection, site, config, path);
        table.setName("table." + buildConfig.getName());
        table.setHideIfEmpty(true);
        table.addStyle("width:100%; background-color: #f0fff0");
        if (buildConfig.getName().contains("config.")) {
            table.addStyle("margin-bottom: 1em");
        }
        if (config == null || buildConfig.findChild(table.getName()) != null) {
            return;
        }
        ArrayList<HtmlTableRow> C51Inputs = new ArrayList<HtmlTableRow>();
        ArrayList<HtmlTableRow> CPP51Inputs = new ArrayList<HtmlTableRow>();
        ArrayList<HtmlTableRow> otherInputs = new ArrayList<HtmlTableRow>();
        Object[] objectArray = definitions;
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            Object defs = objectArray[n2];
            Pair<HtmlTableRow, String> rowPair = this.buildRow(defs);
            if (rowPair != null) {
                HtmlTableRow row = (HtmlTableRow)rowPair.first;
                rootSection.findChild(row.getName());
                if (!rootSection.children().contains(row)) {
                    if (((String)rowPair.second).contains(ELanguage.ASM.toString())) {
                        table.add((IHtmlNode)row);
                    } else if (((String)rowPair.second).contains(ELanguage.C.toString())) {
                        C51Inputs.add(row);
                    } else if (((String)rowPair.second).contains(ELanguage.CPP.toString())) {
                        CPP51Inputs.add(row);
                    } else {
                        otherInputs.add(row);
                    }
                }
            }
            ++n2;
        }
        table.children().addAll(C51Inputs);
        table.children().addAll(CPP51Inputs);
        table.children().addAll(otherInputs);
        buildConfig.add((IHtmlNode)table);
    }

    private Pair<HtmlTableRow, String> buildRow(Object setting) {
        String name;
        HtmlText[] texts;
        String language;
        block8: {
            language = "";
            if (setting instanceof MBuildSetting) {
                language = this.makeLanguage(((MBuildSetting)setting).getLanguageCompatibility());
            }
            try {
                if (setting instanceof MMacroDefinition) {
                    texts = new HtmlText[]{new HtmlText(language), new HtmlText(((MMacroDefinition)setting).getName()), new HtmlText(((MMacroDefinition)setting).getValue())};
                    name = ((MMacroDefinition)setting).getName();
                    break block8;
                }
                if (setting instanceof MIncludePath) {
                    texts = new HtmlText[]{new HtmlText(language), new HtmlText(this.makeIPath(((MIncludePath)setting).getUri()))};
                    name = ((MIncludePath)setting).getUri().toString();
                    break block8;
                }
                if (setting instanceof MLibraryPath) {
                    texts = new HtmlText[]{new HtmlText(language), new HtmlText(this.makeIPath(((MLibraryPath)setting).getUri()))};
                    name = ((MLibraryPath)setting).getUri().toString();
                    break block8;
                }
                if (setting instanceof MLibraryFile) {
                    MLibraryFile libFile = (MLibraryFile)setting;
                    texts = new HtmlText[]{new HtmlText(language), new HtmlText(!TextUtils.isEmpty((String)libFile.getName()) ? libFile.getName() : this.makeIPath(libFile.getUri()))};
                    name = libFile.getUri() == null ? libFile.getName() : libFile.getUri().toString();
                    break block8;
                }
                if (setting instanceof String) {
                    texts = new HtmlText[]{new HtmlText(setting.toString())};
                    name = setting.toString();
                    break block8;
                }
                return null;
            }
            catch (NullPointerException e) {
                Activator.reporter.logException((Throwable)e);
                return null;
            }
        }
        HtmlTableRow row = new HtmlTableRow("row." + name, (IHtmlNode[])texts);
        return new Pair((Object)row, (Object)language);
    }

    private void reportExcludedOptions(MSettingsSite site) {
        if (!(site instanceof MConfiguration)) {
            return;
        }
        HtmlTable excludeTable = new HtmlTable(new String[]{"Excluded File/Folder Paths"});
        excludeTable.addStyle("width:80%; background-color: #ffffff");
        Object[] excludedPaths = ((MConfiguration)site).getExcludedPaths().toArray();
        Arrays.sort(excludedPaths);
        this.buildTable(site, excludeTable, this.excludedSection, excludedPaths);
    }

    private void reportMacros(MSettingsSite site) {
        if (site.getMacroDefinitions().size() == 0) {
            return;
        }
        HtmlTable macroTable = new HtmlTable(new String[]{"Language", "Symbol Name", "Symbol Value"});
        macroTable.addStyle("width:80%; background-color: #ffffff");
        macroTable.getColumnHeaders()[0].setAttribute("style", "width:15%");
        this.buildTable(site, macroTable, this.macroSection, site.getMacroDefinitions().toArray());
    }

    private void reportIncludes(MSettingsSite site) {
        if (site.getIncludePaths().size() == 0) {
            return;
        }
        HtmlTable includeTable = new HtmlTable(new String[]{"Language", "Include Paths"});
        includeTable.addStyle("width:80%; background-color: #ffffff");
        includeTable.getColumnHeaders()[0].setAttribute("style", "width:15%");
        this.buildTable(site, includeTable, this.includeSection, site.getIncludePaths().toArray());
    }

    private void reportLibraries(MSettingsSite site) {
        if (site.getLibraryFiles().size() != 0) {
            HtmlTable libFilesTable = new HtmlTable(new String[]{"Language", "Library Files"});
            libFilesTable.addStyle("width:80%; background-color: #ffffff");
            this.buildTable(site, libFilesTable, this.librarySection, site.getLibraryFiles().toArray());
        }
        if (site.getLibraryPaths().size() != 0) {
            HtmlTable libPathTable = new HtmlTable(new String[]{"Language", "Library Paths"});
            libPathTable.addStyle("width:80%; background-color: #ffffff");
            this.buildTable(site, libPathTable, this.librarySection, site.getLibraryPaths().toArray((Object[])new MBuildSetting[0]));
        }
    }

    @Override
    public void reportSettingConversions(MSettingsSite site) {
        this.reportExcludedOptions(site);
        this.reportIncludes(site);
        this.reportMacros(site);
        this.reportLibraries(site);
        for (MConvertedOption cnv : site.getConvertedOptions()) {
            SettingsSiteCollator collator;
            if (cnv instanceof MSpecificOption) {
                MSpecificOption spec = (MSpecificOption)cnv;
                if (spec.getGenericMappings().isEmpty()) {
                    if (spec.getMappingStatus() == EMappingStatus.MAPPED || !this.isInterestingOmission(spec)) continue;
                    collator = this.getSettingsSiteCollator(site, spec.getMappingStatus());
                    collator.addMapping((MConvertedOption)spec, null);
                    continue;
                }
                for (MGenericOption gen : spec.getGenericMappings()) {
                    SettingsSiteCollator collator2;
                    if (gen.getSpecificMappings().isEmpty()) {
                        if (!this.isInterestingOmission(spec)) continue;
                        collator2 = this.getSettingsSiteCollator(site, null);
                        collator2.addMapping((MConvertedOption)spec, (MConvertedOption)gen);
                        continue;
                    }
                    collator2 = this.getSettingsSiteCollator(site, spec.getMappingStatus());
                    for (MSpecificOption ext : gen.getSpecificMappings()) {
                        collator2.addMapping((MConvertedOption)spec, (MConvertedOption)ext);
                    }
                }
                continue;
            }
            if (cnv instanceof MGenericOption) {
                MGenericOption gen = (MGenericOption)cnv;
                collator = this.getSettingsSiteCollator(site, EMappingStatus.UNMAPPED);
                for (MSpecificOption ext : gen.getSpecificMappings()) {
                    collator.addMapping((MConvertedOption)ext, null);
                }
                continue;
            }
            assert (false);
        }
    }

    private boolean isInterestingOmission(MSpecificOption spec) {
        if (spec.getValueStatus() != EValueStatus.KNOWN_CUSTOMIZED) {
            return false;
        }
        IProperty specProperty = (IProperty)Property.registry().findDescriptor(spec.getOptionId());
        return specProperty == null || !ObjectUtils.equals((Object)spec.getValue(), (Object)specProperty.getDefaultValue());
    }

    private String makeLanguage(String langSet) {
        StringBuilder ret = new StringBuilder();
        if (langSet == null || ".*".equals(langSet) || "ALL".equals(langSet)) {
            return ".*";
        }
        String[] stringArray = langSet.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String lang = stringArray[n2];
            if (lang.equals(ELanguage.ASM.toString())) {
                ret.append("/Assembly");
            } else if (lang.equals(ELanguage.C.toString())) {
                ret.append("/C");
            } else if (lang.equals(ELanguage.CPP.toString())) {
                ret.append("/C++");
            } else if (lang.equals(ELanguage.OBJ.toString())) {
                ret.append("/Linker");
            }
            ++n2;
        }
        assert (ret.length() > 0);
        return ret.length() > 0 ? ret.substring(1) : ret.substring(0);
    }

    private String makeIPath(String uriStr) {
        try {
            try {
                IPath iPath = URIUtils.resolveURIToPath((URI)URIUtil.fromString((String)uriStr));
                return iPath.toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                IPath iPath = URIUtils.resolveURIToPath((URI)URI.create(uriStr));
                return iPath.toString();
            }
        }
        catch (IOException iOException) {
            return uriStr;
        }
    }

    private Pair<MConfiguration, MEntry> getConfigurationOwner(MSettingsSite site) {
        Pair returnPair = new Pair(null, null);
        block0: for (MConfiguration configIter : this.project.getConfigurations()) {
            for (Map.Entry entryMap : configIter.getEntrySettings()) {
                if (entryMap.getValue() != site) continue;
                returnPair.first = configIter;
                returnPair.second = (MEntry)entryMap.getKey();
                continue block0;
            }
        }
        if (returnPair.first == null) {
            returnPair.first = this.getConfigurationOwning((EObject)site);
        }
        if (returnPair.second == null) {
            returnPair.second = this.getEntryOwning((EObject)site);
        }
        return returnPair;
    }

    private MEntry getEntryOwning(EObject obj) {
        while (obj != null) {
            if (obj instanceof MEntry) {
                return (MEntry)obj;
            }
            obj = obj.eContainer();
        }
        return this.project;
    }

    private MConfiguration getConfigurationOwning(EObject obj) {
        while (obj != null) {
            if (obj instanceof MConfiguration) {
                return (MConfiguration)obj;
            }
            obj = obj.eContainer();
        }
        return null;
    }

    private IPath getPath(MEntry entry) {
        if (entry instanceof MProject) {
            return Path.ROOT;
        }
        MEntry parent = this.getEntryOwning(entry.eContainer());
        if (parent != null) {
            return this.getPath(parent).append(entry.getName());
        }
        return new Path(entry.getName());
    }

    protected SettingsSiteCollator getSettingsSiteCollator(MSettingsSite site, EMappingStatus status) {
        HtmlContainerNode root;
        if (status == null) {
            root = this.unhandledSection;
        } else {
            switch (status) {
                default: {
                    root = this.unmappedSection;
                    break;
                }
                case PARTIALLY_MAPPED: {
                    root = this.partiallyMappedSection;
                    break;
                }
                case MAPPED: {
                    root = this.mappedSection;
                }
            }
        }
        SettingsSiteCollator collator = this.getSettingsSiteCollator(root, site);
        return collator;
    }

    @Override
    public void addMessage(int severity, String string) {
        HtmlTableRow row = new HtmlTableRow(null, new IHtmlNode[]{new HtmlText(ProjectImportReport.statusSeverity(severity)), new HtmlText(string)});
        this.messages.add((IHtmlNode)row);
    }

    private static String statusSeverity(int sev) {
        switch (sev) {
            case 4: {
                return "error";
            }
            case 2: {
                return "warning";
            }
            case 1: {
                return "info";
            }
        }
        return Integer.toString(sev);
    }

    @Override
    public String createReport() {
        for (SettingsSiteCollator coll : this.settingSiteToCollatorMap.values()) {
            coll.flush();
        }
        this.applyTableStyles(this);
        return this.format();
    }

    private void applyTableStyles(IHtmlNode node) {
        if (node instanceof HtmlTable || node instanceof HtmlTableRow || node instanceof HtmlTableColumn) {
            node.addStyle(tableStyle);
        }
        if (node instanceof IHtmlContainerNode) {
            for (IHtmlNode kid : ((IHtmlContainerNode)node).children()) {
                this.applyTableStyles(kid);
            }
        }
    }
}

