/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.external;

import com.silabs.ss.framework.project.api.core.external.IExternalType;
import com.silabs.ss.framework.project.api.core.external.ImportProjectRecord;
import java.io.File;
import java.util.Objects;

public final class ImportProjectInfo {
    private String projectName;
    private final IExternalType extProjectType;
    private final File root;
    private long newestFileTime;
    private ImportProjectRecord record;

    public ImportProjectInfo(IExternalType extProjectType, File root, ImportProjectRecord record, long newestFileTime) {
        this.record = record;
        this.projectName = record.getName();
        this.extProjectType = extProjectType;
        this.root = root;
        this.newestFileTime = newestFileTime;
    }

    public int hashCode() {
        return Objects.hash(this.extProjectType, this.record, this.root);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImportProjectInfo other = (ImportProjectInfo)obj;
        if (!Objects.equals(this.extProjectType, other.extProjectType)) {
            return false;
        }
        if (!Objects.equals(this.root, other.root)) {
            return false;
        }
        return Objects.equals(this.record, other.record);
    }

    public String toString() {
        return "ImportProjectInfo [projectName=" + this.projectName + ", extProjectType=" + this.extProjectType.getLabel() + ", location=" + String.valueOf(this.record.getProjectFile()) + "]";
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public IExternalType getExtProjectType() {
        return this.extProjectType;
    }

    public File getProjectFile() {
        return this.record.getProjectFile();
    }

    public File getProjectDirectory() {
        return this.record.getProjectDirectory();
    }

    public boolean isSolution() {
        return this.record.isSolution();
    }

    public File getRoot() {
        return this.root;
    }

    public long getNewestFileTime() {
        return this.newestFileTime;
    }

    public ImportProjectRecord getImportProjectRecord() {
        return this.record;
    }
}

