/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.external;

import com.silabs.java.utils.Pair;
import com.silabs.ss.framework.project.api.core.IBuildConfigurationDescriptor;
import com.silabs.ss.framework.project.api.core.ImportMode;
import com.silabs.ss.framework.project.api.core.external.IExternalImporter;
import com.silabs.ss.framework.project.api.core.external.IExternalType;
import com.silabs.ss.framework.project.api.core.external.IImportDescriptor;
import com.silabs.ss.framework.project.api.core.external.IImportProjectDescriptor;
import com.silabs.ss.framework.project.api.core.external.IImportSolutionDescriptor;
import com.silabs.ss.framework.project.api.core.external.IPostImportCleanup;
import com.silabs.ss.framework.project.api.core.external.ImportProjectDescriptor;
import com.silabs.ss.framework.project.api.core.external.ImportProjectInfo;
import com.silabs.ss.framework.project.api.core.external.ImportProjectScanningEngine;
import com.silabs.ss.framework.project.api.core.external.ImportSolutionDescriptor;
import com.silabs.ss.framework.project.api.core.external.ImportSolutionProjectRecord;
import com.silabs.ss.framework.project.api.core.external.SolutionImportResult;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import com.silabs.ss.framework.project.api.core.solution.model.MSolution;
import com.silabs.ss.framework.project.api.core.type.IProjectType;
import com.silabs.ss.framework.project.api.core.type.ProjectType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public final class ImportExternalProjectEngine {
    private ImportProjectScanningEngine scanner;
    private ImportMode importMode = ImportMode.LINK;
    private Collection<ImportProjectInfo> scannedInfo;
    private ImportProjectInfo selectedInfo;
    private IImportDescriptor importDesc;
    private Collection<Pair<IPostImportCleanup, IImportDescriptor>> cleaners = new ArrayList<Pair<IPostImportCleanup, IImportDescriptor>>();
    private IProjectType projectType;
    private MSolution solutionModel;

    public ImportExternalProjectEngine() {
        this.scanner = ImportExternalProjectEngine.setupDefaultScanner();
    }

    public Collection<ImportProjectInfo> scan(File scanLoc, ImportMode mode, IProgressMonitor monitor) {
        this.setImportMode(mode);
        return this.scan(scanLoc, monitor);
    }

    public Collection<ImportProjectInfo> scan(File scanLoc, IProgressMonitor monitor) {
        this.setScanLocation(scanLoc);
        return this.scan(monitor);
    }

    public Collection<ImportProjectInfo> scan(IProgressMonitor monitor) {
        this.scannedInfo = this.scanner.scanProjects(this.importMode, monitor);
        return this.scannedInfo;
    }

    public IImportDescriptor setSelectedInfo(ImportProjectInfo info) {
        this.runCleanup();
        if (info == null) {
            this.selectedInfo = null;
            this.importDesc = null;
            return null;
        }
        this.selectedInfo = info;
        this.registerCleaner(info, this.importDesc);
        this.importDesc = this.createImportDesc(info, this.importMode);
        return this.importDesc;
    }

    public void runCleanup() {
        if (this.cleaners == null) {
            return;
        }
        Collection<Pair<IPostImportCleanup, IImportDescriptor>> lclCleaners = this.cleaners;
        this.cleaners = new ArrayList<Pair<IPostImportCleanup, IImportDescriptor>>();
        lclCleaners.forEach(p -> ((IPostImportCleanup)p.first).runPostImport((IImportDescriptor)p.second));
    }

    public boolean loadModels(IProgressMonitor monitor) throws CoreException {
        if (this.importDesc == null) {
            return false;
        }
        IExternalImporter importProjectType = this.importDesc.getExternalProjectType().getImportType();
        this.importDesc.setTemplate(null);
        boolean defaultConfigsCreated = false;
        if (this.importDesc instanceof IImportSolutionDescriptor) {
            defaultConfigsCreated = this.importForSolution((IImportSolutionDescriptor)this.importDesc, importProjectType, monitor);
        } else if (this.importDesc instanceof IImportProjectDescriptor) {
            defaultConfigsCreated = this.importForProject((IImportProjectDescriptor)this.importDesc, monitor);
        }
        return defaultConfigsCreated;
    }

    private boolean importForSolution(IImportSolutionDescriptor slnDesc, IExternalImporter importer, IProgressMonitor monitor) throws CoreException {
        SubMonitor submon = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        SolutionImportResult result = importer.solutionProjectLocations(slnDesc, (IProgressMonitor)submon.split(1));
        if (result == null || result.locations().isEmpty()) {
            return false;
        }
        ImportProjectScanningEngine projScanner = ImportExternalProjectEngine.setupDefaultScanner();
        projScanner.setLocations((List<File>)result.locations());
        projScanner.setSingleProjectMode(false);
        projScanner.setExtProjectTypes(ImportExternalProjectEngine.importers(result.disallowedTypes()));
        ImportMode projMode = result.importMode() == null ? this.importMode : result.importMode();
        Collection<ImportProjectInfo> projInfo = projScanner.scanProjects(projMode, (IProgressMonitor)submon.split(1));
        ((ImportSolutionProjectRecord)this.selectedInfo.getImportProjectRecord()).setChildInfos(projInfo);
        submon.setWorkRemaining(projInfo.size());
        boolean defaultConfigsCreated = false;
        ArrayList<IImportProjectDescriptor> subprojs = new ArrayList<IImportProjectDescriptor>();
        for (ImportProjectInfo info : projInfo) {
            IImportDescriptor subImportDesc = this.createImportDesc(info, projMode);
            if (!(subImportDesc instanceof IImportProjectDescriptor)) continue;
            IImportProjectDescriptor subProjDesc = (IImportProjectDescriptor)subImportDesc;
            this.registerCleaner(info, subProjDesc);
            subprojs.add(subProjDesc);
            defaultConfigsCreated |= this.importForProject(subProjDesc, (IProgressMonitor)submon.split(1));
        }
        slnDesc.setChildProjects(subprojs);
        return defaultConfigsCreated;
    }

    private boolean importForProject(IImportProjectDescriptor importDesc, IProgressMonitor monitor) throws CoreException {
        IExternalImporter importer = importDesc.getExternalProjectType().getImportType();
        MProject model = importer.createImportModel(importDesc, monitor);
        importDesc.setProjectModel(model);
        boolean defaultConfigsCreated = false;
        if (model != null && model.getConfigurations().isEmpty()) {
            defaultConfigsCreated = true;
            MConfiguration debug = ProjectModelFactory.eINSTANCE.createMConfiguration();
            debug.setName("debug");
            debug.setStockConfigCompatibility("com.silabs.ss.framework.project.toolchain.core.debug");
            model.getConfigurations().add((Object)debug);
            MConfiguration release = ProjectModelFactory.eINSTANCE.createMConfiguration();
            release.setName("release");
            release.setStockConfigCompatibility("com.silabs.ss.framework.project.toolchain.core.release");
            model.getConfigurations().add((Object)release);
        }
        return defaultConfigsCreated;
    }

    public void updateConfigsFromModel() {
        this.doUpdateConfigsFromModel(this.projDesc());
    }

    private void doUpdateConfigsFromModel(IImportDescriptor projDesc) {
        if (projDesc instanceof IImportProjectDescriptor) {
            MProject model = ((IImportProjectDescriptor)projDesc).getProjectModel();
            if (model == null) {
                return;
            }
            for (MConfiguration config : model.getConfigurations()) {
                IBuildConfigurationDescriptor buildConfig = projDesc.findBuildConfigurationDescriptor(config.getName());
                if (buildConfig == null) continue;
                config.setLabel(buildConfig.getLabel());
            }
        } else if (projDesc instanceof IImportSolutionDescriptor) {
            ((IImportSolutionDescriptor)projDesc).getChildProjects().forEach(this::doUpdateConfigsFromModel);
        }
    }

    public MSolution solutionModel() {
        return this.solutionModel;
    }

    public ImportProjectScanningEngine scanner() {
        return this.scanner;
    }

    public IImportDescriptor projDesc() {
        return this.importDesc;
    }

    public ImportProjectInfo selectedInfo() {
        return this.selectedInfo;
    }

    public ImportExternalProjectEngine setImportMode(ImportMode importMode) {
        this.importMode = importMode;
        return this;
    }

    public ImportExternalProjectEngine setScanLocation(File ... scanLoc) {
        this.scanner.setLocations(List.of(scanLoc));
        return this;
    }

    public ImportExternalProjectEngine setProjectType(IProjectType projectType) {
        this.projectType = projectType;
        return this;
    }

    private void registerCleaner(ImportProjectInfo info, IImportDescriptor projDesc) {
        IPostImportCleanup cleaner = (IPostImportCleanup)info.getExtProjectType().getAdapter(IPostImportCleanup.class);
        if (cleaner == null) {
            return;
        }
        this.cleaners.add((Pair<IPostImportCleanup, IImportDescriptor>)new Pair((Object)cleaner, (Object)projDesc));
    }

    private IImportDescriptor createImportDesc(ImportProjectInfo info, ImportMode mode) {
        ImportProjectDescriptor importDesc = info.getImportProjectRecord().isSolution() ? new ImportSolutionDescriptor(info.getProjectName()) : new ImportProjectDescriptor(info.getProjectName());
        importDesc.setProjectType(this.projectType);
        importDesc.setImportMode(mode);
        importDesc.setExternalProjectType(info.getExtProjectType());
        importDesc.setImportProjectRecord(info.getImportProjectRecord());
        importDesc.setInputLocation(info.getProjectFile());
        return importDesc;
    }

    private static List<IExternalType> importers(Collection<String> disallowed) {
        return Stream.of(ProjectType.manager().getAllExternalTypes()).filter(type -> !disallowed.contains(type.getId())).collect(Collectors.toList());
    }

    private static ImportProjectScanningEngine setupDefaultScanner() {
        ImportProjectScanningEngine scanner = new ImportProjectScanningEngine();
        scanner.setExtProjectTypes(null);
        scanner.setIgnoreDirectoryProjects(true);
        scanner.setRecurse(false);
        scanner.setSingleProjectMode(true);
        scanner.setTimeLimit(null);
        return scanner;
    }
}

