/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.external;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.IFileVisitor;
import com.silabs.ss.framework.project.api.core.ImportMode;
import com.silabs.ss.framework.project.api.core.engine.ProjectModelUtils;
import com.silabs.ss.framework.project.api.core.external.IExternalImporter;
import com.silabs.ss.framework.project.api.core.external.IImportProjectDescriptor;
import com.silabs.ss.framework.project.api.core.external.IImportSolutionDescriptor;
import com.silabs.ss.framework.project.api.core.external.ProjectImportUtils;
import com.silabs.ss.framework.project.api.core.external.SolutionImportResult;
import com.silabs.ss.framework.project.api.core.external.utils.IExternalProjectConfiguration;
import com.silabs.ss.framework.project.api.core.external.utils.IExternalProjectContentContainer;
import com.silabs.ss.framework.project.api.core.external.utils.IExternalProjectEntry;
import com.silabs.ss.framework.project.api.core.external.utils.IExternalProjectOption;
import com.silabs.ss.framework.project.api.core.model.MBuildSetting;
import com.silabs.ss.framework.project.api.core.model.MConfiguration;
import com.silabs.ss.framework.project.api.core.model.MContent;
import com.silabs.ss.framework.project.api.core.model.MEntry;
import com.silabs.ss.framework.project.api.core.model.MFileContent;
import com.silabs.ss.framework.project.api.core.model.MFileEntry;
import com.silabs.ss.framework.project.api.core.model.MFolderContent;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MLibraryFile;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import com.silabs.ss.framework.project.api.core.model.MSettingsSite;
import com.silabs.ss.framework.project.api.core.model.ProjectModelFactory;
import com.silabs.ss.framework.project.api.core.model.options.ConvertedOptionsUtils;
import com.silabs.ss.framework.project.api.core.model.util.ProjectModelSwitch;
import com.silabs.ss.framework.project.api.core.solution.model.MSolution;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.framework.project.internal.core.engine.ProjectModelMergeUtils;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;

public abstract class BaseExternalProjectImporter
implements IExternalImporter {
    private boolean importImplicitContent = true;
    protected String superTypeId;

    public BaseExternalProjectImporter(String superTypeId) {
        this.superTypeId = superTypeId;
    }

    @Override
    public SolutionImportResult solutionProjectLocations(IImportSolutionDescriptor importDesc, IProgressMonitor monitor) throws CoreException {
        return null;
    }

    @Override
    public MSolution createImportSolutionModel(IImportSolutionDescriptor importDescr, IProgressMonitor monitor) throws CoreException {
        return null;
    }

    @Override
    public String getSuperExternalProjectTypeId() {
        return this.superTypeId;
    }

    protected MProject instantiateProject(IImportProjectDescriptor importDescr, File projectFolder) {
        MProject mproject = ProjectModelFactory.eINSTANCE.createMProject();
        mproject.setName(importDescr.getName());
        mproject.setContentRoot(projectFolder.toURI().toString());
        return mproject;
    }

    protected File getProjectFolder(IImportProjectDescriptor importDescr) {
        File loc = importDescr.getInputLocation();
        return loc.isFile() ? loc.getParentFile() : loc;
    }

    protected void updateProjectFolder(IPath projectPath, MFolderContent content) {
    }

    protected boolean acceptProjectFile(IPath projectPath) {
        return true;
    }

    protected boolean acceptProjectFolder(IPath projectPath) {
        return true;
    }

    @Override
    public IStatus getImportMessage(ImportMode mode) {
        if (mode == ImportMode.IN_PLACE) {
            return Activator.reporter.newWarningStatus("The project will no longer build in the original IDE.", null);
        }
        return null;
    }

    public void setUseExplicitContent() {
        this.importImplicitContent = false;
    }

    private boolean defaultFilter(IImportModelDirectoryFilter.TYPE type, IPath path) {
        switch (type) {
            case FILE: {
                return this.acceptProjectFile(path);
            }
            case FOLDER: {
                return this.acceptProjectFolder(path);
            }
        }
        return true;
    }

    protected MProject createImportModelFromDirectory(IImportProjectDescriptor importDescr, IProgressMonitor monitor) throws CoreException {
        return this.createImportModelFromDirectory(importDescr, this::defaultFilter, monitor);
    }

    protected MProject createImportModelFromDirectory(IImportProjectDescriptor importDescr, final IImportModelDirectoryFilter filter, IProgressMonitor monitor) throws CoreException {
        final File loc = this.getProjectFolder(importDescr);
        final MProject mproject = this.instantiateProject(importDescr, loc);
        FileUtils.accept((File)loc, (IFileVisitor)new IFileVisitor(){
            int prefixLength;
            {
                this.prefixLength = file.getPath().length();
            }

            IPath getProjectPath(File ent) {
                return new Path(ent.getPath().substring(this.prefixLength)).makeAbsolute();
            }

            public boolean enterDirectory(File dir) {
                if (dir.equals(loc)) {
                    return true;
                }
                IPath projectPath = this.getProjectPath(dir);
                if (!filter.acceptPath(IImportModelDirectoryFilter.TYPE.FOLDER, projectPath)) {
                    return false;
                }
                if (BaseExternalProjectImporter.this.importImplicitContent) {
                    MFolderContent content = ProjectModelUtils.findOrCreateFolderContent(null, mproject, projectPath, dir.getPath());
                    content.setLinked(Boolean.valueOf(false));
                    content.setIncludeAllFiles(BaseExternalProjectImporter.this.importImplicitContent);
                    content.setIncludeAllFolders(BaseExternalProjectImporter.this.importImplicitContent);
                    BaseExternalProjectImporter.this.updateProjectFolder(projectPath, content);
                } else {
                    ProjectModelUtils.findOrCreateFolder(null, (MFolderEntry)mproject, projectPath);
                }
                return !BaseExternalProjectImporter.this.importImplicitContent;
            }

            public void exitDirectory(File dir) {
            }

            public void visitFile(File file) {
                IPath projectPath = this.getProjectPath(file);
                if (!filter.acceptPath(IImportModelDirectoryFilter.TYPE.FILE, projectPath)) {
                    return;
                }
                MFolderEntry mfolder = ProjectModelUtils.findOrCreateFolder(null, (MFolderEntry)mproject, projectPath.removeLastSegments(1));
                MFileContent mfile = ProjectModelFactory.eINSTANCE.createMFileContent();
                mfile.setName(projectPath.lastSegment());
                mfile.setUri(file.toURI().toString());
                mfile.setLinked(Boolean.valueOf(false));
                mfolder.getFiles().add((Object)mfile);
            }
        });
        return mproject;
    }

    protected static Map<String, Boolean> searchFileEntries(File zipFile) {
        return BaseExternalProjectImporter.searchFileEntries(zipFile, null);
    }

    protected static Map<String, Boolean> searchFileEntries(File zipFile, Collection<String> searchNames) {
        HashMap<String, Boolean> fileMap = new HashMap<String, Boolean>();
        HashSet<String> expected = searchNames == null ? null : new HashSet<String>(searchNames);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (ZipFile zf = new ZipFile(zipFile);){
                Enumeration<? extends ZipEntry> e = zf.entries();
                for (int elementCnt = 0; e.hasMoreElements() && elementCnt < 8192; ++elementCnt) {
                    ZipEntry entry = e.nextElement();
                    fileMap.put(entry.getName(), !entry.isDirectory());
                    if (searchNames == null) continue;
                    expected.remove(entry.getName());
                    if (!expected.isEmpty()) continue;
                    break;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            Activator.reporter.logError("Cannot open zipped file: " + String.valueOf(zipFile), (Throwable)ex);
        }
        return fileMap;
    }

    public ExternalProject externalProjectToMProject(IExternalProjectContentContainer projectRoot, IImportProjectDescriptor importDescr) {
        return new ExternalProject(projectRoot, importDescr);
    }

    public class ExternalProject
    extends ExternalProjectContentContainer {
        Map<String, MConfiguration> mconfigMap;
        File externalProjectFolder;
        MProject mproject;
        IPath mprojectRoot;
        MFolderEntry rootFolder;
        ImportMode importMode;
        Map<MFileEntry, MLibraryFile> convertedLibraries;

        public ExternalProject(IExternalProjectContentContainer projectRoot, IImportProjectDescriptor importDescr) {
            super(projectRoot);
            this.convertedLibraries = new HashMap<MFileEntry, MLibraryFile>();
            this.externalProjectFolder = BaseExternalProjectImporter.this.getProjectFolder(importDescr);
            this.mproject = BaseExternalProjectImporter.this.instantiateProject(importDescr, this.externalProjectFolder);
            this.mprojectRoot = new Path(".");
            this.rootFolder = this.mproject;
            this.importMode = importDescr.getImportMode();
            this.mconfigMap = new HashMap<String, MConfiguration>();
            for (Map.Entry entry : this.configurations.entrySet()) {
                MConfiguration mConfiguration = ((ExternalProjectConfiguration)entry.getValue()).toMConfiguration();
                this.mconfigMap.put((String)entry.getKey(), mConfiguration);
                this.mproject.getConfigurations().add((Object)mConfiguration);
            }
            this.addSubfolders(this.rootFolder, this.externalProjectFolder, (Map)this.mconfigMap, this.mprojectRoot, this.importMode);
            this.fixupLibraries();
        }

        public MProject getMProject() {
            return this.mproject;
        }

        public Map<MFileEntry, MLibraryFile> convertedLibraries() {
            return this.convertedLibraries;
        }

        private void fixupLibraries() {
            new ProjectModelSwitch<Object>(){

                public Object caseMFileEntry(MFileEntry file) {
                    if (!file.getName().endsWith(".a") || !(file instanceof MContent)) {
                        return null;
                    }
                    MLibraryFile libFile = ProjectModelFactory.eINSTANCE.createMLibraryFile();
                    libFile.setUri(((MContent)file).getUri());
                    libFile.setBuiltin(file.isBuiltin());
                    ProjectModelMergeUtils.mergeSelectableSettings((MSelectable)file, (MSelectable)libFile);
                    ExternalProject.this.mproject.getLibraryFiles().add((Object)libFile);
                    ExternalProject.this.convertedLibraries.put(file, libFile);
                    return null;
                }

                public Object defaultCase(EObject object) {
                    for (Object obj : object.eContents()) {
                        this.doSwitch((EObject)obj);
                    }
                    return this;
                }
            }.doSwitch((EObject)this.mproject);
        }
    }

    public static class ExternalProjectConfiguration {
        String name;
        List<ExternalProjectOption> options;
        List<MBuildSetting> buildSettings;

        public ExternalProjectConfiguration(IExternalProjectConfiguration extConfig) {
            this.name = extConfig.getName();
            this.options = new ArrayList<ExternalProjectOption>();
            this.buildSettings = new ArrayList<MBuildSetting>();
            if (extConfig.getOptions() != null) {
                for (IExternalProjectOption iExternalProjectOption : extConfig.getOptions()) {
                    this.options.add(new ExternalProjectOption(iExternalProjectOption));
                }
            }
            if (extConfig.getBuildSettings() != null) {
                this.buildSettings.addAll(extConfig.getBuildSettings());
            }
        }

        public List<ExternalProjectOption> getOptions() {
            return this.options;
        }

        public List<MBuildSetting> getBuildSettings() {
            return this.buildSettings;
        }

        public MConfiguration toMConfiguration() {
            MConfiguration config = ProjectModelFactory.eINSTANCE.createMConfiguration();
            config.setName(this.name);
            config.setLabel(this.name);
            for (ExternalProjectOption option : this.options) {
                option.importOption((MSettingsSite)config);
            }
            ProjectImportUtils.addBuildSettingsToSettingsSite((MSettingsSite)config, this.buildSettings);
            return config;
        }
    }

    private class ExternalProjectContentContainer
    extends ExternalProjectEntry {
        List<ExternalProjectFile> files;
        List<ExternalProjectFolder> folders;

        public ExternalProjectContentContainer(IExternalProjectContentContainer extFolder) {
            super(extFolder);
            this.files = new ArrayList<ExternalProjectFile>();
            this.folders = new ArrayList<ExternalProjectFolder>();
            for (IExternalProjectEntry iExternalProjectEntry : extFolder.getChildFiles()) {
                this.files.add(new ExternalProjectFile(iExternalProjectEntry));
            }
            for (IExternalProjectContentContainer iExternalProjectContentContainer : extFolder.getChildFolders()) {
                this.folders.add(new ExternalProjectFolder(iExternalProjectContentContainer));
            }
        }

        public List<ExternalProjectFile> getFiles() {
            return this.files;
        }

        public List<ExternalProjectFolder> getFolders() {
            return this.folders;
        }

        public void addSubfolders(MFolderEntry thisFolder, File externalProjectFolder, Map<String, MConfiguration> mconfigMap, IPath slsModelPath, ImportMode importMode) {
            for (ExternalProjectFile file : this.getFiles()) {
                thisFolder.getFiles().add((Object)file.toMFile(thisFolder, externalProjectFolder, mconfigMap, slsModelPath, importMode));
            }
            for (ExternalProjectFolder folder : this.getFolders()) {
                MFolderEntry mFolder = folder.toMFolder(thisFolder, externalProjectFolder, mconfigMap, slsModelPath, importMode);
                if (mFolder == null) continue;
                thisFolder.getFolders().add((Object)mFolder);
            }
        }
    }

    public static class ExternalProjectEntry {
        String name;
        Map<String, ExternalProjectConfiguration> configurations;
        List<String> excludedConfigurations;
        ExternalProjectConfiguration targetConfiguration;

        public <T extends IExternalProjectEntry> ExternalProjectEntry(T extEntry) {
            this.name = extEntry.getName();
            this.configurations = new HashMap<String, ExternalProjectConfiguration>();
            this.excludedConfigurations = new ArrayList<String>();
            if (extEntry.getExcludedConfigurationNames() != null) {
                this.excludedConfigurations.addAll((Collection<String>)extEntry.getExcludedConfigurationNames());
            }
            if (extEntry.getConfigurations() != null) {
                for (IExternalProjectConfiguration iExternalProjectConfiguration : extEntry.getConfigurations()) {
                    String configName = iExternalProjectConfiguration.getName();
                    this.configurations.put(configName, new ExternalProjectConfiguration(iExternalProjectConfiguration));
                }
            }
            this.targetConfiguration = extEntry.getTargetConfiguration() != null ? new ExternalProjectConfiguration(extEntry.getTargetConfiguration()) : null;
        }

        public Collection<ExternalProjectConfiguration> getConfigurations() {
            return this.configurations.values();
        }

        protected void updateExcludedConfigurations(IPath slsPath, Map<String, MConfiguration> mconfigMap) {
            for (String configName : this.excludedConfigurations) {
                if (!mconfigMap.containsKey(configName)) continue;
                mconfigMap.get(configName).getExcludedPaths().add((Object)slsPath.toString());
            }
        }

        protected void mapEntryConfigurations(MEntry mentry, Map<String, MConfiguration> mconfigMap, File projectFolder) {
            for (Map.Entry<String, ExternalProjectConfiguration> entry : this.configurations.entrySet()) {
                String configName = entry.getKey();
                ExternalProjectConfiguration configuration = entry.getValue();
                if (!mconfigMap.containsKey(configName)) continue;
                MConfiguration entrySettings = configuration.toMConfiguration();
                assert (entrySettings != null);
                mconfigMap.get(configName).getEntrySettings().put((Object)mentry, (Object)entrySettings);
                assert (mconfigMap.get(configName).getEntrySettings().get((Object)mentry) != null);
            }
        }

        protected void toMEntry(MEntry thisEntry) {
            if (this.targetConfiguration == null) {
                return;
            }
            for (ExternalProjectOption option : this.targetConfiguration.getOptions()) {
                option.importOption((MSettingsSite)thisEntry);
            }
            ProjectImportUtils.addBuildSettingsToSettingsSite((MSettingsSite)thisEntry, this.targetConfiguration.getBuildSettings());
        }
    }

    private class ExternalProjectFile
    extends ExternalProjectEntry {
        File file;

        public ExternalProjectFile(IExternalProjectEntry extFile) {
            super(extFile);
            this.file = new File(extFile.getAbsPath());
        }

        public MFileEntry toMFile(MFolderEntry parentFolder, File externalProjectFolder, Map<String, MConfiguration> mconfigMap, IPath slsModelPath, ImportMode importMode) {
            MFileContent mfile = ProjectModelFactory.eINSTANCE.createMFileContent();
            mfile.setName(this.name);
            mfile.setUri(this.file.toURI().toString());
            mfile.setLinked(Boolean.valueOf(importMode != ImportMode.COPY));
            this.toMEntry((MEntry)mfile);
            IPath slsFilePath = slsModelPath.append(this.name);
            this.updateExcludedConfigurations(slsFilePath, mconfigMap);
            this.mapEntryConfigurations((MEntry)mfile, mconfigMap, externalProjectFolder);
            return mfile;
        }
    }

    private class ExternalProjectFolder
    extends ExternalProjectContentContainer {
        public ExternalProjectFolder(IExternalProjectContentContainer extFolder) {
            super(extFolder);
        }

        public MFolderEntry toMFolder(MFolderEntry parentFolder, File externalProjectFolder, Map<String, MConfiguration> mconfigMap, IPath slsModelPath, ImportMode importMode) {
            IPath slsFolderPath = slsModelPath.append(this.name);
            MFolderEntry mfolder = ProjectModelUtils.findOrCreateFolder(null, parentFolder, (IPath)new Path(this.name));
            if (mfolder instanceof MProject) {
                return null;
            }
            this.toMEntry((MEntry)mfolder);
            this.updateExcludedConfigurations(slsFolderPath, mconfigMap);
            this.addSubfolders(mfolder, externalProjectFolder, mconfigMap, slsFolderPath, importMode);
            this.mapEntryConfigurations((MEntry)mfolder, mconfigMap, externalProjectFolder);
            return mfolder;
        }
    }

    private static class ExternalProjectOption {
        List<IProperty> properties = new ArrayList<IProperty>();
        Object value;

        public ExternalProjectOption(IExternalProjectOption extOption) {
            for (IProperty property : extOption.getIProperties()) {
                if (property == null) continue;
                this.properties.add(property);
            }
            this.value = extOption.getValue();
        }

        public void importOption(MSettingsSite site) {
            assert (site != null);
            for (IProperty property : this.properties) {
                if (property == null) continue;
                List<URI> importValue = this.value;
                if (property.getType().getName().equals("uriList")) {
                    assert (this.value != null);
                    assert (this.value instanceof List);
                    List valueList = (List)this.value;
                    importValue = ProjectImportUtils.convertObjectListToURIList(valueList);
                }
                if (this.value == null) continue;
                ConvertedOptionsUtils.findOrCreateSpecificOption((MSettingsSite)site, (IProperty)property, (Object)importValue);
            }
        }
    }

    protected static interface IImportModelDirectoryFilter {
        public boolean acceptPath(TYPE var1, IPath var2);

        public static enum TYPE {
            FILE,
            FOLDER;

        }
    }
}

