/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.engine.operations;

import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineSession;
import com.silabs.ss.framework.project.api.core.engine.operations.BaseLanguageAwareProjectSettingOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IProjectLanguageSettingOperation;
import com.silabs.ss.framework.project.api.core.model.MBuildSetting;
import com.silabs.ss.framework.project.api.core.model.MIncludePath;
import com.silabs.ss.framework.project.internal.core.Activator;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class AddIncludePathSettingOperation
extends BaseLanguageAwareProjectSettingOperation
implements IProjectLanguageSettingOperation {
    private URI uri;
    private boolean isUser;

    public AddIncludePathSettingOperation(IProjectEngineSession session, String buildConfig, MIncludePath path, IPath projectPath) {
        super(session, buildConfig, projectPath, (MBuildSetting)path);
        this.buildConfig = buildConfig;
        try {
            this.uri = session.getProjectModel().resolveURI(path.getUri(), true);
            this.uri = session.getProjectModel().encodeProjectURI(this.uri);
        }
        catch (IllegalArgumentException e) {
            Activator.reporter.logError("invalid include path: " + path.getUri(), (Throwable)e);
            this.uri = URI.create("");
        }
        this.isUser = path.isUser();
    }

    @Override
    public final void executeProcess(IProjectEngineOperationHandler handler, IProgressMonitor monitor) throws CoreException {
        handler.handleAddIncludePathSettingOperation(this, monitor);
    }

    @Override
    public String toString() {
        return super.toString() + ": " + (this.isUser ? "\"" : "<") + String.valueOf(this.uri) + (this.isUser ? (char)'\"' : '>');
    }

    public boolean isUser() {
        return this.isUser;
    }

    public URI getUri() {
        return this.uri;
    }
}

