/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.engine;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.ImportMode;
import com.silabs.ss.framework.project.api.core.ProjectProperties;
import com.silabs.ss.framework.project.api.core.engine.CopyIntoProjectOperationFactory;
import com.silabs.ss.framework.project.api.core.engine.CreateInPlaceOperationFactory;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationFactory;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineOperationHandler;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineSession;
import com.silabs.ss.framework.project.api.core.engine.LinkIntoProjectOperationFactory;
import com.silabs.ss.framework.project.api.core.engine.LinkLibrariesIntoProjectOperationFactory;
import com.silabs.ss.framework.project.api.core.engine.ProjectModelUtils;
import com.silabs.ss.framework.project.api.core.engine.operations.CreateProjectFolderOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.entity.IProjectEntity;
import com.silabs.ss.framework.project.api.core.model.MContent;
import com.silabs.ss.framework.project.api.core.model.MFolderContent;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.platform.api.rcp.core.URIUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProjectEngineOperationUtils {
    private ProjectEngineOperationUtils() {
    }

    public static URI resolveURI(IProjectEngineSession session, File contentFile, MContent content) {
        if (content instanceof MFolderContent && ((MFolderContent)content).isVirtual()) {
            return URI.create(content.getUri());
        }
        if (contentFile.exists()) {
            return contentFile.toURI();
        }
        if (content != null && content.getUri() != null) {
            URI uri = session.getProjectModel().resolveURI(content.getUri(), content instanceof MFolderContent);
            String uriStr = ProjectModelUtils.getProjectModelURI(session.getProjectModel(), session.getProjectDescriptor(), content, uri.toString(), false);
            uri = URIUtils.createAbsoluteURI((String)uriStr);
            return uri;
        }
        return null;
    }

    public static IProjectEngineOperationFactory getOperationFactory(IProjectEntity entity) {
        String importModeId = (String)entity.getProperty(ProjectProperties.IMPORT_MODE_ID);
        ImportMode importMode = null;
        if (!TextUtils.isEmpty((String)importModeId)) {
            try {
                importMode = ImportMode.valueOf(importModeId);
            }
            catch (Exception exception) {}
        }
        return ProjectEngineOperationUtils.getOperationFactory(importMode);
    }

    public static IProjectEngineOperationFactory getOperationFactory(ImportMode importMode) {
        if (importMode == null) {
            return ProjectEngineOperationUtils.getDefaultOperationFactory();
        }
        switch (importMode) {
            case COPY: {
                return new CopyIntoProjectOperationFactory();
            }
            case LINK: {
                return new LinkIntoProjectOperationFactory();
            }
            case IN_PLACE: {
                return new CreateInPlaceOperationFactory();
            }
            case LINK_LIBRARIES: 
            case LINK_PROJECT: {
                return new LinkLibrariesIntoProjectOperationFactory();
            }
        }
        return ProjectEngineOperationUtils.getDefaultOperationFactory();
    }

    public static IProjectEngineOperationFactory getDefaultOperationFactory() {
        return new CreateInPlaceOperationFactory();
    }

    public static void createParents(IProjectEngineOperationHandler handler, IProjectEngineOperation operation, IPath prjPath, IProgressMonitor monitor) throws CoreException {
        File basePath;
        monitor.beginTask("", prjPath.segmentCount());
        try {
            basePath = URIUtils.toFileWithRelative((URI)operation.getSession().getProjectRoot());
        }
        catch (IOException e) {
            Activator.reporter.logException((Throwable)e);
            return;
        }
        int i = 0;
        while (i < prjPath.segmentCount() - 1) {
            IPath parentPath = prjPath.removeLastSegments(prjPath.segmentCount() - i - 1);
            File filePath = new File(basePath, parentPath.toString());
            handler.handleCreateProjectFolderOperation(new CreateProjectFolderOperation(operation.getSession(), parentPath, filePath, null, null), monitor);
            ++i;
        }
        monitor.done();
    }
}

