/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.engine;

import com.silabs.java.utils.FileUtils;
import com.silabs.ss.framework.project.api.core.engine.IProjectModel;
import com.silabs.ss.framework.project.api.core.model.MContent;
import com.silabs.ss.framework.project.api.core.model.MFileContent;
import com.silabs.ss.framework.project.api.core.model.MIncludePath;
import com.silabs.ss.framework.project.api.core.model.MLibraryFile;
import com.silabs.ss.framework.project.api.core.model.MLibraryPath;
import com.silabs.ss.framework.project.api.core.model.MProject;
import com.silabs.ss.framework.project.api.core.model.util.ProjectModelSwitch;
import com.silabs.ss.framework.project.api.core.model.util.manual.ProjectModelLoading;
import com.silabs.ss.framework.project.internal.core.Activator;
import com.silabs.ss.platform.api.descriptor.core.type.EcoreTypeUtils;
import com.silabs.ss.platform.api.rcp.core.URIUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;

public class ExportSLSProjectModelEngine {
    private static final String SLSPROJ = ".slsproj";

    public String convertProjectToString(IProjectModel project) throws CoreException {
        MProject generic = this.makeGenericModel(project);
        return ProjectModelLoading.storeMProjectModel((MProject)generic);
    }

    public String convertProjectToString(MProject project) throws CoreException {
        return ProjectModelLoading.storeMProjectModel((MProject)project);
    }

    public File getExportedFile(File projDir, String fileName) {
        File projFile = projDir;
        if (!projFile.isFile()) {
            if (!((String)fileName).endsWith(SLSPROJ)) {
                fileName = (String)fileName + SLSPROJ;
            }
            projFile = new File(projDir, (String)fileName);
        }
        return projFile;
    }

    public void exportProject(File projDir, String fileName, IProjectModel project) throws CoreException {
        File projFile = this.getExportedFile(projDir, fileName);
        this.exportProject(projFile, project);
    }

    public void exportProject(File projFile, IProjectModel project) throws CoreException {
        String projStr = this.convertProjectToString(project);
        try {
            FileUtils.writeFileContents((File)projFile, (char[])projStr.toCharArray(), null);
        }
        catch (IOException e) {
            throw Activator.reporter.newCoreException("failed to write project model to " + String.valueOf(projFile), (Throwable)e);
        }
    }

    private MProject makeGenericModel(IProjectModel model) {
        MProject orig = model.getModel();
        MProject proj = (MProject)EcoreTypeUtils.copy((EObject)orig);
        final URI root = model.getContentRootURI();
        proj.setContentRoot(proj.getContentRoot());
        new ProjectModelSwitch<Object>(){

            public Object defaultCase(EObject object) {
                for (EObject obj : object.eContents()) {
                    this.doSwitch(obj);
                }
                return this;
            }

            public Object caseMContent(MContent content) {
                if (content.getUri() != null && !content.getUri().startsWith("$")) {
                    content.setUri(ExportSLSProjectModelEngine.this.relativizeURI(root, content).toString());
                    if (content instanceof MFileContent && content.getUri().equals(content.getName())) {
                        content.setUri(null);
                    }
                }
                return null;
            }

            public Object caseMIncludePath(MIncludePath incl) {
                if (incl.getUri().startsWith("$")) {
                    return this;
                }
                URI path = URIUtils.createAbsoluteURI((String)incl.getUri());
                String rel = ExportSLSProjectModelEngine.this.genericizeURI(root, path);
                incl.setUri(rel);
                return this;
            }

            public Object caseMLibraryPath(MLibraryPath lib) {
                if (lib.getUri().startsWith("$")) {
                    return this;
                }
                URI path = URIUtils.createAbsoluteURI((String)lib.getUri());
                String rel = ExportSLSProjectModelEngine.this.genericizeURI(root, path);
                lib.setUri(rel);
                return this;
            }

            public Object caseMLibraryFile(MLibraryFile lib) {
                if (lib.getUri() != null && !lib.getUri().startsWith("$")) {
                    URI path = URIUtils.createAbsoluteURI((String)lib.getUri());
                    String rel = ExportSLSProjectModelEngine.this.genericizeURI(root, path);
                    lib.setUri(rel);
                }
                return this;
            }
        }.doSwitch((EObject)proj);
        return proj;
    }

    private String genericizeURI(URI root, URI uri) {
        if (uri == null) {
            return "";
        }
        if (root == null) {
            return uri.toString();
        }
        URI rel = root.relativize(uri);
        return rel.toString();
    }

    private URI relativizeURI(URI root, MContent entry) {
        Object rel = "";
        MContent parent = this.getContentOwning((EObject)entry);
        while (parent != null) {
            rel = parent.getName() + "/" + (String)rel;
            parent = this.getContentOwning((EObject)parent);
        }
        try {
            URI ret = root.resolve(new URI(null, (String)rel, null));
            return ret.relativize(URIUtils.createAbsoluteURI((String)entry.getUri()));
        }
        catch (URISyntaxException uRISyntaxException) {
            return URI.create((String)rel);
        }
    }

    private MContent getContentOwning(EObject obj) {
        while (obj != null) {
            if (!((obj = obj.eContainer()) instanceof MContent)) continue;
            return (MContent)obj;
        }
        return null;
    }
}

