/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.engine;

import com.silabs.ss.framework.project.api.core.engine.BaseProjectEngineOperationFactory;
import com.silabs.ss.framework.project.api.core.engine.IProjectEngineSession;
import com.silabs.ss.framework.project.api.core.engine.operations.CopyProjectFileOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.CreateProjectFolderOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.IAddToProjectEngineOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.LinkProjectFileOperation;
import com.silabs.ss.framework.project.api.core.engine.operations.LinkProjectFolderOperation;
import com.silabs.ss.framework.project.api.core.model.MContent;
import com.silabs.ss.framework.project.api.core.model.MFileEntry;
import com.silabs.ss.framework.project.api.core.model.MFolderEntry;
import com.silabs.ss.framework.project.api.core.model.MSelectable;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;

public class CopyIntoProjectOperationFactory
extends BaseProjectEngineOperationFactory {
    @Override
    public boolean shouldEnter(IProjectEngineSession session, MFolderEntry entry, IAddToProjectEngineOperation folderOperation) {
        return true;
    }

    @Override
    public IAddToProjectEngineOperation createAddProjectFolderOperation(IProjectEngineSession session, File containerFile, IPath projectPath, File contentFolder, MFolderEntry entry, MSelectable selector) {
        if ((entry == null || entry instanceof MContent) && selector instanceof MContent && ((MContent)selector).isLinked()) {
            return new LinkProjectFolderOperation(session, containerFile, projectPath, contentFolder, (MContent)entry, selector);
        }
        return new CreateProjectFolderOperation(session, projectPath, contentFolder, entry, selector);
    }

    @Override
    public IAddToProjectEngineOperation createAddProjectFileOperation(IProjectEngineSession session, File containerFile, IPath projectPath, File contentFile, MFileEntry entry, MSelectable selector) throws IOException {
        IAddToProjectEngineOperation parentOp = super.createAddProjectFileOperation(session, containerFile, projectPath, contentFile, entry, selector);
        if (parentOp != null) {
            return parentOp;
        }
        if (entry == null || entry instanceof MContent) {
            if (selector instanceof MContent && ((MContent)selector).isLinked()) {
                return new LinkProjectFileOperation(session, containerFile, projectPath, contentFile, (MContent)entry, selector);
            }
            return new CopyProjectFileOperation(session, projectPath, contentFile, entry, selector);
        }
        return null;
    }
}

