/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core.engine;

import com.silabs.java.utils.variables.IVariableLookup;
import com.silabs.java.utils.variables.engine.CoreOperatorHandler;
import com.silabs.java.utils.variables.engine.IOperatorHandler;
import com.silabs.java.utils.variables.engine.VariableSubstitutionEngine;
import com.silabs.ss.platform.api.apack.core.model.AdapterPackManager;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;

public class BaseEngineOperationHandler
implements IVariableLookup {
    private static final String DEFAULT_BUILD_DIR = ".";
    private static final String APACK_NAME = "Simplicity Commander";
    private static final String APACK_EXE_NAME = "commander";
    protected static final String APACK_COMMANDER_VARIABLE = "commander";
    protected static final String PROJECT_PATH_VARIABLE = "project";
    protected static final String SOLUTION_PATH_VARIABLE = "solution";
    protected static final String BUILD_DIR_VARIABLE = "builddir";
    private final VariableSubstitutionEngine substEngine = new VariableSubstitutionEngine('(');

    protected BaseEngineOperationHandler() {
        this.substEngine.allowRecursion(false);
        this.substEngine.setOperatorHandler((IOperatorHandler)CoreOperatorHandler.INSTANCE);
    }

    protected String substitutePostBuildVariables(String postBuildStr) {
        return this.substEngine.substitute(postBuildStr, (IVariableLookup)this);
    }

    public String lookupCommanderVariable() {
        return "\"" + this.postBuildExeLocation() + "\"";
    }

    public String postBuildExeLocation() {
        Collection paths = AdapterPackManager.instance().findExecutableAdapterPacks(APACK_NAME, "commander");
        File path = paths != null && !paths.isEmpty() ? (File)paths.iterator().next() : null;
        return path != null ? path.getAbsolutePath() : "";
    }

    protected String lookupBuildDirVariable() {
        return DEFAULT_BUILD_DIR;
    }

    public Object getValue(String var) {
        if (var.equals("commander")) {
            return this.lookupCommanderVariable();
        }
        if (var.equals(BUILD_DIR_VARIABLE)) {
            return this.lookupBuildDirVariable();
        }
        return null;
    }

    public Collection<String> getVariableNames() {
        return Arrays.asList("commander", PROJECT_PATH_VARIABLE);
    }
}

