/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core;

import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.preferences.PropertyReference;
import com.silabs.ss.framework.project.api.core.INewProjectDescriptor;
import com.silabs.ss.framework.project.api.core.IProjectDescriptor;
import com.silabs.ss.framework.project.api.core.ProjectCommonProperties;
import com.silabs.ss.framework.project.api.core.external.IImportProjectDescriptor;
import com.silabs.ss.framework.project.api.templates.ITemplate;
import com.silabs.ss.platform.api.content.board.core.IBoardDescriptor;
import com.silabs.ss.platform.api.content.part.core.IPartDescriptor;
import com.silabs.ss.platform.api.descriptor.core.IDescribable;
import com.silabs.ss.platform.api.descriptor.core.IDescriptor;
import com.silabs.ss.platform.api.descriptor.core.property.CoreProperties;
import com.silabs.ss.platform.api.descriptor.core.type.CoreTypes;
import com.silabs.ss.platform.api.idemanager.core.IDEPreferenceManager;
import com.silabs.ss.platform.api.idemanager.core.IIDE;
import com.silabs.ss.platform.api.rcp.core.analytics.AnalyticsLogger;
import com.silabs.ss.platform.api.sdk.core.ISDKDescriptor;
import com.silabs.ss.platform.api.sdk.core.protocol.ProtocolProperties;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.json.JSONStringer;
import org.json.JSONWriter;

public final class ProjectAnalytics {
    private static final String EVENT_NEW_PROJECT = "project_new";

    private ProjectAnalytics() {
    }

    public static void logNewProject(IProjectDescriptor projDesc) {
        if (projDesc instanceof IImportProjectDescriptor) {
            return;
        }
        AnalyticsLogger.log((String)EVENT_NEW_PROJECT, () -> ProjectAnalytics.getJSON(projDesc), (Boolean)true);
    }

    public static void logNewProject(IBoardDescriptor[] boards, IPartDescriptor[] parts, ISDKDescriptor sdk, String name) {
        AnalyticsLogger.log((String)EVENT_NEW_PROJECT, () -> ProjectAnalytics.getJSON(boards, parts, sdk, name), (Boolean)true);
    }

    private static String getJSON(IBoardDescriptor[] boards, IPartDescriptor[] parts, ISDKDescriptor sdk, String name) {
        return new JSONStringer().object().key("partId").value((Object)ProjectAnalytics.convertToString((IDescriptor[])parts)).key("boardIds").value((Object)ProjectAnalytics.convertToString((IDescriptor[])boards)).key("sdkId").value((Object)ProjectAnalytics.convertToString(new IDescriptor[]{sdk})).key("currentIDE").value((Object)IDEPreferenceManager.getPreferredIDE().getName()).key("exampleName").value((Object)name).key("projectType").value((Object)"newExample").endObject().toString();
    }

    private static String getJSON(IProjectDescriptor projDesc) {
        String type;
        IIDE ide;
        String id;
        ITemplate projTemplate;
        JSONWriter writer = new JSONStringer().object();
        ProjectAnalytics.addProperty(writer, projDesc, ProjectCommonProperties.PART_ID);
        ProjectAnalytics.addProperty(writer, projDesc, ProjectCommonProperties.BOARD_IDS);
        ProjectAnalytics.addProperty(writer, projDesc, ProjectCommonProperties.SDK_ID);
        ProjectAnalytics.addProperty(writer, projDesc, ProjectCommonProperties.TOOLCHAIN_ID);
        if (projDesc instanceof INewProjectDescriptor && (projTemplate = ((INewProjectDescriptor)projDesc).getTemplate()) != null) {
            ProjectAnalytics.writeProperty(writer, (IDescriptor)projTemplate, "protocolId", ProtocolProperties.CONTRIBUTING_PROTOCOL);
            ProjectAnalytics.writeProperty(writer, (IDescriptor)projTemplate, "provider_uri", CoreProperties.PROVIDER_URI);
            ProjectAnalytics.writeProperty(writer, (IDescriptor)projTemplate, "provider_label", CoreProperties.PROVIDER_LABEL);
        }
        if (TextUtils.hasContent((String)(id = (String)projDesc.getProperty(ProjectCommonProperties.IDE_ID))) && (ide = IDEPreferenceManager.getIDEByID((String)id)) != null) {
            writer.key("currentIDE").value((Object)ide.getName());
        }
        if (projDesc instanceof IImportProjectDescriptor) {
            File inputLocation = ((IImportProjectDescriptor)projDesc).getInputLocation();
            writer.key("fileName").value((Object)(inputLocation == null ? "unknown location" : inputLocation.getName()));
            type = "import";
        } else if (projDesc instanceof INewProjectDescriptor) {
            ITemplate template = ((INewProjectDescriptor)projDesc).getTemplate();
            writer.key("exampleName").value((Object)(template == null ? "no template" : template.getLabel()));
            type = "newExample";
        } else {
            type = "default";
        }
        writer.key("projectType").value((Object)type);
        return writer.endObject().toString();
    }

    private static JSONWriter writeProperty(JSONWriter writer, IDescriptor desc, String key, PropertyReference<?> prop) {
        String propertyValue = desc.getPropertyAccess().getValueString(prop);
        if (TextUtils.hasContent((String)propertyValue)) {
            writer.key(key).value((Object)propertyValue);
        }
        return writer;
    }

    private static JSONWriter addProperty(JSONWriter writer, IProjectDescriptor projDesc, PropertyReference<?> prop) {
        Collection descIds = ((Stream)Stream.of(projDesc, projDesc.getBuildConfigurationDescriptors()).parallel()).flatMap(d -> d instanceof Object[] ? Stream.of((Object[])d) : Stream.of(d)).map(d -> (IDescriptor)d).map(d -> d.getProperty(prop)).flatMap(d -> d instanceof List ? ((List)d).stream() : Stream.of(d)).distinct().collect(Collectors.toList());
        return writer.key(prop.id()).value((Object)CoreTypes.STRING_LIST.stringizeObject((Object)descIds));
    }

    private static String convertToString(IDescriptor ... descs) {
        return Stream.of(descs).map(IDescribable::getId).collect(Collectors.joining(" "));
    }
}

