/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.api.core;

import com.silabs.java.utils.TextUtils;
import com.silabs.ss.framework.project.api.core.ImportMode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class ImportModeUtils {
    private ImportModeUtils() {
    }

    public static String getDefaultTemplateImportMode() {
        return ImportModeUtils.importModeCompatAllBut(ImportMode.IN_PLACE, ImportMode.LINK_PROJECT);
    }

    public static String importModeCompatAllBut(ImportMode ... invalidModes) {
        if (invalidModes.length == 0) {
            return ".*";
        }
        StringBuilder compat = new StringBuilder();
        ImportMode[] importModeArray = invalidModes;
        int n = invalidModes.length;
        int n2 = 0;
        while (n2 < n) {
            ImportMode mode = importModeArray[n2];
            compat.append("-").append(mode.getId()).append(" ");
            ++n2;
        }
        return compat.toString().trim();
    }

    public static String importModeCompatOnlyThese(ImportMode ... validModes) {
        if (validModes.length == 0) {
            return "-.*";
        }
        StringBuilder compat = new StringBuilder();
        ImportMode[] importModeArray = validModes;
        int n = validModes.length;
        int n2 = 0;
        while (n2 < n) {
            ImportMode mode = importModeArray[n2];
            compat.append(mode.getId()).append(" ");
            ++n2;
        }
        return compat.toString().trim();
    }

    public static Set<ImportMode> getValidImportModes(String compatibility) {
        String[] compats;
        if (TextUtils.isEmpty((String)compatibility)) {
            return new LinkedHashSet<ImportMode>(Arrays.asList(ImportMode.values()));
        }
        if (compatibility.contains("-.*")) {
            return new LinkedHashSet<ImportMode>();
        }
        if (compatibility.contains(".*")) {
            return new LinkedHashSet<ImportMode>(Arrays.asList(ImportMode.values()));
        }
        HashSet<ImportMode> validModes = new HashSet<ImportMode>();
        if (compatibility.contains("-")) {
            validModes.addAll(Arrays.asList(ImportMode.values()));
        }
        validModes.remove((Object)ImportMode.LINK_PROJECT);
        String[] stringArray = compats = compatibility.split(" ");
        int n = compats.length;
        int n2 = 0;
        while (n2 < n) {
            String compat = stringArray[n2];
            if (compat.startsWith("-")) {
                validModes.remove((Object)ImportMode.valueOf(compat.substring(1)));
            } else {
                validModes.add(ImportMode.valueOf(compat));
            }
            ++n2;
        }
        return validModes.stream().sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

