/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.testing.assertj.AssertUtil;
import io.opentelemetry.sdk.testing.assertj.AttributeAssertion;
import io.opentelemetry.sdk.testing.assertj.OpenTelemetryAssertions;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;

public final class DoubleExemplarAssert
extends AbstractAssert<DoubleExemplarAssert, DoubleExemplarData> {
    DoubleExemplarAssert(@Nullable DoubleExemplarData actual) {
        super((Object)actual, DoubleExemplarAssert.class);
    }

    public DoubleExemplarAssert hasEpochNanos(long expected) {
        this.isNotNull();
        ((AbstractLongAssert)Assertions.assertThat((long)((DoubleExemplarData)this.actual).getEpochNanos()).as("epochNanos", new Object[0])).isEqualTo(expected);
        return this;
    }

    public DoubleExemplarAssert hasSpanId(String expected) {
        this.isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)((DoubleExemplarData)this.actual).getSpanContext().getSpanId()).as("spanId", new Object[0])).isEqualTo(expected);
        return this;
    }

    public DoubleExemplarAssert hasTraceId(String expected) {
        this.isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)((DoubleExemplarData)this.actual).getSpanContext().getTraceId()).as("traceId", new Object[0])).isEqualTo(expected);
        return this;
    }

    public DoubleExemplarAssert hasValue(double expected) {
        this.isNotNull();
        ((AbstractDoubleAssert)Assertions.assertThat((double)((DoubleExemplarData)this.actual).getValue()).as("value", new Object[0])).isEqualTo(expected);
        return this;
    }

    public <T> DoubleExemplarAssert hasFilteredAttribute(AttributeKey<T> key, T value) {
        return this.hasFilteredAttribute(OpenTelemetryAssertions.equalTo(key, value));
    }

    public DoubleExemplarAssert hasFilteredAttribute(AttributeAssertion attributeAssertion) {
        this.isNotNull();
        Set actualKeys = ((DoubleExemplarData)this.actual).getFilteredAttributes().asMap().keySet();
        AttributeKey<?> key = attributeAssertion.getKey();
        ((AbstractCollectionAssert)Assertions.assertThat(actualKeys).as("attribute keys", new Object[0])).contains((Object[])new AttributeKey[]{key});
        Object value = ((DoubleExemplarData)this.actual).getFilteredAttributes().get(key);
        AbstractAssert<?, ?> assertion = AttributeAssertion.attributeValueAssertion(key, value);
        attributeAssertion.getAssertion().accept(assertion);
        return this;
    }

    public DoubleExemplarAssert hasFilteredAttributes(Attributes expected) {
        this.isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)((DoubleExemplarData)this.actual).getFilteredAttributes()).as("filtered_attributes", new Object[0])).isEqualTo((Object)expected);
        return this;
    }

    @SafeVarargs
    public final DoubleExemplarAssert hasFilteredAttributes(Map.Entry<? extends AttributeKey<?>, ?> ... entries) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        for (Map.Entry<AttributeKey<?>, ?> entry : entries) {
            attributesBuilder.put(entry.getKey(), entry.getValue());
        }
        Attributes attributes = attributesBuilder.build();
        return this.hasFilteredAttributes(attributes);
    }

    public DoubleExemplarAssert hasFilteredAttributesSatisfying(AttributeAssertion ... assertions) {
        return this.hasFilteredAttributesSatisfying(Arrays.asList(assertions));
    }

    public DoubleExemplarAssert hasFilteredAttributesSatisfying(Iterable<AttributeAssertion> assertions) {
        AssertUtil.assertAttributes(((DoubleExemplarData)this.actual).getFilteredAttributes(), assertions);
        return (DoubleExemplarAssert)this.myself;
    }

    public DoubleExemplarAssert hasFilteredAttributesSatisfyingExactly(AttributeAssertion ... assertions) {
        return this.hasFilteredAttributesSatisfyingExactly(Arrays.asList(assertions));
    }

    public DoubleExemplarAssert hasFilteredAttributesSatisfyingExactly(Iterable<AttributeAssertion> assertions) {
        AssertUtil.assertAttributesExactly(((DoubleExemplarData)this.actual).getFilteredAttributes(), assertions);
        return (DoubleExemplarAssert)this.myself;
    }
}

