/*
 * Decompiled with CFR 0.152.
 */
package slc.launcher.context;

import com.silabs.java.utils.FileUtils;
import java.nio.file.Path;
import slc.launcher.context.SlcCliArgs;
import slc.launcher.context.SlcTimer;
import slc.launcher.utils.ISlcLogger;

public class SlcCliContext {
    private final Path workingDirectory;
    private final Path installationDirectory;
    private final ISlcLogger logger;
    private SlcCliArgs args;

    public SlcCliContext(Path workingDirectory, Path installationDirectory, ISlcLogger logger) {
        this.workingDirectory = workingDirectory;
        this.installationDirectory = installationDirectory;
        this.logger = logger;
    }

    public SlcCliContext newContextWithDifferentArgs(SlcCliArgs args2) {
        ISlcLogger modifiedLogger = this.logger.copy();
        SlcCliContext newContext = new SlcCliContext(this.workingDirectory, this.installationDirectory, modifiedLogger);
        newContext.setupArgs(args2);
        return newContext;
    }

    public Path resolveInstallationPath(String path) {
        return FileUtils.resolve(this.installationDirectory, path);
    }

    public Path resolvePath(String path) {
        return FileUtils.resolve(this.workingDirectory, path);
    }

    public Path workingDirectory() {
        return this.workingDirectory;
    }

    public void debugPrint(String output) {
        this.debugPrint(output, null);
    }

    public void debugPrint(String output, Throwable t) {
        this.log(ISlcLogger.SlcLogging.DEBUG, output + System.lineSeparator(), t);
    }

    public void print(String output) {
        this.print(output, null);
    }

    public void print(String output, Throwable t) {
        this.log(ISlcLogger.SlcLogging.OUTPUT, output, t);
    }

    public int runningFileTimeout() {
        return -1;
    }

    public void printErr(String error) {
        this.printErr(error, null);
    }

    public void printErr(String error, Throwable t) {
        this.log(ISlcLogger.SlcLogging.ERROR, error, t);
    }

    public void printExact(String output) {
        this.logger.log(ISlcLogger.SlcLogging.OUTPUT, output, null);
    }

    private void log(ISlcLogger.SlcLogging lvl, String message, Throwable t) {
        this.logger.log(lvl, message + System.lineSeparator(), t);
    }

    public SlcTimer timer(String message) {
        return SlcTimer.create(this, message);
    }

    public SlcCliArgs args() {
        return this.args;
    }

    public SlcCliContext setupArgs(SlcCliArgs args2) {
        this.logger.updateDebug(args2.debug);
        this.args = args2;
        return this;
    }

    public ISlcLogger logger() {
        return this.logger;
    }
}

