/*
 * Decompiled with CFR 0.152.
 */
package slc.launcher.connection;

import com.silabs.uc.cli.internal.daemon.shared.SlcDaemonSharedData;
import java.net.URI;
import java.net.http.HttpClient;

public final class ConnectionUtils {
    private static final String WS_LOCALHOST = "ws://localhost:";
    private static final String HTTPS_LOCALHOST = "http://localhost:";
    private static final String CLI_WS_URI = "/ws/uccli/feedback";
    private static final String CLI_CMDLINE_URI = "/rest/uccli/action/commandline";
    private static final HttpClient client = ConnectionUtils.loadHttpClient();

    private ConnectionUtils() {
    }

    public static HttpClient httpclient() {
        return client;
    }

    private static HttpClient loadHttpClient() {
        return HttpClient.newHttpClient();
    }

    public static URI wsFeedback(SlcDaemonSharedData sharedFile) {
        return ConnectionUtils.doCreateUrl(sharedFile, WS_LOCALHOST, CLI_WS_URI);
    }

    public static URI restCmd(SlcDaemonSharedData sharedFile) {
        return ConnectionUtils.doCreateUrl(sharedFile, HTTPS_LOCALHOST, CLI_CMDLINE_URI);
    }

    private static URI doCreateUrl(SlcDaemonSharedData sharedFile, String host, String target) {
        return URI.create(host + sharedFile.portNumber() + target);
    }
}

