/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.uc.cli.internal.daemon.shared;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.StreamUtils;
import com.silabs.java.utils.log.Log;
import com.silabs.java.utils.runtime.RuntimeUtils;
import com.silabs.java.utils.thread.SilabsThreadFactory;
import com.silabs.uc.cli.internal.daemon.shared.DaemonSearchResult;
import com.silabs.uc.cli.internal.daemon.shared.DaemonVersionInfo;
import com.silabs.uc.cli.internal.daemon.shared.DataDirectoryStatus;
import com.silabs.uc.cli.internal.daemon.shared.IInfoTracer;
import com.silabs.uc.cli.internal.daemon.shared.ISlcDaemon;
import com.silabs.uc.cli.internal.daemon.shared.LockFileAcquisitionException;
import com.silabs.uc.cli.internal.daemon.shared.RunningFileRead;
import com.silabs.uc.cli.internal.daemon.shared.RunningFileWaitTimeExceededException;
import com.silabs.uc.cli.internal.daemon.shared.SlcDaemonSharedData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;

public final class DaemonUtils {
    public static final String RUNNING_FILE_NAME = ".running";
    public static final String VERSION_FILE_NAME = ".version";
    public static final String LOCK_FILE_NAME = ".lock";
    public static final String PROP_PORT_NUMBER = "port_number";
    public static final String PROP_PROCESS_ID = "process_id";
    private static final long ALLOWED_LOCK_AGE_MS = 100L;
    private static final ExecutorService lockWatcherPool = Executors.newFixedThreadPool(1, SilabsThreadFactory.withName("daemon-lock-watcher").setDaemon(true).create());
    private static final ExecutorService runningWatcherPool = Executors.newFixedThreadPool(1, SilabsThreadFactory.withName("daemon-running-file-watcher").setDaemon(true).create());
    private static final int TOTAL_LOCK_ACQ_ATTEMPTS = 100;
    private static final int TOTAL_WAIT_FOR_AWAITING_FILE_FILLED_IN_S = 30;
    private static IDaemonProcessFunctions daemonProcessFunctions = DaemonProcessFunctions.INSTANCE;

    private static Stream<Path> dataDirIterate(Path parent, ISlcDaemon creator) throws IOException {
        return Files.list(parent).filter(p -> p.getFileName().toString().startsWith(creator.daemonName()) && Files.isDirectory(p, new LinkOption[0])).sorted((p1, p2) -> p1.getFileName().toString().compareTo(p2.getFileName().toString()));
    }

    public static DaemonSearchResult searchForMatchingOrAwaiting(ISlcDaemon creator, DaemonVersionInfo ourVersion, IInfoTracer logger) throws IOException {
        logger.daemonLog(() -> "Searching for matching/awaiting files for " + creator.daemonName() + (ourVersion != null ? " using version matching" : " ignoring versions"));
        Path parent = creator.location();
        if (!Files.isDirectory(parent, new LinkOption[0])) {
            logger.daemonLog(() -> "Creator location " + creator.location() + " not even a directory.");
            return DaemonSearchResult.Nothing.INSTANCE;
        }
        ArrayList<DataDirectoryStatus> awaitingData = new ArrayList<DataDirectoryStatus>();
        DataDirectoryStatus existingDaemon = null;
        try (Stream<Path> dirs = DaemonUtils.dataDirIterate(parent, creator);){
            for (Path dataDirectory : StreamUtils.iterableOf(dirs)) {
                Optional<DataDirectoryStatus> status = DaemonUtils.checkDataDirectory(dataDirectory, ourVersion, true, logger);
                if (!status.isPresent()) continue;
                DataDirectoryStatus stat = status.get();
                if (stat.runningFileStatus().isAwaiting()) {
                    logger.daemonLog(() -> "Found awaiting file: " + stat.runningFile());
                    awaitingData.add(stat);
                } else {
                    if (!stat.sharedData().isPresent()) continue;
                    SlcDaemonSharedData shared = stat.sharedData().get();
                    logger.daemonLog(() -> "Found a complete .running file: " + stat.runningFile() + "[ pid: " + shared.processId() + " ]");
                    existingDaemon = stat;
                }
                break;
            }
        }
        if (existingDaemon != null) {
            assert (existingDaemon.sharedData().isPresent()) : "Detected an existing daemon but did not properly check shared data availability.";
            return new DaemonSearchResult.AcceptableDaemon(existingDaemon.sharedData().get());
        }
        if (!awaitingData.isEmpty()) {
            return new DaemonSearchResult.AwaitingFiles(Collections.unmodifiableList(awaitingData));
        }
        logger.daemonLog(() -> "No running daemons, no awaiting files. Nothing of any substance found");
        return DaemonSearchResult.Nothing.INSTANCE;
    }

    public static Path ensureCreatedNewAwaitingDataDirectory(ISlcDaemon creator, IInfoTracer logger) throws IOException {
        block18: {
            try {
                if (!Files.exists(creator.location(), new LinkOption[0])) {
                    Files.createDirectories(creator.location(), new FileAttribute[0]);
                }
            }
            catch (FileAlreadyExistsException e) {
                if (Files.exists(creator.location(), new LinkOption[0])) break block18;
                throw new IOException("Creation of directory failed, but subsequent check shows it does not exist: " + e.getMessage(), e);
            }
        }
        try (Stream<Path> dirs = DaemonUtils.dataDirIterate(creator.location(), creator);){
            for (Path dataDirectory : StreamUtils.iterableOf(dirs)) {
                Path runningFileExpected = dataDirectory.resolve(RUNNING_FILE_NAME);
                DataDirLock lock = DaemonUtils.acquireLock(dataDirectory.resolve(LOCK_FILE_NAME), logger);
                try {
                    if (Files.exists(runningFileExpected, new LinkOption[0])) continue;
                    DaemonUtils.cleanDataFolder(dataDirectory, logger);
                    Files.createFile(runningFileExpected, new FileAttribute[0]);
                    logger.daemonLog(() -> "Reusing an old data directory: " + dataDirectory);
                    Path path = dataDirectory;
                    return path;
                }
                finally {
                    if (lock == null) continue;
                    lock.close();
                }
            }
        }
        Path newDataFolder = creator.newFolder();
        try {
            Files.createDirectory(newDataFolder, new FileAttribute[0]);
            Path runningFile = newDataFolder.resolve(RUNNING_FILE_NAME);
            Files.createFile(runningFile, new FileAttribute[0]);
            logger.daemonLog(() -> "Created a new data directory at " + newDataFolder);
        }
        catch (FileAlreadyExistsException e) {
            logger.daemonLog(() -> "Another process beat us to creating " + newDataFolder);
        }
        return newDataFolder;
    }

    public static Optional<DataDirectoryStatus> checkDataDirectory(Path dataDir, DaemonVersionInfo ourInfo, boolean checkVersions, IInfoTracer logger) throws IOException {
        if (Files.isRegularFile(dataDir, new LinkOption[0])) {
            throw new IllegalArgumentException("Expecting data directory but got a file: " + dataDir);
        }
        logger.daemonLog(() -> "Checking data directory status of " + dataDir);
        Path runningFile = dataDir.resolve(RUNNING_FILE_NAME);
        if (!Files.exists(runningFile, new LinkOption[0])) {
            logger.daemonLog(() -> "No .running file at " + runningFile);
            return Optional.empty();
        }
        RunningFileRead possibleFile = DaemonUtils.readRunningFile(runningFile);
        if (possibleFile instanceof RunningFileRead.EmptyStates) {
            RunningFileRead.EmptyStates emptyState = (RunningFileRead.EmptyStates)possibleFile;
            if (emptyState == RunningFileRead.EmptyStates.CORRUPTED_RUNNING_FILE) {
                logger.daemonLog(() -> "Invalid .running file, so cleanup operation is occurring in " + dataDir);
                Files.delete(runningFile);
                Files.deleteIfExists(dataDir.resolve(VERSION_FILE_NAME));
                return Optional.empty();
            }
            logger.daemonLog(() -> "Awaiting or otherwise unknown .running file at " + dataDir);
            return Optional.of(new DataDirectoryStatus(null, possibleFile, dataDir));
        }
        assert (possibleFile instanceof RunningFileRead.ProperFile) : "Controlled interface RunningFileRead had an unaccounted for type added -- " + possibleFile.getClass().getName();
        SlcDaemonSharedData loadedShared = ((RunningFileRead.ProperFile)possibleFile).sharedData();
        Path versionFile = loadedShared.versionFile();
        if (!Files.exists(versionFile, new LinkOption[0])) {
            logger.daemonLog(() -> "valid .running file with no .version at " + loadedShared.dataFolder());
            Files.delete(runningFile);
            return Optional.empty();
        }
        if (ourInfo == null || !checkVersions) {
            logger.daemonLog(() -> "Data directory found at " + loadedShared.dataFolder());
            return Optional.of(new DataDirectoryStatus(loadedShared, possibleFile, dataDir));
        }
        DaemonVersionInfo.VersionComparison sameVersion = ourInfo.strictVersionCompare(versionFile);
        switch (sameVersion) {
            case BROKEN: {
                logger.daemonLog(() -> "Broken .version file, performing cleanup operation in " + loadedShared.dataFolder());
                Files.delete(versionFile);
                Files.delete(runningFile);
                return Optional.empty();
            }
            case DIFFERENT: {
                DaemonUtils.cleanupIfNeeded(runningFile, versionFile, loadedShared, logger);
                return Optional.empty();
            }
            case SAME: {
                boolean hadToClean = DaemonUtils.cleanupIfNeeded(runningFile, versionFile, loadedShared, logger);
                if (hadToClean) {
                    return Optional.empty();
                }
                return Optional.of(new DataDirectoryStatus(loadedShared, possibleFile, dataDir));
            }
        }
        throw new RuntimeException("Missing case statement: " + sameVersion);
    }

    public static boolean isSharedDataOurs(SlcDaemonSharedData shared) {
        return shared.processId() == daemonProcessFunctions.currentProcessId();
    }

    public static boolean cleanupIfNeeded(Path file, Path versionFile, SlcDaemonSharedData shared, IInfoTracer logger) throws IOException {
        if (!daemonProcessFunctions.isProcessActive(shared.processId())) {
            logger.daemonLog(() -> "Data directory at " + shared.dataFolder() + " represents a non-running process, so it will be cleaned.");
            Files.delete(file);
            Files.delete(versionFile);
            return true;
        }
        return false;
    }

    public static boolean cleanupIfNeeded(SlcDaemonSharedData shared, IInfoTracer logger) throws IOException {
        return DaemonUtils.cleanupIfNeeded(shared.runningFile(), shared.versionFile(), shared, logger);
    }

    public static void cleanDataFolder(Path dataFolder, IInfoTracer logger) throws IOException {
        Path possibleRunning;
        logger.daemonLog(() -> "Running a cleanup on data folder " + dataFolder);
        Path possibleVersion = dataFolder.resolve(VERSION_FILE_NAME);
        if (Files.deleteIfExists(possibleVersion)) {
            logger.daemonLog(() -> "Removed version file: " + possibleVersion);
        }
        if (Files.deleteIfExists(possibleRunning = dataFolder.resolve(RUNNING_FILE_NAME))) {
            logger.daemonLog(() -> "Removed running file: " + possibleRunning);
        }
    }

    public static RunningFileRead readRunningFile(Path sharedFile) {
        int readPort;
        long readPid;
        if (!Files.isRegularFile(sharedFile, new LinkOption[0])) {
            return RunningFileRead.EmptyStates.NO_RUNNING_FILE;
        }
        try {
            Properties readProps = FileUtils.readProperties(sharedFile.toFile());
            if (readProps.isEmpty()) {
                return RunningFileRead.EmptyStates.AWAITING_RUNNING_FILE;
            }
            if (!readProps.containsKey(PROP_PROCESS_ID) || !readProps.containsKey(PROP_PORT_NUMBER)) {
                return RunningFileRead.EmptyStates.CORRUPTED_RUNNING_FILE;
            }
            readPid = Long.parseLong(readProps.getProperty(PROP_PROCESS_ID));
            readPort = Integer.parseInt(readProps.getProperty(PROP_PORT_NUMBER));
        }
        catch (IOException | NumberFormatException e) {
            Log.info("Issue interpreting shared file " + sharedFile + " due to " + e.getMessage(), e);
            return RunningFileRead.EmptyStates.CORRUPTED_RUNNING_FILE;
        }
        return new RunningFileRead.ProperFile(new SlcDaemonSharedData(readPort, readPid, sharedFile.getParent(), false));
    }

    public static Optional<SlcDaemonSharedData> fillInRunning(DaemonVersionInfo versioning, Path dataDirectory, ISlcDaemon creator, int portNumber, IInfoTracer logger) throws IOException {
        if (!Files.exists(dataDirectory, new LinkOption[0])) {
            logger.daemonLog(() -> "Cannot fill in .running file when data directory does not exist.");
            return Optional.empty();
        }
        if (Files.isRegularFile(dataDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException("Passed data folder points to a file: " + dataDirectory);
        }
        Properties props = new Properties();
        long pid = daemonProcessFunctions.currentProcessId();
        props.setProperty(PROP_PROCESS_ID, String.valueOf(pid));
        props.setProperty(PROP_PORT_NUMBER, String.valueOf(portNumber));
        Path lockFile = dataDirectory.resolve(LOCK_FILE_NAME);
        Path runningFile = dataDirectory.resolve(RUNNING_FILE_NAME);
        try (DataDirLock lock = DaemonUtils.acquireLock(lockFile, logger);){
            logger.daemonLog(() -> "Acquired lock for writing out full .running file process id and port data: " + runningFile + " pid " + pid + "port" + portNumber);
            if (!Files.isRegularFile(runningFile, new LinkOption[0])) {
                logger.daemonLog(() -> "Nothing to do -- the .running file did NOT exist. " + runningFile);
                Optional<SlcDaemonSharedData> optional = Optional.empty();
                return optional;
            }
            try (OutputStream sharedStream = Files.newOutputStream(runningFile, new OpenOption[0]);){
                props.store(sharedStream, "Autogenerated: do not manually edit, move, or remove! Basically don't touch.");
            }
            String versionFileContents = versioning.versionContent();
            Path versionFile = dataDirectory.resolve(VERSION_FILE_NAME);
            if (Files.exists(versionFile, new LinkOption[0])) {
                Files.delete(versionFile);
            }
            FileUtils.writeFileContents(versionFile.toFile(), versionFileContents);
            logger.daemonLog(() -> ".running file written out with pid and port info successfully: " + runningFile);
            Optional<SlcDaemonSharedData> optional = Optional.of(new SlcDaemonSharedData(portNumber, pid, dataDirectory, true));
            return optional;
        }
    }

    public static Optional<SlcDaemonSharedData> waitForRunning(List<Path> awaitingFiles, DaemonVersionInfo ourVersion, IInfoTracer logger) throws RunningFileWaitTimeExceededException, IOException {
        return DaemonUtils.waitForRunningInternal(awaitingFiles, ourVersion, 30, logger);
    }

    public static Optional<SlcDaemonSharedData> waitForRunning(List<Path> awaitingFiles, DaemonVersionInfo ourVersion, int timeoutInSeconds, IInfoTracer logger) throws RunningFileWaitTimeExceededException, IOException {
        return DaemonUtils.waitForRunningInternal(awaitingFiles, ourVersion, timeoutInSeconds < 0 ? 30 : timeoutInSeconds, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataDirLock acquireLockInternal(Path lockFile, int totalAttempts, int waitTimePerLockInSeconds, IInfoTracer logger, Runnable testInject) throws IOException {
        int attemptsRemaining = totalAttempts;
        while (true) {
            if (!Files.isDirectory(lockFile.getParent(), new LinkOption[0])) {
                throw new LockFileAcquisitionException("Can not even try to acquire lock at " + lockFile + " as the parent directory " + (Files.exists(lockFile.getParent(), new LinkOption[0]) ? "is a file." : "doesn't exist."));
            }
            if (Files.exists(lockFile, new LinkOption[0])) {
                logger.daemonLog(() -> ".lock exists: " + lockFile + ". We will now wait...");
                WaitForLockFileDeletion theLockWatcher = new WaitForLockFileDeletion(lockFile);
                try {
                    Future<Boolean> await = lockWatcherPool.submit(theLockWatcher);
                    await.get(waitTimePerLockInSeconds, TimeUnit.SECONDS);
                }
                catch (TimeoutException ex) {
                    logger.daemonLog(() -> ".lock timeout -- checking if it is referring to a dead process: " + lockFile);
                    DaemonUtils.repairDeadLock(lockFile, waitTimePerLockInSeconds, logger);
                }
                catch (ExecutionException ex) {
                    throw new LockFileAcquisitionException(".lock file failed to be acquired due to unexpected issue during execution: " + ex.getMessage(), ex);
                }
                catch (InterruptedException ex) {
                    logger.daemonLog(() -> "Unexpected thread interruption whilst waiting for lock file: " + lockFile);
                    Thread.currentThread().interrupt();
                }
                finally {
                    theLockWatcher.stop = true;
                }
            }
            if (testInject != null) {
                testInject.run();
            }
            try {
                String pid = String.valueOf(daemonProcessFunctions.currentProcessId());
                Path createLockLock = lockFile.getParent().resolve("create_lock.lock");
                boolean created = false;
                try {
                    Files.createFile(createLockLock, new FileAttribute[0]).toFile().deleteOnExit();
                    created = true;
                    Files.createFile(lockFile, new FileAttribute[0]);
                    try (BufferedWriter lockWriter = Files.newBufferedWriter(lockFile, StandardCharsets.UTF_8, new OpenOption[0]);){
                        lockWriter.append(pid);
                    }
                }
                finally {
                    DaemonUtils.cleanUpLockLock(createLockLock, created);
                }
                logger.daemonLog(() -> "Lock created: " + lockFile);
                return new DataDirLock(lockFile);
            }
            catch (AccessDeniedException | FileAlreadyExistsException ex) {
                logger.daemonLog(() -> "Process contention with creating a new lock, so we will try again: " + lockFile + ". We ran into " + ex.getClass().getCanonicalName() + " with message " + ex.getMessage());
                int atR = attemptsRemaining;
                logger.daemonLog(() -> "Lock not acquired: " + lockFile + ". Will try again. There are " + atR + " attempts remaining.");
                if (attemptsRemaining-- >= 0) continue;
                throw new LockFileAcquisitionException("Tried many too many times (" + totalAttempts + ") to acquire the .lock file and failed. Please ensure that this program has the correct privileges to write to this file, as well as read/write within the data folder.");
            }
            break;
        }
    }

    public static void cleanUpLockLock(Path lockFile, boolean created) throws IOException {
        try {
            if (created) {
                Files.delete(lockFile);
                return;
            }
            boolean isOlder = Files.getLastModifiedTime(lockFile, new LinkOption[0]).toInstant().isBefore(Instant.now().plusMillis(100L));
            if (isOlder) {
                Files.delete(lockFile);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    private static void repairDeadLock(Path lockFile, int waitTimePerLockInSeconds, IInfoTracer logger) throws LockFileAcquisitionException {
        block11: {
            try (BufferedReader reader = Files.newBufferedReader(lockFile, StandardCharsets.UTF_8);){
                String processIdMaybe = reader.readLine();
                try {
                    long processId = Long.parseLong(processIdMaybe);
                    if (daemonProcessFunctions.isProcessActive(processId)) {
                        throw new LockFileAcquisitionException(".lock file may be stale -- no deletion attempt detected after " + waitTimePerLockInSeconds + " seconds, and it is still owned by a currently running process.");
                    }
                    logger.daemonLog(() -> "Repairing stale .lock at " + lockFile + " held by dead process " + processId);
                    Files.delete(lockFile);
                }
                catch (NumberFormatException e) {
                    logger.daemonLog(() -> ".lock at " + lockFile + " + doesn't even make sense. First line was not a number: " + processIdMaybe);
                    Files.delete(lockFile);
                }
            }
            catch (IOException e) {
                if (!Files.exists(lockFile, new LinkOption[0])) break block11;
                throw new LockFileAcquisitionException("Could not read .lock file at " + lockFile + " to determine deadness state due to " + e.getMessage(), e);
            }
        }
    }

    public static Optional<SlcDaemonSharedData> waitForRunningInternal(List<Path> awaitingFiles, DaemonVersionInfo ourVersion, int timeoutInSeconds, IInfoTracer logger) throws RunningFileWaitTimeExceededException, IOException {
        for (Path running : awaitingFiles) {
            logger.daemonLog(() -> "Waiting for " + running + " to fill with contents.");
            Path home = running.getParent();
            Path lockFile = home.resolve(LOCK_FILE_NAME);
            long lastModifiedTsMs = -1L;
            try (DataDirLock lock = DaemonUtils.acquireLock(lockFile, logger);){
                RunningFileRead result = DaemonUtils.readRunningFile(running);
                if (DaemonUtils.checkDaemonVersion(ourVersion, result.connectedDaemon())) {
                    logger.daemonLog(() -> ".running file must have already been filled in: " + running);
                    Optional<SlcDaemonSharedData> optional = result.connectedDaemon();
                    return optional;
                }
                if (result.isAwaiting()) {
                    lastModifiedTsMs = Files.getLastModifiedTime(running, new LinkOption[0]).toMillis();
                }
            }
            if (lastModifiedTsMs == -1L) continue;
            long lastModifiedConst = lastModifiedTsMs;
            Future<?> futureResult = runningWatcherPool.submit(() -> DaemonUtils.waitForRunningFileModification(running, lastModifiedConst, logger));
            try {
                futureResult.get(timeoutInSeconds, TimeUnit.SECONDS);
                logger.daemonLog(() -> ".running file at " + running + " detected modified! Checking for viability.");
                RunningFileRead secondResult = null;
                try (DataDirLock secondLock = DaemonUtils.acquireLock(lockFile, logger);){
                    secondResult = DaemonUtils.readRunningFile(running);
                }
                if (!DaemonUtils.checkDaemonVersion(ourVersion, secondResult.connectedDaemon())) continue;
                logger.daemonLog(() -> ".running file at " + running + " is viable!");
                return secondResult.connectedDaemon();
            }
            catch (TimeoutException ex) {
                logger.daemonLog(() -> "A .running file in awaiting state took more than " + timeoutInSeconds + " whilst waiting for a proper Daemon process to fill it with content.");
                DaemonUtils.cleanDataFolder(home, logger);
            }
            catch (ExecutionException ex) {
                throw new RunningFileWaitTimeExceededException("A .running file in awaiting state could not be waited for due to an issue with thread execution: " + ex.getMessage(), ex);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        logger.daemonLog(() -> "No viable .running files found whilst waiting on all of " + awaitingFiles);
        return Optional.empty();
    }

    public static DataDirLock acquireLock(Path lockFile, IInfoTracer logger) throws IOException {
        return DaemonUtils.acquireLockInternal(lockFile, 100, 30, logger, null);
    }

    private static boolean checkDaemonVersion(DaemonVersionInfo ourVersion, Optional<SlcDaemonSharedData> shared) {
        if (shared.isPresent()) {
            SlcDaemonSharedData data = shared.get();
            if (ourVersion == null || ourVersion.strictVersionCompare(data.versionFile()) == DaemonVersionInfo.VersionComparison.SAME) {
                return true;
            }
        }
        return false;
    }

    private static void waitForRunningFileModification(Path running, long lastModifiedTsMs, IInfoTracer logger) {
        int waitTime = 500;
        try {
            long currentModifiedTsMs = lastModifiedTsMs;
            while (currentModifiedTsMs == lastModifiedTsMs) {
                currentModifiedTsMs = Files.getLastModifiedTime(running, new LinkOption[0]).toMillis();
                Thread.sleep(waitTime);
                waitTime = 50;
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex.getMessage(), ex);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.daemonLog(() -> "Thread interrupted whilst trying to wait for the .running file at " + running + " to be modified.");
        }
    }

    public static IDaemonProcessFunctions mockOutProcessFunctions(IDaemonProcessFunctions newFunctions) {
        if (!RuntimeUtils.isJUnitRunning()) {
            throw new RuntimeException("Mocking out static functions is only allowed in JUnit tests. This should not be called in production code!");
        }
        IDaemonProcessFunctions old = daemonProcessFunctions;
        daemonProcessFunctions = newFunctions;
        return old;
    }

    public static void mockRestoreProcessFunctions() {
        if (!RuntimeUtils.isJUnitRunning()) {
            throw new RuntimeException("Mocking out static functions is only allowed in JUnit tests. This should not be called in production code!");
        }
        daemonProcessFunctions = DaemonProcessFunctions.INSTANCE;
    }

    public static final class DataDirLock
    implements AutoCloseable {
        private final Path lockFile;

        private DataDirLock(Path lockFile) {
            this.lockFile = lockFile;
        }

        @Override
        public void close() throws IOException {
            Files.delete(this.lockFile);
        }
    }

    public static interface IDaemonProcessFunctions {
        public long currentProcessId();

        public boolean isProcessActive(long var1);
    }

    private static final class WaitForLockFileDeletion
    implements Callable<Boolean> {
        private final Path lockFile;
        volatile boolean stop = false;

        public WaitForLockFileDeletion(Path lockFile) {
            this.lockFile = lockFile;
        }

        @Override
        public Boolean call() throws Exception {
            while (!this.stop && Files.exists(this.lockFile, new LinkOption[0])) {
                Thread.onSpinWait();
            }
            return !this.stop;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum DaemonProcessFunctions implements IDaemonProcessFunctions
    {
        INSTANCE{

            @Override
            public long currentProcessId() {
                return ProcessHandle.current().pid();
            }

            @Override
            public boolean isProcessActive(long pid) {
                return !ProcessHandle.of(pid).isEmpty();
            }
        };

    }
}

