/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils.zip;

import com.silabs.java.utils.FileUtils;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.log.Log;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class ZipFileGroup {
    private File baseDir;
    private final Map<File, String> entries = new LinkedHashMap<File, String>();
    private final String zipPath;
    private int prefixStart;

    public ZipFileGroup(File baseDir, String zipPath) {
        this.zipPath = zipPath;
        this.baseDir = this.resolveCanonical(baseDir);
        this.prefixStart = this.baseDir.getPath().length();
        if (!this.baseDir.getPath().endsWith("/") && !this.baseDir.getPath().endsWith("\\")) {
            ++this.prefixStart;
        }
    }

    public void addFile(String filePath) {
        this.addFile(filePath, null);
    }

    public void addFile(String filePath, String zipPath) {
        if (TextUtils.isEmpty(filePath)) {
            return;
        }
        this.addFile(new File(filePath), zipPath);
    }

    public void addFile(File file) {
        this.addFile(file, null);
    }

    public void addFile(File inFile, String zipPath) {
        File file = this.resolveCanonical(inFile);
        if (!file.getPath().startsWith(this.baseDir.getPath())) {
            return;
        }
        if (file.isDirectory()) {
            Log.warning("not adding " + file + " to file group -- expand directories in caller");
            return;
        }
        if (TextUtils.isEmpty(zipPath)) {
            zipPath = file.getPath().substring(this.prefixStart);
        }
        this.entries.put(file, zipPath);
    }

    public void addFiles(boolean allowDots, File ... files) {
        if (files == null) {
            return;
        }
        for (File file : files) {
            Object zipPath = file.getPath().substring(this.prefixStart);
            String name = file.getName();
            if (!allowDots && name.startsWith(".")) {
                zipPath = ((String)zipPath).substring(0, ((String)zipPath).length() - name.length()) + name.substring(1) + name;
            }
            this.addFile(file, (String)zipPath);
        }
    }

    public void addAllFiles(boolean allowDots) {
        File[] allFiles = FileUtils.listFilesInTree(this.baseDir, false, null);
        this.addFiles(allowDots, allFiles);
    }

    public Map<File, String> getEntries() {
        return Collections.unmodifiableMap(this.entries);
    }

    public String getZipPath() {
        return this.zipPath;
    }

    private File resolveCanonical(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }
}

