/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils.variables.engine;

import com.silabs.java.utils.ArrayUtils;
import com.silabs.java.utils.MapUtils;
import com.silabs.java.utils.extension.ExtensionManager;
import com.silabs.java.utils.variables.IVariableStore;
import com.silabs.java.utils.variables.engine.IStockVariableAdapter;
import com.silabs.java.utils.variables.engine.IStockVariableFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class StockVariables {
    public static final StockVariables INSTANCE = new StockVariables();
    private static final String EXTENSION_ID = "stockVariableSupport";
    private static final String STOCK_VARIABLE_ELEMENT = "stockVariableFactory";
    private static final String CLASS_ATTR = "class";
    private final Set<IStockVariableFactory> providers = new LinkedHashSet<IStockVariableFactory>();

    private StockVariables() {
        this.providers.add(new DefaultVariableFactory());
        ExtensionManager extMgr = new ExtensionManager("com.silabs.java.utils", EXTENSION_ID, null);
        extMgr.addHandler(STOCK_VARIABLE_ELEMENT, (el, added, context) -> this.providers.add((IStockVariableFactory)el.createExecutableExtension(CLASS_ATTR)));
        extMgr.startup();
    }

    public IVariableStore setVariables(IVariableStore variables, Object obj) {
        Collection<IStockVariableAdapter> gatherObjects = this.gatherObjects(obj);
        gatherObjects.forEach(var -> var.setVariables(variables));
        return variables;
    }

    private Collection<IStockVariableAdapter> gatherObjects(Object obj) {
        LinkedHashMap<Object, Collection<IStockVariableAdapter>> adapterMap = new LinkedHashMap<Object, Collection<IStockVariableAdapter>>();
        this.recursiveGatherObjects(adapterMap, obj, 0);
        return adapterMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void recursiveGatherObjects(Map<Object, Collection<IStockVariableAdapter>> adapterMap, Object newObj, int level) {
        if (level > 20) {
            throw new IllegalStateException("Recursive overflow of variable objects. Aborting variable store creation.");
        }
        if (adapterMap.containsKey(newObj)) {
            return;
        }
        Collection adapterList = MapUtils.findOrCreate(adapterMap, newObj, ArrayList::new);
        for (IStockVariableFactory provider : this.providers) {
            Object[] subObjs;
            IStockVariableAdapter[] varSupps = provider.getAdapters(newObj);
            if (!ArrayUtils.isEmpty(varSupps)) {
                adapterList.addAll(Arrays.asList(varSupps));
            }
            if (ArrayUtils.isEmpty(subObjs = provider.getSubObjects(newObj))) continue;
            Stream.of(subObjs).forEach(o -> this.recursiveGatherObjects(adapterMap, o, level + 1));
        }
    }

    private class DefaultVariableFactory
    implements IStockVariableFactory {
        private DefaultVariableFactory() {
        }

        @Override
        public Object[] getSubObjects(Object obj) {
            if (obj instanceof Object[]) {
                return (Object[])obj;
            }
            return null;
        }

        @Override
        public IStockVariableAdapter[] getAdapters(Object obj) {
            return null;
        }
    }
}

