/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import com.silabs.java.utils.FrameUtil;
import com.silabs.java.utils.StringTemplate;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class TextUtils {
    private static Pattern commonSeperators = Pattern.compile("[ .,-]");
    private static final String LINE_ENDING_PATTERN_STRING = "(\r\n|\r|\n)";
    private static final Pattern ANY_NEWLINE_MATCHING_PATTERN = Pattern.compile("(\r\n|\r|\n)");
    public static final String IDENT = "  ";
    private static final Pattern REMOVE_TAGS = Pattern.compile("<.+?>");
    private static final String PRE_TAG_PATTERN = "<pre>([^<]*)</pre";
    private static final String UTF_8_CHARSET_NAME = "UTF-8";

    public static boolean isEmpty(String text) {
        return text == null || text.isEmpty();
    }

    public static boolean isBlank(String text) {
        return text == null || text.isBlank();
    }

    public static boolean hasContent(String text) {
        return !TextUtils.isEmpty(text);
    }

    public static boolean isNumeric(String text) {
        if (TextUtils.isEmpty(text)) {
            return false;
        }
        int size = text.length();
        for (int i = 0; i < size; ++i) {
            if (Character.isDigit(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isHexChar(char character) {
        return "0123456789ABCDEFabcdef".indexOf(character) != -1;
    }

    public static boolean isAlphaNumeric(String text) {
        return text != null && text.matches("[a-zA-Z0-9]+");
    }

    public static String canonicalizeNewlines(String text) {
        return TextUtils.canonicalizeNewlines(text, "\n");
    }

    public static String canonicalizeNewlines(String text, String eol) {
        if (text == null) {
            return "";
        }
        Matcher matcher = ANY_NEWLINE_MATCHING_PATTERN.matcher(text);
        return matcher.replaceAll(eol);
    }

    public static String titleCase(String name) {
        if (name.length() == 0) {
            return name;
        }
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public static String untitleCase(String name) {
        if (name.length() == 0) {
            return name;
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    public static String escape(String val, char quote) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < val.length(); ++i) {
            char ch = val.charAt(i);
            if (ch == quote || ch == '\\') {
                sb.append('\\');
                sb.append(ch);
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\t': {
                        sb.append("\\t");
                        break;
                    }
                    case '\n': {
                        sb.append("\\n");
                        break;
                    }
                    case '\r': {
                        sb.append("\\r");
                        break;
                    }
                    case '\f': {
                        sb.append("\\f");
                        break;
                    }
                    case '\b': {
                        sb.append("\\b");
                        break;
                    }
                    default: {
                        sb.append("\\");
                        sb.append(String.format("%03o", ch));
                        break;
                    }
                }
                continue;
            }
            if (TextUtils.isLineOrParaSeparator(ch)) {
                sb.append("\\u");
                sb.append(Integer.toHexString(ch));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static boolean isLineOrParaSeparator(char ch) {
        int type = Character.getType(ch);
        return ch > '\u007f' && (type == 14 || type == 13);
    }

    public static String quote(String val, char quote) {
        StringBuilder sb = new StringBuilder();
        sb.append(quote);
        sb.append(TextUtils.escape(val, quote));
        sb.append(quote);
        return sb.toString();
    }

    public static String unescape(String val, char quote) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < val.length(); ++i) {
            char ch = val.charAt(i);
            if (ch == '\\' && i + 1 < val.length()) {
                String code;
                if (Character.digit(ch = val.charAt(++i), 8) >= 0 && i + 2 < val.length()) {
                    code = val.substring(i, i + 3);
                    i += 2;
                    try {
                        int octal = Integer.parseInt(code, 8);
                        sb.append((char)octal);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                switch (ch) {
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'u': {
                        try {
                            code = val.substring(i + 1, i + 5);
                            sb.append((char)Integer.parseInt(code, 16));
                            i += 4;
                        }
                        catch (NumberFormatException e) {
                            sb.append('\\');
                            sb.append('u');
                        }
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case '\'': {
                        sb.append('\'');
                        break;
                    }
                    default: {
                        sb.append('\\');
                        sb.append(ch);
                        break;
                    }
                }
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String unquote(String string, char quote) {
        if (string.length() >= 2 && string.charAt(0) == quote && string.charAt(string.length() - 1) == quote) {
            return TextUtils.unescape(string.substring(1, string.length() - 1), quote);
        }
        return string;
    }

    public static String formatTabbedList(Collection<?> items) {
        StringBuilder builder = new StringBuilder();
        for (Object name : items) {
            String item = name.toString();
            builder.append('\t');
            builder.append(item);
            builder.append('\n');
        }
        return builder.toString();
    }

    public static String catenateStrings(Object[] objects, String separator) {
        return TextUtils.catenateStrings(objects, separator, String::valueOf);
    }

    public static <T> String catenateStrings(T[] objects, String separator, Function<T, String> converter) {
        return TextUtils.catenateStrings(Stream.of(objects), separator, converter);
    }

    public static String catenateStrings(Collection<?> list, String separator) {
        return TextUtils.catenateStrings(list, separator, String::valueOf);
    }

    public static <T> String catenateStrings(Collection<T> list, String separator, Function<T, String> converter) {
        return TextUtils.catenateStrings(list.stream(), separator, converter);
    }

    private static <T> String catenateStrings(Stream<T> objects, String separator, Function<T, String> converter) {
        StringBuilder builder = new StringBuilder();
        boolean[] first = new boolean[]{true};
        objects.forEach(o -> {
            if (first[0]) {
                first[0] = false;
            } else if (separator != null) {
                builder.append(separator);
            }
            builder.append((String)converter.apply(o));
        });
        return builder.toString();
    }

    public static String repeatString(String string, int count) {
        if (count <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (count-- > 0) {
            sb.append(string);
        }
        return sb.toString();
    }

    public static String indent(String text, int count, String indentString) {
        if (TextUtils.isEmpty(text)) {
            return text;
        }
        String indent = TextUtils.repeatString(indentString, count);
        Object[] lines = text.split("\n", -1);
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = !lines[i].trim().isEmpty() ? indent + (String)lines[i] : "";
        }
        return TextUtils.catenateStrings(lines, "\n");
    }

    public static String[] splitByCharacter(String text, char c) {
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != c) continue;
            ++count;
        }
        String[] segments = new String[count + 1];
        int prev = 0;
        int idx = 0;
        int pos = text.indexOf(c, prev);
        while (pos >= 0) {
            segments[idx++] = text.substring(prev, pos);
            prev = pos + 1;
            pos = text.indexOf(c, prev);
        }
        segments[idx++] = text.substring(prev);
        return segments;
    }

    public static List<String> splitByCharacterToList(String text, char c) {
        ArrayList<String> segments = new ArrayList<String>();
        if (TextUtils.isEmpty(text)) {
            return segments;
        }
        int prev = 0;
        int pos = text.indexOf(c, prev);
        while (pos >= 0) {
            segments.add(text.substring(prev, pos));
            prev = pos + 1;
            pos = text.indexOf(c, prev);
        }
        segments.add(text.substring(prev));
        return segments;
    }

    public static String[] splitByNewLine(String text) {
        return (String[])Arrays.stream(text.split("\\r?\\n")).filter(i -> !TextUtils.isBlank(i)).toArray(String[]::new);
    }

    public static String escapeValue(String value) {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static String[] readKeyValue(String line) {
        int i = line.indexOf("=");
        if (i == -1) {
            return null;
        }
        String[] ret = new String[]{line.substring(0, i).trim(), line.substring(i + 1).trim()};
        return ret;
    }

    public static String writeKeyValue(String key, Object value) {
        return key + "=" + String.valueOf(value);
    }

    public static String[] breakIntoLines(String longString, int maxLineLength) {
        return TextUtils.breakIntoLines(longString, null, maxLineLength);
    }

    public static String[] breakIntoLines(String longString, String linePrefix, int maxLineLength) {
        String[] words = longString != null ? longString.split(" ") : new String[]{};
        if (linePrefix == null) {
            linePrefix = "";
        }
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            if (line.length() == 0) {
                line.append(linePrefix).append(word);
                continue;
            }
            if (line.length() + 1 + word.length() > maxLineLength) {
                lines.add(line.toString());
                line = new StringBuilder(linePrefix);
            } else {
                line.append(' ');
            }
            line.append(word);
        }
        if (line.length() > 0) {
            lines.add(line.toString());
        }
        return lines.toArray(new String[0]);
    }

    public static String breakIntoLinesIfNeeded(String longString, int maxLineLength) {
        String returnText = TextUtils.removeHtmlTags(longString);
        if (returnText.contains("\n")) {
            return returnText;
        }
        return TextUtils.breakIntoLinesWithNewLineEnding(returnText, maxLineLength);
    }

    public static String breakIntoLinesWithNewLineEnding(String longString, int maxLineLength) {
        String[] lines = TextUtils.breakIntoLines(longString, null, maxLineLength);
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line).append("\n");
        }
        return sb.toString();
    }

    public static String replaceTokens(String pattern, Map<String, String> tokenMap) {
        return StringTemplate.replaceTokensSimple(pattern, tokenMap, "{", "}");
    }

    public static String defineStringToCamelString(String define, boolean startUppercase, char separator) {
        StringBuilder sb = new StringBuilder();
        boolean startNewWord = true;
        boolean firstWord = true;
        for (int i = 0; i < define.length(); ++i) {
            char c = define.charAt(i);
            if (c == separator) {
                startNewWord = true;
                continue;
            }
            if (startNewWord) {
                if (firstWord && !startUppercase) {
                    firstWord = false;
                    sb.append(Character.toLowerCase(c));
                } else {
                    sb.append(Character.toUpperCase(c));
                }
                startNewWord = false;
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static void ident(StringBuffer sb, int n) {
        for (int i = 0; i < n; ++i) {
            sb.append(IDENT);
        }
    }

    public static int countOccurences(String haystack, char needle) {
        int cnt = 0;
        if (haystack == null) {
            return cnt;
        }
        for (int i = 0; i < haystack.length(); ++i) {
            if (haystack.charAt(i) != needle) continue;
            ++cnt;
        }
        return cnt;
    }

    public static int countOccurences(String haystack, String needle) {
        if (TextUtils.isEmpty(haystack) || TextUtils.isEmpty(needle)) {
            return 0;
        }
        int count = 0;
        int idx = haystack.indexOf(needle);
        while (idx >= 0) {
            ++count;
            idx = haystack.indexOf(needle, idx + needle.length());
        }
        return count;
    }

    public static String strip(String prefix, String macro) {
        String result = macro;
        while (result.startsWith(prefix)) {
            result = result.substring(prefix.length());
        }
        while (result.startsWith("_")) {
            result = result.substring(1);
        }
        return result;
    }

    public static String defineStringToCamelString(String define) {
        return TextUtils.defineStringToCamelString(define, true, '_');
    }

    public static String camelStringToSentenceCaseReadableString(String camelString) {
        return TextUtils.camelStringToReadableString(camelString, true);
    }

    public static String camelStringToDefineString(String camel) {
        return TextUtils.demarkedStringToDefineString(TextUtils.camelStringToSentenceCaseReadableString(camel));
    }

    public static String camelStringToTitleCaseReadableString(String camelString) {
        return TextUtils.camelStringToReadableString(camelString, false);
    }

    private static String camelStringToReadableString(String camelString, boolean sentenceCase) {
        boolean isAllCaps = true;
        for (int i = 0; i < camelString.length(); ++i) {
            char c = camelString.charAt(i);
            if (!Character.isLowerCase(c)) continue;
            isAllCaps = false;
            break;
        }
        if (isAllCaps) {
            return camelString;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < camelString.length(); ++i) {
            char c = camelString.charAt(i);
            if (i == 0) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            if (Character.isUpperCase(c)) {
                sb.append(" ");
            }
            sb.append(sentenceCase ? Character.toLowerCase(c) : c);
        }
        return sb.toString();
    }

    public static String defineStringToSentenceCaseReadableString(String defineString) {
        return TextUtils.camelStringToSentenceCaseReadableString(TextUtils.defineStringToCamelString(defineString));
    }

    public static String defineStringToTitleCaseReadableString(String defineString) {
        return TextUtils.camelStringToTitleCaseReadableString(TextUtils.defineStringToCamelString(defineString));
    }

    public static String demarkedStringToDefineString(String demarkedString) {
        if (demarkedString == null) {
            return "";
        }
        boolean allCaps = true;
        for (int i = 0; i < demarkedString.length(); ++i) {
            char c = demarkedString.charAt(i);
            if (!Character.isLowerCase(c)) continue;
            allCaps = false;
            break;
        }
        StringBuilder sb = new StringBuilder();
        if (!allCaps) {
            for (int i = 0; i < demarkedString.length(); ++i) {
                char c = demarkedString.charAt(i);
                if (i != 0 && Character.isUpperCase(c)) {
                    sb.append(" ");
                }
                sb.append(c);
            }
        } else {
            sb.append(demarkedString);
        }
        String[] ss = commonSeperators.split(sb.toString());
        sb = new StringBuilder();
        int i = 0;
        for (String s : ss) {
            ++i;
            if (s.trim().length() == 0) continue;
            sb.append(s);
            if (i >= ss.length) continue;
            sb.append("_");
        }
        return sb.toString().toUpperCase(Locale.ROOT);
    }

    public static String demarkedStringToCamelString(String demarkedString) {
        return TextUtils.defineStringToCamelString(TextUtils.demarkedStringToDefineString(demarkedString), false, '_');
    }

    public static String demarkedStringToCamelString(String demarkedString, boolean startUppercase) {
        return TextUtils.defineStringToCamelString(TextUtils.demarkedStringToDefineString(demarkedString), startUppercase, '_');
    }

    public static String demarkedStringToFilenameString(String demarkedString) {
        return TextUtils.demarkedStringToDefineString(demarkedString).toLowerCase(Locale.ROOT).replaceAll("[_/\\\\]", "-");
    }

    public static String demarkedStringToCVariable(String demarkedString) {
        if (demarkedString == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < demarkedString.length(); ++i) {
            char ch = demarkedString.charAt(i);
            if (i == 0) {
                if (Character.isLetter(ch) && ch >= ' ' && ch < '\u007f') {
                    sb.append(ch);
                    continue;
                }
                sb.append('_');
                if (!Character.isDigit(ch) || ch < ' ' || ch >= '\u007f') continue;
                sb.append(ch);
                continue;
            }
            if (Character.isLetterOrDigit(ch) && ch >= ' ' && ch < '\u007f') {
                sb.append(ch);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    public static String print(Object x) {
        return TextUtils.print(x, 0);
    }

    public static String print(Object x, String separator) {
        return TextUtils.print(x, 0, separator);
    }

    private static String print(Object x, int level) {
        return TextUtils.print(x, level, ",");
    }

    private static String print(Object x, int level, String separator) {
        String ret;
        if (level > 20) {
            return "";
        }
        String ident = TextUtils.repeatString(IDENT, level);
        if (x instanceof byte[]) {
            byte[] ar = (byte[])x;
            ret = FrameUtil.formatByteArray(ar);
        } else if (x instanceof int[]) {
            int[] ar = (int[])x;
            StringBuilder sb = new StringBuilder();
            String sep = "";
            for (int i : ar) {
                sb.append(sep).append(i);
                sep = separator;
            }
            ret = sb.toString();
        } else if (x instanceof String[]) {
            String[] ar = (String[])x;
            StringBuilder sb = new StringBuilder();
            String sep = "";
            for (String s : ar) {
                if (level > 0) {
                    sb.append(ident).append(s).append("\n");
                    continue;
                }
                sb.append(sep).append(s);
                sep = separator;
            }
            ret = sb.toString();
        } else if (x instanceof Object[]) {
            StringBuilder sb = new StringBuilder();
            String sep = "";
            for (Object o : (Object[])x) {
                if (level > 0) {
                    sb.append(ident).append(TextUtils.print(o, level + 1)).append("\n");
                    continue;
                }
                sb.append(sep).append(TextUtils.print(o, level + 1));
                sep = separator;
            }
            ret = sb.toString();
        } else if (x instanceof Map) {
            Map m = (Map)x;
            StringBuilder sb = new StringBuilder();
            for (Object key : m.keySet()) {
                Object val = m.get(key);
                sb.append(ident);
                sb.append(TextUtils.print(key, level + 1));
                sb.append(" => ");
                sb.append(TextUtils.print(val, level + 1));
                sb.append("\n");
            }
            ret = sb.toString();
        } else if (x instanceof Collection) {
            StringBuilder sb = new StringBuilder();
            String sep = "";
            for (Object o : (Collection)x) {
                if (level > 0) {
                    sb.append(ident).append(TextUtils.print(o, level + 1)).append("\n");
                    continue;
                }
                sb.append(sep).append(TextUtils.print(o, level + 1));
                sep = separator;
            }
            ret = sb.toString();
        } else {
            Optional o;
            ret = x instanceof Optional ? ((o = (Optional)x).isPresent() ? TextUtils.print(o.get()) : "<<void optional>>") : String.valueOf(x);
        }
        return ident + ret;
    }

    public static String join(String ... input) {
        return TextUtils.join(false, input);
    }

    public static String joinCsv(String ... input) {
        return TextUtils.join(true, input);
    }

    public static String join(boolean preserve, String ... input) {
        if (input == null) {
            return "";
        }
        StringBuilder output = new StringBuilder();
        int count = 0;
        for (String element : input) {
            String string = element = element == null ? "" : element.trim();
            if (!preserve && element.isEmpty()) continue;
            if (count != 0) {
                output.append(", ");
            }
            output.append(element);
            ++count;
        }
        return output.toString();
    }

    public static String[] split(String input) {
        return TextUtils.split(input, false);
    }

    public static List<String> splitToList(String input) {
        return TextUtils.splitToList(input, false);
    }

    public static String[] splitCsv(String input) {
        return TextUtils.split(input, true);
    }

    public static String[] split(String input, boolean preserve) {
        return TextUtils.splitToList(input, preserve).toArray(new String[0]);
    }

    public static List<String> splitToList(String input, boolean preserve) {
        ArrayList<String> output = new ArrayList<String>();
        if (input == null) {
            return output;
        }
        String regex = "\\s*,\\s*";
        int limit = preserve ? -1 : 0;
        input = input.trim();
        for (String element : input.split(regex, limit)) {
            if (!preserve && element.isEmpty()) continue;
            output.add(element);
        }
        return output;
    }

    public static String[] splitProperty(Properties properties, String key) {
        return TextUtils.split(properties.getProperty(key));
    }

    public static String[] splitCsvProperty(Properties properties, String key) {
        return TextUtils.splitCsv(properties.getProperty(key));
    }

    public static String unarray(String value) {
        return value == null ? null : value.replaceAll("^\\s*\\[\\s*(.*)\\s*]\\s*$", "$1");
    }

    public static String nullTerminatedByteArrayToString(byte[] data) {
        int n = data.length;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != 0) continue;
            n = i;
            break;
        }
        Charset cs = Charset.forName("US-ASCII");
        return new String(data, 0, n, cs);
    }

    public static String asReadableList(Collection<?> objects) {
        Object[] input = objects.toArray(new Object[0]);
        StringBuilder output = new StringBuilder();
        output.append(input[0]);
        for (int i = 1; i < input.length; ++i) {
            if (input.length > 2) {
                output.append(",");
            }
            if (i == input.length - 1) {
                output.append(" and");
            }
            output.append(" ");
            output.append(input[i]);
        }
        return output.toString();
    }

    public static String asReadableList(Collection<?> objects, String singular, String plural) {
        StringBuilder output = new StringBuilder(TextUtils.asReadableList(objects));
        output.append(" ");
        output.append(objects.size() == 1 ? singular : plural);
        return output.toString();
    }

    public static String asReadableList(Collection<?> objects, String suffix) {
        return TextUtils.asReadableList(objects, suffix, suffix + "s");
    }

    public static List<String> addProperties(Properties properties, Collection<String> data) {
        ArrayList<String> errors = new ArrayList<String>();
        for (String datum : data) {
            try {
                properties.load(new StringReader(datum));
            }
            catch (Exception exception) {
                errors.add(datum);
            }
        }
        return errors;
    }

    public static String normalize(String path, String separator) {
        boolean keepGoing;
        StringBuilder normalizedPath = new StringBuilder();
        String splitter = "\\".equals(separator) ? "\\\\" : separator;
        String[] individualPathParts = path.split(splitter);
        LinkedList<String> pathPartDeque = new LinkedList<String>();
        for (String pathPart : individualPathParts) {
            if (".".equals(pathPart)) continue;
            if ("..".equals(pathPart) && !pathPartDeque.isEmpty() && !"..".equals(pathPartDeque.peekLast())) {
                pathPartDeque.removeLast();
                continue;
            }
            pathPartDeque.addLast(pathPart);
        }
        boolean bl = keepGoing = !pathPartDeque.isEmpty();
        while (keepGoing) {
            normalizedPath.append((String)pathPartDeque.removeFirst());
            keepGoing = !pathPartDeque.isEmpty();
            if (!keepGoing) continue;
            normalizedPath.append(separator);
        }
        return normalizedPath.toString();
    }

    public static String uppercaseChar(String string, int index) {
        StringBuffer buffer = new StringBuffer(string);
        int i = 0;
        for (i = 0; i < string.length() && index > -1; ++i) {
            if (!Character.isLetter(string.charAt(i))) continue;
            --index;
        }
        if (--i < string.length() && i >= 0 && index == -1) {
            buffer.setCharAt(i, Character.toUpperCase(string.charAt(i)));
        }
        return buffer.toString();
    }

    public static String uppercaseFirstChar(String string) {
        return TextUtils.uppercaseChar(string, 0);
    }

    public static Map<String, String> getPropertyKeyValueMap(String prop, Properties allProperties) {
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        for (String property : allProperties.stringPropertyNames()) {
            if (!property.startsWith(prop)) continue;
            String propertyValue = allProperties.getProperty(property);
            int ind = property.indexOf("(");
            String architectureIds = property.substring(ind + 1, property.length() - 1);
            for (String id : TextUtils.split(architectureIds)) {
                keyValueMap.put(id, propertyValue);
            }
        }
        return keyValueMap;
    }

    public static String removeHtmlTags(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        Matcher m = REMOVE_TAGS.matcher(string);
        return m.replaceAll("");
    }

    public static String removeNewLines(String str) {
        return str.replaceAll("\\r|\\n", " ");
    }

    public static String getPreText(String input) {
        StringBuilder output = new StringBuilder();
        Pattern p = Pattern.compile(PRE_TAG_PATTERN);
        Matcher m = p.matcher(input);
        if (m.find()) {
            String codeGroup = m.group(1);
            output.append(codeGroup);
            return output.toString();
        }
        return input;
    }

    public static Charset getDefaultCharset() {
        Charset charset;
        try {
            charset = Charset.forName(UTF_8_CHARSET_NAME);
            if (charset == null) {
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException exc) {
            charset = Charset.defaultCharset();
        }
        return charset;
    }

    public static List<String> trimSamePrefixAndSuffix(List<String> list) {
        char ch;
        char comparisonChar;
        if (list.isEmpty()) {
            return list;
        }
        int trimCountLeft = 0;
        int trimCountRight = 0;
        block0: while (true) {
            comparisonChar = '\uffff';
            for (String s : list) {
                if (s.length() <= trimCountLeft) break block0;
                ch = s.charAt(trimCountLeft);
                if (comparisonChar == '\uffff') {
                    comparisonChar = ch;
                    continue;
                }
                if (comparisonChar == ch) continue;
                break block0;
            }
            ++trimCountLeft;
        }
        block2: while (true) {
            comparisonChar = '\uffff';
            for (String s : list) {
                if (s.length() <= trimCountLeft + trimCountRight) break block2;
                ch = s.charAt(s.length() - trimCountRight - 1);
                if (comparisonChar == '\uffff') {
                    comparisonChar = ch;
                    continue;
                }
                if (comparisonChar == ch) continue;
                break block2;
            }
            ++trimCountRight;
        }
        ArrayList<String> output = new ArrayList<String>();
        for (String s : list) {
            String replacement = s.substring(trimCountLeft, s.length() - trimCountRight);
            output.add(replacement);
        }
        return output;
    }

    public static String[] convertToStringArray(Object someArrayList) {
        if (someArrayList instanceof ArrayList) {
            ArrayList<String> strings = new ArrayList<String>();
            for (Object item : (ArrayList)someArrayList) {
                strings.add(TextUtils.print(item));
            }
            return strings.toArray(new String[0]);
        }
        return new String[0];
    }
}

