/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import com.silabs.java.utils.log.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class ListenerList<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = -4548014975540398630L;
    private static final Object[] NO_LISTENERS = new Object[0];
    private final Set<T> listeners;
    private transient Object[] listenerArray;
    private final List<IFire<T>> queuedFirers = new ArrayList<IFire<T>>(0);
    private boolean suppress;

    public ListenerList() {
        this.listeners = new LinkedHashSet<T>(1);
        this.listenerArray = NO_LISTENERS;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.listeners == null ? 0 : this.listeners.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListenerList other = (ListenerList)obj;
        return !(this.listeners == null ? other.listeners != null : !this.listeners.equals(other.listeners));
    }

    public String toString() {
        return this.listenerArray.length + " listeners";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        Set<T> set = this.listeners;
        synchronized (set) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
                this.listenerArray = this.listeners.toArray(new Object[this.listeners.size()]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(T listener) {
        Set<T> set = this.listeners;
        synchronized (set) {
            if (this.listeners.remove(listener)) {
                this.listenerArray = this.listeners.isEmpty() ? NO_LISTENERS : this.listeners.toArray(new Object[this.listeners.size()]);
            }
        }
    }

    public void fire(IFire<T> fire) {
        Object[] localArray;
        Object[] objectArray = localArray = this.listenerArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object obj;
            Object listener = obj = objectArray[i];
            try {
                fire.fire(listener);
                continue;
            }
            catch (Throwable t) {
                Log.error("exception caught in listener", t);
            }
        }
    }

    public void fireReverse(IFire<T> fire) {
        Object[] localArray = this.listenerArray;
        for (int i = localArray.length - 1; i >= 0; --i) {
            Object obj;
            Object listener = obj = localArray[i];
            try {
                fire.fire(listener);
                continue;
            }
            catch (Throwable t) {
                Log.error("exception caught in listener", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireOrQueue(IFire<T> fire) {
        List<IFire<T>> list = this.queuedFirers;
        synchronized (list) {
            if (this.suppress) {
                this.queuedFirers.add(fire);
                return;
            }
        }
        this.fire(fire);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSuppressed(boolean suppress) {
        boolean wasSuppressed;
        IFire[] firers = null;
        List<IFire<T>> list = this.queuedFirers;
        synchronized (list) {
            wasSuppressed = this.suppress;
            if (wasSuppressed && !suppress) {
                firers = this.queuedFirers.toArray(new IFire[this.queuedFirers.size()]);
                this.queuedFirers.clear();
            }
            this.suppress = suppress;
        }
        if (firers != null) {
            for (List<IFire<T>> list2 : firers) {
                this.fire((IFire<T>)((Object)list2));
            }
        }
        return wasSuppressed;
    }

    public boolean isSuppressed() {
        return this.suppress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> iterator() {
        Set<T> set = this.listeners;
        synchronized (set) {
            return new Iterator<T>(){
                Object[] localArray;
                int idx;
                {
                    this.localArray = ListenerList.this.listenerArray;
                    this.idx = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.idx < this.localArray.length;
                }

                @Override
                public T next() {
                    if (this.idx >= this.localArray.length) {
                        throw new NoSuchElementException();
                    }
                    return this.localArray[this.idx++];
                }

                @Override
                public void remove() {
                    if (this.idx == 0) {
                        throw new IllegalStateException();
                    }
                    ListenerList.this.remove(this.localArray[this.idx - 1]);
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Set<T> set = this.listeners;
        synchronized (set) {
            this.listeners.clear();
            this.listenerArray = NO_LISTENERS;
        }
    }

    public boolean isEmpty() {
        return this.listenerArray == NO_LISTENERS;
    }

    public Object[] toArray() {
        return this.listenerArray;
    }

    public <X> X[] toArray(X[] a) {
        if (a.length < this.listenerArray.length) {
            return Arrays.copyOf(this.listenerArray, this.listenerArray.length, a.getClass());
        }
        System.arraycopy(this.listenerArray, 0, a, 0, this.listenerArray.length);
        if (a.length > this.listenerArray.length) {
            a[this.listeners.size()] = null;
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getAndClear() {
        Set<T> set = this.listeners;
        synchronized (set) {
            Object[] arr = this.listenerArray;
            this.listeners.clear();
            this.listenerArray = NO_LISTENERS;
            return arr;
        }
    }

    @FunctionalInterface
    public static interface IFire<T> {
        public void fire(T var1);
    }
}

