/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import com.silabs.java.utils.LangUtilities;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Locale;

public class FrameUtil {
    private static final char[] LOWER_CASE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] UPPER_CASE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static char[] byteArrayDelimiters = new char[]{' ', '[', ']'};

    public static int calculateRealFromHexAsciiOffset(int bytesPerBlock, int blocksPerLine, int blockSeparatorLength, int hexAsciiSeparatorLength, int hexAsciiOffset) {
        if (bytesPerBlock < 1) {
            bytesPerBlock = 1;
        }
        if (blocksPerLine < 1) {
            blocksPerLine = 1;
        }
        int bytesPerLine = bytesPerBlock * blocksPerLine;
        int hexCharsPerLine = bytesPerLine * 3 - 1 + (blocksPerLine - 1) * (blockSeparatorLength - 1);
        int asciiCharsPerLine = bytesPerLine + (blocksPerLine - 1) * blockSeparatorLength;
        int charsPerLine = hexCharsPerLine + hexAsciiSeparatorLength + asciiCharsPerLine + 1;
        int lines = hexAsciiOffset / charsPerLine;
        int remainder = hexAsciiOffset %= charsPerLine;
        int realOffset = lines * bytesPerBlock * blocksPerLine;
        if (remainder <= hexCharsPerLine) {
            realOffset += remainder / 3;
        } else {
            if (remainder + 1 == charsPerLine) {
                return -1;
            }
            if (remainder >= hexCharsPerLine + hexAsciiSeparatorLength) {
                realOffset += remainder - hexCharsPerLine - hexAsciiSeparatorLength;
            } else {
                return -1;
            }
        }
        return realOffset;
    }

    public static int[][] calculateHexAsciiBlockOffsets(int bytesPerBlock, int blocksPerLine, int blockSeparatorLength, int hexAsciiSeparatorLength, int from, int to) {
        int bytesPerLine;
        if (bytesPerBlock < 1) {
            bytesPerBlock = 1;
        }
        if (blocksPerLine < 1) {
            blocksPerLine = 1;
        }
        if ((bytesPerLine = bytesPerBlock * blocksPerLine) == 0) {
            return new int[0][0];
        }
        int hexCharsPerLine = bytesPerLine * 3 - 1 + (blocksPerLine - 1) * (blockSeparatorLength - 1);
        int asciiCharsPerLine = bytesPerLine + (blocksPerLine - 1) * blockSeparatorLength;
        int charsPerLine = hexCharsPerLine + hexAsciiSeparatorLength + asciiCharsPerLine + 1;
        int fromLine = from / bytesPerLine;
        int toLine = to / bytesPerLine;
        int fromColumn = from % bytesPerLine;
        int toColumn = to % bytesPerLine;
        ArrayList<int[]> totals = new ArrayList<int[]>();
        for (int line = fromLine; line <= toLine; ++line) {
            int[] hex = new int[]{line == fromLine ? charsPerLine * line + fromColumn * 3 + fromColumn / bytesPerBlock * (blockSeparatorLength - 1) : charsPerLine * line, line == toLine ? charsPerLine * line + (toColumn + 1) * 3 - 1 + toColumn / bytesPerBlock * (blockSeparatorLength - 1) : charsPerLine * line + hexCharsPerLine};
            totals.add(hex);
            int[] ascii = new int[]{line == fromLine ? charsPerLine * line + hexCharsPerLine + hexAsciiSeparatorLength + fromColumn + fromColumn / bytesPerBlock * blockSeparatorLength : charsPerLine * line + hexCharsPerLine + hexAsciiSeparatorLength, line == toLine ? charsPerLine * line + hexCharsPerLine + hexAsciiSeparatorLength + toColumn + 1 + toColumn / bytesPerBlock * blockSeparatorLength : charsPerLine * line + hexCharsPerLine + hexAsciiSeparatorLength + asciiCharsPerLine};
            totals.add(ascii);
        }
        return (int[][])totals.toArray((T[])new int[0][2]);
    }

    public static int calculateRealFromAsciiOffset(String text, int asciiOffset) {
        int realOffset = asciiOffset;
        for (int i = 0; i < asciiOffset; ++i) {
            if (text.charAt(i) != '\n') continue;
            --realOffset;
        }
        return realOffset;
    }

    public static int[][] calculateAsciiBlockOffsets(String text, int from, int to) {
        int i;
        int realFrom = from;
        int realTo = to + 1;
        for (i = 0; i < realFrom; ++i) {
            if (text.charAt(i) != '\n') continue;
            ++realFrom;
        }
        for (i = 0; i < realTo; ++i) {
            if (text.charAt(i) != '\n') continue;
            ++realTo;
        }
        int[] singleIndex = new int[]{realFrom, realTo};
        int[][] indices = new int[][]{singleIndex};
        return indices;
    }

    public static String formatAsciiBlock(byte[] raw, int bytesPerBlock, int blocksPerLine, String blockSeparator) {
        if (bytesPerBlock < 1) {
            bytesPerBlock = 1;
        }
        if (blocksPerLine < 1) {
            blocksPerLine = 1;
        }
        StringBuffer result = new StringBuffer();
        int index = 0;
        while (index < raw.length) {
            for (int i = 0; i < blocksPerLine; ++i) {
                if (i != 0) {
                    result.append(blockSeparator);
                }
                FrameUtil.formatByteArrayAscii(raw, index, bytesPerBlock, result);
                index += bytesPerBlock;
            }
            result.append("\n");
        }
        return result.toString();
    }

    public static String formatHexAsciiBlock(byte[] raw, int bytesPerBlock, int blocksPerLine) {
        StringBuffer sb = new StringBuffer();
        FrameUtil.appendHexAsciiBlock(sb, raw, 0, raw.length, bytesPerBlock, blocksPerLine);
        return sb.toString();
    }

    public static String formatHexAsciiBlock(byte[] raw, int bytesPerBlock, int blocksPerLine, String blockSeparator, String hexAsciiSeparator) {
        StringBuffer sb = new StringBuffer();
        FrameUtil.appendHexAsciiBlock(sb, raw, 0, raw.length, bytesPerBlock, blocksPerLine, blockSeparator, hexAsciiSeparator);
        return sb.toString();
    }

    public static void appendHexAsciiBlock(StringBuffer sb, byte[] raw, int startIndex, int length, int bytesPerBlock, int blocksPerLine) {
        FrameUtil.appendHexAsciiBlock(sb, raw, startIndex, length, bytesPerBlock, blocksPerLine, "  ", "    ");
    }

    public static void appendHexAsciiBlock(StringBuffer buffer, byte[] raw, int startIndex, int length, int bytesPerBlock, int blocksPerLine, String blockSeparator, String hexAsciiSeparator) {
        int index = startIndex;
        if (bytesPerBlock < 1) {
            bytesPerBlock = 1;
        }
        if (blocksPerLine < 1) {
            blocksPerLine = 1;
        }
        while (index < startIndex + length) {
            int i;
            int lineStartIndex = index;
            for (i = 0; i < blocksPerLine; ++i) {
                if (i != 0) {
                    buffer.append(blockSeparator);
                }
                FrameUtil.formatByteArray(raw, index, bytesPerBlock, true, false, true, buffer);
                index += bytesPerBlock;
            }
            buffer.append(hexAsciiSeparator);
            index = lineStartIndex;
            for (i = 0; i < blocksPerLine; ++i) {
                if (i != 0) {
                    buffer.append(blockSeparator);
                }
                FrameUtil.formatByteArrayAscii(raw, index, bytesPerBlock, buffer);
                index += bytesPerBlock;
            }
            buffer.append("\n");
        }
    }

    public static String formatByteArray(byte[] raw, boolean useSpace) {
        if (raw == null) {
            return null;
        }
        return FrameUtil.formatByteArray(raw, 0, raw.length, useSpace, true);
    }

    public static void appendNibble(StringBuilder result, int nibble, boolean lowercase) {
        if (nibble > 9) {
            result.append((char)((lowercase ? 97 : 65) + (nibble - 10)));
        } else {
            result.append((char)(48 + nibble));
        }
    }

    @Deprecated
    public static void appendNibble(StringBuffer result, int nibble, boolean lowercase) {
        if (nibble > 9) {
            result.append((char)((lowercase ? 97 : 65) + (nibble - 10)));
        } else {
            result.append((char)(48 + nibble));
        }
    }

    public static String formatBleAddress(byte[] address) {
        return FrameUtil.formatByteArray(address);
    }

    public static String formatEUI64(byte[] littleEndianEUI64) {
        if (littleEndianEUI64 == null || littleEndianEUI64.length == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = littleEndianEUI64.length - 1; i >= 0; --i) {
            int highNib = (littleEndianEUI64[i] & 0xFF) >> 4 & 0xF;
            int lowNib = littleEndianEUI64[i] & 0xF;
            FrameUtil.appendNibble(result, highNib, false);
            FrameUtil.appendNibble(result, lowNib, false);
        }
        return result.toString();
    }

    public static String formatByteArray(byte[] raw) {
        return FrameUtil.formatByteArray(raw, true);
    }

    public static String formatBytesAsSourceCode(byte[] raw, int start, int length) {
        if (raw == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        FrameUtil.formatByteArray(raw, start, length, true, true, true, result);
        return result.toString();
    }

    public static String formatByteArray(byte[] raw, int start, int length, boolean useSpace, boolean upperCase) {
        if (raw == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        FrameUtil.formatByteArray(raw, start, length, useSpace, false, upperCase, result);
        return result.toString();
    }

    private static void formatByteArray(byte[] raw, int start, int length, boolean useSpace, boolean use0xPrefixAndComma, boolean useUpperCase, StringBuffer result) {
        if (raw == null) {
            return;
        }
        char[] charArray = useUpperCase ? UPPER_CASE : LOWER_CASE;
        for (int i = start; i < start + length; ++i) {
            if (useSpace && i != start) {
                result.append(use0xPrefixAndComma ? ", " : " ");
            }
            if (use0xPrefixAndComma) {
                result.append("0x");
            }
            try {
                byte nibHi = (byte)(raw[i] >> 4 & 0xF);
                byte nibLo = (byte)(raw[i] & 0xF);
                result.append(charArray[nibHi]);
                result.append(charArray[nibLo]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                result.append("  ");
            }
        }
    }

    public static String formatByteArraySummary(byte[] raw, int start, int length, int outputLength) {
        if (raw == null) {
            return "";
        }
        return length > outputLength ? FrameUtil.formatByteArray(raw, start, outputLength - 2, true, true) + " .. " + FrameUtil.hex(raw[start + length - 1] & 0xFF, 2) : FrameUtil.formatByteArray(raw, start, length, true, true);
    }

    public static boolean unprintableByte(int intByte) {
        return intByte < 33 || intByte > 126;
    }

    public static void formatByteArrayAscii(byte[] raw, int start, int length, StringBuffer result) {
        if (raw == null) {
            return;
        }
        for (int i = start; i < start + length; ++i) {
            try {
                int b = raw[i] & 0xFF;
                if (FrameUtil.unprintableByte(b)) {
                    result.append('.');
                    continue;
                }
                result.append((char)b);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                result.append(" ");
            }
        }
    }

    public static String formatByteArrayAscii(byte[] raw) {
        return FrameUtil.formatByteArrayAscii(raw, 0, raw.length);
    }

    public static String formatByteArrayAscii(byte[] raw, int start, int length) {
        if (raw == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        FrameUtil.formatByteArrayAscii(raw, start, length, result);
        return result.toString();
    }

    public static int highLowToInt(int high, int low) {
        return ((high & 0xFF) << 8) + (low & 0xFF);
    }

    public static int byteArrayToInt(byte[] raw, int offset, int length, boolean bigEndian) {
        int value = 0;
        int index = bigEndian ? offset + length - 1 : offset;
        int increment = bigEndian ? -1 : 1;
        for (int i = 0; i < length; ++i) {
            value += (raw[index] & 0xFF) << 8 * i;
            index += increment;
        }
        return value;
    }

    public static void longToByteArray(long value, byte[] dest, int offset, boolean bigEndian) {
        long v = value;
        for (int i = 0; i < 8; ++i) {
            int index = bigEndian ? offset + 7 - i : offset + i;
            dest[index] = (byte)(v & 0xFFL);
            v >>= 8;
        }
    }

    public static long byteArrayToLong(byte[] raw, int offset, int length, boolean bigEndian) {
        long value = 0L;
        int index = bigEndian ? offset + length - 1 : offset;
        int increment = bigEndian ? -1 : 1;
        for (int i = 0; i < length; ++i) {
            value |= (long)(raw[index] & 0xFF) << 8 * i;
            index += increment;
        }
        return value;
    }

    public static String hex(long value, int minLength) {
        Object result = Long.toHexString(value).toUpperCase(Locale.ROOT);
        while (((String)result).length() % 2 != 0 || ((String)result).length() < minLength) {
            result = "0" + (String)result;
        }
        return result;
    }

    public static String hex(int value, int minLength) {
        Object result = Integer.toHexString(value).toUpperCase(Locale.ROOT);
        while (((String)result).length() % 2 != 0 || ((String)result).length() < minLength) {
            result = "0" + (String)result;
        }
        return result;
    }

    public static int hexStringValue(String hexString) {
        int result = 0;
        int i = 0;
        int j = hexString.length() - 1;
        while (i < hexString.length()) {
            int value = LangUtilities.hexDigitValue(hexString.charAt(j));
            if (value == -1) {
                return -1;
            }
            result += value << 4 * i;
            ++i;
            --j;
        }
        return result;
    }

    private static byte[] stringToBytes(String input, boolean reversedOrder) {
        int[] delimiters = FrameUtil.splitByIndex(input, byteArrayDelimiters);
        int byteSize = input.length() / 3 + 1;
        byte[] bytes = new byte[byteSize];
        byte[] reversedBytes = new byte[byteSize];
        int byteIndex = 0;
        int lastIndex = 0;
        for (int delimiter : delimiters) {
            int lowNibble;
            int highNibble;
            if (delimiter - lastIndex == 2 && (highNibble = LangUtilities.hexDigitValue(input.charAt(lastIndex))) != -1 && (lowNibble = LangUtilities.hexDigitValue(input.charAt(lastIndex + 1))) != -1) {
                bytes[byteIndex] = (byte)((highNibble << 4) + lowNibble);
                reversedBytes[byteSize - byteIndex - 1] = bytes[byteIndex];
                ++byteIndex;
            }
            lastIndex = delimiter + 1;
        }
        byte[] trimmed = new byte[byteIndex];
        if (!reversedOrder) {
            System.arraycopy(bytes, 0, trimmed, 0, byteIndex);
        } else {
            System.arraycopy(reversedBytes, 0, trimmed, 0, byteIndex);
        }
        return trimmed;
    }

    public static byte[] toBytes(String input) {
        return FrameUtil.stringToBytes(input, false);
    }

    public static byte[] toReversedBytes(String input) {
        return FrameUtil.stringToBytes(input, true);
    }

    public static int[] splitByIndex(String string, char[] delimiters) {
        int length = string.length();
        int[] results = new int[length + 1];
        int matchCount = 0;
        block0: for (int i = 0; i < length; ++i) {
            for (char delimiter : delimiters) {
                if (string.charAt(i) != delimiter) continue;
                results[matchCount++] = i;
                continue block0;
            }
        }
        results[matchCount++] = length;
        int[] trimmed = new int[matchCount];
        System.arraycopy(results, 0, trimmed, 0, matchCount);
        return trimmed;
    }

    public static String[] split(String string, char[] delimiters) {
        String[] tokens = new String[string.length() / 2 + 1];
        int lastIndex = 0;
        int tokenIndex = 0;
        block0: for (int i = 0; i < string.length(); ++i) {
            for (char delimiter : delimiters) {
                if (string.charAt(i) != delimiter) continue;
                if (i > lastIndex) {
                    tokens[tokenIndex] = string.substring(lastIndex, i);
                    ++tokenIndex;
                }
                lastIndex = i + 1;
                continue block0;
            }
        }
        if (lastIndex < string.length()) {
            tokens[tokenIndex] = string.substring(lastIndex);
            ++tokenIndex;
        }
        String[] trimmed = new String[tokenIndex];
        System.arraycopy(tokens, 0, trimmed, 0, tokenIndex);
        return trimmed;
    }

    public static boolean isValidByteValue(String value, int numOfBytes) {
        BigInteger bigIntValue;
        try {
            bigIntValue = value.startsWith("0x") || value.startsWith("0X") ? new BigInteger(value.substring(2), 16) : new BigInteger(value);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        BigInteger maxBitValue = new BigInteger("1").shiftLeft(numOfBytes * 8).subtract(new BigInteger("1"));
        return bigIntValue.compareTo(maxBitValue) != 1;
    }

    public static String formatBitField(int byteCount, int bitmask, int value) {
        StringBuilder sb = new StringBuilder();
        int shiftedValue = value << LangUtilities.lowZeroBitCount(bitmask);
        for (int nibbleCount = 0; nibbleCount < byteCount * 2; ++nibbleCount) {
            for (int bitCount = 0; bitCount < 4; ++bitCount) {
                int bit = nibbleCount * 4 + bitCount;
                if ((bitmask & 1 << bit) != 0) {
                    if ((shiftedValue & 1 << bit) == 0) {
                        sb.insert(0, '0');
                        continue;
                    }
                    sb.insert(0, '1');
                    continue;
                }
                sb.insert(0, '.');
            }
            sb.insert(0, ' ');
        }
        return sb.toString();
    }

    public static String formatBitField(int byteCount, long bitmask, long value) {
        StringBuilder sb = new StringBuilder();
        long shiftedValue = value << (int)LangUtilities.lowZeroBitCount(bitmask);
        for (int nibbleCount = 0; nibbleCount < byteCount * 2; ++nibbleCount) {
            for (int bitCount = 0; bitCount < 4; ++bitCount) {
                int bit = nibbleCount * 4 + bitCount;
                if ((bitmask & 1L << bit) != 0L) {
                    if ((shiftedValue & 1L << bit) == 0L) {
                        sb.insert(0, '0');
                        continue;
                    }
                    sb.insert(0, '1');
                    continue;
                }
                sb.insert(0, '.');
            }
            sb.insert(0, ' ');
        }
        return sb.toString();
    }
}

