/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.internal.utils.files.monitor;

import com.silabs.java.internal.utils.files.monitor.IDirectoryMonitorImpl;
import com.silabs.java.internal.utils.files.monitor.PollingDirectoryMonitorImpl;
import com.silabs.java.internal.utils.files.monitor.WatchServiceDirectoryMonitorImpl;
import com.silabs.java.utils.HostUtils;
import com.silabs.java.utils.files.monitor.IDirectoryNotifier;
import com.silabs.java.utils.log.Log;
import com.silabs.java.utils.thread.SilabsThreadFactory;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;

public final class SingleDirectoryMonitor
implements IDirectoryNotifier {
    private static final ExecutorService threadPool = Executors.newCachedThreadPool(SilabsThreadFactory.withName("Directory-Monitor-Thread").setDaemon(true).create());
    private static final Map<Path, SingleDirectoryMonitor> monitors = new ConcurrentHashMap<Path, SingleDirectoryMonitor>();
    private final Path path;
    private final boolean isRecursive;
    private final Map<DirectoryMonitorHandle, IDirectoryNotifier> notifiers = new ConcurrentHashMap<DirectoryMonitorHandle, IDirectoryNotifier>();
    private final IDirectoryMonitorImpl monitor;
    private final Future<?> directoryMonitorFuture;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DirectoryMonitorHandle create(Path path, IDirectoryNotifier notifier, boolean checkModified, boolean isNew, boolean isRecursive) throws IOException {
        DirectoryMonitorHandle handle;
        Map<Path, SingleDirectoryMonitor> map = monitors;
        synchronized (map) {
            SingleDirectoryMonitor monitor = monitors.computeIfAbsent(path, p -> new SingleDirectoryMonitor(path, checkModified, isNew, isRecursive));
            handle = new DirectoryMonitorHandle(monitor);
            monitor.notifiers.put(handle, notifier);
        }
        if (isNew) {
            SingleDirectoryMonitor.notifyCreated(notifier, path);
        }
        return handle;
    }

    private static void notifyCreated(IDirectoryNotifier notifier, Path path) {
        try (Stream<Path> pathStream = Files.list(path);){
            pathStream.forEachOrdered(p -> notifier.fileEvent(IDirectoryNotifier.TYPE.CREATED, (Path)p));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private SingleDirectoryMonitor(Path path, boolean checkModified, boolean isNew, boolean isRecursive) throws UncheckedIOException {
        this.path = path;
        this.isRecursive = isRecursive;
        this.monitor = this.createMonitor(checkModified);
        this.directoryMonitorFuture = this.startup();
    }

    private void checkForChanges() {
        if (this.monitor instanceof PollingDirectoryMonitorImpl) {
            ((PollingDirectoryMonitorImpl)this.monitor).pollNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(DirectoryMonitorHandle handle) {
        this.notifiers.remove(handle);
        if (this.notifiers.isEmpty()) {
            SingleDirectoryMonitor singleDirectoryMonitor = this;
            synchronized (singleDirectoryMonitor) {
                if (this.notifiers.isEmpty()) {
                    monitors.remove(this.path);
                    Future<?> stopFuture = threadPool.submit(this::doStop);
                    try {
                        stopFuture.get(1L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException | TimeoutException exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    void monitorShutdown() {
        monitors.remove(this.path);
        this.notifiers.clear();
    }

    private void doStop() {
        if (this.monitor != null) {
            this.monitor.stop();
            try {
                if (!Objects.equals(Thread.currentThread(), this.monitor.runningThread())) {
                    this.directoryMonitorFuture.get(500L, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (CancellationException | ExecutionException | TimeoutException exception) {
                // empty catch block
            }
            this.directoryMonitorFuture.cancel(true);
        }
    }

    private IDirectoryMonitorImpl createMonitor(boolean checkModified) throws UncheckedIOException {
        boolean usePolling;
        IDirectoryMonitorImpl monitor = null;
        boolean bl = usePolling = HostUtils.isOSX() || HostUtils.isLinux() || this.isRecursive;
        if (!usePolling) {
            try {
                monitor = new WatchServiceDirectoryMonitorImpl(checkModified);
                monitor.init(this.path, this);
            }
            catch (IOException ioe) {
                Log.warning("Could not start directory watch service: " + this.path.toString(), ioe);
                usePolling = true;
            }
        }
        if (usePolling) {
            monitor = new PollingDirectoryMonitorImpl(checkModified);
            try {
                monitor.init(this.path, this);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return monitor;
    }

    @Override
    public void fileEvent(IDirectoryNotifier.TYPE type, Path changedFile) {
        this.notifiers.values().forEach(n -> n.fileEvent(type, changedFile));
    }

    private Future<?> startup() {
        return threadPool.submit(this.monitor);
    }

    public static class DirectoryMonitorHandle {
        public final SingleDirectoryMonitor monitor;

        private DirectoryMonitorHandle(SingleDirectoryMonitor monitor) {
            this.monitor = monitor;
        }

        public void stop() {
            this.monitor.stop(this);
        }

        public void checkForChanges() {
            this.monitor.checkForChanges();
        }
    }
}

