/*
 * Decompiled with CFR 0.152.
 */
package com.arm.cmsis.parser;

import com.arm.cmsis.config.model.ConfigWizardItem;
import com.arm.cmsis.config.model.IConfigWizardItem;
import com.arm.cmsis.utils.Utils;
import com.silabs.jface.text.rules.IHeaderContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.Assert;

public class HeaderModel {
    private IHeaderContent<? extends Object> document;
    private IConfigWizardItem rootItem;
    private TreeMap<Integer, String> fNumberContainer;
    private TreeMap<Integer, String> fStringContainer;
    private TreeMap<Integer, String> fCommentContainer;
    private Map<String, Integer> fMacroValueMap;
    private TreeMap<Integer, String> fMacroOffsetMap;

    public HeaderModel(IHeaderContent<? extends Object> document) {
        this.document = document;
        this.fNumberContainer = new TreeMap();
        this.fStringContainer = new TreeMap();
        this.fCommentContainer = new TreeMap();
        this.fMacroValueMap = new HashMap<String, Integer>();
        this.fMacroOffsetMap = new TreeMap();
    }

    public void clearMaps() {
        this.rootItem = null;
        this.fNumberContainer.clear();
        this.fStringContainer.clear();
        this.fCommentContainer.clear();
    }

    public void createRootItem(String name) {
        this.rootItem = new ConfigWizardItem(IConfigWizardItem.EItemType.ROOT, 0, null);
        this.rootItem.setName(name);
    }

    public IHeaderContent<? extends Object> getDocument() {
        return this.document;
    }

    public IConfigWizardItem getRootItem() {
        return this.rootItem;
    }

    public void clearRootItem() {
        this.rootItem = null;
    }

    public int getDocumentLength() {
        return this.document.getLength();
    }

    public void putNumber(int offset, String value) {
        this.fNumberContainer.put(offset, value);
    }

    public void putString(int offset, String value) {
        this.fStringContainer.put(offset, value);
    }

    public void putMacro(int offset, String value) {
        this.fMacroOffsetMap.put(offset, value);
        this.fMacroValueMap.put(value, offset);
    }

    public void putComment(int offset, String value) {
        this.fCommentContainer.put(offset, value);
    }

    public boolean macroIsUnknownOrNoValue(String name) {
        boolean unknownOrNoValue = !this.fMacroValueMap.containsKey(name) || this.fMacroValueMap.get(name) == null;
        return unknownOrNoValue;
    }

    public void setValuesAndStrings(IConfigWizardItem item) throws IHeaderContent.ContentException {
        IConfigWizardItem.EItemType type = item.getItemType();
        if (type == IConfigWizardItem.EItemType.OPTION_SELECT && item.hasIdentifierItems()) {
            type = IConfigWizardItem.EItemType.OPTION_STRING;
        }
        switch (type) {
            case HEADING_ENABLE: 
            case OPTION: 
            case OPTION_CHECK: 
            case OPTION_SELECT: {
                this.setValuesAndStringsOptionSelect(item, type);
                break;
            }
            case OPTION_STRING: {
                if (this.setValueOptionString(item)) break;
                return;
            }
            case ARRAY: {
                this.setArrayValues(item);
                return;
            }
        }
        if (item.hasChildren()) {
            for (IConfigWizardItem child : item.getChildren()) {
                this.setValuesAndStrings(child);
            }
        }
    }

    private void setArrayValues(IConfigWizardItem item) throws IHeaderContent.ContentException {
        int offset = this.document.getLineOffset(item.getStartLine());
        if (item.getMacroName() != null) {
            offset = this.fMacroValueMap.get(item.getMacroName());
        }
        String valueStr = "";
        Iterator<String> stringsIter = this.fStringContainer.tailMap(offset).values().iterator();
        if (stringsIter.hasNext()) {
            valueStr = stringsIter.next().trim();
        }
        item.setItemErrorType(IConfigWizardItem.EItemErrorType.NO_ERROR);
        if (!valueStr.isEmpty()) {
            int[] intValues = Utils.parseIntegerArray(valueStr, item.getArrayLength());
            item.setArrayValues(intValues);
        } else {
            int[] initialList = new int[item.getArrayLength()];
            Arrays.fill(initialList, 0);
            item.setArrayValues(initialList);
        }
    }

    private boolean setValueOptionString(IConfigWizardItem item) throws IHeaderContent.ContentException {
        int offset = this.document.getLineOffset(item.getStartLine());
        int skip = item.getSkipNumber();
        if (item.getMacroName() != null) {
            offset = this.fMacroValueMap.get(item.getMacroName());
            skip = 0;
        }
        Collection<String> strings = this.fStringContainer.tailMap(offset).values();
        Iterator<String> siter = strings.iterator();
        String str = "";
        while (siter.hasNext() && skip >= 0) {
            str = siter.next();
            --skip;
        }
        if (skip >= 0) {
            item.setItemErrorType(IConfigWizardItem.EItemErrorType.LOCATE_POSITION_ERROR);
            return false;
        }
        item.setItemErrorType(IConfigWizardItem.EItemErrorType.NO_ERROR);
        if (item.getMacroName() != null) {
            item.setMacroValue(str);
        } else {
            item.setString(str);
        }
        return true;
    }

    private void setValuesAndStringsOptionSelect(IConfigWizardItem item, IConfigWizardItem.EItemType type) throws IHeaderContent.ContentException {
        int offset = this.document.getLineOffset(item.getStartLine());
        int skip = item.getSkipNumber();
        int minBit = item.getMinBit();
        long mask = HeaderModel.buildMask(minBit, item.getMaxBit());
        if (item.getMacroName() != null) {
            offset = this.fMacroValueMap.get(item.getMacroName());
        }
        Collection<String> numbers = this.fStringContainer.tailMap(offset).values();
        Iterator<String> iter = numbers.iterator();
        if (type == IConfigWizardItem.EItemType.OPTION) {
            iter = this.fStringContainer.tailMap(offset).values().iterator();
        }
        String valueText = "";
        long value = 0L;
        while (iter.hasNext() && skip >= 0) {
            valueText = iter.next();
            --skip;
        }
        if (skip >= 0) {
            item.setItemErrorType(IConfigWizardItem.EItemErrorType.LOCATE_POSITION_ERROR);
            return;
        }
        value = this.parseNumber(item, valueText);
        if (item.getItemErrorType() != IConfigWizardItem.EItemErrorType.NO_ERROR) {
            return;
        }
        int base = HeaderModel.getBaseFromValue(valueText);
        item.setBase(base);
        long realValue = value;
        if (value >= 0L) {
            realValue = value >> minBit & mask;
        }
        item.setValue(realValue);
    }

    private static long buildMask(int minBit, int maxBit) {
        long mask = 1L;
        int i = 0;
        while (i < maxBit - minBit) {
            mask <<= 1;
            mask |= 1L;
            ++i;
        }
        return mask;
    }

    private long parseNumber(IConfigWizardItem item, String number) {
        number = HeaderModel.removeParens(number);
        int radix = 10;
        if ((number = number.toLowerCase()).startsWith("0x")) {
            radix = 16;
            number = number.substring(2);
        } else if (number.startsWith("0b")) {
            radix = 2;
            number = number.substring(2);
        } else if (number.startsWith("0") && number.length() > 1 && Character.isDigit(number.charAt(number.length() - 1))) {
            radix = 8;
            number = number.substring(1);
        }
        char lastChar = number.charAt(number.length() - 1);
        if (radix != 16 && radix != 2 && radix != 8 && !Character.isDigit(lastChar)) {
            switch (lastChar) {
                case 'B': 
                case 'b': {
                    radix = 2;
                    break;
                }
                case 'O': 
                case 'Q': 
                case 'o': 
                case 'q': {
                    radix = 8;
                    break;
                }
                case 'D': 
                case 'd': {
                    radix = 10;
                    break;
                }
                case 'H': 
                case 'h': {
                    radix = 16;
                    break;
                }
                default: {
                    item.setItemErrorType(IConfigWizardItem.EItemErrorType.NUMBER_PARSE_ERROR);
                    return 0L;
                }
            }
            number = number.substring(0, number.length() - 1);
        }
        if ((radix == 2 || radix == 8 || radix == 16) && item.getMinValue() <= 0L) {
            item.setMinValue(0L);
        }
        try {
            long i = Long.parseLong(number, radix);
            item.setItemErrorType(IConfigWizardItem.EItemErrorType.NO_ERROR);
            return i;
        }
        catch (NumberFormatException numberFormatException) {
            item.setItemErrorType(IConfigWizardItem.EItemErrorType.NUMBER_PARSE_ERROR);
            return 0L;
        }
    }

    private static String removeParens(String txt) {
        if (txt == null) {
            return "";
        }
        if (txt.length() < 2) {
            return txt;
        }
        String trimmed = txt.trim();
        if (trimmed.startsWith("(") && trimmed.endsWith(")")) {
            trimmed = trimmed.substring(1, trimmed.length() - 1);
            trimmed = trimmed.trim();
            return trimmed;
        }
        return txt;
    }

    private static int getBaseFromValue(String valueText) {
        valueText = HeaderModel.removeParens(valueText);
        if ((valueText = valueText.toLowerCase()).startsWith("0x")) {
            return 16;
        }
        if (valueText.startsWith("0b")) {
            return 2;
        }
        if (valueText.startsWith("0") && valueText.length() > 1 && Character.isDigit(valueText.charAt(valueText.length() - 1))) {
            return 8;
        }
        switch (valueText.charAt(valueText.length() - 1)) {
            case 'b': {
                return 2;
            }
            case 'o': 
            case 'q': {
                return 8;
            }
            case 'd': {
                return 10;
            }
            case 'h': {
                return 16;
            }
        }
        return 10;
    }

    public UpdateResult updateModel(IConfigWizardItem item, Object newVal) {
        if (newVal instanceof Boolean) {
            return this.updateBooleanValue(item, (Boolean)newVal);
        }
        if (newVal instanceof Integer || newVal instanceof Long) {
            if (newVal instanceof Integer) {
                newVal = ((Integer)newVal).longValue();
            }
            return this.updateNumberValue(item, (Long)newVal);
        }
        if (newVal instanceof String) {
            return this.updateStringValue(item, (String)newVal);
        }
        if (newVal instanceof int[]) {
            return this.updateArrayValue(item, (int[])newVal);
        }
        throw new IllegalArgumentException("Cannot update configuration model with " + String.valueOf(newVal) + " of class " + newVal.getClass().getCanonicalName() + ". Must be either Boolean, String, Integer, Long");
    }

    private UpdateResult updateBooleanValue(IConfigWizardItem item, Boolean newVal) {
        long value = newVal != false ? 1 : 0;
        if (item.getValue() == value) {
            return UpdateResult.NO_UPDATE;
        }
        item.setValue(value);
        if (item.invertValue()) {
            newVal = newVal == false;
        }
        this.updateDocument(item, newVal);
        return UpdateResult.SUCCESS;
    }

    private UpdateResult updateNumberValue(IConfigWizardItem item, Long newVal) {
        long value = newVal;
        if (item.getItemType() == IConfigWizardItem.EItemType.OPTION_SELECT) {
            int i = 0;
            for (Long k : item.getItems().keySet()) {
                if ((long)i == value) {
                    if (item.getValue() == k.longValue()) {
                        return UpdateResult.NO_UPDATE;
                    }
                    item.setValue(k);
                    this.updateDocument(item, k);
                    return UpdateResult.SUCCESS;
                }
                ++i;
            }
        } else {
            if (item.getItemType() == IConfigWizardItem.EItemType.OPTION) {
                return this.updateSpinnerItem(item, value);
            }
            if (item.getItemType() == IConfigWizardItem.EItemType.OPTION_CHECK) {
                item.setValue(value);
                this.updateDocument(item, value);
                return UpdateResult.SUCCESS;
            }
        }
        return UpdateResult.ERROR;
    }

    private UpdateResult updateSpinnerItem(IConfigWizardItem item, long value) {
        long spinStep;
        long min = item.getMinValue();
        long modifier = item.getModifier();
        char op = item.getModification();
        if (((value = Utils.modifyValue(value, op, modifier, item.getMaxValue(), item.getMinValue())) - min) % (spinStep = Utils.modifyValue(item.getSpinStep(), op, modifier, Long.MAX_VALUE, 1L)) != 0L) {
            value = min + (value - min) / spinStep * spinStep;
        }
        if (item.getValue() == value) {
            return UpdateResult.NO_UPDATE;
        }
        item.setValue(value);
        this.updateDocument(item, value);
        return UpdateResult.SUCCESS;
    }

    private UpdateResult updateStringValue(IConfigWizardItem item, String newVal) {
        IConfigWizardItem.EItemType type = item.getItemType();
        String value = newVal;
        switch (type) {
            case OPTION_STRING: {
                if (item.getMacroName() == null && item.getString().equals(value) || item.getMacroName() != null && item.getMacroValue().equals(value)) {
                    return UpdateResult.NO_UPDATE;
                }
                int max = item.getStringLength();
                if (max > 0 && value.length() > max) {
                    value = value.substring(0, max);
                }
                if (item.getMacroName() != null) {
                    item.setMacroValue(value);
                } else {
                    item.setString(value);
                }
                this.updateDocument(item, value);
                return UpdateResult.SUCCESS;
            }
            case OPTION_SELECT: {
                return this.updateStringValueOptionSelect(item, value);
            }
            case OPTION: {
                return this.updateOptionStringValue(item, value);
            }
            case ARRAY: {
                try {
                    String[] strVals = value.split(",");
                    int[] intVals = Arrays.stream(strVals).map(String::trim).filter(s -> !s.isEmpty()).mapToInt(Utils::parseDefaultInteger).toArray();
                    return this.updateArrayValue(item, intVals);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return UpdateResult.ERROR;
                }
            }
        }
        return UpdateResult.ERROR;
    }

    private UpdateResult updateArrayValue(IConfigWizardItem item, int[] newVal) {
        IConfigWizardItem.EItemType type = item.getItemType();
        switch (type) {
            case ARRAY: {
                if (Arrays.equals(item.getArrayValues(), newVal)) {
                    return UpdateResult.NO_UPDATE;
                }
                if (newVal.length != item.getArrayLength()) {
                    return UpdateResult.ERROR;
                }
                item.setArrayValues(newVal);
                this.updateDocument(item, newVal);
                return UpdateResult.SUCCESS;
            }
        }
        return UpdateResult.ERROR;
    }

    private static int[] findRadix(String value, int dflt) {
        int[] nArray = new int[2];
        nArray[0] = dflt;
        int[] result = nArray;
        if (value.toLowerCase().startsWith("0x")) {
            result[0] = 16;
            result[1] = 2;
        } else if (value.toLowerCase().startsWith("0o")) {
            result[0] = 8;
            result[1] = 2;
        } else if (value.toLowerCase().startsWith("0b")) {
            result[0] = 2;
            result[1] = 2;
        }
        return result;
    }

    private UpdateResult updateOptionStringValue(IConfigWizardItem item, String value) {
        int[] radix = HeaderModel.findRadix(value, item.getBase());
        if (radix[1] > 0) {
            value = value.substring(radix[1]);
        }
        value = value.replaceAll("[\\s<>]", "");
        try {
            long realValue = Utils.modifyValue(Long.parseLong(value, radix[0]), item.getModification(), item.getModifier(), item.getMaxValue(), item.getMinValue());
            item.setItemErrorType(IConfigWizardItem.EItemErrorType.NO_ERROR);
            if (item.getValue() == realValue) {
                return UpdateResult.NO_UPDATE;
            }
            item.setValue(realValue);
            this.updateDocument(item, realValue);
            return UpdateResult.SUCCESS;
        }
        catch (NumberFormatException numberFormatException) {
            item.setItemErrorType(IConfigWizardItem.EItemErrorType.NUMBER_PARSE_ERROR);
            return UpdateResult.ERROR;
        }
    }

    private UpdateResult updateStringValueOptionSelect(IConfigWizardItem item, String value) {
        if (item.getItems().get(item.getValue()) != null && item.getItems().get(item.getValue()).equals(value)) {
            return UpdateResult.NO_UPDATE;
        }
        if (!item.getItems().isEmpty()) {
            try {
                long l = Long.parseLong(value);
                if (item.getItems().containsKey(l)) {
                    item.setValue(l);
                    this.updateDocument(item, l);
                    return UpdateResult.SUCCESS;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        for (Map.Entry<String, String> entry : item.getIdentifierItems().entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            item.setMacroValue(entry.getKey());
            this.updateDocument(item, entry.getKey());
            return UpdateResult.SUCCESS;
        }
        for (Map.Entry<Object, String> entry : item.getItems().entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            item.setValue((Long)entry.getKey());
            this.updateDocument(item, entry.getKey());
            return UpdateResult.SUCCESS;
        }
        if (item.getIdentifierItems().containsKey(value)) {
            item.setMacroValue(value);
            this.updateDocument(item, value);
            return UpdateResult.SUCCESS;
        }
        return UpdateResult.ERROR;
    }

    private void updateDocument(IConfigWizardItem item, Object newVal) {
        try {
            if (item.getItemType() == IConfigWizardItem.EItemType.CODE_ENABLE || item.getItemType() == IConfigWizardItem.EItemType.CODE_DISABLE) {
                this.updateDocumentCode(item, newVal);
            } else if (item.getItemType() == IConfigWizardItem.EItemType.ARRAY) {
                int[] values = (int[])newVal;
                StringBuilder sb = new StringBuilder(64);
                sb.append("{ ");
                int i = 0;
                while (i < values.length) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(Integer.toString(values[i]));
                    ++i;
                }
                sb.append(" }");
                String arrayAsString = sb.toString();
                this.updateDocumentString(item, arrayAsString);
            } else if (newVal instanceof Integer || newVal instanceof Long || newVal instanceof Boolean) {
                this.updateDocumentNumeric(item, newVal);
            } else if (newVal instanceof String) {
                this.updateDocumentString(item, newVal);
            }
        }
        catch (IHeaderContent.ContentException contentException) {}
    }

    private void updateDocumentString(IConfigWizardItem item, Object newVal) throws IHeaderContent.ContentException {
        Pair<Integer, String> offsetValuePair = this.findOriginalValues(item.getStartLine(), item.getMacroName(), item.getSkipNumber());
        int valueOffset = (Integer)offsetValuePair.first;
        String oldValue = (String)offsetValuePair.second;
        Assert.isTrue((valueOffset != -1 ? 1 : 0) != 0);
        int oldValueLength = oldValue.length();
        String newText = (String)newVal;
        this.updateIndex(valueOffset, newText.length() - oldValueLength);
        this.fStringContainer.remove(valueOffset);
        this.fStringContainer.put(valueOffset, newText);
        this.document.replace(valueOffset, oldValueLength, newText);
    }

    private Pair<Integer, String> findOriginalValues(int startLine, String macroName, int skip) throws IHeaderContent.ContentException {
        int startOffset = this.document.getLineOffset(startLine);
        if (macroName != null) {
            startOffset = this.fMacroValueMap.get(macroName);
        }
        Set<Map.Entry<Integer, String>> map = this.fStringContainer.tailMap(startOffset).entrySet();
        int i = 0;
        int valueOffset = -1;
        String oldValue = "";
        for (Map.Entry<Integer, String> e : map) {
            if (i == skip) {
                valueOffset = e.getKey();
                oldValue = e.getValue();
                break;
            }
            ++i;
        }
        return new Pair<Integer, String>(valueOffset, oldValue);
    }

    private void updateDocumentNumeric(IConfigWizardItem item, Object newVal) throws IHeaderContent.ContentException {
        Pair<Integer, String> offsetValuePair = this.findOriginalValues(item.getStartLine(), item.getMacroName(), item.getSkipNumber());
        int valueOffset = (Integer)offsetValuePair.first;
        String oldValue = (String)offsetValuePair.second;
        Assert.isTrue((valueOffset != -1 && !oldValue.isEmpty() ? 1 : 0) != 0);
        int oldValueLength = oldValue.length();
        int minBit = item.getMinBit();
        int maxBit = item.getMaxBit();
        long mask = HeaderModel.buildMask(minBit, maxBit) << minBit ^ 0xFFFFFFFFFFFFFFFFL;
        long value = newVal instanceof Boolean ? (long)((Boolean)newVal != false ? 1 : 0) : Long.valueOf(newVal.toString());
        value <<= minBit;
        long newValue = this.parseNumber(item, oldValue);
        if (item.getItemErrorType() != IConfigWizardItem.EItemErrorType.NO_ERROR) {
            return;
        }
        newValue &= mask;
        Object newText = String.valueOf(newValue |= value);
        if (item.getBase() == 16) {
            newText = Long.toHexString(newValue).toUpperCase();
            StringBuilder sb = new StringBuilder((String)newText);
            sb.insert(0, "0x");
            newText = sb.toString();
        } else if (item.getBase() == 8) {
            newText = Long.toOctalString(newValue);
            newText = "0" + (String)newText;
        } else if (item.getBase() == 2) {
            newText = Long.toBinaryString(newValue);
            StringBuilder sb = new StringBuilder((String)newText);
            sb.insert(0, "0b");
            while (sb.length() < oldValueLength) {
                sb.insert(2, '0');
            }
            newText = sb.toString();
        }
        this.updateIndex(valueOffset, ((String)newText).length() - oldValueLength);
        this.fStringContainer.remove(valueOffset);
        this.fStringContainer.put(valueOffset, (String)newText);
        this.document.replace(valueOffset, oldValueLength, (String)newText);
    }

    private void updateDocumentCode(IConfigWizardItem item, Object newVal) throws IHeaderContent.ContentException {
        int startLine = item.getStartLine();
        int endLine = item.getEndLine();
        int endOffset = this.document.getLineOffset(endLine);
        int skip = item.getSkipNumber();
        Assert.isTrue((boolean)(newVal instanceof Boolean));
        boolean useCode = (Boolean)newVal;
        int startOffset = this.document.getLineOffset(startLine + skip + 1);
        Iterator<Map.Entry<Integer, String>> iter = this.fCommentContainer.subMap(startOffset, endOffset).entrySet().iterator();
        TreeMap<Integer, String> newMap = new TreeMap<Integer, String>();
        int shift = 0;
        while (iter.hasNext()) {
            Map.Entry<Integer, String> e = iter.next();
            int offset = e.getKey() + shift;
            String oldComment = e.getValue();
            iter.remove();
            if (useCode) {
                this.document.replace(offset, oldComment.length(), "");
                shift -= oldComment.length();
                newMap.put(offset, "");
                continue;
            }
            this.document.replace(offset, oldComment.length(), "//");
            shift -= oldComment.length() - 2;
            newMap.put(offset, "//");
        }
        this.fCommentContainer.putAll(newMap);
        if (shift != 0) {
            this.updateIndex(endOffset, shift);
        }
    }

    private void updateIndex(int startOffset, int shift) {
        if (shift == 0) {
            return;
        }
        HeaderModel.updateContainer(this.fNumberContainer, startOffset, shift);
        HeaderModel.updateContainer(this.fStringContainer, startOffset, shift);
        HeaderModel.updateContainer(this.fCommentContainer, startOffset, shift);
        HeaderModel.updateContainer(this.fMacroOffsetMap, startOffset, shift);
        HeaderModel.updateMacroOffsets(this.fMacroValueMap, startOffset, shift);
    }

    private static void updateContainer(TreeMap<Integer, String> container, int startOffset, int shift) {
        NavigableMap<Integer, String> behind = container.tailMap(startOffset, false);
        TreeMap<Integer, String> newMap = new TreeMap<Integer, String>();
        Iterator iter = behind.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            int key = (Integer)entry.getKey();
            String value = (String)entry.getValue();
            newMap.put(key + shift, value);
            iter.remove();
        }
        container.putAll(newMap);
    }

    private static void updateMacroOffsets(Map<String, Integer> map, int startOffset, int shift) {
        Set<String> keys = map.keySet();
        for (String k : keys) {
            int value = map.get(k);
            if (value <= startOffset) continue;
            map.put(k, value + shift);
        }
    }

    public static boolean isValid(IConfigWizardItem item, Object value) {
        if (value instanceof Boolean) {
            return HeaderModel.checkBooleanValue();
        }
        if (value instanceof Integer || value instanceof Long) {
            if (value instanceof Integer) {
                value = (long)((Integer)value).intValue();
            }
            if (item.getItemType().considerAsBinary()) {
                return true;
            }
            return HeaderModel.checkNumberValue(item, (Long)value);
        }
        if (value instanceof String) {
            return HeaderModel.checkStringValue(item, (String)value);
        }
        return false;
    }

    private static boolean checkBooleanValue() {
        return true;
    }

    private static boolean checkNumberValue(IConfigWizardItem item, Long value) {
        if (item.getItemType() == IConfigWizardItem.EItemType.OPTION_SELECT) {
            int i = 0;
            Iterator<Long> iterator = item.getItems().keySet().iterator();
            while (iterator.hasNext()) {
                iterator.next();
                if ((long)i == value) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (item.getItemType() == IConfigWizardItem.EItemType.OPTION) {
            if (value < item.getMinValue()) {
                return false;
            }
            return value <= item.getMaxValue();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkStringValue(IConfigWizardItem item, String value) {
        IConfigWizardItem.EItemType type = item.getItemType();
        switch (type) {
            case OPTION_STRING: {
                int max = item.getStringLength();
                return max <= 0 || value.length() <= max;
            }
            case OPTION_SELECT: {
                return HeaderModel.checkStringValueOptionSelect(item, value);
            }
            case OPTION: {
                int[] radix = HeaderModel.findRadix(value, item.getBase());
                if (radix[1] > 0) {
                    value = value.substring(radix[1]);
                }
                value = value.replaceAll("[\\s<>]", "");
                try {
                    long parseLong = Long.parseLong(value, radix[0]);
                    if (parseLong < item.getMinValue()) {
                        return false;
                    }
                    if (parseLong > item.getMaxValue()) {
                        return false;
                    }
                    long realValue = Utils.modifyValue(parseLong, item.getModification(), item.getModifier(), item.getMaxValue(), item.getMinValue());
                    if (item.getValue() == realValue) {
                        return true;
                    }
                    return HeaderModel.checkNumberValue(item, realValue);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean checkStringValueOptionSelect(IConfigWizardItem item, String value) {
        if (item.getItems().get(item.getValue()) != null && item.getItems().get(item.getValue()).equals(value)) {
            return true;
        }
        if (!item.getItems().isEmpty()) {
            try {
                long l = Long.parseLong(value);
                if (item.getItems().containsKey(l)) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        for (Map.Entry<String, String> entry : item.getIdentifierItems().entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return true;
        }
        for (Map.Entry<Object, String> entry : item.getItems().entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return true;
        }
        return item.getIdentifierItems().containsKey(value);
    }

    public List<String> getKnownMacroNames() {
        ArrayList<String> names = new ArrayList<String>(this.fMacroValueMap.keySet());
        return names;
    }

    public boolean containsMacro(String name) {
        return this.fMacroValueMap.containsKey(name);
    }

    public String getMacroValue(String macroName) {
        if (!this.fMacroValueMap.containsKey(macroName)) {
            return null;
        }
        int offset = this.fMacroValueMap.get(macroName);
        if (this.fNumberContainer.containsKey(offset)) {
            return this.fNumberContainer.get(offset);
        }
        if (this.fStringContainer.containsKey(offset)) {
            return this.fStringContainer.get(offset);
        }
        return null;
    }

    public String getMacroName(IConfigWizardItem item) {
        if (item == null || item.getItemType() == IConfigWizardItem.EItemType.HEADING || item.getItemType() == IConfigWizardItem.EItemType.CODE_DISABLE || item.getItemType() == IConfigWizardItem.EItemType.CODE_ENABLE) {
            return null;
        }
        if (item.getMacroName() != null) {
            return item.getMacroName();
        }
        String name = null;
        int line = item.getStartLine();
        try {
            int offset = this.document.getLineOffset(line);
            Iterator<String> iter = this.fMacroOffsetMap.tailMap(offset).values().iterator();
            int i = 0;
            int skip = item.getSkipNumber();
            while (i <= skip) {
                name = iter.next();
                if (i != skip) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (IHeaderContent.ContentException contentException) {}
        return name;
    }

    public int getLineOffset(int line) {
        try {
            return this.document.getLineOffset(line);
        }
        catch (IHeaderContent.ContentException contentException) {
            return -1;
        }
    }

    public String getDocumentContent(int offset, int length) {
        try {
            return this.document.get(offset, length);
        }
        catch (IHeaderContent.ContentException e) {
            throw new RuntimeException("Exception obtaining content", e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(2048);
        sb.append("Document len: " + String.valueOf(this.document != null ? Integer.valueOf(this.document.getLength()) : "null") + "\r\n");
        sb.append("Root Item: " + (this.rootItem != null ? this.rootItem.toString() : "null") + "\r\n");
        sb.append("Parsed Numbers: " + String.valueOf(this.fNumberContainer) + "\r\n");
        sb.append("Parsed Strings: " + String.valueOf(this.fStringContainer) + "\r\n");
        sb.append("Parsed Comments: " + String.valueOf(this.fCommentContainer) + "\r\n");
        sb.append("Macro Value Map: " + String.valueOf(this.fMacroValueMap) + "\r\n");
        sb.append("Macro Offset Map: " + String.valueOf(this.fMacroOffsetMap) + "\r\n");
        return sb.toString();
    }

    private static class Pair<S, T> {
        public final S first;
        public final T second;

        public Pair(S s, T t) {
            this.first = s;
            this.second = t;
        }
    }

    public static enum UpdateResult {
        SUCCESS,
        NO_UPDATE,
        ERROR;

    }
}

